#! /usr/local/bin/gtklauncher

package_list(){
  if [ -z "$FILTER" ]; then 
    rpm -qa --qf "%{name} %{version} %{group}\n"
    return
  fi

  for P in $(rpm -qa); do
    if rpm -qi $P | grep $FILTER >/dev/null; then 
      rpm -q $P --qf "%{name} %{version} %{group}\n" 
    fi
  done
}

package_query(){
  rpm -qi $PACKAGE >/tmp/rpm.sh
}

export MAIN_DIALOG='
<vbox>
  <frame Description>
    <hbox>
      <pixmap><input file>help.png</input></pixmap>
      <text>
        <label>
"The rpm (Red Hat Package Manager) is a complex tool for manipulating software 
packages. This dialog useful to get base information about installed packages."
        </label>
      </text>
    </hbox>
  </frame>

  <frame Installed packages>
    <hbox>
      <text><label>Search:</label></text>
      <entry>
        <variable>FILTER</variable>
      </entry>
      <button>
        <label>Search</label>
        <action clear>PACKAGE</action>
        <action>Refresh:PACKAGE</action>
      </button>
    </hbox>
    <table>
      <label>Package name|Package Version|Group</label>
      <variable>PACKAGE</variable>
      <input>package_list</input>
      <action>package_query</action>
      <action>refresh:INFO</action>
      <width>500</width><height>150</height>
    </table>
  </frame>
  <frame Info>
    <edit>
      <variable>INFO</variable>
      <input file>/tmp/rpm.sh</input>
      <width>500</width><height>250</height>
    </edit>
  </frame>
  <hbox>
    <button ok>
      <action>rm -f /tmp/rpm.sh</action>
      <action>EXIT=OK</action>
    </button>
    <button help>
      <action>xterm -e man rpm&</action>
    </button>
  </hbox>
</vbox>
'

