/*
 * Copyright (C) 1994, 1995, 1996, 1998 Free Software Foundation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.org
 *
 * This header provides the UNION of all talk message types.  This
 * lets us play with one structure which can have any type of message
 * in it after the UDP read.
 *
 * Purpose:
 *  the definition in here basically links all the thre other message
 * types together because it just doesn't belong in gtalk.h
 *
 * $Log: gtl_union.h,v $
 * Revision 1.5  1998/05/01 16:44:17  zappo
 * Updated ControlExtension type, and moved it into an IFDEF.
 *
 * Revision 1.4  1997/12/14 19:59:30  zappo
 * Renamed package to gtalk, renamed symbols and files apropriately
 * Fixed copyright and email address.
 *
 * Revision 1.3  1996/03/02 03:28:48  zappo
 * Moved related prototypes into this file as well
 *
 * Revision 1.2  1995/03/25  04:18:33  zappo
 * Updated copyright and comments
 *
 * Revision 1.1  1994/12/12  23:47:14  zappo
 * Initial revision
 *
 */

#ifndef _GTL_UNION
#define _GTL_UNION

/*
 * Special unions so one pointer may point to all types of responses.
 * This assumes that otalk.h, and ntalk.h have both been included
 * before this file.
 */
#ifdef _GTALK_H
union ctl_msg {
#ifdef _OTALK_H
  CTL_MSG_OLD otalk;
#endif
#ifdef _PROTOCOLS_TALKD_H
  CTL_MSG     talk;
#endif
  CTL_MSG_GNU gtalk;
};

union ctl_response {
#ifdef _OTALK_H
  CTL_RESPONSE_OLD otalk;
#endif
#ifdef _PROTOCOLS_TALKD_H
  CTL_RESPONSE     talk;
#endif
  CTL_RESPONSE_GNU gtalk;
};
#endif /* _GTALK_H */

/* Prototypes */
/* etl_msgm.c */
extern char *msg_types[];
extern char *msg_responses[];
#ifdef _GTALK_H
extern union ctl_msg      Control;
extern union ctl_response Response;
extern CTL_MSG_EXTENSION  ControlExtension;
#endif
#ifdef PROTOTYPES
extern int control_size(enum DaemonType type);
extern int response_size(enum DaemonType type);
extern void ETM_control_print(enum DaemonType type);
extern int ETM_response_print(enum DaemonType type);
extern int DMN_check_compile();
#else
extern int control_size();
extern int response_size();
extern void ETM_control_print();
extern int ETM_response_print();
extern int DMN_check_compile();
#endif

#endif /* _ETL_UNION */
