/* GStreamer
 *
 * unit test for videofilter elements
 *
 * Copyright (C) <2006> Mark Nauwelaerts <mnauw@users.sourceforge.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <unistd.h>

#include <gst/check/gstcheck.h>

#include "videofilter.h"

static RunInfo ri;

GST_START_TEST (test_fields)
{
  INIT_RUNINFO_YUV (&ri, 2);
  check_filter ("fields", &ri, "operation", 0, NULL); /* flip */
  check_filter ("fields", &ri, "operation", 1, NULL); /* shift */
  check_filter ("fields", &ri, "operation", 2, NULL); /* ship */
  check_filter ("fields", &ri, "operation", 3, NULL); /* flift */
  check_filter ("fields", &ri, "operation", 5, NULL); /* lin */
  check_filter ("fields", &ri, "operation", 6, NULL); /* blend */

  INIT_RUNINFO (&ri, 384, 288, 384, 144, 2, 2, YUV, 3 / 2);
  check_filter ("fields", &ri, "operation", 4, NULL); /* drop */
  INIT_RUNINFO (&ri, 384, 288, 384, 144, 2, 4, YUV, 3 / 2);
  ri.out_caps = YUV_CAPS_FULL (384, 144, 50/1);
  check_filter ("fields", &ri, "operation", 7, NULL); /* split */
  INIT_RUNINFO (&ri, 384, 144, 384, 288, 4, 2, YUV, 3 / 2);
  ri.in_caps = YUV_CAPS_FULL (384, 144, 50/1);
  check_filter ("fields", &ri, "operation", 8, NULL); /* merge */
  INIT_RUNINFO (&ri, 384, 288, 384, 288, 2, 4, YUV, 3 / 2);
  ri.out_caps = YUV_CAPS_FULL (384, 288, 50/1);
  check_filter ("fields", &ri, "operation", 9, NULL); /* mix */
}
GST_END_TEST;

Suite *
fields_suite ()
{
  Suite *s = suite_create ("fields");
  TCase *tc_chain = tcase_create ("general");

  suite_add_tcase (s, tc_chain);
  tcase_add_test (tc_chain, test_fields);

  return s;
}

int
main (int argc, char **argv)
{
  int nf;

  Suite *s = fields_suite ();
  SRunner *sr = srunner_create (s);

  gst_check_init (&argc, &argv);

  srunner_run_all (sr, CK_NORMAL);
  nf = srunner_ntests_failed (sr);
  srunner_free (sr);

  return nf;
}
