<?xml version='1.0'?>

<!DOCTYPE xsl:stylesheet [
<!ENTITY % url-entities SYSTEM "../url.entities">
%url-entities;
]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'
                xml:lang="en">


<!-- ********************************************************************

     Pre-DocBook wrapper (processing)

     ******************************************************************** -->

<xsl:output method="xml" />

<!-- identity by default -->

<xsl:template match="@*|node()">
  <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>

<!-- implement element macro -->

<xsl:template match="element">
  <xsl:variable name="element" select="." />
  <xsl:variable name="link" select="concat('base-', $element, '.html')" />
  <xsl:variable name="context" select="ancestor::chapter|ancestor::part" />

  <!-- determine where to link to -->
  <xsl:variable name="gstbase" select="'&url-gst-home;data/doc/gstreamer/head/'" />

  <xsl:variable name="base">
    <xsl:choose>
      <xsl:when test="@repos = 'core'">
        <xsl:value-of select="concat($gstbase, 'gstreamer-plugins/html/gstreamer-plugins')" />
      </xsl:when>
      <xsl:when test="@repos = 'base' or @repos = 'good' or @repos = 'ugly'">
        <xsl:value-of select="concat($gstbase, 'gst-plugins-', @repos,
            '-plugins/html/gst-plugins-', @repos, '-plugins')" />
      </xsl:when>
      <xsl:when test="@repos = 'ffmpeg' or @repos = 'bad'">
        <!--
        <xsl:value-of select="concat($gstbase,
            'gst-ffmpeg-plugins/html/gst-ffmpeg-plugins')" />
            -->
        <!-- no ffmpeg documentation, don't rely on bad either -->
        <xsl:value-of select="''" />
      </xsl:when>
      <xsl:when test="@repos = 'entrans'">
        <xsl:value-of select="concat('&rel-gst-entrans-plugins;', 'gst-entrans-plugins')" />
      </xsl:when>
      <xsl:when test="string(@repos) = ''">
        <xsl:value-of select="''" />
      </xsl:when>
      <!-- some brute error handling -->
      <xsl:otherwise>
        <xsl:message terminate="yes">
          <xsl:value-of select="concat('Unknown repository', @repos)" />
        </xsl:message>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="$base != ''">
      <!-- don't generate link info in man-page -->
      <ulink type="http" url="{concat($base, '-', $element, '.html')}">
        <emphasis>
          <xsl:apply-templates />
      </emphasis>
      </ulink>
    </xsl:when>
    <xsl:otherwise>
      <emphasis>
        <xsl:apply-templates />
      </emphasis>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- ==================================================================== -->

</xsl:stylesheet>
