<?xml version='1.0'?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns="http://www.w3.org/1999/xhtml"
                xmlns:date="http://exslt.org/dates-and-times"  
                exclude-result-prefixes="date"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************

     DocBook XSL customization
     
     ******************************************************************** -->

<xsl:import href="http://docbook.sourceforge.net/release/xsl/current/xhtml/chunk.xsl" />

<xsl:param name="chunker.output.encoding" select="'us-ascii'" />
<xsl:param name="chunker.output.omit-xml-declaration" select="'yes'"/>

<xsl:param name="chunk.section.depth" select="0" />

<xsl:param name="use.id.as.filename" select="1" />

<xsl:param name="css.decoration" select="0" />
<xsl:param name="spacing.paras" select="0" />

<!--<xsl:param name="generate.index" select="1" />-->

<xsl:param name="base.dir" select="'html/'" />

<xsl:param name="html.stylesheet" select="'manual.css'" />

<!--<xsl:param name="toc.max.depth" select="3" />-->

<xsl:param name="generate.toc">
book toc
chapter toc
</xsl:param>

<xsl:param name="local.l10n.xml" select="document('')" />
<l:i18n xmlns:l="http://docbook.sourceforge.net/xmlns/l10n/1.0">
  <l:l10n language="en">
    <l:gentext key="nav-home" text="Table of Contents" />
    <l:gentext key="nav-prev" text="&lt;&lt; Previous" />
    <l:gentext key="nav-next" text="Next &gt;&gt;" />

    <l:context name="xref">
      <l:template name="refsection" text="&#8220;%t&#8221;"/>
      <l:template name="refsect1" text="&#8220;%t&#8221;"/>
      <l:template name="refsect2" text="&#8220;%t&#8221;"/>
      <l:template name="refsect3" text="&#8220;%t&#8221;"/>
      <l:template name="sect1" text="&#8220;%t&#8221;"/>
      <l:template name="sect2" text="&#8220;%t&#8221;"/>
      <l:template name="sect3" text="&#8220;%t&#8221;"/>
      <l:template name="sect4" text="&#8220;%t&#8221;"/>
      <l:template name="sect5" text="&#8220;%t&#8221;"/>
      <l:template name="section" text="&#8220;%t&#8221;"/>
      <l:template name="simplesect" text="&#8220;%t&#8221;"/>
    </l:context>
  </l:l10n>
</l:i18n>

<xsl:template name="user.footer.navigation">
<div class="footer-homepage">
<table width="100%">
<tr>
<td width="40%" align="left">Last created:
<xsl:call-template name="datetime.format">  
   <xsl:with-param name="date" select="date:date-time()"/>  
   <xsl:with-param name="format" select="'Y-m-d X'"/>  
</xsl:call-template>
</td>
<td width="20%" align="center">
<a href="http://gentrans.sourceforge.net/" title="GEntrans: Home page">GEntrans home page</a>
</td>
<td width="40%" align="right"></td>
</tr>
</table>
</div>
</xsl:template>

<xsl:param name="link.mailto.url">
  <xsl:text>mailto:mnauw@users.sourceforge.net</xsl:text>
</xsl:param>

</xsl:stylesheet>

