/* GStreamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include <string.h>

#include <gconf/gconf-client.h>
#include <glade/glade.h>
#include <gst/gst.h>

#include <gst/editor/editor.h>
#include "config.h"

int
main (int argc, char *argv[])
{
  /* FIXME : get rid of these when we remove the startup dialog. */
  GError *error = NULL;
  GConfClient *gconf_client = NULL;
  gboolean hide_dialog = FALSE;

  GstEditor *editor = NULL;
  GnomeProgram *p;
  gboolean launch = FALSE;
  struct poptOption options[] = {
    {NULL, '\0', POPT_ARG_INCLUDE_TABLE, NULL, 0, "Help options:", NULL},
    {"launch",	'l',  POPT_ARG_NONE|POPT_ARGFLAG_STRIP,   &launch,   0,
     "Create pipeline from gst-launch(1) syntax", NULL},
    POPT_TABLEEND
  };
  poptContext context;
  const gchar **argvn;

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  g_type_init ();
  glade_init ();
  gst_scheduler_factory_set_default_name ("basicwingo");
  options[0].arg = (void*)gst_init_get_popt_table ();
  if (!(p = gnome_program_init ("gst-editor", VERSION,
                                LIBGNOMEUI_MODULE,
                                argc, argv,
                                GNOME_PARAM_POPT_TABLE, options,
				GNOME_PARAM_APP_DATADIR, DATADIR,
                                "app-datadir", GST_EDITOR_DATA_DIR,
                                NULL)))
      g_error("cannot gnome_progam_init(), aborting...");

  g_object_get (p, "popt-context", &context, NULL);
  argvn = poptGetArgs (context);

  if (argvn) {
    if (launch) {
      GError *error = NULL;
      GstBin *bin = gst_parse_launchv (argvn, &error);
      if (!bin) {
        g_print ("Error: %s\n", error->message);
        exit (1);
      }
      editor = (GstEditor*)gst_editor_new (GST_ELEMENT (bin));
    } else {
      while (*argvn) {
        editor = (GstEditor*)gst_editor_new (NULL);
        gst_editor_load (editor, *argvn++);
      }
    }
  } else {
    editor = (GstEditor*) gst_editor_new
      (gst_element_factory_make ("pipeline", NULL));
  }

  /* FIXME : temporary hack to display a warning dialog at startup. */
  gconf_client = gconf_client_get_default ();
  hide_dialog = gconf_client_get_bool (gconf_client,
                                       "/apps/gst-editor/hide-warning",
                                       &error);
  if (error || !hide_dialog) {
    gnome_ok_dialog_parented(
      "The GStreamer editor and core have not yet reached a stable development "
      "state. There are known bugs when dealing with some GStreamer plugins. "
      "If you encounter recurring bugs when using particular plugins in the "
      "editor, please file a bug report at http://bugzilla.gnome.org/.\n\n"
      "You can turn off this warning by using the following GConf command: "
      "gconftool -s /apps/gst-editor/hide-warning -t b TRUE",
      GTK_WINDOW(editor->window));
    if (error) g_error_free (error);
  }

  gtk_main();

  exit(0);
}
