//*****************************************************************************
//                                TypeDefs.hpp                                *
//                               --------------                               *
//  Description : This header file mostly contains enumerated type            *
//                definitions which may be used anywhere in the application.  *
//  Started     : 06/09/2007                                                  *
//  Last Update : 19/08/2009                                                  *
//  Copyright   : (C) 2007 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef TYPEDEFS_HPP
#define TYPEDEFS_HPP

// wxWindows Includes

#include <wx/wx.h>
#include <wx/filename.h>

//*****************************************************************************
// Fonts

#define FONT_NORM   wxFont( 9, wxFONTFAMILY_SWISS,  wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL )
#define FONT_BOLD   wxFont( 9, wxFONTFAMILY_SWISS,  wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD   )
#define FONT_SLANT  wxFont( 9, wxFONTFAMILY_SWISS,  wxFONTSTYLE_SLANT,  wxFONTWEIGHT_LIGHT  )
#define FONT_MONO   wxFont( 8, wxFONTFAMILY_MODERN, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL )

//*****************************************************************************
// Enumerated types

// Enumerated type for the various simulator engine types
enum  eSimrType
{
  eSIMR_GNUCAP,   // GNU-Cap
  eSIMR_NGSPICE,  // NG-Spice

  eSIMR_NONE,     // Used if a simulation engine has not yet been selected

  eSIMR_FST = eSIMR_GNUCAP,
  eSIMR_LST = eSIMR_NGSPICE
};

// Enumerated type for the various waveform viewers types
enum  eViewType
{
  eVIEW_GWAVE,  // GWave
  eVIEW_GAW,    // Gaw

  eVIEW_NONE,   // Used if a waveform viewer has not yet been selected

  eVIEW_FST = eVIEW_GWAVE,
  eVIEW_LST = eVIEW_GAW
};

// Enumerated type for the various command types which may be performed
enum  eCmdType
{
  eCMD_OP = 0,  // Quiescent operating point analysis
  eCMD_DC,      // DC analysis
  eCMD_AC,      // AC analysis
  eCMD_TR,      // Transient analysis
  eCMD_FO,      // Fourier analysis
  eCMD_DI,      // Distortion analysis
  eCMD_NO,      // Noise analysis
  eCMD_PZ,      // Pole-zero analysis
  eCMD_SE,      // Sensitivity analysis
  eCMD_TF,      // Transfer function analysis

  eCMD_OPT,     // OPTIONS command
  eCMD_IC,      // Initial conditions command
  eCMD_PR,      // PRINT command
  eCMD_GEN,     // GENERATOR command (GNU-Cap only)

  eCMD_NONE,    // Analysis type not set

  eCMD_FST = eCMD_OP,
  eCMD_LST = eCMD_GEN,

  eCMD_ANA_FST = eCMD_OP,
  eCMD_ANA_LST = eCMD_TF
};

// Enumerated type for the various components
enum  eCpntType
{
  eCPNT_CAP,      // Capacitor
  eCPNT_RES,      // Resistor
  eCPNT_ADM,      // Admittance
  eCPNT_IND,      // Inductor
  eCPNT_DIODE,    // Diode
  eCPNT_BJT,      // Bipolar Junction Transistor
  eCPNT_JFET,     // Junction Field-Effect Transistor
  eCPNT_MOS,      // Metal-Oxide Semiconductor Field-Effect Transistor
  eCPNT_VCVS,     // Voltage Controlled Voltage Source
  eCPNT_CCCS,     // Current Controlled Current Source
  eCPNT_VCCS,     // Voltage Controlled Current Source
  eCPNT_CCVS,     // Current Controlled Voltage Source
  eCPNT_CIND,     // Coupled (Mutual) Inductors
  eCPNT_TLINE,    // Transmission Line
  eCPNT_LOGIC,    // Logic Device
  eCPNT_ICS,      // Independent Current Source
  eCPNT_IVS,      // Independent Voltage Source
  eCPNT_CCSW,     // Current Controlled Switch
  eCPNT_VCSW,     // Voltage Controlled Switch
  eCPNT_SUBCKT,   // Sub-circuit

  eCPNT_NONE,     // None type selected

  eCPNT_FST = eCPNT_CAP,
  eCPNT_LST = eCPNT_SUBCKT
};

// Enumerated type for the various types of units
enum eUnitsType
{
  eUNITS_CAP,      // Capacitance
  eUNITS_IND,      // Inductance
  eUNITS_RES,      // Resistance
  eUNITS_VOLT,     // Voltage
  eUNITS_CURR,     // Current
  eUNITS_TIME,     // Time
  eUNITS_FREQ,     // Frequency
  eUNITS_PHASE,    // Phase
  eUNITS_TEMP,     // Temperature
  eUNITS_SCLR,     // Scalar

  eUNITS_NONE,     // No units specified

  eUNITS_FST = eUNITS_CAP,
  eUNITS_LST = eUNITS_SCLR
};

// Enumerated type for the various parameters which may be determined by analysis
enum  eParType
{
  ePAR_VLT = 0,  // Node or component voltage
  ePAR_CUR,      // Node or component current
  ePAR_PWR,      // Node or component power
  ePAR_RES,      // Input and output resistance

  ePAR_NONE,

  ePAR_FST = ePAR_VLT,
  ePAR_LST = ePAR_RES
};

// Enumerated type for the various sub-parameters which may be determined (AC analysis only)
enum  eCpxType
{
  eCPX_MAG = 0,  // Magnitude      of the complex node or component parameter
  eCPX_PHASE,    // Phase          of the complex node or component parameter
  eCPX_REAL,     // Real part      of the complex node or component parameter
  eCPX_IMAG,     // Imaginary part of the complex node or component parameter
  eCPX_MAGDB,    // Convert the magnitude to dBV

  eCPX_NONE,

  eCPX_FST = eCPX_MAG,
  eCPX_LST = eCPX_MAGDB
};

// Enumerated type for the various step scale types
enum  eScaleType
{
  eSCALE_LIN,
  eSCALE_LOG,
  eSCALE_DEC,
  eSCALE_OCT,

  eSCALE_NONE,

  eSCALE_FST = eSCALE_LIN,
  eSCALE_LST = eSCALE_OCT
};

// Enumerated type for the initial conditions for a transient analysis
enum  eInitCType
{
  eINITC_WARM = 0,  // Warm start
  eINITC_UICS,      // Use initial conditions
  eINITC_COLD,      // Cold start

  eINITC_NONE,

  eINITC_FST = eINITC_WARM,
  eINITC_LST = eINITC_COLD
};

// Enumerated type for the temporary file management strategy
enum eTypeTmpFileMgt
{
  eTFMS_DELETE=0,
  eTFMS_PROMPT,
  eTFMS_KEEP,
  eTFMS_NONE,

  eTFMS_FST = eTFMS_DELETE,
  eTFMS_LST = eTFMS_KEEP
};

//*****************************************************************************
// Define new array types

WX_DECLARE_OBJARRAY( wxFileName, ArrayFileName  );

//*****************************************************************************

#endif // TYPEDEFS_HPP
