//*****************************************************************************
//                                 TextCtrl.hpp                               *
//                                --------------                              *
//  Description : This class extends wxTextCtrl, it adds some useful          *
//                functionality (eg. increment by more than one).             *
//  Started     : 21/06/2004                                                  *
//  Last Update : 25/10/2007                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef TEXTCTRL_HPP
#define TEXTCTRL_HPP

// wxWindows Includes

#include <wx/wx.h>
#include <wx/textctrl.h>
#include <wx/textfile.h>

// System Includes

#include <climits>
#include <iostream>

// Application Includes

#include "TypeDefs.hpp"

// Local Constant Declarations

#define  TXTCTL_INITMSG   wxT("Empty")
#define  TXTCTL_DISPMIN      10    // Minimum allowable lines in display area
#define  TXTCTL_DISPDEF      15    // Default number of lines in display area
#define  TXTCTL_DISPMAX      50    // Maximum allowable lines in display area
#define  TXTCTL_LINESMIN     50    // Minimum allowable lines in control
#define  TXTCTL_LINESDEF   1000    // Default number of lines in control
#define  TXTCTL_LINESMAX  10000    // Maximum allowable lines in control
#define  TXTCTL_VIEWCOLS    122    // The number of columns in display area
#define  TXTCTL_NBKTABHT     40    // Extra height in pixels needed by wxNotebook
#define  TXTCTL_FONTHT       12.7  // Height in pixels of the font

//*****************************************************************************

class TextCtrl : public wxTextCtrl
{
  private:

            wxString  m_osInitMsg;
    static  int       m_iLinesMax; // Max no. lines the text controls will hold
    static  int       m_iLinesDsp; // No. of lines in text control display area
            int       m_iLinesCnt; // No. of lines currently in text control

  public:

    TextCtrl( void );
   ~TextCtrl( );

    bool  bCreate( wxWindow * poWin, wxWindowID oWinID=-1 );
    bool  bIsCreated( void ) { return( GetParent( )!=NULL ? TRUE : FALSE ); }

    bool  bClear( void );
    void  Initialize( void );

            bool  bSetInitMsg ( const wxString & rosMsg );
    static  bool  bSetLinesMax( int iLines );
    static  bool  bSetLinesDsp( int iLines );

    const   wxString & rosGetInitMsg ( void ) { return( m_osInitMsg ); }
            int          iGetLinesMax( void ) { return( m_iLinesMax ); }
            int          iGetLinesDsp( void ) { return( m_iLinesDsp ); }
            int          iGetLinesCnt( void ) { return( m_iLinesCnt ); }
    static  int          iGetPixelHt ( void )
            { return( (int) ( (float) m_iLinesDsp * TXTCTL_FONTHT + 0.5 ) ); }

    bool  bAppendLine( const wxString & rosLine );
    bool  bAppendFile( const wxString & roFName );
    bool  bLoadFile  ( const wxString & roFName );
};

//*****************************************************************************

#endif // TEXTCTRL_HPP
