//*****************************************************************************
//                                NbkSimrBase.cpp                             *
//                               -----------------                            *
//  Started     : 05/05/2004                                                  *
//  Last Update : 20/09/2007                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "base/NbkSimrBase.hpp"

//*****************************************************************************
// Constructor.
//
// Arguments:
//   poParent - The parent window
//   oWinID   - The display object ID
//   roPosn   - The notebook position
//   roSize   - The notebook size

NbkSimrBase::NbkSimrBase( wxWindow * poParent, wxWindowID oWinID )
                        : wxNotebook( poParent, oWinID )
{
  m_eSimrType = eSIMR_NONE;
}

//*****************************************************************************
// Default constructor.
// (Used for two stage creation ie. must call Create( ) method.

NbkSimrBase::NbkSimrBase( void ) : wxNotebook( )
{
  m_eSimrType = eSIMR_NONE;
}

//*****************************************************************************
// Destructor.

NbkSimrBase::~NbkSimrBase( )
{
}

//*****************************************************************************
// Set the simulator engine type managed by this notebook.
//
// Argument List:
//   eType - The simulator engine type specifier
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  NbkSimrBase::bSetSimrType( eSimrType eType )
{
  if( eType<eSIMR_FST || eType>eSIMR_LST ) return( FALSE );

  m_eSimrType = eType;

  return( TRUE );
}

//*****************************************************************************
// Get any error message active in the simulation configuration page.
//
// Return Values:
//   The error message (an empty string if no error active)

const wxString & NbkSimrBase::rosGetErrMsg( void )
{
  PnlAnaBase * poPnlAna=NULL;

  poPnlAna = (PnlAnaBase *) GetPage( GetSelection( ) ); 

  return( poPnlAna->rosGetErrMsg( ) );
}

//*****************************************************************************
