//*****************************************************************************
//                              CmdNgSpicePR.cpp                              *
//                             ------------------                             *
//  Started     : 16/10/2007                                                  *
//  Last Update : 23/10/2007                                                  *
//  Copyright   : (C) 2007 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "ngspice/commands/CmdNgSpicePR.hpp"

//*****************************************************************************
// Constructor.

CmdNgSpicePR::CmdNgSpicePR( void )
{
  bClear( );
}

//*****************************************************************************
// Destructor.

CmdNgSpicePR::~CmdNgSpicePR( )
{
}

//*****************************************************************************
// Parse the command string.
//
// Eg.s : .PRINT AC VM(6,0) 0-VM(5) VM(1,7) VM(2) VP(6,0) 0-VP(5) VP(1,7) VP(2)
//        .PRINT AC VDB(4)
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpicePR::bParse( void )
{
  wxStringTokenizer  ostk1;
  wxString           os1;
  int                i1, i2;

  // Tokenize the command string
  ostk1.SetString( *this );
  if( ostk1.CountTokens( ) < 3 ) return( FALSE );

  // Clear object attributes but keep the command string
  bClear( );
  (wxString &) *this = ostk1.GetString( );

  // Check command type
  os1 = ostk1.GetNextToken( ).Left( 6 ).Upper( );
  if( os1 != wxT(".PRINT") )        return( FALSE );
  m_osName = wxT("PRINT");

  m_bIsOk = TRUE;

  // Extract the analysis type
  os1 = ostk1.GetNextToken( );
  if(      os1 == wxT("DC")   ) m_eAnaType = eANA_DC;
  else if( os1 == wxT("AC")   ) m_eAnaType = eANA_AC;
  else if( os1 == wxT("TRAN") ) m_eAnaType = eANA_TR;
  else m_bIsOk = FALSE;

  // Not yet implemented
  m_bIsOk = FALSE;

//  // Extract the parameters to derive, any complex parts and the test component
//  // and/or test node labels
//  while( ostk1.HasMoreTokens( ) )
//  {
//    // Extract the next field
//    os1 = ostk1.GetNextToken( );
//    if( os1.Length( ) < 4 ) { m_bIsOk = FALSE; continue; }
//
//    // Standardize the parameter format; there are 3 possible formats eg. V(n),
//    // V(n,m) or 0-V(n). The latter is reformatted to : V(0,n).
//    if( os1.StartsWith( wxT("0-") ) )
//    {
//      i1 = os1.Index( wxT('(') );
//      i2 = os1.Index( wxT(')') );
//      if( i1!=-1 && i2!=-1 && i2>(i1+1) )
//        os1 = os1.Mid( 2, (size_t) i1-1 ) + wxT("0,") + os1.Mid( (size_t) i1+1 );
//    }
//
//    // Extract the parameter specifierss
//    switch( os1.GetChar( 0 ) )
//    {
//      case wxT('V') : m_bParmtrs[ ePAR_VLT ] = TRUE; break;
//      case wxT('I') : m_bParmtrs[ ePAR_CUR ] = TRUE; break;
//      case wxT('P') : m_bParmtrs[ ePAR_PWR ] = TRUE; break;
//      case wxT('R') : m_bParmtrs[ ePAR_RES ] = TRUE; break;
//      default :       m_bIsOk = FALSE; break;
//    }
//
//    // Extract the complex parts if the analysis type is AC
//    if( m_eAnaType == eANA_AC )
//    {
//      switch( os1.GetChar( 1 ) )
//      {
//        case wxT('M') : m_bCpxPrts[ eCPX_MAG   ] = TRUE; break;
//        case wxT('P') : m_bCpxPrts[ eCPX_PHASE ] = TRUE; break;
//        case wxT('R') : m_bCpxPrts[ eCPX_REAL  ] = TRUE; break;
//        case wxT('I') : m_bCpxPrts[ eCPX_IMAG  ] = TRUE; break;
//        case wxT('D') :
//          if( os1.Mid( 1, 2 ).Upper( ) == wxT("DB") )
//          {
//            m_bCpxPrts[ eCPX_MAG   ] = TRUE;
//            m_bCpxPrts[ eCPX_MAGDB ] = TRUE;
//            break;
//          }
//        default: m_bIsOk = FALSE; break;
//      }
//    }
//
//    // Extract the node label/s, there are 2 possible formats eg. V(n) or
//    // V(n,m). The first denotes a node and the second a component.
//    i1 = os1.Index( wxT('(') );
//    i2 = os1.Index( wxT(')') );
//    if( i1!=-1 && i2!=-1 && i2>(i1+1) )
//    {
//      os1 = os1.Mid( (size_t) i1+1, (size_t) i2-i1-1 );
//      if( os1.Find( wxT(',') ) == -1 ) m_osaNodes.Add( os1 );
//      else                             m_osaCpnts.Add( os1 );
//    }
//    else m_bIsOk = FALSE;
//  }

  return( m_bIsOk );
}

//*****************************************************************************
// Format the command string.
//
// Eg.s : .PRINT AC VM(6,0) 0-VM(5) VM(1,7) VM(2) VP(6,0) 0-VP(5) VP(1,7) VP(2)
//        .PRINT AC VDB(4)
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpicePR::bFormat( void )
{
  wxString  osCmd, osParmtr, osCpxPrt, osNodes;
  int       i1, i2, i3;

  m_bIsOk = FALSE;

  // Set the command name
  osCmd = wxT(".PR");

  // Append the analysis type
  switch( m_eAnaType )
  {
    case eANA_DC : osCmd << wxT(" DC");   break;
    case eANA_AC : osCmd << wxT(" AC");   break;
    case eANA_TR : osCmd << wxT(" TRAN"); break;
    default :      return( FALSE );
  }

  // Not yet implemented
  m_bIsOk = FALSE;

//  // Sequence through the various parameter types
//  for( i2=ePAR_FST; i2<=ePAR_LST; i2++ )
//  {
//    if( ! m_bParmtrs[ i2 ] ) continue;
//
//    switch( (eParType) i2 )
//    {
//      case ePAR_VLT : osParmtr = wxT("V"); break;
//      case ePAR_CUR : osParmtr = wxT("I"); break;
//      case ePAR_PWR : osParmtr = wxT("P"); break;
//      case ePAR_RES : osParmtr = wxT("R"); break;
//      default :       return( FALSE );
//    }
//
//    if( m_eAnaType == eANA_AC )
//    { // Sequence through the various complex parts
//      for( i3=eCPX_FST; i3<=eCPX_LST-1; i3++ )
//      {
//        if( ! m_bCpxPrts[ i3 ] ) continue;
//
//        switch( (eCpxType) i3 )
//        {
//          case eCPX_MAG   :
//            osCpxPrt = ( m_bCpxPrts[ eCPX_MAGDB ] ? wxT("DB") : wxT('M') );
//            break;
//          case eCPX_PHASE : osCpxPrt = wxT('P'); break;
//          case eCPX_REAL  : osCpxPrt = wxT('R'); break;
//          case eCPX_IMAG  : osCpxPrt = wxT('I'); break;
//          default :         return( FALSE );
//        }
//      }
//    }
//    else osCpxPrt = wxT("");
//
//    // Append a variable to command
//    osCmd << osParmtr << osCpxPrt << wxT('(') << osNodes << wxT(')');
//  }

//  m_bIsOk = TRUE;
//  (wxString) *this = os1;

  return( TRUE );
}

//*****************************************************************************
// Clear the object attributes.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpicePR::bClear( void )
{
  bool  bRtnValue;
  int   i1;

  bRtnValue = CmdBase::bClear( );

  m_eAnaType = eANA_NONE;

  m_osaNodes.Empty( );
  m_osaCpnts.Empty( );

  for( i1=(int)ePAR_FST; i1<=(int)ePAR_LST; i1++ ) m_bParmtrs[ i1 ] = FALSE;
  for( i1=(int)eCPX_FST; i1<=(int)eCPX_LST; i1++ ) m_bCpxPrts[ i1 ] = FALSE;

  return( bRtnValue );
}

//*****************************************************************************
