//*****************************************************************************
//                                 CmdBase.cpp                                *
//                                -------------                               *
//  Started     : 31/08/2006                                                  *
//  Last Update : 22/08/2007                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "base/CmdBase.hpp"

//*****************************************************************************
// Constructor.

CmdBase::CmdBase( void ) : wxString( wxT("") )
{
  bClear( );
}

//*****************************************************************************
// Destructor.

CmdBase::~CmdBase( )
{
}

//*****************************************************************************
// Clear the object attributes.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdBase::bClear( void )
{
  m_bIsOk = FALSE;

  m_osName.Empty( );

  wxString::Empty( );

  return( TRUE );
}

//*****************************************************************************
// Get the command string.
//
// Return Values:
//   The command string

wxString & CmdBase::rosGetCmd( void )
{
  bFormat( );

  return( *((wxString *) this) );
}

//*****************************************************************************
// Set the command string.
//
// Argument List:
//   rosCmd - A string reference containing the command
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdBase::bSetCmd( const wxString & rosCmd )
{
  if( rosCmd.IsEmpty( ) ) return( FALSE );

  *((wxString *) this) = rosCmd;
  if( ! bParse( ) )       return( FALSE );

  return( TRUE );
}

//*****************************************************************************
