#include <stdio.h>

typedef struct				/* Builtin Standard Encoding */
{
   int  index;
   char *name;
} EncodingTable;
static EncodingTable StdEnc[] = {
   040 , "space",
   041 , "exclam",
   042 , "quotedbl",
   043 , "numbersign",
   044 , "dollar",
   045 , "percent",
   046 , "ampersand",
   047 , "quoteright",
   050 , "parenleft",
   051 , "parenright",
   052 , "asterisk",
   053 , "plus",
   054 , "comma",
   055 , "hyphen",
   056 , "period",
   057 , "slash",
   060 , "zero",
   061 , "one",
   062 , "two",
   063 , "three",
   064 , "four",
   065 , "five",
   066 , "six",
   067 , "seven",
   070 , "eight",
   071 , "nine",
   072 , "colon",
   073 , "semicolon",
   074 , "less",
   075 , "equal",
   076 , "greater",
   077 , "question",
  0100 , "at",
  0101 , "A",
  0102 , "B",
  0103 , "C",
  0104 , "D",
  0105 , "E",
  0106 , "F",
  0107 , "G",
  0110 , "H",
  0111 , "I",
  0112 , "J",
  0113 , "K",
  0114 , "L",
  0115 , "M",
  0116 , "N",
  0117 , "O",
  0120 , "P",
  0121 , "Q",
  0122 , "R",
  0123 , "S",
  0124 , "T",
  0125 , "U",
  0126 , "V",
  0127 , "W",
  0130 , "X",
  0131 , "Y",
  0132 , "Z",
  0133 , "bracketleft",
  0134 , "backslash",
  0135 , "bracketright",
  0136 , "asciicircum",
  0137 , "underscore",
  0140 , "quoteleft",
  0141 , "a",
  0142 , "b",
  0143 , "c",
  0144 , "d",
  0145 , "e",
  0146 , "f",
  0147 , "g",
  0150 , "h",
  0151 , "i",
  0152 , "j",
  0153 , "k",
  0154 , "l",
  0155 , "m",
  0156 , "n",
  0157 , "o",
  0160 , "p",
  0161 , "q",
  0162 , "r",
  0163 , "s",
  0164 , "t",
  0165 , "u",
  0166 , "v",
  0167 , "w",
  0170 , "x",
  0171 , "y",
  0172 , "z",
  0173 , "braceleft",
  0174 , "bar",
  0175 , "braceright",
  0176 , "asciitilde",
  0241 , "exclamdown",
  0242 , "cent",
  0243 , "sterling",
  0244 , "fraction",
  0245 , "yen",
  0246 , "florin",
  0247 , "section",
  0250 , "currency",
  0251 , "quotesingle",
  0252 , "quotedblleft",
  0253 , "guillemotleft",
  0254 , "guilsinglleft",
  0255 , "guilsinglright",
  0256 , "fi",
  0257 , "fl",
  0261 , "endash",
  0262 , "dagger",
  0263 , "daggerdbl",
  0264 , "periodcentered",
  0266 , "paragraph",
  0267 , "bullet",
  0270 , "quotesinglbase",
  0271 , "quotedblbase",
  0272 , "quotedblright",
  0273 , "guillemotright",
  0274 , "ellipsis",
  0275 , "perthousand",
  0277 , "questiondown",
  0301 , "grave",
  0302 , "acute",
  0303 , "circumflex",
  0304 , "tilde",
  0305 , "macron",
  0306 , "breve",
  0307 , "dotaccent",
  0310 , "dieresis",
  0312 , "ring",
  0313 , "cedilla",
  0315 , "hungarumlaut",
  0316 , "ogonek",
  0317 , "caron",
  0320 , "emdash",
  0341 , "AE",
  0343 , "ordfeminine",
  0350 , "Lslash",
  0351 , "Oslash",
  0352 , "OE",
  0353 , "ordmasculine",
  0361 , "ae",
  0365 , "dotlessi",
  0370 , "lslash",
  0371 , "oslash",
  0372 , "oe",
  0373 , "germandbls",
    0,      0
};

main(ac,ag)
char **ag;
{
  char *fontname;
  char familyname[256];
  int i;

  if(ac<3)exit(1);
  fontname=ag[1];
  sprintf(familyname,"%s.r%s",fontname,ag[2]);
  printf("StartFontMetrics 2.0\n");
  printf("FontName %s\n",fontname);
  printf("FullName %s\n",fontname);
  printf("FamilyName %s\n",familyname);
  printf("Weight Regular\n");
  printf("ItalicAngle 0\n");
  printf("IsFixedPitch true\n");
  printf("FontBBox 0 0 1000 1000\n");
  printf("UnderlinePosition 0\n");
  printf("UnderlineThickness 0\n");
  printf("Version 001.001\n");
  printf("EncodingScheme StandardEncoding\n");
  printf("StartCharMetrics %d\n",0x7e-0x20);
  for(i=0x21;i<=0x7e;i++)
    printf("C %d ; WX 1000 ; N %s ; B 0 0 1000 1000 ;\n",i,StdEnc[i-040].name);
  printf("EndCharMetrics\n");
  printf("EndFontMetrics\n");
}
