/* GSAMBAD, an easy to use GTK+ frontend for the SAMBA file and print server.
 * Copyright (C) 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "commands.h"
#include "activate_button_clicked.h"
#include "add_standard_users.h"
#include "functions.h"
#include "show_info.h"

extern int activated;



void activate_button_clicked(struct w *widgets)
{
    gchar *start, *test;

    if( activated )
      return;

    /* If theres no file, nothing is reported so show info if thats the case */
    if( ! file_exists(SAMBA_CONF) )
    {
        test = g_strdup_printf("Cant start the server, missing configuration file:\n%s\n", SAMBA_CONF);
        show_info(test);
        g_free(test);
	return;
    }

    /* Make sure we have the required standard users and groups */
    if( ! add_standard_users() )
    {
	printf("Error adding standard users and groups.\n");
	return;
    }


    // FIXME .. use conf paths from settings.

    // Use runlevel start scripts instead ???

    /* Start SMBD */
    start = g_strdup_printf("%s -D -s %s", SMBD_BINARY, SAMBA_CONF);
    if( ! run_command(start) )
    {
        printf("Starting samba (smbd) failed using this command: %s\n", start);
        test = g_strdup_printf("%s -D -s %s 2>&1", SMBD_BINARY, SAMBA_CONF);
	run_command_show_err(test);
	g_free(test);
	g_free(start);
	return;
    }
    g_free(start);


    /* Start NMBD */
    start = g_strdup_printf("%s -D -s %s", NMBD_BINARY, SAMBA_CONF);
    if( ! run_command(start) )
    {
        printf("Starting samba (nmbd) failed using this command: %s\n", start);
        test = g_strdup_printf("%s -D -s %s 2>&1", NMBD_BINARY, SAMBA_CONF);
	run_command_show_err(test);
	g_free(test);
	g_free(start);
	return;
    }
    g_free(start);

    /* Start WinBindD */
    start = g_strdup_printf("%s -D -s %s", WINBINDD_BINARY, SAMBA_CONF);
    if( ! run_command(start) )
    {
        printf("Starting winbindd failed using this command: %s\nThe main SAMBA servers are working ok.\n", start);
        test = g_strdup_printf("%s -D -s %s 2>&1", WINBINDD_BINARY, SAMBA_CONF);
	run_command_show_err(test);
	g_free(test);
	g_free(start);
	return;
    }
    g_free(start);
}
