/*-----------------------------------------------------------------+
 |                                                                 |
 |  Copyright (C) 2002-2003 Grubconf                               |
 |                     http://grubconf.sourceforge.net/            | 
 |                                                                 |
 | This program is free software; you can redistribute it and/or   |
 | modify it under the terms of the GNU General Public License     |
 | as published by the Free Software Foundation; either version 2  |
 | of the License, or (at your option) any later version           |
 |                                                                 |
 | This program is distributed in the hope that it will be useful, |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of  |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   |
 | GNU General Public License for more details.                    |
 |                                                                 |
 | A copy of the GNU General Public License may be found in the    |
 | installation directory named "COPYING"                          |
 |                                                                 |
 +-----------------------------------------------------------------+
 */
/*
 * contains all callback functions from gui events
 */

#include <config.h>

#include <gnome.h>
#include <string.h>
#include <fstab.h>
#include <sys/wait.h>
#include <unistd.h>
#include <fnmatch.h>

#include <include/grubconf_global.h>
#include <include/callbacks.h>
#include <include/interface.h>
#include <include/support.h>


void 
on_chkSplash_toggled (GtkToggleButton * togglebutton, gpointer user_data) 
{
	GtkWidget *optGenSplashDev = lookup_widget (winMain, "optGenSplashDev");
	GtkWidget *txtGenSplash = lookup_widget (winMain, "txtGenSplash");
	GtkWidget *cmdSplashFind = lookup_widget (winMain, "cmdSplashFind");
	gboolean active = gtk_toggle_button_get_active (togglebutton);
	
	gtk_widget_set_sensitive (optGenSplashDev, active);
	gtk_widget_set_sensitive (txtGenSplash, active);
	gtk_widget_set_sensitive (cmdSplashFind, active);

	if (cmdOSRevertMain) {
		gtk_widget_set_sensitive (cmdOSRevertMain, TRUE);
	}
}

void 
on_chkColor_toggled (GtkToggleButton * togglebutton, gpointer user_data)
{
	GtkWidget *optNFor = lookup_widget (winMain, "optNFor");
	GtkWidget *optNBak = lookup_widget (winMain, "optNBak");
	GtkWidget *optHFor = lookup_widget (winMain, "optHFor");
	GtkWidget *optHBak = lookup_widget (winMain, "optHBak");
	gboolean active = gtk_toggle_button_get_active (togglebutton);

	gtk_widget_set_sensitive (optNFor, active);
	gtk_widget_set_sensitive (optNBak, active);
	gtk_widget_set_sensitive (optHFor, active);
	gtk_widget_set_sensitive (optHBak, active);

	if (cmdOSRevertMain) {
		gtk_widget_set_sensitive (cmdOSRevertMain, TRUE);
	}
}


void
on_cmdOSNew_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *optOSType =
		lookup_widget (diaOS, "optOSType");
	gtk_widget_set_sensitive (optOSType, TRUE);
	reset_diaOS ();
	gtk_widget_show (diaOS);
	new_os = TRUE;
}


void
on_cmdOsEdit_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *optOSType = lookup_widget (diaOS, "optOSType");
	GtkTreeModel *model;
	GtkTreeSelection *selection = 
	      gtk_tree_view_get_selection ( GTK_TREE_VIEW (lookup_widget (winMain, "treeview1")) );
	GtkTreeIter iter;
	
	if (gtk_tree_selection_get_selected (selection, &model, &iter))
	{
		gtk_widget_set_sensitive (optOSType, FALSE);
		reset_diaOS ();
		edit_diaOS (model, &iter);
		gtk_widget_show (diaOS);
		gtk_window_resize (GTK_WINDOW (diaOS), 1, 1);
	}
	new_os = FALSE;
}


void
on_cmdOsDelete_clicked (GtkButton * button, gpointer user_data)
{
	if (os_list_delete_selected ())
		gtk_widget_set_sensitive (cmdOSRevertMain, TRUE);
}


void
on_txtOSTitle_changed (GtkEditable *editable, gpointer user_data) {
	gchar *tmp_str = gtk_editable_get_chars (editable, 0, -1);
	if (!tmp_str || !*tmp_str) {
		free (tmp_str);
		tmp_str = "[ No Title Entered ]";
	}
	gtk_window_set_title (GTK_WINDOW (diaOS), tmp_str);
}


void
on_optOSType_menu_clicked (GtkMenu * button, gpointer user_data)
{
	GtkWidget *optOSType =
		lookup_widget (diaOS, "optOSType");
	GtkWidget *fraOSLinux =
		lookup_widget (diaOS, "fraOSLinux");
	GtkWidget *fraOSWindows =
		lookup_widget (diaOS, "fraOSWindows");
	GtkWidget *fraOSOther =
		lookup_widget (diaOS, "fraOSOther");
	gint active_index = gtk_option_menu_get_history (GTK_OPTION_MENU (optOSType));
	switch (active_index)
	{
	case 0:
		gtk_widget_hide (fraOSWindows);
		gtk_widget_hide (fraOSOther);
		gtk_widget_show (fraOSLinux);
		break;
	case 1:
		gtk_widget_hide (fraOSLinux);
		gtk_widget_hide (fraOSOther);
		gtk_widget_show (fraOSWindows);
		break;
	case 2:
		gtk_widget_hide (fraOSLinux);
		gtk_widget_hide (fraOSWindows);
		gtk_widget_show (fraOSOther);
		break;
	}
	gtk_window_resize (GTK_WINDOW (diaOS), 1, 1);
}

void
on_cmdOSOk_clicked (GtkButton * button, gpointer user_data)
{
	on_cmdOSApply_clicked (button, user_data);
	gtk_widget_hide (diaOS);
}


void
on_cmdOSApply_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *optOSType = lookup_widget (diaOS, "optOSType");
	enum os_type tmp = get_selected (optOSType);
	if (new_os)
	{
		GtkTreeIter *iter = os_list_new (tmp);
		GtkTreeSelection *selection = 
		      gtk_tree_view_get_selection ( GTK_TREE_VIEW (lookup_widget (winMain, "treeview1")) );
		gtk_tree_selection_select_iter (selection, iter);
		free (iter);
		gtk_widget_set_sensitive (optOSType, FALSE);
		new_os = FALSE;
	}
	else
	{
		os_list_set (tmp);
	}
	gtk_widget_set_sensitive (cmdOSRevertMain, TRUE);
}

void
on_cmdOSCancel_clicked (GtkButton * button, gpointer user_data)
{
	gtk_widget_hide (diaOS);
}

void
on_cmdKernelOpts_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *txtOSLinuxParams = lookup_widget (diaOS, "txtOSLinuxParams");
	gchar* options_string = gtk_editable_get_chars (GTK_EDITABLE (txtOSLinuxParams), 0, -1);
	gchar* parse_string = options_string;
	gchar* other_string = malloc (strlen (options_string) + 1);
	gchar* parse_ptr;
	
	GtkWidget* chkRO      = lookup_widget(diaKernel, "chkRO");
	GtkWidget *chkScsi    = lookup_widget(diaKernel, "chkScsi");
	GtkWidget *chkOther   = lookup_widget(diaKernel, "chkOther");
	GtkWidget *chkScsiHda = lookup_widget(diaKernel, "chkScsiHda");
    GtkWidget *chkScsiHdb = lookup_widget(diaKernel, "chkScsiHdb");
    GtkWidget *chkScsiHdc = lookup_widget(diaKernel, "chkScsiHdc");
    GtkWidget *chkScsiHdd = lookup_widget(diaKernel, "chkScsiHdd");
	GtkWidget *txtOther   = lookup_widget(diaKernel, "txtOther");
	
	//trigger FALSE for chkScsi, thus setting all scsi toggles insensitive
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkRO), FALSE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkScsi), FALSE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkScsiHda), FALSE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkScsiHdb), FALSE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkScsiHdc), FALSE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkScsiHdd), FALSE);
	gtk_editable_delete_text (GTK_EDITABLE (txtOther), 0, -1);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkOther), FALSE);
	on_chkOther_toggled (NULL, NULL);

	*other_string = 0;


	parse_ptr = strtok (parse_string, " ");
	
	while(parse_ptr != NULL)
	{
		if(!(strncmp (parse_ptr, "ro", 2))) {
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkRO), TRUE);
		}
		else if(!(strncmp ( parse_ptr, "hda=ide-scsi", 12))) {
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (chkScsiHda), TRUE);
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (chkScsi), TRUE);
		}
		else if(!(strncmp (parse_ptr, "hdb=ide-scsi", 12))) {
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkScsiHdb), TRUE);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkScsi), TRUE);
		}
		else if(!(strncmp (parse_ptr, "hdc=ide-scsi", 12))) {
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkScsiHdc), TRUE);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkScsi), TRUE);
		}
		else if(!(strncmp (parse_ptr, "hdd=ide-scsi", 12))){ 
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkScsiHdd), TRUE);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkScsi), TRUE);
		}
		else{
			if (*other_string)
				strcat (other_string, " ");

			strcat(other_string, parse_ptr);
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chkOther), TRUE);
		}		

		parse_ptr = strtok(NULL, " ");	
	}
	
		
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (chkOther))) {
		gtk_entry_set_text(GTK_ENTRY(txtOther), (const gchar*) other_string);
	}
		
	free (options_string);
	free (other_string);
		
	gtk_widget_show (diaKernel);
}

void
on_winMain_destroy (GtkObject * object, gpointer user_data)
{
	clean_global ();
	gtk_main_quit ();
}

void on_diaMore_destroy (GtkObject * object, gpointer user_data)
{
	create_diaMore ();
}

void on_cmdMoreClose_clicked (GtkButton * button, gpointer user_data)
{
	gtk_widget_hide (diaMore);
}

void on_cmdMore_clicked (GtkButton * button, gpointer user_data)
{
	gtk_widget_show (diaMore);
}

void
on_diaOS_destroy (GtkObject * object, gpointer user_data)
{
	create_diaOS (); // make sure theres always a diaOS to show when needed
}

void
on_diaKernel_destroy (GtkObject * object, gpointer user_data)
{
	create_diaKernel (); // make sure theres always a diaKernel to show when needed
}


void on_chkScsi_toggled (GtkButton *button, gpointer user_data)
{
	gboolean scsi_checked = FALSE;
	GtkWidget *chkScsiHda = lookup_widget(diaKernel, "chkScsiHda");
	GtkWidget *chkScsiHdb = lookup_widget(diaKernel, "chkScsiHdb");
	GtkWidget *chkScsiHdc = lookup_widget(diaKernel, "chkScsiHdc");
	GtkWidget *chkScsiHdd = lookup_widget(diaKernel, "chkScsiHdd");
	
	scsi_checked = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button));

	gtk_widget_set_sensitive(chkScsiHda, scsi_checked);
	gtk_widget_set_sensitive(chkScsiHdb, scsi_checked);
	gtk_widget_set_sensitive(chkScsiHdc, scsi_checked);
	gtk_widget_set_sensitive(chkScsiHdd, scsi_checked);
}

void 
on_chkOther_toggled (GtkButton *button, gpointer user_data)
{
	GtkWidget *txtOther = lookup_widget (diaKernel, "txtOther");
	GtkWidget *chkOther = lookup_widget (diaKernel, "chkOther");
	gboolean other_checked = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (chkOther));
	gtk_widget_set_sensitive (txtOther, other_checked);
}

void
on_cmdKernCancel_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide (diaKernel);
}

void
on_cmdKernOk_clicked (GtkButton *button, gpointer user_data)
{
	const int max_len = 100;
	//gchar *other_options;
	gboolean mount_read_only = FALSE;
	gboolean check_scsi = FALSE;
	gboolean emu_hda = FALSE;
	gboolean emu_hdb = FALSE;
	gboolean emu_hdc = FALSE;
	gboolean emu_hdd = FALSE;
	gboolean other_options = FALSE;
	
	//value must be known	
	GtkWidget *chkRO = lookup_widget (diaKernel, "chkRO");
	GtkWidget *chkScsi = lookup_widget (diaKernel, "chkScsi");
	GtkWidget *chkOther = lookup_widget (diaKernel, "chkOther");
	GtkWidget *txtOSLinuxParams = lookup_widget (diaOS, "txtOSLinuxParams");
	gchar     *final_string;
	gchar     *final_ptr;

	//values dependent on truth of above values
	GtkWidget *chkScsiHda;
    GtkWidget *chkScsiHdb;
    GtkWidget *chkScsiHdc;
    GtkWidget *chkScsiHdd;
	GtkWidget *txtOther = lookup_widget (diaKernel, "txtOther");
	gchar     *options_string = gtk_editable_get_chars (GTK_EDITABLE (txtOther), 0, -1);
	
	// to combat an obsurdly long value
	if (strlen (options_string) > max_len) {
		realloc (options_string, max_len);
		options_string[max_len - 1] = '\0';
	}
//	gchar *options_final = NULL;
		
	
	mount_read_only = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (chkRO));
    check_scsi = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (chkScsi));
    
	if(check_scsi){
		chkScsiHda = lookup_widget (diaKernel, "chkScsiHda");
        chkScsiHdb = lookup_widget (diaKernel, "chkScsiHdb");
        chkScsiHdc = lookup_widget (diaKernel, "chkScsiHdc");
        chkScsiHdd = lookup_widget (diaKernel, "chkScsiHdd");
    	emu_hda = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (chkScsiHda));
    	emu_hdb = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (chkScsiHdb));
    	emu_hdc = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (chkScsiHdc));
    	emu_hdd = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (chkScsiHdd));
    }
	
	other_options = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chkOther));
/*	
	if(other_options){
		options_final = malloc(sizeof(gchar)*strlen(options_string)+1);
		strcpy(options_final, options_string);
	}
*/	
	final_string = malloc (150);
	*final_string = 0;
	final_ptr = final_string;
//	strcpy(final_string, ""); //initialize the string to blank (weird gchar* interaction)
	int tmp_index = 0;
	
	
    if(mount_read_only){
		strncpy (final_ptr, "ro", 3);
	}		
	
	if(emu_hda){
		// this is to insert a space when needed. I dont use strcncat
		//  because I just need to shuffle one char in there and I
		//  can do this really quick
		if (*final_string) {
			tmp_index = strlen (final_ptr);
			final_ptr[tmp_index + 1] = '\0';
			final_ptr[tmp_index] = ' ';
			final_ptr += tmp_index + 1;
		}
		strncpy (final_ptr, "hda=ide-scsi", 13);
	}
	
	if(emu_hdb){
		if (*final_string) {
			tmp_index = strlen (final_ptr);
			final_ptr[tmp_index + 1] = '\0';
			final_ptr[tmp_index] = ' ';
			final_ptr += tmp_index + 1;
		}
		strncpy (final_ptr, "hdb=ide-scsi", 13);
	}
	
	if(emu_hdc){
		if (*final_string) {
			tmp_index = strlen (final_ptr);
			final_ptr[tmp_index + 1] = '\0';
			final_ptr[tmp_index] = ' ';
			final_ptr += tmp_index + 1;
		}
		strncpy (final_ptr, "hdc=ide-scsi", 13);
	}
	
	if(emu_hdd){
		if (*final_string) {
			tmp_index = strlen (final_ptr);
			final_ptr[tmp_index + 1] = '\0';
			final_ptr[tmp_index] = ' ';
			final_ptr += tmp_index + 1;
		}
		strncpy (final_ptr, "hdd=ide-scsi", 13);
	}
	
	if(other_options && *options_string){
		if (*final_string) {
			tmp_index = strlen (final_ptr);
			final_ptr[tmp_index + 1] = '\0';
			final_ptr[tmp_index] = ' ';
			final_ptr += tmp_index + 1;
		}
		strcpy(final_ptr, options_string);
		free(options_string);
	}
	
	
	gtk_entry_set_text (GTK_ENTRY (txtOSLinuxParams), (const char*)final_string);
	
	free (final_string);
	
	gtk_widget_hide (diaKernel);	
}

void
splash_replace( GtkWidget *w, GtkFileSelection *fs)
{
	if (!dir_pointer) {
		gtk_message(GTK_MESSAGE_WARNING, _("Internal error setting splash image"));
		return;
	}
	
    GtkWidget *txtGenSplash = lookup_widget (winMain, "txtGenSplash");
    char* file_returned = strdup (gtk_file_selection_get_filename(GTK_FILE_SELECTION (fs)));
	int valid_file;
	int len = strlen(dir_pointer);
	
	if(strncmp(file_returned, dir_pointer, len) == 0) {
		
		file_returned += len - 1;
		/* if the file doesn't end in .xpm AND doesn't end in .xpm.gz
		   then it is an invalid splash file */
		if(!(valid_file = fnmatch ("*.xpm", file_returned, 0)) == 0 && 
		   !(valid_file = fnmatch ("*.xpm.gz", file_returned, 0)) == 0)
		{
			gtk_message(GTK_MESSAGE_WARNING, _("Splash Files must be of extension .xpm.gz"));
		} else {
			gtk_entry_set_text (GTK_ENTRY(txtGenSplash), file_returned);
		}

	} else {
		gtk_message(GTK_MESSAGE_WARNING, _("Splash Image must be in %s"), dir_pointer);
	}
	
	free (file_returned);
}

void
kernel_replace( GtkWidget *w, GtkFileSelection *fs)
{
	if (!dir_pointer) {
		gtk_message(GTK_MESSAGE_WARNING, _("Internal error setting splash image"));
		return;
	}
	
    GtkWidget *txtOSLinuxKernel = lookup_widget (diaOS, "txtOSLinuxKernel");
    char* file_returned = strdup (gtk_file_selection_get_filename(GTK_FILE_SELECTION (fs)));
	int len = strlen(dir_pointer);
	
	if(strncmp(file_returned, dir_pointer, len) == 0) {
		file_returned += len - 1;
		gtk_entry_set_text (GTK_ENTRY(txtOSLinuxKernel), file_returned);
	} else {
		gtk_message(GTK_MESSAGE_WARNING, _("Kernel must be in %s"), dir_pointer);
	}
	free (file_returned);
}

void
on_cmdFileFind_clicked ( GtkButton *button, gpointer user_data ) 
{
    GtkWidget *file;
	int selected_device_index;	
	struct grubconf_dev *selected_device;
	GtkWidget *parent;
	char *tmp_str;
	
	if(GTK_BUTTON(lookup_widget(winMain, "cmdSplashFind")) == button) {
        file = gtk_file_selection_new (_("Select a splash image"));
   	    g_signal_connect (G_OBJECT (GTK_FILE_SELECTION (file)->ok_button),
		      "clicked", G_CALLBACK (splash_replace), (gpointer) file);
    	gtk_window_set_modal (GTK_WINDOW (file), TRUE);       		

		GtkWidget *device = lookup_widget (winMain, "optGenSplashDev");
		selected_device_index = get_selected (device);
	    selected_device = get_dev (selected_device_index);
		parent = winMain;
    
	} else if(GTK_BUTTON(lookup_widget(diaOS, "cmdKernelFind")) == button) {
        file = gtk_file_selection_new (_("Select a kernel"));
   	    g_signal_connect (G_OBJECT (GTK_FILE_SELECTION (file)->ok_button),
		      "clicked", G_CALLBACK (kernel_replace), (gpointer) file);
    	gtk_window_set_modal (GTK_WINDOW (file), TRUE);       		
    	        		
		GtkWidget *device = lookup_widget (diaOS, "optLinuxBootDev");
		selected_device_index = get_selected (device);
	    selected_device = get_dev (selected_device_index);
		parent = diaOS;    
	}
    else {
		gtk_message (GTK_MESSAGE_ERROR, _("Unable to determine the destination"));
		return;
	}
	
	if (!selected_device || !selected_device->mount_point || !selected_device->dev_name) {
		gtk_message (GTK_MESSAGE_ERROR, _("Unable to validate device"));
		return;
	}
	
	if (!selected_device->mounted) {
		GtkWidget *dialog = gtk_message_dialog_new (GTK_WINDOW (parent),
								GTK_DIALOG_DESTROY_WITH_PARENT,
								GTK_MESSAGE_QUESTION,
								GTK_BUTTONS_YES_NO,
								_("Device: %s\nMount Point: %s\n\n"
								"This device is not mounted, Should I mount?"),
								selected_device->dev_name, 
								selected_device->mount_point);

		if ( gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_YES) {
			gtk_widget_destroy (dialog);
			if (!mount_from_dev (selected_device)) {
				gtk_message (GTK_MESSAGE_ERROR, _("Unable to mount %s"), 
					selected_device->dev_name);
				return;
			}
			reset_dev_menus ();
		} else {
			gtk_widget_destroy (dialog);
			gtk_message (GTK_MESSAGE_WARNING, _("Device must be mounted to use file selection"));	
			return;
		}
	}
	
	if (strcmp ("/", selected_device->mount_point) == 0) {
		tmp_str = selected_device->mount_point;
	} else {
		tmp_str = malloc (100);
		sprintf (tmp_str, "%s/", selected_device->mount_point);
	}
	
	dir_pointer = tmp_str;

	gtk_file_selection_set_filename(GTK_FILE_SELECTION(file), dir_pointer); //set the directory of the file selection to dir

		
	g_signal_connect_swapped (G_OBJECT (GTK_FILE_SELECTION (file)->ok_button),
              "clicked", G_CALLBACK (gtk_widget_destroy), G_OBJECT (file));
    g_signal_connect_swapped (G_OBJECT (GTK_FILE_SELECTION (file)->cancel_button),
              "clicked", G_CALLBACK (gtk_widget_destroy), G_OBJECT (file));
	
	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(file));

	gtk_widget_show (file);
}


void
on_cmdOSHelpMain_clicked (GtkButton * button, gpointer user_data) 
{
//	gtk_warning("Manual has not yet been implemented\n\nType 'man grubconf' at a console for information on using grubconf");
	gtk_widget_show (diaHelp);
}

void
on_cmdOSOkMain_clicked (GtkButton * button, gpointer user_data) 
{

	if (!GTK_WIDGET_SENSITIVE(cmdOSRevertMain)) {
		clean_global();
		gtk_main_quit();
		return;
	}
	copy (grubconf_fname, grubconf_fname_bak);
	if (save_to_file()) {
		clean_global ();
		gtk_main_quit ();
	}
}

void
on_cmdOSRevertMain_clicked (GtkButton * button, gpointer user_data) 
{
	GtkWidget *timeout_spin = lookup_widget (winMain, "timeout_spin");
	GtkWidget *chkGenHidden = lookup_widget (winMain, "chkGenHidden");
	GtkWidget *tvGenExtra = lookup_widget (diaMore, "tvGenExtra");
	GtkTextBuffer *tbGenExtra =
		gtk_text_view_get_buffer (GTK_TEXT_VIEW (tvGenExtra));

	// first clear GUI
	os_list_clean ();
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (timeout_spin), 10);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkGenHidden), FALSE);

#if USE_SPLASHIMAGE

	GtkWidget *optGenSplashDev =
		lookup_widget (winMain, "optGenSplashDev");
	GtkWidget *txtGenSplash = lookup_widget (winMain, "txtGenSplash");
	GtkWidget *chkSplash = lookup_widget (winMain, "chkSplash");
	
	gtk_option_menu_set_history (GTK_OPTION_MENU (optGenSplashDev), 0);
	gtk_editable_delete_text (GTK_EDITABLE (txtGenSplash), 0, -1);
	
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkSplash), FALSE);

#else

	GtkWidget *optNFor = lookup_widget (winMain, "optNFor");
	GtkWidget *optNBak = lookup_widget (winMain, "optNBak");
	GtkWidget *optHFor = lookup_widget (winMain, "optHFor");
	GtkWidget *optHBak = lookup_widget (winMain, "optHBak");
	
	GtkWidget *chkColor = lookup_widget (winMain, "chkColor");
	
	gtk_option_menu_set_history (GTK_OPTION_MENU (optNFor), 0);
	gtk_option_menu_set_history (GTK_OPTION_MENU (optNBak), 0);
	gtk_option_menu_set_history (GTK_OPTION_MENU (optHFor), 0);
	gtk_option_menu_set_history (GTK_OPTION_MENU (optHBak), 0);
	
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chkColor), FALSE);
	
#endif

	gtk_text_buffer_set_text (tbGenExtra, "", 0);

	// now re-load config
	load_from_file();
	
	// then make sure we update the status of the revert button
	gtk_widget_set_sensitive (cmdOSRevertMain, FALSE);
}

void
on_cmdManual_clicked (GtkButton * button, gpointer user_data) 
{
	GError *error = NULL;
	gnome_help_display_uri ("ghelp:/usr/share/gnome/help/grubconf/C/grubconf.xml", &error);
	if (error) {
		gtk_message(GTK_MESSAGE_WARNING, error->message);
	}
	gtk_widget_hide (diaHelp);
}

void
on_cmdAbout_clicked (GtkButton * button, gpointer user_data) 
{
	GtkWidget *diaAbout;

	const gchar *authors[] = {
		"Joseph Monti <countjoe@users.sourceforge.net>",
		"Ryan Scotka <evangelionrs@users.sourceforge.net>",
		NULL
	};

	diaAbout = gnome_about_new ("GrubConf", VERSION,
				    _("Copyright (C) 2002-2003 GNU General Public Licence"),
				    _("Grubconf is an editor for the GNU GRUB Boot Loader. For more information on GRUB, visit http://www.gnu.org/software/grub/. \n\nOur Website: http://grubconf.sourceforge.net/"),
				    authors, NULL, NULL, gdk_pixbuf_new_from_file(PACKAGE_PIXMAPS_DIR G_DIR_SEPARATOR_S "grubconf-app.png", NULL));
	gtk_dialog_run (GTK_DIALOG (diaAbout));

	gtk_widget_hide (diaHelp);
}

void
on_timeout_spin_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	gtk_widget_set_sensitive (cmdOSRevertMain, TRUE);
}

void 
on_optGenSplashDev_changed (GtkOptionMenu *optionmenu, gpointer user_data)
{
	gtk_widget_set_sensitive (cmdOSRevertMain, TRUE);
}

void on_optHFor_changed (GtkOptionMenu *optionmenu, gpointer user_data)
{
	GtkWidget *optionmenu2 = lookup_widget (winMain, "optHBak");
	if (get_selected (GTK_WIDGET (optionmenu)) == INVERSE && get_selected (optionmenu2) != DARK_GRAY) {
		gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu2), DARK_GRAY);
	}
	gtk_widget_set_sensitive (cmdOSRevertMain, TRUE);
}

void on_optHBak_changed (GtkOptionMenu *optionmenu, gpointer user_data)
{
	GtkWidget *optionmenu2 = lookup_widget (winMain, "optHFor");
	if (get_selected (GTK_WIDGET (optionmenu)) == DARK_GRAY && get_selected (optionmenu2) != INVERSE) {
		gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu2), INVERSE);
	}
	gtk_widget_set_sensitive (cmdOSRevertMain, TRUE);
}

void 
on_txtGenSplash_changed (GtkEditable *editable, gpointer user_data)
{
	gtk_widget_set_sensitive (cmdOSRevertMain, TRUE);
}

void 
on_chkGenHidden_clicked (GtkButton * button, gpointer user_data)
{
	gtk_widget_set_sensitive (cmdOSRevertMain, TRUE);
}

void 
on_tvGenExtra_changed (GtkTextBuffer *textbuffer, gpointer user_data)
{
	gtk_widget_set_sensitive (cmdOSRevertMain, TRUE);
}

void 
list_toggle (GtkCellRendererToggle *cellrenderertoggle,
                                   gchar *arg1,
                                   gpointer user_data)
{
	GtkTreeModel *model = gtk_tree_view_get_model ( GTK_TREE_VIEW (lookup_widget (winMain, "treeview1")) );
	GtkTreeIter iter;

	int i = 0, index = atoi (arg1);
	
	gtk_tree_model_get_iter_first (model, &iter);
	do {
		if (i == index)
			gtk_list_store_set (GTK_LIST_STORE (model), &iter,
			                    DEFAULT_COLUMN, TRUE,
			                    -1);
		else {
			gtk_list_store_set (GTK_LIST_STORE (model), &iter,
			                    DEFAULT_COLUMN, FALSE,
			                    -1);
		}
		i++;
	} while (gtk_tree_model_iter_next (model, &iter));
	
	gtk_widget_set_sensitive (cmdOSRevertMain, TRUE);
}
