/*-----------------------------------------------------------------+
 |                                                                 |
 |  Copyright (C) 2002-2003 Grubconf                               |
 |                     http://grubconf.sourceforge.net/            | 
 |                                                                 |
 | This program is free software; you can redistribute it and/or   |
 | modify it under the terms of the GNU General Public License     |
 | as published by the Free Software Foundation; either version 2  |
 | of the License, or (at your option) any later version           |
 |                                                                 |
 | This program is distributed in the hope that it will be useful, |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of  |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   |
 | GNU General Public License for more details.                    |
 |                                                                 |
 | A copy of the GNU General Public License may be found in the    |
 | installation directory named "COPYING"                          |
 |                                                                 |
 +-----------------------------------------------------------------+
 */

#ifndef _GRUBCONF_OS_LIST_H_
#define _GRUBCONF_OS_LIST_H_

#include <include/grubconf_global.h>

enum os_type
{ LINUX, WINDOWS, OTHER };

struct os_list_item
{
	enum os_type type;
	void *data;
	char *unknown;
	struct os_list_item *next;
	struct os_list_item *previous;
};

struct os_list_linux
{
	int rdev_index;
	int bdev_index;
	char *kernel;
	char *kernel_parms;
};

struct os_list_windows
{
	int dev_index;
};

/* Creates a new entry in the os list of type t from the current dialog
 */
GtkTreeIter   *os_list_new (enum os_type t);

/* Allocates a new os_list_item of type linux and appends it
 * to the clist
 */
struct os_list_item *os_list_new_linux (gboolean def, char *new_title,
					int rd_index,
					int bd_index,
					char *new_kernel,
					char *new_kernel_parms,
					char *new_unknown);

/* allocates a new os_list_item of type windows and appends it
 * to the clist
 */
struct os_list_item *os_list_new_windows (gboolean def, char *new_title,
					  int index,
					  char *new_unknown);

/* Allocates a new os_list_item of type other and appends it
 * to the clist
 */
struct os_list_item *os_list_new_other (gboolean def, char *new_title, char *new_unknown);

/* Inserts new_item into the list of OS'
 */
GtkTreeIter   *os_list_put(char *title, gboolean def, struct os_list_item *new_item);

/* sets a previously created os list item of type t at index
 */
int os_list_set (enum os_type t);

/* deletes selected os from lists
 */
int os_list_delete_selected (void);

/* deletes provided os from lists
 */
int os_list_delete (GtkTreeModel *model, GtkTreeIter *iter);

/* cleans the internal list of OS's
 */
int os_list_clean (void);

/* free's any dynamic data allocated to item
 */
int os_list_free (struct os_list_item *item);

/* cleans default status from any list items
 */
void os_list_clean_default (void);

#endif
