#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "support.h"
#include "callbacks.h"


int main (int argc, char *argv[]) {
#ifdef ENABLE_NLS
	bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain(GETTEXT_PACKAGE);
#endif

	gtk_set_locale();
	gtk_init(&argc, &argv);

	gint i = 1, result;

	cmdline_session = FALSE;
	cmdline_execute = FALSE;
	cmdline_stayopen = FALSE;
	while (i < argc && argv[i] != NULL) {
		if (argv[i][0] == '-') {
			if (argv[i][1] == 'e') cmdline_execute = TRUE;
			if (argv[i][1] == 's') cmdline_stayopen = TRUE;
		} else {
			argv_session = g_strconcat(argv[i], NULL);
			cmdline_session = TRUE;
		}
		i++;
	}
	if (!cmdline_session) argv_session = g_strconcat("default", NULL);

	if (g_file_test("pixmaps/grsync.png", G_FILE_TEST_EXISTS))
		gtk_window_set_default_icon_from_file("pixmaps/grsync.png", NULL);
	else gtk_window_set_default_icon_from_file(PACKAGE_DATA_DIR "/pixmaps/grsync.png", NULL);

	builder = gtk_builder_new();
	result = gtk_builder_add_from_file(builder, XMLFILE, NULL) || gtk_builder_add_from_file(builder, PACKAGE_DATA_DIR "/" PACKAGE "/" XMLFILE, NULL);
	if (result) {
		main_window = (GtkWidget*) gtk_builder_get_object(builder, "main_window");
		gtk_builder_connect_signals(builder, NULL);
		on_main_create((GtkWindow*) main_window, NULL);		// I run the callback now because the "show" signal seems not to be emitted with gtkbuilder
		gtk_widget_show_all(main_window);
		gtk_main();
	} else {
		printf("Error loading gtkbuilder xml file " XMLFILE "\n");
	}

	g_free(argv_session);
	g_object_unref(G_OBJECT(builder));
	return 0;
}
