#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"


gchar **argv;
GPid rsync_pid;
gchar **groups = NULL;
gint session_last = -1, session_number = 0;


gboolean load_settings(GtkWidget* main, gchar *session) {
	gchar settings_file_path[MAXPATH];
	g_sprintf(settings_file_path, "%s/.grsync/%s", g_get_home_dir(), "grsync.ini");
	
	if (!g_file_test(settings_file_path, G_FILE_TEST_EXISTS)) {
		g_printf (_("(ERROR) Can't open config file! Maybe this is the first run?\n"));
		save_settings(main, session);
		load_groups(main, session);
	}
	
	GError *error_handler = NULL;
	GKeyFile *settings_file;
	gchar *stmp;
	gboolean btmp;
	
	settings_file = g_key_file_new();		
	g_key_file_load_from_file(settings_file, settings_file_path, 	G_KEY_FILE_NONE, &error_handler);
	
	stmp = g_key_file_get_string(settings_file, session, "text_source", NULL);		
	gtk_entry_set_text((GtkEntry*) lookup_widget((GtkWidget*) main, "text_source"), stmp);
	g_free(stmp);

	stmp = g_key_file_get_string(settings_file, session, "text_dest", NULL);		
	gtk_entry_set_text((GtkEntry*) lookup_widget((GtkWidget*) main, "text_dest"), stmp);
	g_free(stmp);
	
	btmp = g_key_file_get_boolean(settings_file, session, "check_time",	NULL);
	gtk_toggle_button_set_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_time"), btmp);
	btmp = g_key_file_get_boolean(settings_file, session, "check_perm",	NULL);
	gtk_toggle_button_set_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_perm"), btmp);
	btmp = g_key_file_get_boolean(settings_file, session, "check_owner",	NULL);
	gtk_toggle_button_set_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_owner"), btmp);
	btmp = g_key_file_get_boolean(settings_file, session, "check_group",	NULL);
	gtk_toggle_button_set_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_group"), btmp);
	btmp = g_key_file_get_boolean(settings_file, session, "check_onefs",	NULL);
	gtk_toggle_button_set_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_onefs"), btmp);
	btmp = g_key_file_get_boolean(settings_file, session, "check_verbose",	NULL);
	gtk_toggle_button_set_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_verbose"), btmp);
	btmp = g_key_file_get_boolean(settings_file, session, "check_progr",	NULL);
	gtk_toggle_button_set_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_progr"), btmp);
	btmp = g_key_file_get_boolean(settings_file, session, "check_delete",	NULL);
	gtk_toggle_button_set_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_delete"), btmp);
	btmp = g_key_file_get_boolean(settings_file, session, "check_exist",	NULL);
	gtk_toggle_button_set_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_exist"), btmp);
	btmp = g_key_file_get_boolean(settings_file, session, "check_size",	NULL);
	gtk_toggle_button_set_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_size"), btmp);
	
	g_key_file_free (settings_file);
	g_clear_error (&error_handler);
}


gboolean save_settings(GtkWidget* main, gchar *session) {
	gchar settings_file_path[MAXPATH];
	gchar settings_file_name[MAXPATH];
  gchar *key_data;
	FILE *key_file;
	GError *error_handler = NULL;
	GKeyFile *settings_file;
	gboolean btmp;
	const gchar *stmp;
	
	g_sprintf(settings_file_path, "%s/.grsync", g_get_home_dir());
	g_sprintf(settings_file_name, "%s/%s", settings_file_path, "grsync.ini");
	
//	g_printf(_("Saving settings to %s...\n"), settings_file_name);
//	set_statusbar_text (_("Saving settings..."));
	g_mkdir(settings_file_path, 0700);
	settings_file = g_key_file_new();
	g_key_file_load_from_file(settings_file, settings_file_name, G_KEY_FILE_NONE, NULL);

	stmp = gtk_entry_get_text((GtkEntry*) lookup_widget((GtkWidget*) main, "text_source"));
	g_key_file_set_string(settings_file, session, "text_source", stmp);
	stmp = gtk_entry_get_text((GtkEntry*) lookup_widget((GtkWidget*) main, "text_dest"));
	g_key_file_set_string(settings_file, session, "text_dest", stmp);

	btmp = gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_time"));
	g_key_file_set_boolean(settings_file, session, "check_time", btmp);
	btmp = gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_perm"));
	g_key_file_set_boolean(settings_file, session, "check_perm", btmp);
	btmp = gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_owner"));
	g_key_file_set_boolean(settings_file, session, "check_owner", btmp);
	btmp = gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_group"));
	g_key_file_set_boolean(settings_file, session, "check_group", btmp);
	btmp = gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_onefs"));
	g_key_file_set_boolean(settings_file, session, "check_onefs", btmp);
	btmp = gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_verbose"));
	g_key_file_set_boolean(settings_file, session, "check_verbose", btmp);
	btmp = gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_progr"));
	g_key_file_set_boolean(settings_file, session, "check_progr", btmp);
	btmp = gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_delete"));
	g_key_file_set_boolean(settings_file, session, "check_delete", btmp);
	btmp = gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_exist"));
	g_key_file_set_boolean(settings_file, session, "check_exist", btmp);
	btmp = gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) main, "check_size"));
	g_key_file_set_boolean(settings_file, session, "check_size", btmp);

	key_data = g_key_file_to_data(settings_file, NULL, &error_handler);
	key_file = fopen(settings_file_name, "w");
	if (key_file != NULL) {
		fputs(key_data, key_file);
		fclose(key_file);
//		g_printf(_("\tSettings saved!\n"));
	} else {
		g_printf(_("\tUnable to save settings!\n"));
	}
	
	g_key_file_free(settings_file);
	g_clear_error(&error_handler);
}


gboolean load_groups(GtkWidget* main, gchar *session) {
	gchar settings_file_path[MAXPATH];
	g_sprintf(settings_file_path, "%s/.grsync/%s", g_get_home_dir(), "grsync.ini");
	
	if (g_file_test(settings_file_path, G_FILE_TEST_EXISTS)) {
		GError *error_handler = NULL;
		GKeyFile *settings_file;
		GtkComboBox *combo;
		gint i;
		
		combo = (GtkComboBox*) lookup_widget(main, "combo_session");
//		while (i = gtk_combo_box_get_active(combo) != -1) gtk_combo_box_remove_text(combo, i);
		for (i = 0; i < session_number; i++) gtk_combo_box_remove_text(combo, 0);
		
		settings_file = g_key_file_new();		
		g_key_file_load_from_file(settings_file, settings_file_path, 	G_KEY_FILE_NONE, &error_handler);
		groups = g_key_file_get_groups(settings_file, &session_number);
		
		i = 0;
		while (groups[i] != NULL) {
			gtk_combo_box_insert_text(combo, i, groups[i]);
			if (strcmp(groups[i], session) == 0) {
				gtk_combo_box_set_active(combo, i);
				session_last = i;
			}
			i++;
		}
		
		g_key_file_free (settings_file);
		g_clear_error (&error_handler);
		return TRUE;
	}	else {
		g_printf (_("(ERROR) Can't open config file! Maybe this is the first run?\n"));
		return FALSE;
	}
}


void show_browse_source(GtkButton *button, gpointer user_data) {
	GtkWidget *dialog;
	gint retval;
	dialog = gtk_file_chooser_dialog_new (_("Browse"), NULL, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
	gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog),
		gtk_entry_get_text((GtkEntry*) lookup_widget((GtkWidget*) button, "text_source")));

	retval = gtk_dialog_run (GTK_DIALOG (dialog));
	if (retval == GTK_RESPONSE_ACCEPT || retval == GTK_RESPONSE_OK) {
		gchar *filename, *tmp;
		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		tmp = g_malloc(strlen(filename) + 2);
		strcpy(tmp, filename);
		strcat(tmp, "/");
		gtk_entry_set_text((GtkEntry*) lookup_widget((GtkWidget*) button, "text_source"), tmp);
		g_free(filename);
		g_free(tmp);
	}
	
	gtk_widget_destroy (dialog);
}


void show_browse_dest(GtkButton *button, gpointer user_data) {
	GtkWidget *dialog;
	gint retval;
	dialog = gtk_file_chooser_dialog_new (_("Browse"), NULL, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
	gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog),
		gtk_entry_get_text((GtkEntry*) lookup_widget((GtkWidget*) button, "text_dest")));

	retval = gtk_dialog_run (GTK_DIALOG (dialog));
	if (retval == GTK_RESPONSE_ACCEPT || retval == GTK_RESPONSE_OK) {
		gchar *filename;
		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		gtk_entry_set_text((GtkEntry*) lookup_widget((GtkWidget*) button, "text_dest"), filename);
		g_free (filename);
	}
	
	gtk_widget_destroy (dialog);
}


void
on_play_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *rsync;
	gint i = 0;

	argv = g_new(gchar *, 30);
	argv[i++] = "rsync";
	argv[i++] = "-r";
	
	if (user_data != NULL && strcmp(user_data, "dryrun") == 0) argv[i++] = "-n";
	if (gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) button, "check_time"))) argv[i++] = "-t";
	if (gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) button, "check_perm"))) argv[i++] = "-p";
	if (gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) button, "check_owner"))) argv[i++] = "-o";
	if (gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) button, "check_group"))) argv[i++] = "-g";
	if (gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) button, "check_onefs"))) argv[i++] = "-x";
	if (gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) button, "check_verbose"))) argv[i++] = "-v";
	if (gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) button, "check_progr"))) argv[i++] = "--progress";
	if (gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) button, "check_delete"))) argv[i++] = "--delete";
	if (gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) button, "check_exist"))) argv[i++] = "--ignore-existing";
	if (gtk_toggle_button_get_active((GtkToggleButton*) lookup_widget((GtkWidget*) button, "check_size"))) argv[i++] = "--size-only";

	argv[i++] = (gchar*) gtk_entry_get_text((GtkEntry*) lookup_widget((GtkWidget*) button, "text_source"));
	argv[i++] = (gchar*) gtk_entry_get_text((GtkEntry*) lookup_widget((GtkWidget*) button, "text_dest"));
	argv[i++] = NULL;
	
	rsync = create_rsync();
	gtk_widget_show(rsync);
}

void
on_dryrun_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	on_play_clicked(button, "dryrun");
}


void
on_main_create               (GtkWindow       *window,
                                        gpointer         user_data)
{
	load_groups((GtkWidget*) window, "default");
	load_settings((GtkWidget*) window, "default");
}


void
on_main_destroy                        (GtkObject       *object,
                                        gpointer         user_data)
{
	gint sel = gtk_combo_box_get_active((GtkComboBox*) lookup_widget((GtkWidget*) object, "combo_session"));
	save_settings((GtkWidget*) object, groups[	sel]);
	g_strfreev(groups);
	gtk_main_quit();
}


void
on_close_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
	if (rsync_pid) kill(rsync_pid, 1);
	else gtk_widget_destroy(lookup_widget((GtkWidget*) button, "rsync"));
}


gboolean out_watch(GIOChannel *source, GIOCondition condition, gpointer data) {
	GtkTextBuffer *buffer;
	GtkTextIter iter, iter2;
 	GString *str;
	static gchar *carriage = NULL;
	
	buffer = gtk_text_view_get_buffer((GtkTextView*)data);
	
	if (carriage != NULL) {
		gtk_text_buffer_get_iter_at_line(buffer, &iter, gtk_text_buffer_get_line_count(buffer) - 2);
		gtk_text_buffer_get_end_iter(buffer, &iter2);
		gtk_text_buffer_delete(buffer, &iter, &iter2);
	}
	
	str = g_string_new("");	
	g_io_channel_read_line_string(source, str, NULL, NULL);
	carriage = strchr(str->str, '\r');
	
	gtk_text_buffer_insert_at_cursor(buffer, (gchar*)str->str, -1);
	gtk_text_buffer_get_end_iter(buffer, &iter);
	gtk_text_view_scroll_to_iter((GtkTextView*)data, &iter, 0, TRUE, 0.0, 1.0);
	g_string_free (str, TRUE);

	if (condition == G_IO_HUP) {
 		g_io_channel_shutdown (source, FALSE, NULL);
 		g_io_channel_unref (source);
		gtk_button_set_label((GtkButton*)lookup_widget((GtkWidget*) data, "close"), "gtk-close");
		gtk_button_set_use_stock((GtkButton*)lookup_widget((GtkWidget*) data, "close"), TRUE);
		g_spawn_close_pid(rsync_pid);
		rsync_pid = 0;
		g_free(argv);
		return FALSE;
	}
	return TRUE;
}


gboolean err_watch(GIOChannel *source, GIOCondition condition, gpointer data) {
	GtkTextBuffer *buffer;
	GtkTextIter start, end, iter;
//	GIOStatus status;
 	GString *str;
	
	buffer = gtk_text_view_get_buffer((GtkTextView*)data);
	str = g_string_new("");	
	
	g_io_channel_read_line_string(source, str, NULL, NULL);
//	if (status == G_IO_STATUS_NORMAL) {
		gtk_text_buffer_get_end_iter(buffer, &iter);
		gtk_text_buffer_insert_with_tags_by_name(buffer, &iter, (gchar*)str->str, -1, "fore-red", NULL);
/*		
		gtk_text_buffer_get_iter_at_offset(buffer, &start, buf_len);
		buf_len += str->len;
		gtk_text_buffer_get_iter_at_offset(buffer, &end, buf_len);
		gtk_text_buffer_apply_tag_by_name(buffer, "fore-red", &start, &end);
*/		
		gtk_text_buffer_get_end_iter(buffer, &iter);
		gtk_text_view_scroll_to_iter((GtkTextView*)data, &iter, 0, TRUE, 0.0, 1.0);
//	}
	g_string_free (str, TRUE);

	if (condition == G_IO_HUP) {
 		g_io_channel_shutdown (source, FALSE, NULL);
 		g_io_channel_unref (source);
		return FALSE;
	}
	return TRUE;
}


void
on_rsync_show                          (GtkWidget       *widget,
                                        gpointer         user_data)
{
	gint out, err;
	GtkTextBuffer *buffer;
	GtkTextView *view;
	GIOChannel *chout, *cherr;
	GtkTextTag *tag;
	rsync_pid = 0;
	
	if (g_spawn_async_with_pipes(NULL, argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &rsync_pid, NULL, &out, &err, NULL)) {
 		chout = g_io_channel_unix_new (out);
 		cherr = g_io_channel_unix_new (err);
/*	g_io_channel_set_flags(chout, G_IO_FLAG_NONBLOCK, NULL);
		g_io_channel_set_flags(cherr, G_IO_FLAG_NONBLOCK, NULL); */
/*	g_io_channel_set_buffer_size(chout, 32);
		g_io_channel_set_buffer_size(cherr, 32); */
/*	g_io_channel_set_encoding(chout, NULL, NULL);
		g_io_channel_set_encoding(cherr, NULL, NULL);
		g_io_channel_set_buffered(chout, FALSE);
		g_io_channel_set_buffered(cherr, FALSE); */

		view = (GtkTextView*)lookup_widget((GtkWidget*) widget, "textview1");
		buffer = gtk_text_view_get_buffer(view);
		tag = gtk_text_buffer_create_tag(buffer, "fore-red", "foreground", "red", NULL);
		g_io_add_watch_full(chout, G_PRIORITY_DEFAULT_IDLE, G_IO_IN | G_IO_HUP, out_watch, view, NULL);
		g_io_add_watch_full(cherr, G_PRIORITY_DEFAULT_IDLE, G_IO_IN | G_IO_HUP, err_watch, view, NULL);
 	}
}

void
on_rsync_destroy                       (GtkObject       *object,
                                        gpointer         user_data) {
	if (rsync_pid) kill(rsync_pid, 1);
}


void
on_combo_session_changed               (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
	gint sel = gtk_combo_box_get_active((GtkComboBox*) lookup_widget((GtkWidget*) combobox, "combo_session"));
	if (session_last != -1 && sel != session_last) {
		save_settings((GtkWidget*) combobox, groups[session_last]);
		session_last = sel;
		load_settings((GtkWidget*) combobox, groups[session_last]);
	}
}


void
on_session_add_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *add;
	add = create_dialog_new_session();
	gint result = gtk_dialog_run ((GtkDialog*) add);
	
  if (result == GTK_RESPONSE_OK) {
		gchar *newses;
		newses = (gchar*) gtk_entry_get_text((GtkEntry*) lookup_widget((GtkWidget*) add, "entry_session_name"));
		save_settings((GtkWidget*) button, newses);
		session_number++;
		load_groups((GtkWidget*) button, newses);
  }
  gtk_widget_destroy(add);
}


void
on_session_del_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar settings_file_path[MAXPATH];
	gchar settings_file_name[MAXPATH];
  gchar *key_data;
	FILE *key_file;
	GError *error_handler = NULL;
	GKeyFile *settings_file;
	gint i;

	i = gtk_combo_box_get_active((GtkComboBox*) lookup_widget((GtkWidget*) button, "combo_session"));
	if (strcmp(groups[i], "default") == 0) return;
	
	g_sprintf(settings_file_path, "%s/.grsync", g_get_home_dir());
	g_sprintf(settings_file_name, "%s/%s", settings_file_path, "grsync.ini");
	settings_file = g_key_file_new();
	g_key_file_load_from_file(settings_file, settings_file_name, G_KEY_FILE_NONE, NULL);
	g_key_file_remove_group(settings_file, groups[i], &error_handler);
	
	key_data = g_key_file_to_data(settings_file, NULL, &error_handler);
	key_file = fopen(settings_file_name, "w");
	if (key_file != NULL) {
		fputs(key_data, key_file);
		fclose(key_file);
	} else {
		g_printf(_("\tUnable to save settings!\n"));
	}
	
	g_key_file_free(settings_file);
	g_clear_error(&error_handler);
	session_last = -1;
	load_groups((GtkWidget*) button, "default");
	load_settings((GtkWidget*) button, "default");
}

void
on_button_about_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *about;
	about = create_dialog_about();
	gtk_dialog_run ((GtkDialog*) about);
  gtk_widget_destroy(about);

}

