/* -*-objc-*-
 *
 * Grr - Guenther's RSS Reader
 * Copyright (C) 2004-2006 Guenther Noack
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation;
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#import <AppKit/AppKit.h>
#import "MainController.h"

#import "ArticleViewing.h"


MainController* singleton = nil;

MainController* getMainController()
{
  if (singleton == nil)
    singleton = [[MainController alloc] init];
  
  return singleton;
}

@implementation MainController

- (id) init
{
  self = [super init];
  if (singleton != nil)
    {
      [self dealloc];
      return singleton;
    }
  
  // real init here
  fetchingProgressManager = nil;
  
  singleton = self;
  return singleton;
}

- (id) articleView
{
  return AUTORELEASE(RETAIN(articleView));
}

- (void) goThereButton: (id)sender
{
  if ([RSSArticle currentlyViewed] == nil)
    {
      NSLog(@"You need to select the article you want to read.");
      return;
    }
    
  [[NSWorkspace sharedWorkspace]
    openURL: [NSURL URLWithString: [[RSSArticle currentlyViewed] url]]];
}


- (void) refreshMainTable
{
  [RSSArticle viewNone];
  [mainTable deselectAll: self];
  [mainTable reloadData];
  [mainTable setNeedsDisplay: YES];
}

- (void) reloadButton: (id)sender
{
  [[self fetchingProgressManager]
    fetchFeeds: [getFeedList() feedList]];
  
  [getFeedList() setArticleListDirty: YES];
  [self refreshMainTable];
}


// Fetching Progress Manager Singleton stuff
- (void) fetchingProgressManager: (FetchingProgressManager*) aFPM
{
  RELEASE(fetchingProgressManager);
  fetchingProgressManager = RETAIN(aFPM);
}

- (FetchingProgressManager*) fetchingProgressManager
{
  return AUTORELEASE(RETAIN(fetchingProgressManager));
}



// Error Log Controller Singleton Stuff
- (void) errorLogController: (ErrorLogController*) aELC
{
  RELEASE(errorLogController);
  errorLogController = RETAIN(aELC);
}

- (ErrorLogController*) errorLogController
{
  return AUTORELEASE(RETAIN(errorLogController));
}


@end
