/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * See note at OscarTlvList.h
 */

#import <Oscar/OscarTlvList.h>

@implementation OscarTlvListIn

+ listFromBuffer:(const void*)buffer andLength:(size_t)l andTLVs:(size_t*)n
{
	OscarTlvListIn *r = [OscarTlvListIn new];
	if( ![r initWithBuffer:buffer andLength:l andTLVs:n] )
	{
		[r release];
		return nil;
	}
	else
		return r;
} 

- initWithBuffer:(const void*)buffer andLength:(size_t)l andTLVs:(size_t*)nt
{
	buf = buffer;
	len = l;
	if( nt )
	{
		const char *p = buf;
		int i = *nt;
		*nt = 0;
		while( l && i-- )
		{
			int l2 = oscar_int16_get(p+2); 
			if( l < l2+4 )
				break;
			*nt += (l2+=4);
			p += l2;
			l -= l2;
		}
		len = *nt;
	}
	return self;
}

- (OscarIncomingSnac*)getTLV:(int)type
{
	const char *p = buf;
	size_t l = len;
	while( l )
		if( oscar_int16_get(p) == type )
		{
			OscarIncomingSnac *r;
			r = [OscarIncomingSnac snacAtHeaderlessBuffer:p+4
				withLength:oscar_int16_get(p+2)];
			[r autorelease];
			return r;
		}
		else
		{
			size_t off = oscar_int16_get(p+2) + 4;
			if( off > l )
				break;
			p += off;
			l -= off;
		}
	return nil;
}

- (const void*)buffer
{
	return buf;
}

- (size_t)length
{
	return len;
}

@end
