/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * You get your buddy list as well as permit/deny here.
 */

#import <Oscar/OscarHandlers.h>
#import <Oscar/OscarFlap.h>
#import <Oscar/OscarBuffer.h>
#import <Oscar/OscarTlvList.h>
#import <Oscar/OscarIncomingSnac.h>
#import <Oscar/OscarClient.h>
#import <Oscar/OscarSsiList.h>

#import <Grouch/GrouchClient.h>
#import <Grouch/GrouchStringTool.h>

#import <Foundation/NSDictionary.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSValue.h>
#import <Foundation/NSBundle.h>

@interface OscarSnac00130006 : NSObject <OscarSnacHandler>
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf;
@end

@implementation OscarSnac00130006
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf
{
	id<GrouchClient> cli;
	OscarSsiList *ssi;
	OscarBuffer *out = [OscarBuffer snacWithFamily:0x13 andType:0x07
			    andFlags:0 andTag:nil];

	cli = [[flap client] getUI];
	ssi = [[flap client] buddyList];

	// Skip SSI version information
	[buf skipBytes:2];			// not sure what this is
	[buf skipBytes:2];			// TLV
	[buf skipBytes:[buf readInt16]];	// TLV cont
	[buf skipBytes:1];			// SSI version
	[buf skipBytes:2];			// object count

	while( [buf bytesRemaining] > 4 )
	{
		NSString *name;
		int gid, iid, type;
		OscarTlvListIn *tlv;

		name = [buf readPascalString16];
		
		gid  = [buf readInt16];
		iid  = [buf readInt16];
		type = [buf readInt16];
		tlv  = [buf readTlvList16];

		[ssi addRecord:name item:iid group:gid type:type tlv:tlv];
	}

	[ssi reparentChildrenForBos:(OscarBos*)flap];

	[cli reloadData:YES];

	[flap write:out];
	[out/*(ward)*/ release];
}
@end

@interface OscarSnac0013000e : NSObject <OscarSnacHandler>
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf;
@end
@implementation OscarSnac0013000e
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf
{
	if(tag)
	{
		NSArray *records = tag;
		BOOL needsUpdate = NO;
		int i;

		// Skip SSI version information
		[buf skipBytes:2];			// not sure what this is
		[buf skipBytes:2];			// TLV
		[buf skipBytes:[buf readInt16]];	// TLV cont

		for( i=0; i<[records count]; ++i )
		{
			OscarSsiRecord *record = [records objectAtIndex:i];
			switch([buf readInt16])
			{
			case 0:		// Success; you must be lucky
				needsUpdate = YES;
				[[[flap client] buddyList] confirmAdd:record
							bos:(OscarBos*)flap];
				break;
			case 0x0e:	// ICQ: requires authorization
				[[[flap client] getUI] error:
				[GrouchString getString:@"icq-auth" withBundle:
				 [NSBundle bundleForClass:[self class]]]
				 fatal:NO];
			default:
#if 0
				NSLog(@"add failure");
				if( [record type] == OscarSsiUser )
					NSLog(@"%@", [[record description] alias] );
				else
					NSLog(@"%@", [record description]);
#endif
				[record remove];
				// TODO: report error
			}
		}
		if( needsUpdate )
			[[[flap client] getUI] reloadData:YES];
	}
}
@end

@implementation OscarSsiHandler
+ get
{
	static id r = nil;
	if( r )
		return r;
	else
		return r = [OscarSsiHandler new];
}

- init
{
	[super init];
	[super initForFamily:0x13 andVersion:0x04 andDLL:0x0629];
	[self addHandler:[OscarSnac00130006 new] forType:0x06];
	[self addHandler:[OscarSnac0013000e new] forType:0x0e];
	return self;
}
@end
