/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 */

#import <Oscar/OscarSnacHandler.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSValue.h>

@implementation OscarSnacFamilyHandler

+ handlerForFamily:(int)fam andVersion:(int)vers andDLL:(int)lib
{
	OscarSnacFamilyHandler *r = [OscarSnacFamilyHandler new];
	if( ![r initForFamily:fam andVersion:vers andDLL:lib] )
	{
		[r release];
		return nil;
	}
	else
		return r;
}

- initForFamily:(int)fam andVersion:(int)vers andDLL:(int)lib
{
	handlers = [NSMutableDictionary new];
	family = fam;
	version = vers;
	dll = lib;
	return self;
}

- init
{
	[super init];
	handlers = nil;
	family = version = dll = 0;
	return self;
}

- (void)dealloc
{
	if( handlers )
		[handlers release];
	[super dealloc];
}

- (void)addHandler:(id<OscarSnacHandler>)handler forType:(int)type
{
	NSNumber *key = [NSNumber numberWithInt:type];
	[handlers setObject:handler forKey:key];
}

- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)fam andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf
{
	NSNumber *key = [NSNumber numberWithInt:type];
	id<OscarSnacHandler> obj = [handlers objectForKey:key];
	if( obj )
		[obj handleSnacForClient:flap ofFamily:fam andType:type
		     withFlags:flags andTag:tag buffer:buf];
}

- (int)family			{return family;}
- (int)version			{return version;}
- (int)dll			{return dll;}

- copy
{
	OscarSnacFamilyHandler *r = [OscarSnacFamilyHandler new];
	[r initForFamily:family andVersion:version andDLL:dll];
	[r->handlers addEntriesFromDictionary:handlers];
	return r;
}

@end

@interface OscarSnacFamilyHandler (OscarSnacFamilyEx)
- (NSMutableDictionary*)_dict;
@end
@implementation OscarSnacFamilyHandler (OscarSnacFamilyEx)
- (NSMutableDictionary*)_dict	{return handlers;}
@end

@implementation OscarSnacHandler

- init
{
	[super init];
	families = [NSMutableDictionary new];
	return self;
}

- (void)dealloc
{
	[families release];
	[super dealloc];
}

- (void)addFamily:(OscarSnacFamilyHandler*)fam
{
	OscarSnacFamilyHandler *family = [self getFamily:[fam family]];
	if( !family )
	{
		NSNumber *key = [NSNumber numberWithInt:[fam family]];
		family = [fam copy];
		[families setObject:family forKey:key];
		[family release];

	}
	else
		[[family _dict] addEntriesFromDictionary:[fam _dict]];
}

- (void)addHandler:(id<OscarSnacHandler>)handler forFamily:(int)fam
	andType:(int)type
{
	OscarSnacFamilyHandler *family = [self getFamily:fam];
	if( !family )
	{
		NSNumber *key = [NSNumber numberWithInt:fam];
		family = [OscarSnacFamilyHandler new];
		[families setObject:family forKey:key];
		[family release];
	}
	[family addHandler:handler forType:type];
}

- (OscarSnacFamilyHandler*)getFamily:(int)fam
{
	NSNumber *key = [NSNumber numberWithInt:fam];
	OscarSnacFamilyHandler *r = [families objectForKey:key];
	return r;
}

- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)fam andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf
{
	OscarSnacFamilyHandler *obj = [self getFamily:fam];
	if( obj )
		[obj handleSnacForClient:flap ofFamily:fam andType:type
		     withFlags:flags andTag:tag buffer:buf];
}

- (NSEnumerator*)familyEnumerator
{
	return [families objectEnumerator];
}

@end
