/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * If you get a profile or away message, it comes in here.
 */

#import <Oscar/OscarHandlers.h>
#import <Oscar/OscarFlap.h>
#import <Oscar/OscarIncomingSnac.h>
#import <Oscar/OscarClient.h>
#import <Oscar/OscarEncoding.h>
#import <Oscar/OscarTlvList.h>
#import <Grouch/GrouchClient.h>

@interface OscarSnac00020006 : NSObject <OscarSnacHandler>
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf;
@end

@implementation OscarSnac00020006
static NSString *makeString( enc, data )
	OscarIncomingSnac *enc, *data;
{
	NSStringEncoding encoding = [NSString defaultCStringEncoding]; 
	if( enc )
	{
		NSString *desiredEncoding;
		desiredEncoding = [enc readRawString];
		encoding = [OscarEncoding get:desiredEncoding];
	}
	if( data )
	{
		NSString *r;
		r = [data readRawStringWithEncoding:encoding];
		return r;
	}
	else
		return nil;
}

- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf
{
	id<GrouchProfile> p = tag;
	OscarClient *cli = [flap client];
	NSString *nick = [buf readPascalString];
	int warn = [buf readInt16];
	OscarTlvListIn *tlv = [buf readTlvList];

	oscar_process_buddy
	(
		warn, tlv, [[cli getUI] getUser:nick]
	);
	tlv = [buf readTLVs];
	if( p )
	{
		NSString *str;
		str = makeString([tlv getTLV:0x01], [tlv getTLV:0x02]);
		if( str )
			[p profile:str];
		str = makeString([tlv getTLV:0x03], [tlv getTLV:0x04]);
		if( str )
			[p awayMessage:str];
		[p finishedProfile];
	}
}
@end

@implementation OscarLookupHandler

+ get
{
	static id r = nil;
	if( r )
		return r;
	else
		return r = [OscarLookupHandler new];
}

- init
{
	[super initForFamily:0x02 andVersion:0x01 andDLL:0x0629];
	[self addHandler:[OscarErrorHandler get] forType:0x01];
	[self addHandler:[OscarSnac00020006 new] forType:0x06];
	return self;
}

@end
