/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 */

#import <Foundation/NSObject.h>

@class NSView, NSButton;

@protocol PreferencePane

- (NSView*)create;
- (NSButton*)button;

- (void)load;
- (void)save;

@end

void GrouchShowPrefs();

@class NSView, NSBox, NSPopUpButton, NSButton;
@class NSMutableDictionary;

@interface PrefsEvents : NSObject <PreferencePane>
{
	NSView *root;
	NSBox *msgBox, *listBox;
	NSPopUpButton *msgEvent, *listEvent;
	NSButton *msgFlagF, *msgFlagB, *msgSoundSwitch;
	NSButton *listFlagF, *listFlagB, *listSoundSwitch;
	NSPopUpButton *msgSound, *listSound;

	NSMutableDictionary *events;
	NSMutableDictionary *currentMsgEvent, *currentListEvent;
}

- (void)switchMsgEvent:sender;
- (void)switchListEvent:sender;
- (void)checkMsgEvent:sender;
- (void)checkListEvent:sender;
@end 

