/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Socket glue.
 *
 * GrouchSocketUnix - Unix/winsock
 * GrouchSocketMac  - NSStream for Mac OS
 */

#include <Grouch/GrouchSocket.h>

@protocol GrouchSocketBackend
- (int)write:(const void*)buf length:(int)len;
- (int)read:(void*)buf length:(int)len;

- (void)startWriteThread;
- (void)setBlocking:(BOOL)b;
- (GrouchSocketEvent)pollSocketEvents;

- (BOOL)lastOperationWasError;
@end

#if !defined(USE_NSSTREAM) && !defined(USE_UNIX_SOCKETS)
#if defined(__APPLE__) && !defined(GNUSTEP)
#define USE_NSSTREAM
#else
#define USE_UNIX_SOCKETS
#endif
#endif

#if defined(USE_UNIX_SOCKETS) && !defined(SOCKET_IMPL)
#import <Grouch/GrouchSocketUnix.h>
#define SOCKET_IMPL	GrouchSocketUnix
#endif
#if defined(USE_NSSTREAM) && !defined(SOCKET_IMPL)
#import <Grouch/GrouchSocketMac.h>
#define SOCKET_IMPL	GrouchSocketMac
#endif

