/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Quaint little string functions.
 */

#import <Grouch/GrouchStringTool.h>

#import <Foundation/NSDictionary.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSBundle.h>
#import <Foundation/NSPropertyList.h>
#import <Foundation/NSUserDefaults.h>
#import <Foundation/NSFileHandle.h>
#import <Foundation/NSException.h>

#include <stdarg.h>

@implementation GrouchString

+ getString:(NSString*)str fromDict:(NSString*)dictName
  withBundle:(NSBundle*)b
{
	//NSBundle *b = [NSBundle mainBundle];
	NSString *s;
	if( !b )
		b = [NSBundle mainBundle];
	s = [b localizedStringForKey:str value:nil table:dictName];
	if( !s )	// Couldn't find.  Get the English version.
	{
		NSString *path;
		NSDictionary *plist;

		if( !dictName )
			dictName = @"Localizable";
		path = [b pathForResource:dictName ofType:@"strings"
			inDirectory:nil forLocalization:@"English"];
		NS_DURING
		plist = [[NSString stringWithContentsOfFile:path]
			 propertyListFromStringsFileFormat];
		s = [plist objectForKey:str];
		NS_HANDLER
		NS_ENDHANDLER
	}
	return s;
}

+ getString:(NSString*)str fromDict:(NSString*)dictName
{
	return [self getString:str fromDict:dictName withBundle:nil];
}

+ getString:(NSString*)str withBundle:(NSBundle*)b
{
	return [self getString:str fromDict:nil withBundle:b];
}

+ getString:(NSString*)str
{
	return [self getString:str fromDict:nil withBundle:nil];
}

@end

@implementation NSString (GrouchStringTool)

- (NSString*)createUserString:(int)n,...
{
	NSString *fmt = self;	// ...
	NSMutableArray *a = [NSMutableArray new];
	NSMutableString *r = [NSMutableString new];
	int i;
	unichar c;
	va_list ap;
	va_start( ap, n );
	for( i=n; i--; )
		[a addObject:va_arg(ap, NSString*)];
	for( i=0; i<[fmt length]; ++i )
		switch( (c=[fmt characterAtIndex:i]) )
		{
			case '^':
				if( i+1 < [fmt length] )
				{
					unichar c2 = [fmt characterAtIndex:i+1];
					if( c2 >= '0' && c2 <= '9' )
					{
						int j = c2-'0';
						NSString *s;
						s = [a objectAtIndex:j-1];
						if( s )
						{
							[r appendString:s];	
							++i;
							break;
						}
					}
				}
			default:
				[r appendString:
				[NSString stringWithCharacters:&c length:1]];
		}
	[a release];
	[r autorelease];
	return r;
}

@end
