/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2012,2013, by the GROMACS development team, led by
 * David van der Spoel, Berk Hess, Erik Lindahl, and including many
 * others, as listed in the AUTHORS file in the top-level source
 * directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*
 * Note: this file was generated by the GROMACS sse4_1_double kernel generator.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>

#include "../nb_kernel.h"
#include "types/simple.h"
#include "vec.h"
#include "nrnb.h"

#include "gmx_math_x86_sse4_1_double.h"
#include "kernelutil_x86_sse4_1_double.h"

/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecEw_VdwNone_GeomW3W3_VF_sse4_1_double
 * Electrostatics interaction: Ewald
 * VdW interaction:            None
 * Geometry:                   Water3-Water3
 * Calculate force/pot:        PotentialAndForce
 */
void
nb_kernel_ElecEw_VdwNone_GeomW3W3_VF_sse4_1_double
                    (t_nblist * gmx_restrict                nlist,
                     rvec * gmx_restrict                    xx,
                     rvec * gmx_restrict                    ff,
                     t_forcerec * gmx_restrict              fr,
                     t_mdatoms * gmx_restrict               mdatoms,
                     nb_kernel_data_t * gmx_restrict        kernel_data,
                     t_nrnb * gmx_restrict                  nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with SSE double precision, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    __m128d          tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    __m128d          ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwioffset1;
    __m128d          ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    __m128d          ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwjidx0A,vdwjidx0B;
    __m128d          jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    int              vdwjidx1A,vdwjidx1B;
    __m128d          jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B;
    __m128d          jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    __m128d          dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m128d          dx01,dy01,dz01,rsq01,rinv01,rinvsq01,r01,qq01,c6_01,c12_01;
    __m128d          dx02,dy02,dz02,rsq02,rinv02,rinvsq02,r02,qq02,c6_02,c12_02;
    __m128d          dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    __m128d          dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    __m128d          dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    __m128d          dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    __m128d          dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    __m128d          dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    __m128d          velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    __m128i          ewitab;
    __m128d          ewtabscale,eweps,sh_ewald,ewrt,ewtabhalfspace,ewtabF,ewtabFn,ewtabD,ewtabV;
    real             *ewtab;
    __m128d          dummy_mask,cutoff_mask;
    __m128d          signbit   = gmx_mm_castsi128_pd( _mm_set_epi32(0x80000000,0x00000000,0x80000000,0x00000000) );
    __m128d          one     = _mm_set1_pd(1.0);
    __m128d          two     = _mm_set1_pd(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_pd(fr->epsfac);
    charge           = mdatoms->chargeA;

    sh_ewald         = _mm_set1_pd(fr->ic->sh_ewald);
    ewtab            = fr->ic->tabq_coul_FDV0;
    ewtabscale       = _mm_set1_pd(fr->ic->tabq_scale);
    ewtabhalfspace   = _mm_set1_pd(0.5/fr->ic->tabq_scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq0              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+0]));
    iq1              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+1]));
    iq2              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+2]));

    jq0              = _mm_set1_pd(charge[inr+0]);
    jq1              = _mm_set1_pd(charge[inr+1]);
    jq2              = _mm_set1_pd(charge[inr+2]);
    qq00             = _mm_mul_pd(iq0,jq0);
    qq01             = _mm_mul_pd(iq0,jq1);
    qq02             = _mm_mul_pd(iq0,jq2);
    qq10             = _mm_mul_pd(iq1,jq0);
    qq11             = _mm_mul_pd(iq1,jq1);
    qq12             = _mm_mul_pd(iq1,jq2);
    qq20             = _mm_mul_pd(iq2,jq0);
    qq21             = _mm_mul_pd(iq2,jq1);
    qq22             = _mm_mul_pd(iq2,jq2);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_3rvec_broadcast_pd(shiftvec+i_shift_offset,x+i_coord_offset,
                                                 &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2);

        fix0             = _mm_setzero_pd();
        fiy0             = _mm_setzero_pd();
        fiz0             = _mm_setzero_pd();
        fix1             = _mm_setzero_pd();
        fiy1             = _mm_setzero_pd();
        fiz1             = _mm_setzero_pd();
        fix2             = _mm_setzero_pd();
        fiy2             = _mm_setzero_pd();
        fiz2             = _mm_setzero_pd();

        /* Reset potential sums */
        velecsum         = _mm_setzero_pd();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_2ptr_swizzle_pd(x+j_coord_offsetA,x+j_coord_offsetB,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);
            dx01             = _mm_sub_pd(ix0,jx1);
            dy01             = _mm_sub_pd(iy0,jy1);
            dz01             = _mm_sub_pd(iz0,jz1);
            dx02             = _mm_sub_pd(ix0,jx2);
            dy02             = _mm_sub_pd(iy0,jy2);
            dz02             = _mm_sub_pd(iz0,jz2);
            dx10             = _mm_sub_pd(ix1,jx0);
            dy10             = _mm_sub_pd(iy1,jy0);
            dz10             = _mm_sub_pd(iz1,jz0);
            dx11             = _mm_sub_pd(ix1,jx1);
            dy11             = _mm_sub_pd(iy1,jy1);
            dz11             = _mm_sub_pd(iz1,jz1);
            dx12             = _mm_sub_pd(ix1,jx2);
            dy12             = _mm_sub_pd(iy1,jy2);
            dz12             = _mm_sub_pd(iz1,jz2);
            dx20             = _mm_sub_pd(ix2,jx0);
            dy20             = _mm_sub_pd(iy2,jy0);
            dz20             = _mm_sub_pd(iz2,jz0);
            dx21             = _mm_sub_pd(ix2,jx1);
            dy21             = _mm_sub_pd(iy2,jy1);
            dz21             = _mm_sub_pd(iz2,jz1);
            dx22             = _mm_sub_pd(ix2,jx2);
            dy22             = _mm_sub_pd(iy2,jy2);
            dz22             = _mm_sub_pd(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);
            rsq01            = gmx_mm_calc_rsq_pd(dx01,dy01,dz01);
            rsq02            = gmx_mm_calc_rsq_pd(dx02,dy02,dz02);
            rsq10            = gmx_mm_calc_rsq_pd(dx10,dy10,dz10);
            rsq11            = gmx_mm_calc_rsq_pd(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_pd(dx12,dy12,dz12);
            rsq20            = gmx_mm_calc_rsq_pd(dx20,dy20,dz20);
            rsq21            = gmx_mm_calc_rsq_pd(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_pd(dx22,dy22,dz22);

            rinv00           = gmx_mm_invsqrt_pd(rsq00);
            rinv01           = gmx_mm_invsqrt_pd(rsq01);
            rinv02           = gmx_mm_invsqrt_pd(rsq02);
            rinv10           = gmx_mm_invsqrt_pd(rsq10);
            rinv11           = gmx_mm_invsqrt_pd(rsq11);
            rinv12           = gmx_mm_invsqrt_pd(rsq12);
            rinv20           = gmx_mm_invsqrt_pd(rsq20);
            rinv21           = gmx_mm_invsqrt_pd(rsq21);
            rinv22           = gmx_mm_invsqrt_pd(rsq22);

            rinvsq00         = _mm_mul_pd(rinv00,rinv00);
            rinvsq01         = _mm_mul_pd(rinv01,rinv01);
            rinvsq02         = _mm_mul_pd(rinv02,rinv02);
            rinvsq10         = _mm_mul_pd(rinv10,rinv10);
            rinvsq11         = _mm_mul_pd(rinv11,rinv11);
            rinvsq12         = _mm_mul_pd(rinv12,rinv12);
            rinvsq20         = _mm_mul_pd(rinv20,rinv20);
            rinvsq21         = _mm_mul_pd(rinv21,rinv21);
            rinvsq22         = _mm_mul_pd(rinv22,rinv22);

            fjx0             = _mm_setzero_pd();
            fjy0             = _mm_setzero_pd();
            fjz0             = _mm_setzero_pd();
            fjx1             = _mm_setzero_pd();
            fjy1             = _mm_setzero_pd();
            fjz1             = _mm_setzero_pd();
            fjx2             = _mm_setzero_pd();
            fjy2             = _mm_setzero_pd();
            fjz2             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm_mul_pd(rsq00,rinv00);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r00,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq00,_mm_sub_pd(rinv00,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq00,rinv00),_mm_sub_pd(rinvsq00,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx00);
            ty               = _mm_mul_pd(fscal,dy00);
            tz               = _mm_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r01              = _mm_mul_pd(rsq01,rinv01);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r01,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq01,_mm_sub_pd(rinv01,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq01,rinv01),_mm_sub_pd(rinvsq01,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx01);
            ty               = _mm_mul_pd(fscal,dy01);
            tz               = _mm_mul_pd(fscal,dz01);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx1             = _mm_add_pd(fjx1,tx);
            fjy1             = _mm_add_pd(fjy1,ty);
            fjz1             = _mm_add_pd(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r02              = _mm_mul_pd(rsq02,rinv02);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r02,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq02,_mm_sub_pd(rinv02,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq02,rinv02),_mm_sub_pd(rinvsq02,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx02);
            ty               = _mm_mul_pd(fscal,dy02);
            tz               = _mm_mul_pd(fscal,dz02);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx2             = _mm_add_pd(fjx2,tx);
            fjy2             = _mm_add_pd(fjy2,ty);
            fjz2             = _mm_add_pd(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r10              = _mm_mul_pd(rsq10,rinv10);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r10,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq10,_mm_sub_pd(rinv10,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq10,rinv10),_mm_sub_pd(rinvsq10,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx10);
            ty               = _mm_mul_pd(fscal,dy10);
            tz               = _mm_mul_pd(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r11              = _mm_mul_pd(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r11,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq11,_mm_sub_pd(rinv11,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq11,rinv11),_mm_sub_pd(rinvsq11,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx11);
            ty               = _mm_mul_pd(fscal,dy11);
            tz               = _mm_mul_pd(fscal,dz11);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx1             = _mm_add_pd(fjx1,tx);
            fjy1             = _mm_add_pd(fjy1,ty);
            fjz1             = _mm_add_pd(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r12              = _mm_mul_pd(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r12,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq12,_mm_sub_pd(rinv12,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq12,rinv12),_mm_sub_pd(rinvsq12,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx12);
            ty               = _mm_mul_pd(fscal,dy12);
            tz               = _mm_mul_pd(fscal,dz12);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx2             = _mm_add_pd(fjx2,tx);
            fjy2             = _mm_add_pd(fjy2,ty);
            fjz2             = _mm_add_pd(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r20              = _mm_mul_pd(rsq20,rinv20);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r20,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq20,_mm_sub_pd(rinv20,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq20,rinv20),_mm_sub_pd(rinvsq20,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx20);
            ty               = _mm_mul_pd(fscal,dy20);
            tz               = _mm_mul_pd(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r21              = _mm_mul_pd(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r21,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq21,_mm_sub_pd(rinv21,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq21,rinv21),_mm_sub_pd(rinvsq21,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx21);
            ty               = _mm_mul_pd(fscal,dy21);
            tz               = _mm_mul_pd(fscal,dz21);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx1             = _mm_add_pd(fjx1,tx);
            fjy1             = _mm_add_pd(fjy1,ty);
            fjz1             = _mm_add_pd(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r22              = _mm_mul_pd(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r22,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq22,_mm_sub_pd(rinv22,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq22,rinv22),_mm_sub_pd(rinvsq22,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx22);
            ty               = _mm_mul_pd(fscal,dy22);
            tz               = _mm_mul_pd(fscal,dz22);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx2             = _mm_add_pd(fjx2,tx);
            fjy2             = _mm_add_pd(fjy2,ty);
            fjz2             = _mm_add_pd(fjz2,tz);

            gmx_mm_decrement_3rvec_2ptr_swizzle_pd(f+j_coord_offsetA,f+j_coord_offsetB,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 369 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_1ptr_swizzle_pd(x+j_coord_offsetA,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);
            dx01             = _mm_sub_pd(ix0,jx1);
            dy01             = _mm_sub_pd(iy0,jy1);
            dz01             = _mm_sub_pd(iz0,jz1);
            dx02             = _mm_sub_pd(ix0,jx2);
            dy02             = _mm_sub_pd(iy0,jy2);
            dz02             = _mm_sub_pd(iz0,jz2);
            dx10             = _mm_sub_pd(ix1,jx0);
            dy10             = _mm_sub_pd(iy1,jy0);
            dz10             = _mm_sub_pd(iz1,jz0);
            dx11             = _mm_sub_pd(ix1,jx1);
            dy11             = _mm_sub_pd(iy1,jy1);
            dz11             = _mm_sub_pd(iz1,jz1);
            dx12             = _mm_sub_pd(ix1,jx2);
            dy12             = _mm_sub_pd(iy1,jy2);
            dz12             = _mm_sub_pd(iz1,jz2);
            dx20             = _mm_sub_pd(ix2,jx0);
            dy20             = _mm_sub_pd(iy2,jy0);
            dz20             = _mm_sub_pd(iz2,jz0);
            dx21             = _mm_sub_pd(ix2,jx1);
            dy21             = _mm_sub_pd(iy2,jy1);
            dz21             = _mm_sub_pd(iz2,jz1);
            dx22             = _mm_sub_pd(ix2,jx2);
            dy22             = _mm_sub_pd(iy2,jy2);
            dz22             = _mm_sub_pd(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);
            rsq01            = gmx_mm_calc_rsq_pd(dx01,dy01,dz01);
            rsq02            = gmx_mm_calc_rsq_pd(dx02,dy02,dz02);
            rsq10            = gmx_mm_calc_rsq_pd(dx10,dy10,dz10);
            rsq11            = gmx_mm_calc_rsq_pd(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_pd(dx12,dy12,dz12);
            rsq20            = gmx_mm_calc_rsq_pd(dx20,dy20,dz20);
            rsq21            = gmx_mm_calc_rsq_pd(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_pd(dx22,dy22,dz22);

            rinv00           = gmx_mm_invsqrt_pd(rsq00);
            rinv01           = gmx_mm_invsqrt_pd(rsq01);
            rinv02           = gmx_mm_invsqrt_pd(rsq02);
            rinv10           = gmx_mm_invsqrt_pd(rsq10);
            rinv11           = gmx_mm_invsqrt_pd(rsq11);
            rinv12           = gmx_mm_invsqrt_pd(rsq12);
            rinv20           = gmx_mm_invsqrt_pd(rsq20);
            rinv21           = gmx_mm_invsqrt_pd(rsq21);
            rinv22           = gmx_mm_invsqrt_pd(rsq22);

            rinvsq00         = _mm_mul_pd(rinv00,rinv00);
            rinvsq01         = _mm_mul_pd(rinv01,rinv01);
            rinvsq02         = _mm_mul_pd(rinv02,rinv02);
            rinvsq10         = _mm_mul_pd(rinv10,rinv10);
            rinvsq11         = _mm_mul_pd(rinv11,rinv11);
            rinvsq12         = _mm_mul_pd(rinv12,rinv12);
            rinvsq20         = _mm_mul_pd(rinv20,rinv20);
            rinvsq21         = _mm_mul_pd(rinv21,rinv21);
            rinvsq22         = _mm_mul_pd(rinv22,rinv22);

            fjx0             = _mm_setzero_pd();
            fjy0             = _mm_setzero_pd();
            fjz0             = _mm_setzero_pd();
            fjx1             = _mm_setzero_pd();
            fjy1             = _mm_setzero_pd();
            fjz1             = _mm_setzero_pd();
            fjx2             = _mm_setzero_pd();
            fjy2             = _mm_setzero_pd();
            fjz2             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm_mul_pd(rsq00,rinv00);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r00,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq00,_mm_sub_pd(rinv00,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq00,rinv00),_mm_sub_pd(rinvsq00,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx00);
            ty               = _mm_mul_pd(fscal,dy00);
            tz               = _mm_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r01              = _mm_mul_pd(rsq01,rinv01);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r01,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq01,_mm_sub_pd(rinv01,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq01,rinv01),_mm_sub_pd(rinvsq01,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx01);
            ty               = _mm_mul_pd(fscal,dy01);
            tz               = _mm_mul_pd(fscal,dz01);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx1             = _mm_add_pd(fjx1,tx);
            fjy1             = _mm_add_pd(fjy1,ty);
            fjz1             = _mm_add_pd(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r02              = _mm_mul_pd(rsq02,rinv02);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r02,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq02,_mm_sub_pd(rinv02,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq02,rinv02),_mm_sub_pd(rinvsq02,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx02);
            ty               = _mm_mul_pd(fscal,dy02);
            tz               = _mm_mul_pd(fscal,dz02);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx2             = _mm_add_pd(fjx2,tx);
            fjy2             = _mm_add_pd(fjy2,ty);
            fjz2             = _mm_add_pd(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r10              = _mm_mul_pd(rsq10,rinv10);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r10,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq10,_mm_sub_pd(rinv10,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq10,rinv10),_mm_sub_pd(rinvsq10,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx10);
            ty               = _mm_mul_pd(fscal,dy10);
            tz               = _mm_mul_pd(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r11              = _mm_mul_pd(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r11,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq11,_mm_sub_pd(rinv11,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq11,rinv11),_mm_sub_pd(rinvsq11,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx11);
            ty               = _mm_mul_pd(fscal,dy11);
            tz               = _mm_mul_pd(fscal,dz11);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx1             = _mm_add_pd(fjx1,tx);
            fjy1             = _mm_add_pd(fjy1,ty);
            fjz1             = _mm_add_pd(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r12              = _mm_mul_pd(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r12,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq12,_mm_sub_pd(rinv12,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq12,rinv12),_mm_sub_pd(rinvsq12,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx12);
            ty               = _mm_mul_pd(fscal,dy12);
            tz               = _mm_mul_pd(fscal,dz12);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx2             = _mm_add_pd(fjx2,tx);
            fjy2             = _mm_add_pd(fjy2,ty);
            fjz2             = _mm_add_pd(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r20              = _mm_mul_pd(rsq20,rinv20);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r20,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq20,_mm_sub_pd(rinv20,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq20,rinv20),_mm_sub_pd(rinvsq20,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx20);
            ty               = _mm_mul_pd(fscal,dy20);
            tz               = _mm_mul_pd(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r21              = _mm_mul_pd(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r21,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq21,_mm_sub_pd(rinv21,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq21,rinv21),_mm_sub_pd(rinvsq21,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx21);
            ty               = _mm_mul_pd(fscal,dy21);
            tz               = _mm_mul_pd(fscal,dz21);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx1             = _mm_add_pd(fjx1,tx);
            fjy1             = _mm_add_pd(fjy1,ty);
            fjz1             = _mm_add_pd(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r22              = _mm_mul_pd(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r22,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq22,_mm_sub_pd(rinv22,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq22,rinv22),_mm_sub_pd(rinvsq22,felec));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx22);
            ty               = _mm_mul_pd(fscal,dy22);
            tz               = _mm_mul_pd(fscal,dz22);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx2             = _mm_add_pd(fjx2,tx);
            fjy2             = _mm_add_pd(fjy2,ty);
            fjz2             = _mm_add_pd(fjz2,tz);

            gmx_mm_decrement_3rvec_1ptr_swizzle_pd(f+j_coord_offsetA,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 369 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_3atom_swizzle_pd(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,
                                              f+i_coord_offset,fshift+i_shift_offset);

        ggid                        = gid[iidx];
        /* Update potential energies */
        gmx_mm_update_1pot_pd(velecsum,kernel_data->energygrp_elec+ggid);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 19 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_W3W3_VF,outeriter*19 + inneriter*369);
}
/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecEw_VdwNone_GeomW3W3_F_sse4_1_double
 * Electrostatics interaction: Ewald
 * VdW interaction:            None
 * Geometry:                   Water3-Water3
 * Calculate force/pot:        Force
 */
void
nb_kernel_ElecEw_VdwNone_GeomW3W3_F_sse4_1_double
                    (t_nblist * gmx_restrict                nlist,
                     rvec * gmx_restrict                    xx,
                     rvec * gmx_restrict                    ff,
                     t_forcerec * gmx_restrict              fr,
                     t_mdatoms * gmx_restrict               mdatoms,
                     nb_kernel_data_t * gmx_restrict        kernel_data,
                     t_nrnb * gmx_restrict                  nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with SSE double precision, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    __m128d          tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    __m128d          ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwioffset1;
    __m128d          ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    __m128d          ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwjidx0A,vdwjidx0B;
    __m128d          jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    int              vdwjidx1A,vdwjidx1B;
    __m128d          jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B;
    __m128d          jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    __m128d          dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m128d          dx01,dy01,dz01,rsq01,rinv01,rinvsq01,r01,qq01,c6_01,c12_01;
    __m128d          dx02,dy02,dz02,rsq02,rinv02,rinvsq02,r02,qq02,c6_02,c12_02;
    __m128d          dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    __m128d          dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    __m128d          dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    __m128d          dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    __m128d          dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    __m128d          dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    __m128d          velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    __m128i          ewitab;
    __m128d          ewtabscale,eweps,sh_ewald,ewrt,ewtabhalfspace,ewtabF,ewtabFn,ewtabD,ewtabV;
    real             *ewtab;
    __m128d          dummy_mask,cutoff_mask;
    __m128d          signbit   = gmx_mm_castsi128_pd( _mm_set_epi32(0x80000000,0x00000000,0x80000000,0x00000000) );
    __m128d          one     = _mm_set1_pd(1.0);
    __m128d          two     = _mm_set1_pd(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_pd(fr->epsfac);
    charge           = mdatoms->chargeA;

    sh_ewald         = _mm_set1_pd(fr->ic->sh_ewald);
    ewtab            = fr->ic->tabq_coul_F;
    ewtabscale       = _mm_set1_pd(fr->ic->tabq_scale);
    ewtabhalfspace   = _mm_set1_pd(0.5/fr->ic->tabq_scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq0              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+0]));
    iq1              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+1]));
    iq2              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+2]));

    jq0              = _mm_set1_pd(charge[inr+0]);
    jq1              = _mm_set1_pd(charge[inr+1]);
    jq2              = _mm_set1_pd(charge[inr+2]);
    qq00             = _mm_mul_pd(iq0,jq0);
    qq01             = _mm_mul_pd(iq0,jq1);
    qq02             = _mm_mul_pd(iq0,jq2);
    qq10             = _mm_mul_pd(iq1,jq0);
    qq11             = _mm_mul_pd(iq1,jq1);
    qq12             = _mm_mul_pd(iq1,jq2);
    qq20             = _mm_mul_pd(iq2,jq0);
    qq21             = _mm_mul_pd(iq2,jq1);
    qq22             = _mm_mul_pd(iq2,jq2);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_3rvec_broadcast_pd(shiftvec+i_shift_offset,x+i_coord_offset,
                                                 &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2);

        fix0             = _mm_setzero_pd();
        fiy0             = _mm_setzero_pd();
        fiz0             = _mm_setzero_pd();
        fix1             = _mm_setzero_pd();
        fiy1             = _mm_setzero_pd();
        fiz1             = _mm_setzero_pd();
        fix2             = _mm_setzero_pd();
        fiy2             = _mm_setzero_pd();
        fiz2             = _mm_setzero_pd();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_2ptr_swizzle_pd(x+j_coord_offsetA,x+j_coord_offsetB,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);
            dx01             = _mm_sub_pd(ix0,jx1);
            dy01             = _mm_sub_pd(iy0,jy1);
            dz01             = _mm_sub_pd(iz0,jz1);
            dx02             = _mm_sub_pd(ix0,jx2);
            dy02             = _mm_sub_pd(iy0,jy2);
            dz02             = _mm_sub_pd(iz0,jz2);
            dx10             = _mm_sub_pd(ix1,jx0);
            dy10             = _mm_sub_pd(iy1,jy0);
            dz10             = _mm_sub_pd(iz1,jz0);
            dx11             = _mm_sub_pd(ix1,jx1);
            dy11             = _mm_sub_pd(iy1,jy1);
            dz11             = _mm_sub_pd(iz1,jz1);
            dx12             = _mm_sub_pd(ix1,jx2);
            dy12             = _mm_sub_pd(iy1,jy2);
            dz12             = _mm_sub_pd(iz1,jz2);
            dx20             = _mm_sub_pd(ix2,jx0);
            dy20             = _mm_sub_pd(iy2,jy0);
            dz20             = _mm_sub_pd(iz2,jz0);
            dx21             = _mm_sub_pd(ix2,jx1);
            dy21             = _mm_sub_pd(iy2,jy1);
            dz21             = _mm_sub_pd(iz2,jz1);
            dx22             = _mm_sub_pd(ix2,jx2);
            dy22             = _mm_sub_pd(iy2,jy2);
            dz22             = _mm_sub_pd(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);
            rsq01            = gmx_mm_calc_rsq_pd(dx01,dy01,dz01);
            rsq02            = gmx_mm_calc_rsq_pd(dx02,dy02,dz02);
            rsq10            = gmx_mm_calc_rsq_pd(dx10,dy10,dz10);
            rsq11            = gmx_mm_calc_rsq_pd(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_pd(dx12,dy12,dz12);
            rsq20            = gmx_mm_calc_rsq_pd(dx20,dy20,dz20);
            rsq21            = gmx_mm_calc_rsq_pd(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_pd(dx22,dy22,dz22);

            rinv00           = gmx_mm_invsqrt_pd(rsq00);
            rinv01           = gmx_mm_invsqrt_pd(rsq01);
            rinv02           = gmx_mm_invsqrt_pd(rsq02);
            rinv10           = gmx_mm_invsqrt_pd(rsq10);
            rinv11           = gmx_mm_invsqrt_pd(rsq11);
            rinv12           = gmx_mm_invsqrt_pd(rsq12);
            rinv20           = gmx_mm_invsqrt_pd(rsq20);
            rinv21           = gmx_mm_invsqrt_pd(rsq21);
            rinv22           = gmx_mm_invsqrt_pd(rsq22);

            rinvsq00         = _mm_mul_pd(rinv00,rinv00);
            rinvsq01         = _mm_mul_pd(rinv01,rinv01);
            rinvsq02         = _mm_mul_pd(rinv02,rinv02);
            rinvsq10         = _mm_mul_pd(rinv10,rinv10);
            rinvsq11         = _mm_mul_pd(rinv11,rinv11);
            rinvsq12         = _mm_mul_pd(rinv12,rinv12);
            rinvsq20         = _mm_mul_pd(rinv20,rinv20);
            rinvsq21         = _mm_mul_pd(rinv21,rinv21);
            rinvsq22         = _mm_mul_pd(rinv22,rinv22);

            fjx0             = _mm_setzero_pd();
            fjy0             = _mm_setzero_pd();
            fjz0             = _mm_setzero_pd();
            fjx1             = _mm_setzero_pd();
            fjy1             = _mm_setzero_pd();
            fjz1             = _mm_setzero_pd();
            fjx2             = _mm_setzero_pd();
            fjy2             = _mm_setzero_pd();
            fjz2             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm_mul_pd(rsq00,rinv00);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r00,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_2pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),ewtab+gmx_mm_extract_epi32(ewitab,1),
                                         &ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq00,rinv00),_mm_sub_pd(rinvsq00,felec));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx00);
            ty               = _mm_mul_pd(fscal,dy00);
            tz               = _mm_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r01              = _mm_mul_pd(rsq01,rinv01);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r01,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_2pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),ewtab+gmx_mm_extract_epi32(ewitab,1),
                                         &ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq01,rinv01),_mm_sub_pd(rinvsq01,felec));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx01);
            ty               = _mm_mul_pd(fscal,dy01);
            tz               = _mm_mul_pd(fscal,dz01);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx1             = _mm_add_pd(fjx1,tx);
            fjy1             = _mm_add_pd(fjy1,ty);
            fjz1             = _mm_add_pd(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r02              = _mm_mul_pd(rsq02,rinv02);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r02,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_2pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),ewtab+gmx_mm_extract_epi32(ewitab,1),
                                         &ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq02,rinv02),_mm_sub_pd(rinvsq02,felec));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx02);
            ty               = _mm_mul_pd(fscal,dy02);
            tz               = _mm_mul_pd(fscal,dz02);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx2             = _mm_add_pd(fjx2,tx);
            fjy2             = _mm_add_pd(fjy2,ty);
            fjz2             = _mm_add_pd(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r10              = _mm_mul_pd(rsq10,rinv10);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r10,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_2pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),ewtab+gmx_mm_extract_epi32(ewitab,1),
                                         &ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq10,rinv10),_mm_sub_pd(rinvsq10,felec));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx10);
            ty               = _mm_mul_pd(fscal,dy10);
            tz               = _mm_mul_pd(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r11              = _mm_mul_pd(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r11,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_2pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),ewtab+gmx_mm_extract_epi32(ewitab,1),
                                         &ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq11,rinv11),_mm_sub_pd(rinvsq11,felec));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx11);
            ty               = _mm_mul_pd(fscal,dy11);
            tz               = _mm_mul_pd(fscal,dz11);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx1             = _mm_add_pd(fjx1,tx);
            fjy1             = _mm_add_pd(fjy1,ty);
            fjz1             = _mm_add_pd(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r12              = _mm_mul_pd(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r12,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_2pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),ewtab+gmx_mm_extract_epi32(ewitab,1),
                                         &ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq12,rinv12),_mm_sub_pd(rinvsq12,felec));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx12);
            ty               = _mm_mul_pd(fscal,dy12);
            tz               = _mm_mul_pd(fscal,dz12);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx2             = _mm_add_pd(fjx2,tx);
            fjy2             = _mm_add_pd(fjy2,ty);
            fjz2             = _mm_add_pd(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r20              = _mm_mul_pd(rsq20,rinv20);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r20,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_2pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),ewtab+gmx_mm_extract_epi32(ewitab,1),
                                         &ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq20,rinv20),_mm_sub_pd(rinvsq20,felec));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx20);
            ty               = _mm_mul_pd(fscal,dy20);
            tz               = _mm_mul_pd(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r21              = _mm_mul_pd(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r21,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_2pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),ewtab+gmx_mm_extract_epi32(ewitab,1),
                                         &ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq21,rinv21),_mm_sub_pd(rinvsq21,felec));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx21);
            ty               = _mm_mul_pd(fscal,dy21);
            tz               = _mm_mul_pd(fscal,dz21);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx1             = _mm_add_pd(fjx1,tx);
            fjy1             = _mm_add_pd(fjy1,ty);
            fjz1             = _mm_add_pd(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r22              = _mm_mul_pd(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r22,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_2pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),ewtab+gmx_mm_extract_epi32(ewitab,1),
                                         &ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq22,rinv22),_mm_sub_pd(rinvsq22,felec));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx22);
            ty               = _mm_mul_pd(fscal,dy22);
            tz               = _mm_mul_pd(fscal,dz22);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx2             = _mm_add_pd(fjx2,tx);
            fjy2             = _mm_add_pd(fjy2,ty);
            fjz2             = _mm_add_pd(fjz2,tz);

            gmx_mm_decrement_3rvec_2ptr_swizzle_pd(f+j_coord_offsetA,f+j_coord_offsetB,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 324 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_1ptr_swizzle_pd(x+j_coord_offsetA,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);
            dx01             = _mm_sub_pd(ix0,jx1);
            dy01             = _mm_sub_pd(iy0,jy1);
            dz01             = _mm_sub_pd(iz0,jz1);
            dx02             = _mm_sub_pd(ix0,jx2);
            dy02             = _mm_sub_pd(iy0,jy2);
            dz02             = _mm_sub_pd(iz0,jz2);
            dx10             = _mm_sub_pd(ix1,jx0);
            dy10             = _mm_sub_pd(iy1,jy0);
            dz10             = _mm_sub_pd(iz1,jz0);
            dx11             = _mm_sub_pd(ix1,jx1);
            dy11             = _mm_sub_pd(iy1,jy1);
            dz11             = _mm_sub_pd(iz1,jz1);
            dx12             = _mm_sub_pd(ix1,jx2);
            dy12             = _mm_sub_pd(iy1,jy2);
            dz12             = _mm_sub_pd(iz1,jz2);
            dx20             = _mm_sub_pd(ix2,jx0);
            dy20             = _mm_sub_pd(iy2,jy0);
            dz20             = _mm_sub_pd(iz2,jz0);
            dx21             = _mm_sub_pd(ix2,jx1);
            dy21             = _mm_sub_pd(iy2,jy1);
            dz21             = _mm_sub_pd(iz2,jz1);
            dx22             = _mm_sub_pd(ix2,jx2);
            dy22             = _mm_sub_pd(iy2,jy2);
            dz22             = _mm_sub_pd(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);
            rsq01            = gmx_mm_calc_rsq_pd(dx01,dy01,dz01);
            rsq02            = gmx_mm_calc_rsq_pd(dx02,dy02,dz02);
            rsq10            = gmx_mm_calc_rsq_pd(dx10,dy10,dz10);
            rsq11            = gmx_mm_calc_rsq_pd(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_pd(dx12,dy12,dz12);
            rsq20            = gmx_mm_calc_rsq_pd(dx20,dy20,dz20);
            rsq21            = gmx_mm_calc_rsq_pd(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_pd(dx22,dy22,dz22);

            rinv00           = gmx_mm_invsqrt_pd(rsq00);
            rinv01           = gmx_mm_invsqrt_pd(rsq01);
            rinv02           = gmx_mm_invsqrt_pd(rsq02);
            rinv10           = gmx_mm_invsqrt_pd(rsq10);
            rinv11           = gmx_mm_invsqrt_pd(rsq11);
            rinv12           = gmx_mm_invsqrt_pd(rsq12);
            rinv20           = gmx_mm_invsqrt_pd(rsq20);
            rinv21           = gmx_mm_invsqrt_pd(rsq21);
            rinv22           = gmx_mm_invsqrt_pd(rsq22);

            rinvsq00         = _mm_mul_pd(rinv00,rinv00);
            rinvsq01         = _mm_mul_pd(rinv01,rinv01);
            rinvsq02         = _mm_mul_pd(rinv02,rinv02);
            rinvsq10         = _mm_mul_pd(rinv10,rinv10);
            rinvsq11         = _mm_mul_pd(rinv11,rinv11);
            rinvsq12         = _mm_mul_pd(rinv12,rinv12);
            rinvsq20         = _mm_mul_pd(rinv20,rinv20);
            rinvsq21         = _mm_mul_pd(rinv21,rinv21);
            rinvsq22         = _mm_mul_pd(rinv22,rinv22);

            fjx0             = _mm_setzero_pd();
            fjy0             = _mm_setzero_pd();
            fjz0             = _mm_setzero_pd();
            fjx1             = _mm_setzero_pd();
            fjy1             = _mm_setzero_pd();
            fjz1             = _mm_setzero_pd();
            fjx2             = _mm_setzero_pd();
            fjy2             = _mm_setzero_pd();
            fjz2             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm_mul_pd(rsq00,rinv00);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r00,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_1pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),&ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq00,rinv00),_mm_sub_pd(rinvsq00,felec));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx00);
            ty               = _mm_mul_pd(fscal,dy00);
            tz               = _mm_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r01              = _mm_mul_pd(rsq01,rinv01);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r01,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_1pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),&ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq01,rinv01),_mm_sub_pd(rinvsq01,felec));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx01);
            ty               = _mm_mul_pd(fscal,dy01);
            tz               = _mm_mul_pd(fscal,dz01);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx1             = _mm_add_pd(fjx1,tx);
            fjy1             = _mm_add_pd(fjy1,ty);
            fjz1             = _mm_add_pd(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r02              = _mm_mul_pd(rsq02,rinv02);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r02,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_1pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),&ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq02,rinv02),_mm_sub_pd(rinvsq02,felec));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx02);
            ty               = _mm_mul_pd(fscal,dy02);
            tz               = _mm_mul_pd(fscal,dz02);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx2             = _mm_add_pd(fjx2,tx);
            fjy2             = _mm_add_pd(fjy2,ty);
            fjz2             = _mm_add_pd(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r10              = _mm_mul_pd(rsq10,rinv10);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r10,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_1pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),&ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq10,rinv10),_mm_sub_pd(rinvsq10,felec));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx10);
            ty               = _mm_mul_pd(fscal,dy10);
            tz               = _mm_mul_pd(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r11              = _mm_mul_pd(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r11,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_1pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),&ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq11,rinv11),_mm_sub_pd(rinvsq11,felec));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx11);
            ty               = _mm_mul_pd(fscal,dy11);
            tz               = _mm_mul_pd(fscal,dz11);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx1             = _mm_add_pd(fjx1,tx);
            fjy1             = _mm_add_pd(fjy1,ty);
            fjz1             = _mm_add_pd(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r12              = _mm_mul_pd(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r12,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_1pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),&ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq12,rinv12),_mm_sub_pd(rinvsq12,felec));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx12);
            ty               = _mm_mul_pd(fscal,dy12);
            tz               = _mm_mul_pd(fscal,dz12);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx2             = _mm_add_pd(fjx2,tx);
            fjy2             = _mm_add_pd(fjy2,ty);
            fjz2             = _mm_add_pd(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r20              = _mm_mul_pd(rsq20,rinv20);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r20,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_1pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),&ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq20,rinv20),_mm_sub_pd(rinvsq20,felec));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx20);
            ty               = _mm_mul_pd(fscal,dy20);
            tz               = _mm_mul_pd(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r21              = _mm_mul_pd(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r21,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_1pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),&ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq21,rinv21),_mm_sub_pd(rinvsq21,felec));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx21);
            ty               = _mm_mul_pd(fscal,dy21);
            tz               = _mm_mul_pd(fscal,dz21);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx1             = _mm_add_pd(fjx1,tx);
            fjy1             = _mm_add_pd(fjy1,ty);
            fjz1             = _mm_add_pd(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r22              = _mm_mul_pd(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r22,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
            gmx_mm_load_1pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),&ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq22,rinv22),_mm_sub_pd(rinvsq22,felec));

            fscal            = felec;

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx22);
            ty               = _mm_mul_pd(fscal,dy22);
            tz               = _mm_mul_pd(fscal,dz22);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx2             = _mm_add_pd(fjx2,tx);
            fjy2             = _mm_add_pd(fjy2,ty);
            fjz2             = _mm_add_pd(fjz2,tz);

            gmx_mm_decrement_3rvec_1ptr_swizzle_pd(f+j_coord_offsetA,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 324 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_3atom_swizzle_pd(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,
                                              f+i_coord_offset,fshift+i_shift_offset);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 18 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_W3W3_F,outeriter*18 + inneriter*324);
}
