#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "xmlparse.h"

static XML_Parser parser = NULL;

typedef struct {
  char *name;
  double value;
} DataNode;

typedef struct {
  const char *itemID;
  const char *groupID;
  int dataCount;
  DataNode **datas;
} ItemNode;

typedef struct {
  int itemCount;
  ItemNode **items;
} ItemList;

typedef struct {
  int listCount;
  ItemList *lists;
} GroupedLists;


static ItemList *ItemList_create()
{
  ItemList *d = (ItemList *) (malloc(sizeof(ItemList)));
  d->itemCount = 0;
  d->items = NULL;
  return d;
}

static void ItemList_addItemNode(ItemList *d, ItemNode *n)
{
  int i = d->itemCount++;
  d->items = realloc(d->items, sizeof(ItemNode *) * d->itemCount);
  d->items[i] = n;
}

static ItemNode *ItemNode_create()
{
  ItemNode *i = (ItemNode *) (malloc(sizeof(ItemNode)));
  i->itemID = NULL;
  i->groupID = NULL;
  i->dataCount = 0;
  i->datas = NULL;
  return i;
}

static void ItemNode_addDataNode(ItemNode *n, DataNode *d)
{
  int i = n->dataCount++;
  n->datas = realloc(n->datas, sizeof(DataNode *) * n->dataCount);
  n->datas[i] = d;
}

static DataNode *DataNode_create()
{
  DataNode *i = (DataNode *) (malloc(sizeof(DataNode)));
  i->name = NULL;
  i->value = 0.0;
  return i;
}

static void startElement(void *userData, const char *name, const char **atts)
{
  int i;
  ItemList *currentList = (ItemList *) userData;

  if (strcmp(name, "dataset") == 0) {
  }
  else if (strcmp(name, "item") == 0) {
    ItemNode *currentItem = ItemNode_create();
    
    for (;*atts; atts++) {
      if (strcmp(*atts, "groupid") == 0) {
	currentItem->groupID = strdup(*(atts + 1));
      }
      else if (strcmp(*atts, "itemid") == 0) {
	currentItem->itemID = strdup(*(atts + 1));
      }
    }
    ItemList_addItemNode(currentList, currentItem);
  }
  else {
    ItemNode *currentItem = currentList->items[currentList->itemCount - 1];
    DataNode *currentData = DataNode_create();
    currentData->name = strdup(name);
    for (;*atts; atts++) {
      if (strcmp(*atts, "data") == 0) {
	currentData->value = strtod(*(atts + 1), NULL);
      }
    }
    ItemNode_addDataNode(currentItem, currentData);
  }
}

static void endElement(void *userData, const char *name)
{
}

static int compareItems(const void *arg1, const void *arg2)
{
  const ItemNode **item1 = (ItemNode **) arg1;
  const ItemNode **item2 = (ItemNode **) arg2;
  int result;
  if ((result = strcmp((*item1)->groupID, (*item2)->groupID)) != 0) {
    return result;
  }
  return strcmp((*item1)->itemID, (*item2)->itemID);
}


ItemList *getData(FILE *inputfp) {
  int done = 0;
  char buf[1000];
  XML_Parser parser = XML_ParserCreate(NULL);

  ItemList *list = ItemList_create();

  XML_SetUserData(parser, list);
  XML_SetElementHandler(parser, startElement, endElement);

  do {
    size_t len = fread(buf, 1, sizeof(buf), inputfp);
    done = len < sizeof(buf);
    if (!XML_Parse(parser, buf, len, done)) {
      fprintf(stderr,
              "%s at line %d\n",
              XML_ErrorString(XML_GetErrorCode(parser)),
              XML_GetCurrentLineNumber(parser));
      return NULL;
    }
  } while (!done);
   qsort((void *) (list->items), list->itemCount, sizeof(*(list->items)), &compareItems);
  return list;
}

int main(int argc, char **argv)
{
  int i, j;
  ItemList *list = getData(stdin);
  for (i = 0; i < list->itemCount; i++) {
    printf("item %s %s\n",
	   list->items[i]->groupID,
	   list->items[i]->itemID);
    for (j = 0; j < list->items[i]->dataCount; j++) {
      printf("data %s %f\n", 
	     list->items[i]->datas[j]->name, 
	     list->items[i]->datas[j]->value);
    }
  }
}
