/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 18 "parser_impl.y"

#include "parser_impl.h"
#include "gringo/gringo.h"
#include "gringo/parser.h"
#include "gringo/grounder.h"
#include "gringo/output.h"
#include "gringo/domain.h"

#include "gringo/rule.h"
#include "gringo/optimize.h"
#include "gringo/display.h"
#include "gringo/external.h"
#include "gringo/compute.h"

#include "gringo/predlit.h"
#include "gringo/rellit.h"

#include "gringo/sumaggrlit.h"
#include "gringo/avgaggrlit.h"
#include "gringo/junctionaggrlit.h"
#include "gringo/minmaxaggrlit.h"
#include "gringo/parityaggrlit.h"

#include "gringo/constterm.h"
#include "gringo/varterm.h"
#include "gringo/mathterm.h"
#include "gringo/poolterm.h"
#include "gringo/argterm.h"
#include "gringo/rangeterm.h"
#include "gringo/functerm.h"
#include "gringo/luaterm.h"

#define GRD pParser->grounder()
#define OUT pParser->grounder()->output()
#define ONE(loc) new ConstTerm(loc, Val::create(Val::NUM, 1))
#define ZERO(loc) new ConstTerm(loc, Val::create(Val::NUM, 0))
#define MINUSONE(loc) new ConstTerm(loc, Val::create(Val::NUM, -1))

template <class T>
void del(T x)
{
	delete x;
}

template <class T>
boost::ptr_vector<T> *vec1(T *x)
{
	boost::ptr_vector<T> *v = new boost::ptr_vector<T>();
	v->push_back(x);
	return v;
}

typedef std::vector<VarSigVec> VarSigVecVec;

#line 63 "parser_impl.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    parserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is parserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    parserARG_SDECL     A static variable declaration for the %extra_argument
**    parserARG_PDECL     A parameter declaration for the %extra_argument
**    parserARG_STORE     Code to store %extra_argument into yypParser
**    parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 126
#define YYACTIONTYPE unsigned short int
#define parserTOKENTYPE  Parser::Token 
typedef union {
  int yyinit;
  parserTOKENTYPE yy0;
  TermPtrVec* yy11;
  AggrLit* yy21;
  MathTerm::Func* yy23;
  Term* yy27;
  Lit* yy38;
  PredLit* yy63;
  Rule* yy69;
  VarSigVecVec* yy71;
  RelLit::Type yy93;
  CondLitVec* yy94;
  CondLit* yy100;
  VarSigVec* yy129;
  Optimize* yy142;
  LitPtrVec* yy146;
  Compute* yy190;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 0
#endif
#define parserARG_SDECL  Parser *pParser ;
#define parserARG_PDECL , Parser *pParser 
#define parserARG_FETCH  Parser *pParser  = yypParser->pParser 
#define parserARG_STORE yypParser->pParser  = pParser 
#define YYNSTATE 344
#define YYNRULE 175
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   344,  268,  105,   55,  239,  261,  239,  261,   89,  520,
 /*    10 */     1,   57,  175,   58,  176,   23,  174,  170,  207,  206,
 /*    20 */   463,   76,  296,  167,  242,   49,   50,  243,  185,  137,
 /*    30 */   100,   51,  189,  190,  275,  102,   40,   21,  180,  241,
 /*    40 */     3,   64,   65,   68,   69,   66,   67,   70,   71,  244,
 /*    50 */   245,  246,  173,  177,   85,  198,    6,   13,  203,  205,
 /*    60 */     9,   12,  162,  163,  209,  211,  227,  228,  165,   61,
 /*    70 */    60,   73,   74,   72,   62,   63,   64,   65,   68,   69,
 /*    80 */    66,   67,   70,   71,   61,   60,   73,   74,   72,   62,
 /*    90 */    63,   64,   65,   68,   69,   66,   67,   70,   71,   62,
 /*   100 */    63,   64,   65,   68,   69,   66,   67,   70,   71,   34,
 /*   110 */   262,  263,  264,  265,  266,  267,  303,   93,  170,  279,
 /*   120 */    23,   95,  198,    6,   15,  203,  205,    9,   14,   23,
 /*   130 */    86,  209,  211,   55,   89,   96,  239,  261,  175,  180,
 /*   140 */   176,  231,  174,   58,  100,  332,  223,   76,  208,  206,
 /*   150 */   242,  101,  296,  243,   55,  137,   52,  239,  261,  239,
 /*   160 */   261,  364,   40,  108,   58,  217,   58,   16,  201,  199,
 /*   170 */   287,  121,  144,  297,   27,  244,  245,  246,  173,  177,
 /*   180 */    85,  198,    6,  122,  203,  205,    9,   42,  162,  163,
 /*   190 */   209,  211,   55,   89,   86,  239,  261,  175,  278,  176,
 /*   200 */    24,  174,   58,  240,  121,  146,   76,  213,  206,  242,
 /*   210 */    33,  296,  243,   52,  137,   99,  239,  261,  303,   93,
 /*   220 */   365,   40,  133,   58,  241,  202,  199,  287,  308,  303,
 /*   230 */    94,  286,  121,  145,  244,  245,  246,  173,  177,   85,
 /*   240 */   198,    6,   21,  203,  205,    9,   38,  162,  163,  209,
 /*   250 */   211,   61,   60,   73,   74,   72,   62,   63,   64,   65,
 /*   260 */    68,   69,   66,   67,   70,   71,   61,   60,   73,   74,
 /*   270 */    72,   62,   63,   64,   65,   68,   69,   66,   67,   70,
 /*   280 */    71,   61,   60,   73,   74,   72,   62,   63,   64,   65,
 /*   290 */    68,   69,   66,   67,   70,   71,  121,  143,  121,  179,
 /*   300 */   121,  147,   21,   23,  198,    6,  230,  203,  205,    9,
 /*   310 */   132,  239,   56,  209,  211,   55,   84,   23,  239,  261,
 /*   320 */   175,  230,  176,  124,  174,   58,  239,   56,  141,   76,
 /*   330 */   215,  206,  242,  111,  296,  243,   52,  172,  142,  239,
 /*   340 */   261,  151,  309,  152,   40,  153,   58,  241,  204,  199,
 /*   350 */   287,  324,  323,  322,  229,  340,  154,  244,  245,  246,
 /*   360 */   173,  177,   85,  198,    6,  121,  148,  205,    9,  232,
 /*   370 */   340,  155,  209,  211,  156,   61,   60,   73,   74,   72,
 /*   380 */    62,   63,   64,   65,   68,   69,   66,   67,   70,   71,
 /*   390 */    61,   60,   73,   74,   72,   62,   63,   64,   65,   68,
 /*   400 */    69,   66,   67,   70,   71,  230,  111,  157,  125,  158,
 /*   410 */   239,   56,   41,   59,  240,   87,  262,  263,  264,  265,
 /*   420 */   266,  267,  121,  149,  325,  323,  322,  311,  289,  291,
 /*   430 */   252,  262,  263,  264,  265,  266,  267,   52,  235,  136,
 /*   440 */   239,  261,   52,  134,  196,  239,  261,   58,  103,  210,
 /*   450 */   199,  287,   58,  135,  341,   33,  288,  335,  222,  480,
 /*   460 */   480,  480,  112,  219,  239,   48,  113,  321,  218,  480,
 /*   470 */   182,   41,   83,  308,  303,   94,  319,  480,  320,  480,
 /*   480 */   104,  166,   89,  276,  277,  220,  175,  224,  176,  254,
 /*   490 */   174,  159,  480,  329,  223,   76,  480,  114,  242,  106,
 /*   500 */   480,  243,  221,  137,  318,  327,  333,  223,   97,  107,
 /*   510 */    40,  335,  222,  241,  168,  101,   24,  115,  239,   48,
 /*   520 */   334,  150,  226,  244,  245,  246,  173,  177,   85,  239,
 /*   530 */    53,   99,   89,  183,  226,  191,  175,  116,  176,   92,
 /*   540 */   174,  239,   53,  187,  117,   76,  118,   21,  242,  292,
 /*   550 */   200,  243,  119,  137,   52,  255,  328,  239,  261,  327,
 /*   560 */    40,   41,   83,  181,   58,  101,  212,  199,  287,  225,
 /*   570 */   256,  337,  123,  244,  245,  246,  173,  177,   85,  258,
 /*   580 */   124,  338,   84,  337,  334,  164,  175,  125,  176,  126,
 /*   590 */   174,   41,   83,  194,  161,   76,  298,  291,  242,   41,
 /*   600 */    83,  243,   52,  172,  127,  239,  261,  342,  223,  259,
 /*   610 */    40,  257,   58,  241,  214,  199,  287,  260,   45,   41,
 /*   620 */    83,   41,   83,  244,  245,  246,  173,  177,   85,  195,
 /*   630 */    70,   71,   84,  128,  129,   37,  175,  139,  176,  140,
 /*   640 */   174,   46,  120,  130,  131,   76,   47,   19,  242,  237,
 /*   650 */   281,  243,   52,  172,  238,  239,  261,  192,  270,  233,
 /*   660 */    40,  253,   58,  241,  216,  199,  287,  271,  290,  310,
 /*   670 */   234,  169,  236,  244,  245,  246,  173,  177,   85,  171,
 /*   680 */    38,  178,   84,   39,   75,   77,  175,   79,  176,   81,
 /*   690 */   174,   36,   83,   42,   88,   76,  160,  184,  242,  186,
 /*   700 */   269,  243,  188,  172,  268,  109,   90,  239,  261,  272,
 /*   710 */    40,   54,  273,  241,   57,  274,  193,  280,  282,    2,
 /*   720 */     4,    5,   20,  244,  245,  246,  173,  177,   85,   91,
 /*   730 */    22,    8,   84,   30,   31,   24,  175,  293,  176,   35,
 /*   740 */   174,  294,  295,   18,    7,   76,   10,   26,  242,   29,
 /*   750 */   301,  243,  299,  138,  268,  330,  300,  239,  261,   11,
 /*   760 */    40,  302,  304,  241,   57,  305,  306,   25,  307,  521,
 /*   770 */    17,  521,  326,  244,  245,  246,  173,  177,   85,   61,
 /*   780 */    60,   73,   74,   72,   62,   63,   64,   65,   68,   69,
 /*   790 */    66,   67,   70,   71,   61,   60,   73,   74,   72,   62,
 /*   800 */    63,   64,   65,   68,   69,   66,   67,   70,   71,  339,
 /*   810 */   336,  490,  491,  248,  247,   28,   61,   60,   73,   74,
 /*   820 */    72,   62,   63,   64,   65,   68,   69,   66,   67,   70,
 /*   830 */    71,  521,  343,  521,   78,  521,  521,   61,   60,   73,
 /*   840 */    74,   72,   62,   63,   64,   65,   68,   69,   66,   67,
 /*   850 */    70,   71,   61,   60,   73,   74,   72,   62,   63,   64,
 /*   860 */    65,   68,   69,   66,   67,   70,   71,  521,  521,  521,
 /*   870 */    80,  521,  249,   61,   60,   73,   74,   72,   62,   63,
 /*   880 */    64,   65,   68,   69,   66,   67,   70,   71,   61,   60,
 /*   890 */    73,   74,   72,   62,   63,   64,   65,   68,   69,   66,
 /*   900 */    67,   70,   71,  521,  521,  521,   82,  521,  250,   61,
 /*   910 */    60,   73,   74,   72,   62,   63,   64,   65,   68,   69,
 /*   920 */    66,   67,   70,   71,   61,   60,   73,   74,   72,   62,
 /*   930 */    63,   64,   65,   68,   69,   66,   67,   70,   71,  110,
 /*   940 */   312,  284,  239,  261,  251,  283,  197,  521,  521,   32,
 /*   950 */   268,  331,  521,  239,  261,  521,  316,  521,  521,  315,
 /*   960 */    57,  521,  521,  521,  521,  521,  521,  308,  303,   94,
 /*   970 */   313,  314,  521,  521,  521,   98,  110,  312,  284,  239,
 /*   980 */   261,  521,  317,  197,  521,  521,   32,  521,  521,  521,
 /*   990 */   521,  521,  521,  316,  521,  521,  315,  521,  521,  521,
 /*  1000 */   521,  521,  521,  521,  308,  303,   94,  313,  314,   61,
 /*  1010 */    60,   73,   74,   72,   62,   63,   64,   65,   68,   69,
 /*  1020 */    66,   67,   70,   71,   60,   73,   74,   72,   62,   63,
 /*  1030 */    64,   65,   68,   69,   66,   67,   70,   71,  521,  521,
 /*  1040 */   521,  521,  521,  521,  521,  110,  312,  285,  239,  261,
 /*  1050 */   521,  521,  521,  521,  521,   32,  521,  521,  521,  521,
 /*  1060 */   521,  521,  316,  521,  521,  315,  521,  521,  521,  521,
 /*  1070 */   521,  521,  521,  308,  303,   94,  313,  314,   73,   74,
 /*  1080 */    72,   62,   63,   64,   65,   68,   69,   66,   67,   70,
 /*  1090 */    71,   74,   72,   62,   63,   64,   65,   68,   69,   66,
 /*  1100 */    67,   70,   71,   72,   62,   63,   64,   65,   68,   69,
 /*  1110 */    66,   67,   70,   71,  482,  482,  482,  521,  521,  481,
 /*  1120 */   481,  481,  521,  521,  482,  521,  479,  479,  479,  481,
 /*  1130 */    43,  521,  482,  521,  482,   44,  479,  481,  521,  481,
 /*  1140 */   521,  521,  521,  521,  479,  521,  479,  482,  521,  521,
 /*  1150 */   521,  482,  481,  521,  521,  482,  481,  521,  521,  479,
 /*  1160 */   481,  521,  521,  479,  521,  521,  521,  479,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     0,   77,   78,   77,   80,   81,   80,   81,    8,  111,
 /*    10 */   112,   87,   12,   87,   14,   38,   16,    8,   92,   93,
 /*    20 */    21,   21,   96,   23,   24,   25,   26,   27,   28,   29,
 /*    30 */    53,   31,   32,   33,   34,   35,   36,   38,   29,   39,
 /*    40 */    40,    9,   10,   11,   12,   13,   14,   15,   16,   49,
 /*    50 */    50,   51,   52,   53,   54,   55,   56,   56,   58,   59,
 /*    60 */    60,   60,   62,   63,   64,   65,   66,   67,   68,    2,
 /*    70 */     3,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*    80 */    13,   14,   15,   16,    2,    3,    4,    5,    6,    7,
 /*    90 */     8,    9,   10,   11,   12,   13,   14,   15,   16,    7,
 /*   100 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   42,
 /*   110 */    43,   44,   45,   46,   47,   48,  106,  107,    8,   39,
 /*   120 */    38,   30,   55,   56,   56,   58,   59,   60,   60,   38,
 /*   130 */    82,   64,   65,   77,    8,   53,   80,   81,   12,   29,
 /*   140 */    14,   27,   16,   87,   53,  103,  104,   21,   92,   93,
 /*   150 */    24,   41,   96,   27,   77,   29,   77,   80,   81,   80,
 /*   160 */    81,   10,   36,    2,   87,   39,   87,   41,   89,   90,
 /*   170 */    91,   87,   88,   96,   60,   49,   50,   51,   52,   53,
 /*   180 */    54,   55,   56,   87,   58,   59,   60,   36,   62,   63,
 /*   190 */    64,   65,   77,    8,   82,   80,   81,   12,   37,   14,
 /*   200 */    38,   16,   87,   80,   87,   88,   21,   92,   93,   24,
 /*   210 */    87,   96,   27,   77,   29,   53,   80,   81,  106,  107,
 /*   220 */    10,   36,   87,   87,   39,   89,   90,   91,  105,  106,
 /*   230 */   107,  108,   87,   88,   49,   50,   51,   52,   53,   54,
 /*   240 */    55,   56,   38,   58,   59,   60,   36,   62,   63,   64,
 /*   250 */    65,    2,    3,    4,    5,    6,    7,    8,    9,   10,
 /*   260 */    11,   12,   13,   14,   15,   16,    2,    3,    4,    5,
 /*   270 */     6,    7,    8,    9,   10,   11,   12,   13,   14,   15,
 /*   280 */    16,    2,    3,    4,    5,    6,    7,    8,    9,   10,
 /*   290 */    11,   12,   13,   14,   15,   16,   87,   88,   87,   88,
 /*   300 */    87,   88,   38,   38,   55,   56,   75,   58,   59,   60,
 /*   310 */    87,   80,   81,   64,   65,   77,    8,   38,   80,   81,
 /*   320 */    12,   75,   14,   87,   16,   87,   80,   81,   87,   21,
 /*   330 */    92,   93,   24,   80,   96,   27,   77,   29,   87,   80,
 /*   340 */    81,   87,  106,   87,   36,   87,   87,   39,   89,   90,
 /*   350 */    91,   98,   99,  100,  123,  124,   87,   49,   50,   51,
 /*   360 */    52,   53,   54,   55,   56,   87,   88,   59,   60,  123,
 /*   370 */   124,   87,   64,   65,   87,    2,    3,    4,    5,    6,
 /*   380 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*   390 */     2,    3,    4,    5,    6,    7,    8,    9,   10,   11,
 /*   400 */    12,   13,   14,   15,   16,   75,   80,   87,   87,   87,
 /*   410 */    80,   81,   19,   20,   80,   42,   43,   44,   45,   46,
 /*   420 */    47,   48,   87,   88,   98,   99,  100,  106,  101,  102,
 /*   430 */    37,   43,   44,   45,   46,   47,   48,   77,   70,   87,
 /*   440 */    80,   81,   77,   87,   76,   80,   81,   87,   80,   89,
 /*   450 */    90,   91,   87,   87,  124,   87,   91,   73,   74,   20,
 /*   460 */    21,   22,   87,   95,   80,   81,   87,   99,  100,   30,
 /*   470 */     8,   19,   20,  105,  106,  107,  108,   38,  110,   40,
 /*   480 */    80,  113,    8,  115,  116,  117,   12,  119,   14,   37,
 /*   490 */    16,   29,   53,  103,  104,   21,   57,   87,   24,   80,
 /*   500 */    61,   27,  118,   29,  102,  121,  103,  104,   30,   80,
 /*   510 */    36,   73,   74,   39,  114,   41,   38,   87,   80,   81,
 /*   520 */   103,  104,   73,   49,   50,   51,   52,   53,   54,   80,
 /*   530 */    81,   53,    8,  114,   73,  114,   12,   87,   14,   30,
 /*   540 */    16,   80,   81,  114,   87,   21,   87,   38,   24,  101,
 /*   550 */   102,   27,   87,   29,   77,   87,  118,   80,   81,  121,
 /*   560 */    36,   19,   20,   39,   87,   41,   89,   90,   91,  120,
 /*   570 */    87,  122,   87,   49,   50,   51,   52,   53,   54,   37,
 /*   580 */    87,  120,    8,  122,  103,  104,   12,   87,   14,   87,
 /*   590 */    16,   19,   20,   71,   72,   21,  101,  102,   24,   19,
 /*   600 */    20,   27,   77,   29,   87,   80,   81,  103,  104,   37,
 /*   610 */    36,   37,   87,   39,   89,   90,   91,   37,   87,   19,
 /*   620 */    20,   19,   20,   49,   50,   51,   52,   53,   54,    8,
 /*   630 */    15,   16,    8,   87,   87,   87,   12,   37,   14,   37,
 /*   640 */    16,   87,   87,   87,   87,   21,   87,   38,   24,   85,
 /*   650 */    29,   27,   77,   29,   85,   80,   81,   71,   85,   22,
 /*   660 */    36,   37,   87,   39,   89,   90,   91,   85,  102,  102,
 /*   670 */    24,   10,   27,   49,   50,   51,   52,   53,   54,   29,
 /*   680 */    36,   29,    8,   36,   36,   36,   12,   36,   14,   36,
 /*   690 */    16,   36,   20,   36,   30,   21,   29,   10,   24,   29,
 /*   700 */    27,   27,   10,   29,   77,   78,   30,   80,   81,   27,
 /*   710 */    36,   36,   29,   39,   87,   29,   20,   39,   29,   40,
 /*   720 */    20,   56,   20,   49,   50,   51,   52,   53,   54,   30,
 /*   730 */    20,   60,    8,   21,   21,   38,   12,   57,   14,   30,
 /*   740 */    16,   57,   57,   20,   56,   21,   56,   20,   24,   20,
 /*   750 */    57,   27,   61,   29,   77,   78,   61,   80,   81,   56,
 /*   760 */    36,   57,   61,   39,   87,   57,   61,   60,   57,  125,
 /*   770 */    56,  125,   57,   49,   50,   51,   52,   53,   54,    2,
 /*   780 */     3,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*   790 */    13,   14,   15,   16,    2,    3,    4,    5,    6,    7,
 /*   800 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   61,
 /*   810 */    61,   60,   60,   21,   37,   60,    2,    3,    4,    5,
 /*   820 */     6,    7,    8,    9,   10,   11,   12,   13,   14,   15,
 /*   830 */    16,  125,   61,  125,   20,  125,  125,    2,    3,    4,
 /*   840 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   850 */    15,   16,    2,    3,    4,    5,    6,    7,    8,    9,
 /*   860 */    10,   11,   12,   13,   14,   15,   16,  125,  125,  125,
 /*   870 */    20,  125,   37,    2,    3,    4,    5,    6,    7,    8,
 /*   880 */     9,   10,   11,   12,   13,   14,   15,   16,    2,    3,
 /*   890 */     4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   900 */    14,   15,   16,  125,  125,  125,   20,  125,   37,    2,
 /*   910 */     3,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*   920 */    13,   14,   15,   16,    2,    3,    4,    5,    6,    7,
 /*   930 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   77,
 /*   940 */    78,   79,   80,   81,   37,   83,   84,  125,  125,   87,
 /*   950 */    77,   78,  125,   80,   81,  125,   94,  125,  125,   97,
 /*   960 */    87,  125,  125,  125,  125,  125,  125,  105,  106,  107,
 /*   970 */   108,  109,  125,  125,  125,   53,   77,   78,   79,   80,
 /*   980 */    81,  125,   83,   84,  125,  125,   87,  125,  125,  125,
 /*   990 */   125,  125,  125,   94,  125,  125,   97,  125,  125,  125,
 /*  1000 */   125,  125,  125,  125,  105,  106,  107,  108,  109,    2,
 /*  1010 */     3,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*  1020 */    13,   14,   15,   16,    3,    4,    5,    6,    7,    8,
 /*  1030 */     9,   10,   11,   12,   13,   14,   15,   16,  125,  125,
 /*  1040 */   125,  125,  125,  125,  125,   77,   78,   79,   80,   81,
 /*  1050 */   125,  125,  125,  125,  125,   87,  125,  125,  125,  125,
 /*  1060 */   125,  125,   94,  125,  125,   97,  125,  125,  125,  125,
 /*  1070 */   125,  125,  125,  105,  106,  107,  108,  109,    4,    5,
 /*  1080 */     6,    7,    8,    9,   10,   11,   12,   13,   14,   15,
 /*  1090 */    16,    5,    6,    7,    8,    9,   10,   11,   12,   13,
 /*  1100 */    14,   15,   16,    6,    7,    8,    9,   10,   11,   12,
 /*  1110 */    13,   14,   15,   16,   20,   21,   22,  125,  125,   20,
 /*  1120 */    21,   22,  125,  125,   30,  125,   20,   21,   22,   30,
 /*  1130 */    36,  125,   38,  125,   40,   36,   30,   38,  125,   40,
 /*  1140 */   125,  125,  125,  125,   38,  125,   40,   53,  125,  125,
 /*  1150 */   125,   57,   53,  125,  125,   61,   57,  125,  125,   53,
 /*  1160 */    61,  125,  125,   57,  125,  125,  125,   61,
};
#define YY_SHIFT_USE_DFLT (-24)
#define YY_SHIFT_MAX 232
static const short yy_shift_ofst[] = {
 /*     0 */   -24,    0,  126,  126,  126,  474,  474,  474,  474,  474,
 /*    10 */   474,  474,  474,  474,  474,  474,  185,  110,  110,  524,
 /*    20 */   474,  524,  474,  524,  524,  110,  110,  110,  110,  110,
 /*    30 */     9,    9,   67,  249,  308,  308,  574,   82,  674,  674,
 /*    40 */   674,  674,  674,  674,  674,  264,  279,  279,   91,  462,
 /*    50 */   462,  462,  509,  -23,   80,  204,  265,  373,  388,  624,
 /*    60 */   674,  674,  674,  674,  674,  674,  674,  674,  674,  674,
 /*    70 */   674,  674,  674,  674,  674,  674,  674,  674,  674,  674,
 /*    80 */   674,  674,  674,  674,  674,  674,  674,  674,  674,  724,
 /*    90 */   674,  674,  674,  674,  674,  674,  674,  674,  674,  674,
 /*   100 */   674,    9,  621,   -1,  609,  609,  609,  609,   80,  204,
 /*   110 */   204,  204,  777,  792,  814,  835,  850,  871,  886,  907,
 /*   120 */   922, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007,
 /*   130 */  1007, 1007, 1021, 1074, 1086, 1097,   92, 1094, 1099,  439,
 /*   140 */  1106,   32,   32,  393,  452,  542,  572,  580,  600,  602,
 /*   150 */   478,  615,  615,  615,  615,  615,  615,  615,  615,  151,
 /*   160 */   210,  161,    1,   68,  162,  114,  637,  646,  661,  645,
 /*   170 */   650,  644,  647,  648,  649,  651,  653,  652,  655,  672,
 /*   180 */   657,  664,  667,  687,  673,  670,  676,  692,  682,  683,
 /*   190 */   686,  675,  696,  678,  696,  689,  679,  700,  665,  702,
 /*   200 */   699,  680,  684,  688,  685,  671,  710,  691,  695,  690,
 /*   210 */   693,  703,  704,  701,  708,  705,  711,  709,  712,  713,
 /*   220 */   714,  715,  723,  697,  707,  749,  727,  751,  752,  748,
 /*   230 */   729,  755,  771,
};
#define YY_REDUCE_USE_DFLT (-103)
#define YY_REDUCE_MAX 111
static const short yy_reduce_ofst[] = {
 /*     0 */  -102,  368,  862,  899,  968,   79,  136,  259,  -74,   56,
 /*    10 */   360,  477,  115,  525,  238,  575,  123,  384,  438,  -76,
 /*    20 */   365,  627,   77,  677,  873,  449,  461,  231,  246,  330,
 /*    30 */   253,  326,  112,   10,  236,  321,   84,   42,  117,  145,
 /*    40 */   209,  211,  213,  278,  335,  327,  390,  403,  417,  400,
 /*    50 */   419,  429,  448,  481,  522,  495,  504,   48,   48,   96,
 /*    60 */   135,  223,  241,  251,  254,  256,  258,  269,  284,  287,
 /*    70 */   320,  322,  352,  356,  366,  375,  379,  410,  430,  450,
 /*    80 */   457,  459,  465,   96,  468,  483,  485,  493,  500,  468,
 /*    90 */   502,  517,  531,  546,  547,  548,  554,  555,  556,  557,
 /*   100 */   559,  334,  421,  402,  564,  569,  573,  582,  586,  566,
 /*   110 */   567,  402,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   345,  519,  380,  380,  519,  437,  437,  437,  451,  451,
 /*    10 */   437,  437,  451,  437,  451,  437,  519,  492,  492,  519,
 /*    20 */   519,  519,  519,  519,  519,  496,  496,  514,  514,  519,
 /*    30 */   519,  519,  519,  519,  519,  519,  519,  510,  519,  519,
 /*    40 */   519,  519,  519,  519,  519,  444,  510,  510,  510,  349,
 /*    50 */   350,  519,  444,  510,  519,  444,  510,  519,  519,  519,
 /*    60 */   519,  519,  519,  519,  519,  519,  519,  519,  519,  519,
 /*    70 */   519,  519,  519,  519,  519,  519,  519,  519,  519,  519,
 /*    80 */   519,  519,  519,  519,  519,  519,  519,  519,  519,  519,
 /*    90 */   519,  519,  519,  477,  474,  519,  519,  519,  519,  519,
 /*   100 */   519,  519,  519,  375,  366,  366,  366,  366,  519,  442,
 /*   110 */   386,  463,  519,  519,  519,  519,  519,  519,  519,  519,
 /*   120 */   503,  483,  484,  385,  388,  387,  355,  439,  475,  476,
 /*   130 */   502,  506,  409,  408,  421,  422,  420,  402,  402,  428,
 /*   140 */   428,  410,  411,  519,  519,  519,  519,  519,  519,  519,
 /*   150 */   511,  412,  413,  414,  415,  416,  417,  418,  419,  482,
 /*   160 */   481,  519,  519,  519,  511,  519,  519,  519,  519,  519,
 /*   170 */   519,  481,  402,  519,  519,  519,  519,  519,  519,  485,
 /*   180 */   482,  401,  519,  519,  519,  519,  519,  519,  519,  519,
 /*   190 */   519,  519,  371,  519,  370,  519,  374,  381,  519,  438,
 /*   200 */   445,  519,  519,  519,  519,  519,  452,  519,  519,  519,
 /*   210 */   519,  519,  519,  519,  519,  519,  519,  401,  519,  470,
 /*   220 */   519,  519,  494,  511,  519,  519,  498,  488,  489,  519,
 /*   230 */   516,  519,  519,  346,  347,  348,  351,  352,  367,  382,
 /*   240 */   383,  401,  403,  404,  405,  406,  407,  423,  424,  425,
 /*   250 */   426,  427,  429,  430,  431,  433,  434,  432,  428,  479,
 /*   260 */   480,  384,  395,  396,  397,  398,  399,  400,  386,  353,
 /*   270 */   354,  356,  357,  358,  359,  360,  361,  362,  363,  368,
 /*   280 */   369,  364,  365,  372,  378,  379,  391,  435,  436,  440,
 /*   290 */   443,  445,  441,  446,  447,  448,  449,  450,  453,  454,
 /*   300 */   455,  471,  472,  473,  456,  458,  457,  459,  478,  393,
 /*   310 */   460,  392,  389,  390,  394,  461,  462,  373,  464,  376,
 /*   320 */   377,  467,  465,  466,  468,  469,  486,  493,  495,  500,
 /*   330 */   508,  509,  501,  505,  507,  504,  487,  497,  499,  512,
 /*   340 */   515,  517,  518,  513,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "Rule",          "SEM",           "DOTS",        
  "XOR",           "QUESTION",      "AND",           "PLUS",        
  "MINUS",         "MULT",          "SLASH",         "MOD",         
  "PMOD",          "DIV",           "PDIV",          "POW",         
  "PPOW",          "UMINUS",        "UBNOT",         "DSEM",        
  "COMMA",         "VBAR",          "DOT",           "INCLUDE",     
  "STRING",        "HIDE",          "SHOW",          "NUMBER",      
  "CONST",         "IDENTIFIER",    "ASSIGN",        "EXTERNAL",    
  "CUMULATIVE",    "VOLATILE",      "BASE",          "DOMAIN",      
  "LBRAC",         "RBRAC",         "COLON",         "VARIABLE",    
  "IF",            "NOT",           "CASSIGN",       "GREATER",     
  "LOWER",         "GTHAN",         "LTHAN",         "EQUAL",       
  "INEQUAL",       "ANONYMOUS",     "INFIMUM",       "SUPREMUM",    
  "PABS",          "AT",            "BNOT",          "SUM",         
  "LSBRAC",        "RSBRAC",        "AVG",           "COUNT",       
  "LCBRAC",        "RCBRAC",        "EVEN",          "ODD",         
  "MIN",           "MAX",           "MINIMIZE",      "MAXIMIZE",    
  "COMPUTE",       "error",         "rule",          "var_list",    
  "sem_var_list",  "priolit",       "weightedpriolit",  "computelit",  
  "head",          "lit",           "literal",       "body_literal",
  "predicate",     "predlit",       "cmp",           "body",        
  "nbody",         "cond",          "op",            "term",        
  "termlist",      "weightlist",    "nweightlist",   "weightlit",   
  "condlist",      "ncondlist",     "ccondlist",     "head_ccondlist",
  "condlit",       "ccondlit",      "head_ccondlit",  "head_ccondlit_cond",
  "head_ccondlit_nocond",  "weightcond",    "nweightcond",   "priolit_cond",
  "npriolit_cond",  "aggr",          "aggr_ass",      "aggr_num",    
  "aggr_atom",     "conjunction",   "disjunction",   "start",       
  "program",       "line",          "signed",        "optimize",    
  "compute",       "soptimize",     "prio_list",     "soptimize_set",
  "prio_set",      "nprio_list",    "nprio_set",     "compute_list",
  "ncompute_list",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "start ::= program",
 /*   1 */ "program ::=",
 /*   2 */ "program ::= program line DOT",
 /*   3 */ "line ::= INCLUDE STRING",
 /*   4 */ "line ::= rule",
 /*   5 */ "line ::= HIDE",
 /*   6 */ "line ::= SHOW",
 /*   7 */ "line ::= HIDE signed SLASH NUMBER",
 /*   8 */ "line ::= HIDE predicate cond",
 /*   9 */ "line ::= SHOW signed SLASH NUMBER",
 /*  10 */ "line ::= SHOW predicate cond",
 /*  11 */ "line ::= CONST IDENTIFIER ASSIGN term",
 /*  12 */ "line ::= EXTERNAL predicate cond",
 /*  13 */ "line ::= EXTERNAL signed SLASH NUMBER",
 /*  14 */ "line ::= CUMULATIVE IDENTIFIER",
 /*  15 */ "line ::= VOLATILE IDENTIFIER",
 /*  16 */ "line ::= BASE",
 /*  17 */ "line ::= optimize",
 /*  18 */ "line ::= compute",
 /*  19 */ "line ::= DOMAIN signed LBRAC sem_var_list RBRAC",
 /*  20 */ "signed ::= IDENTIFIER",
 /*  21 */ "signed ::= MINUS IDENTIFIER",
 /*  22 */ "cond ::=",
 /*  23 */ "cond ::= COLON literal cond",
 /*  24 */ "var_list ::= VARIABLE",
 /*  25 */ "var_list ::= var_list COMMA VARIABLE",
 /*  26 */ "sem_var_list ::= var_list",
 /*  27 */ "sem_var_list ::= sem_var_list SEM var_list",
 /*  28 */ "rule ::= head IF body",
 /*  29 */ "rule ::= IF body",
 /*  30 */ "rule ::= head",
 /*  31 */ "head ::= predicate",
 /*  32 */ "head ::= aggr_atom",
 /*  33 */ "head ::= disjunction",
 /*  34 */ "nbody ::= body_literal",
 /*  35 */ "nbody ::= nbody COMMA body_literal",
 /*  36 */ "body ::=",
 /*  37 */ "body ::= nbody",
 /*  38 */ "predlit ::= predicate",
 /*  39 */ "predlit ::= NOT predicate",
 /*  40 */ "lit ::= predlit",
 /*  41 */ "lit ::= term cmp term",
 /*  42 */ "literal ::= lit",
 /*  43 */ "literal ::= VARIABLE ASSIGN term",
 /*  44 */ "literal ::= term CASSIGN term",
 /*  45 */ "body_literal ::= literal",
 /*  46 */ "body_literal ::= aggr_atom",
 /*  47 */ "body_literal ::= NOT aggr_atom",
 /*  48 */ "body_literal ::= VARIABLE ASSIGN aggr_ass",
 /*  49 */ "body_literal ::= term CASSIGN aggr_ass",
 /*  50 */ "body_literal ::= conjunction",
 /*  51 */ "cmp ::= GREATER",
 /*  52 */ "cmp ::= LOWER",
 /*  53 */ "cmp ::= GTHAN",
 /*  54 */ "cmp ::= LTHAN",
 /*  55 */ "cmp ::= EQUAL",
 /*  56 */ "cmp ::= INEQUAL",
 /*  57 */ "term ::= VARIABLE",
 /*  58 */ "term ::= IDENTIFIER",
 /*  59 */ "term ::= STRING",
 /*  60 */ "term ::= NUMBER",
 /*  61 */ "term ::= ANONYMOUS",
 /*  62 */ "term ::= INFIMUM",
 /*  63 */ "term ::= SUPREMUM",
 /*  64 */ "term ::= term DOTS term",
 /*  65 */ "term ::= term SEM term",
 /*  66 */ "term ::= term PLUS term",
 /*  67 */ "term ::= term MINUS term",
 /*  68 */ "term ::= term MULT term",
 /*  69 */ "term ::= term SLASH term",
 /*  70 */ "term ::= term DIV term",
 /*  71 */ "term ::= term PDIV term",
 /*  72 */ "term ::= term MOD term",
 /*  73 */ "term ::= term PMOD term",
 /*  74 */ "term ::= term POW term",
 /*  75 */ "term ::= term PPOW term",
 /*  76 */ "term ::= term AND term",
 /*  77 */ "term ::= term XOR term",
 /*  78 */ "term ::= term QUESTION term",
 /*  79 */ "term ::= PABS LBRAC term RBRAC",
 /*  80 */ "term ::= VBAR term VBAR",
 /*  81 */ "term ::= PPOW LBRAC term COMMA term RBRAC",
 /*  82 */ "term ::= PMOD LBRAC term COMMA term RBRAC",
 /*  83 */ "term ::= PDIV LBRAC term COMMA term RBRAC",
 /*  84 */ "term ::= IDENTIFIER LBRAC termlist RBRAC",
 /*  85 */ "term ::= LBRAC termlist RBRAC",
 /*  86 */ "term ::= LBRAC termlist COMMA RBRAC",
 /*  87 */ "term ::= AT IDENTIFIER LBRAC termlist RBRAC",
 /*  88 */ "term ::= AT IDENTIFIER LBRAC RBRAC",
 /*  89 */ "term ::= MINUS term",
 /*  90 */ "term ::= BNOT term",
 /*  91 */ "nweightlist ::= weightlit",
 /*  92 */ "nweightlist ::= nweightlist COMMA weightlit",
 /*  93 */ "weightlist ::=",
 /*  94 */ "weightlist ::= nweightlist",
 /*  95 */ "weightlit ::= lit nweightcond ASSIGN term",
 /*  96 */ "weightlit ::= lit ASSIGN term weightcond",
 /*  97 */ "weightlit ::= lit weightcond",
 /*  98 */ "nweightcond ::= COLON literal",
 /*  99 */ "nweightcond ::= COLON literal nweightcond",
 /* 100 */ "weightcond ::=",
 /* 101 */ "weightcond ::= nweightcond",
 /* 102 */ "aggr_ass ::= SUM LSBRAC weightlist RSBRAC",
 /* 103 */ "aggr_ass ::= LSBRAC weightlist RSBRAC",
 /* 104 */ "aggr_num ::= AVG LSBRAC weightlist RSBRAC",
 /* 105 */ "ncondlist ::= condlit",
 /* 106 */ "ncondlist ::= ncondlist COMMA condlit",
 /* 107 */ "condlist ::=",
 /* 108 */ "condlist ::= ncondlist",
 /* 109 */ "condlit ::= lit weightcond",
 /* 110 */ "aggr_ass ::= COUNT LCBRAC condlist RCBRAC",
 /* 111 */ "aggr_ass ::= LCBRAC condlist RCBRAC",
 /* 112 */ "aggr ::= EVEN LCBRAC condlist RCBRAC",
 /* 113 */ "aggr ::= ODD LCBRAC condlist RCBRAC",
 /* 114 */ "aggr ::= EVEN LSBRAC weightlist RSBRAC",
 /* 115 */ "aggr ::= ODD LSBRAC weightlist RSBRAC",
 /* 116 */ "ccondlit ::= lit nweightcond",
 /* 117 */ "ccondlist ::= ccondlit",
 /* 118 */ "conjunction ::= ccondlist",
 /* 119 */ "head_ccondlit_nocond ::= predicate",
 /* 120 */ "head_ccondlit_cond ::= predicate nweightcond",
 /* 121 */ "head_ccondlit ::= head_ccondlit_nocond",
 /* 122 */ "head_ccondlit ::= head_ccondlit_cond",
 /* 123 */ "head_ccondlist ::= head_ccondlit_cond",
 /* 124 */ "head_ccondlist ::= head_ccondlit_nocond VBAR head_ccondlit",
 /* 125 */ "head_ccondlist ::= head_ccondlist VBAR head_ccondlit",
 /* 126 */ "disjunction ::= head_ccondlist",
 /* 127 */ "aggr_ass ::= MIN LSBRAC weightlist RSBRAC",
 /* 128 */ "aggr_ass ::= MAX LSBRAC weightlist RSBRAC",
 /* 129 */ "aggr_num ::= aggr_ass",
 /* 130 */ "aggr ::= aggr_num",
 /* 131 */ "aggr_atom ::= term aggr_num term",
 /* 132 */ "aggr_atom ::= aggr_num term",
 /* 133 */ "aggr_atom ::= term aggr_num",
 /* 134 */ "aggr_atom ::= aggr",
 /* 135 */ "predicate ::= MINUS IDENTIFIER LBRAC termlist RBRAC",
 /* 136 */ "predicate ::= IDENTIFIER LBRAC termlist RBRAC",
 /* 137 */ "predicate ::= MINUS IDENTIFIER",
 /* 138 */ "predicate ::= IDENTIFIER",
 /* 139 */ "termlist ::= term",
 /* 140 */ "termlist ::= termlist COMMA term",
 /* 141 */ "termlist ::= termlist DSEM termlist",
 /* 142 */ "optimize ::= soptimize LSBRAC prio_list RSBRAC",
 /* 143 */ "optimize ::= soptimize_set LCBRAC prio_set RCBRAC",
 /* 144 */ "soptimize ::= MINIMIZE",
 /* 145 */ "soptimize ::= MAXIMIZE",
 /* 146 */ "soptimize_set ::= MINIMIZE",
 /* 147 */ "soptimize_set ::= MAXIMIZE",
 /* 148 */ "prio_list ::=",
 /* 149 */ "prio_list ::= nprio_list",
 /* 150 */ "nprio_list ::= weightedpriolit",
 /* 151 */ "nprio_list ::= weightedpriolit COMMA prio_list",
 /* 152 */ "prio_set ::=",
 /* 153 */ "prio_set ::= nprio_set",
 /* 154 */ "nprio_set ::= priolit",
 /* 155 */ "nprio_set ::= priolit COMMA prio_set",
 /* 156 */ "weightedpriolit ::= predlit ASSIGN term AT term priolit_cond",
 /* 157 */ "weightedpriolit ::= predlit ASSIGN term priolit_cond",
 /* 158 */ "weightedpriolit ::= predlit npriolit_cond ASSIGN term AT term",
 /* 159 */ "weightedpriolit ::= predlit npriolit_cond ASSIGN term",
 /* 160 */ "weightedpriolit ::= priolit",
 /* 161 */ "priolit ::= predlit AT term priolit_cond",
 /* 162 */ "priolit ::= predlit npriolit_cond AT term",
 /* 163 */ "priolit ::= predlit priolit_cond",
 /* 164 */ "npriolit_cond ::= COLON literal",
 /* 165 */ "npriolit_cond ::= npriolit_cond COLON literal",
 /* 166 */ "priolit_cond ::=",
 /* 167 */ "priolit_cond ::= npriolit_cond",
 /* 168 */ "compute ::= COMPUTE LCBRAC compute_list RCBRAC",
 /* 169 */ "compute ::= COMPUTE NUMBER LCBRAC compute_list RCBRAC",
 /* 170 */ "compute_list ::=",
 /* 171 */ "compute_list ::= ncompute_list",
 /* 172 */ "ncompute_list ::= computelit",
 /* 173 */ "ncompute_list ::= computelit COMMA ncompute_list",
 /* 174 */ "computelit ::= predlit priolit_cond",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = (yyStackEntry *)realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to parser and parserFree.
*/
void *parserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  parserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
      /* TERMINAL Destructor */
    case 1: /* Rule */
    case 2: /* SEM */
    case 3: /* DOTS */
    case 4: /* XOR */
    case 5: /* QUESTION */
    case 6: /* AND */
    case 7: /* PLUS */
    case 8: /* MINUS */
    case 9: /* MULT */
    case 10: /* SLASH */
    case 11: /* MOD */
    case 12: /* PMOD */
    case 13: /* DIV */
    case 14: /* PDIV */
    case 15: /* POW */
    case 16: /* PPOW */
    case 17: /* UMINUS */
    case 18: /* UBNOT */
    case 19: /* DSEM */
    case 20: /* COMMA */
    case 21: /* VBAR */
    case 22: /* DOT */
    case 23: /* INCLUDE */
    case 24: /* STRING */
    case 25: /* HIDE */
    case 26: /* SHOW */
    case 27: /* NUMBER */
    case 28: /* CONST */
    case 29: /* IDENTIFIER */
    case 30: /* ASSIGN */
    case 31: /* EXTERNAL */
    case 32: /* CUMULATIVE */
    case 33: /* VOLATILE */
    case 34: /* BASE */
    case 35: /* DOMAIN */
    case 36: /* LBRAC */
    case 37: /* RBRAC */
    case 38: /* COLON */
    case 39: /* VARIABLE */
    case 40: /* IF */
    case 41: /* NOT */
    case 42: /* CASSIGN */
    case 43: /* GREATER */
    case 44: /* LOWER */
    case 45: /* GTHAN */
    case 46: /* LTHAN */
    case 47: /* EQUAL */
    case 48: /* INEQUAL */
    case 49: /* ANONYMOUS */
    case 50: /* INFIMUM */
    case 51: /* SUPREMUM */
    case 52: /* PABS */
    case 53: /* AT */
    case 54: /* BNOT */
    case 55: /* SUM */
    case 56: /* LSBRAC */
    case 57: /* RSBRAC */
    case 58: /* AVG */
    case 59: /* COUNT */
    case 60: /* LCBRAC */
    case 61: /* RCBRAC */
    case 62: /* EVEN */
    case 63: /* ODD */
    case 64: /* MIN */
    case 65: /* MAX */
    case 66: /* MINIMIZE */
    case 67: /* MAXIMIZE */
    case 68: /* COMPUTE */
{
#line 82 "parser_impl.y"
 (void)pParser; 
#line 988 "parser_impl.c"
}
      break;
    case 71: /* var_list */
{
#line 91 "parser_impl.y"
 del((yypminor->yy129)); 
#line 995 "parser_impl.c"
}
      break;
    case 72: /* sem_var_list */
{
#line 94 "parser_impl.y"
 del((yypminor->yy71)); 
#line 1002 "parser_impl.c"
}
      break;
    case 73: /* priolit */
    case 74: /* weightedpriolit */
{
#line 97 "parser_impl.y"
 del((yypminor->yy142)); 
#line 1010 "parser_impl.c"
}
      break;
    case 75: /* computelit */
{
#line 103 "parser_impl.y"
 del((yypminor->yy190)); 
#line 1017 "parser_impl.c"
}
      break;
    case 76: /* head */
    case 77: /* lit */
    case 78: /* literal */
    case 79: /* body_literal */
{
#line 109 "parser_impl.y"
 del((yypminor->yy38)); 
#line 1027 "parser_impl.c"
}
      break;
    case 80: /* predicate */
    case 81: /* predlit */
{
#line 117 "parser_impl.y"
 del((yypminor->yy63)); 
#line 1035 "parser_impl.c"
}
      break;
    case 83: /* body */
    case 84: /* nbody */
    case 85: /* cond */
    case 101: /* weightcond */
    case 102: /* nweightcond */
    case 103: /* priolit_cond */
    case 104: /* npriolit_cond */
{
#line 124 "parser_impl.y"
 del((yypminor->yy146)); 
#line 1048 "parser_impl.c"
}
      break;
    case 86: /* op */
{
#line 129 "parser_impl.y"
 del((yypminor->yy23)); 
#line 1055 "parser_impl.c"
}
      break;
    case 87: /* term */
{
#line 132 "parser_impl.y"
 del((yypminor->yy27)); 
#line 1062 "parser_impl.c"
}
      break;
    case 88: /* termlist */
{
#line 135 "parser_impl.y"
 del((yypminor->yy11)); 
#line 1069 "parser_impl.c"
}
      break;
    case 89: /* weightlist */
    case 90: /* nweightlist */
    case 92: /* condlist */
    case 93: /* ncondlist */
    case 94: /* ccondlist */
    case 95: /* head_ccondlist */
{
#line 139 "parser_impl.y"
 del((yypminor->yy94)); 
#line 1081 "parser_impl.c"
}
      break;
    case 91: /* weightlit */
    case 96: /* condlit */
    case 97: /* ccondlit */
    case 98: /* head_ccondlit */
    case 99: /* head_ccondlit_cond */
    case 100: /* head_ccondlit_nocond */
{
#line 143 "parser_impl.y"
 del((yypminor->yy100)); 
#line 1093 "parser_impl.c"
}
      break;
    case 105: /* aggr */
    case 106: /* aggr_ass */
    case 107: /* aggr_num */
    case 108: /* aggr_atom */
    case 109: /* conjunction */
    case 110: /* disjunction */
{
#line 180 "parser_impl.y"
 del((yypminor->yy21)); 
#line 1105 "parser_impl.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from parserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_MAX ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_MAX );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_SZ_ACTTAB );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   (void)yypMinor;
   parserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
   parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 111, 1 },
  { 112, 0 },
  { 112, 3 },
  { 113, 2 },
  { 113, 1 },
  { 113, 1 },
  { 113, 1 },
  { 113, 4 },
  { 113, 3 },
  { 113, 4 },
  { 113, 3 },
  { 113, 4 },
  { 113, 3 },
  { 113, 4 },
  { 113, 2 },
  { 113, 2 },
  { 113, 1 },
  { 113, 1 },
  { 113, 1 },
  { 113, 5 },
  { 114, 1 },
  { 114, 2 },
  { 85, 0 },
  { 85, 3 },
  { 71, 1 },
  { 71, 3 },
  { 72, 1 },
  { 72, 3 },
  { 70, 3 },
  { 70, 2 },
  { 70, 1 },
  { 76, 1 },
  { 76, 1 },
  { 76, 1 },
  { 84, 1 },
  { 84, 3 },
  { 83, 0 },
  { 83, 1 },
  { 81, 1 },
  { 81, 2 },
  { 77, 1 },
  { 77, 3 },
  { 78, 1 },
  { 78, 3 },
  { 78, 3 },
  { 79, 1 },
  { 79, 1 },
  { 79, 2 },
  { 79, 3 },
  { 79, 3 },
  { 79, 1 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 87, 1 },
  { 87, 1 },
  { 87, 1 },
  { 87, 1 },
  { 87, 1 },
  { 87, 1 },
  { 87, 1 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 4 },
  { 87, 3 },
  { 87, 6 },
  { 87, 6 },
  { 87, 6 },
  { 87, 4 },
  { 87, 3 },
  { 87, 4 },
  { 87, 5 },
  { 87, 4 },
  { 87, 2 },
  { 87, 2 },
  { 90, 1 },
  { 90, 3 },
  { 89, 0 },
  { 89, 1 },
  { 91, 4 },
  { 91, 4 },
  { 91, 2 },
  { 102, 2 },
  { 102, 3 },
  { 101, 0 },
  { 101, 1 },
  { 106, 4 },
  { 106, 3 },
  { 107, 4 },
  { 93, 1 },
  { 93, 3 },
  { 92, 0 },
  { 92, 1 },
  { 96, 2 },
  { 106, 4 },
  { 106, 3 },
  { 105, 4 },
  { 105, 4 },
  { 105, 4 },
  { 105, 4 },
  { 97, 2 },
  { 94, 1 },
  { 109, 1 },
  { 100, 1 },
  { 99, 2 },
  { 98, 1 },
  { 98, 1 },
  { 95, 1 },
  { 95, 3 },
  { 95, 3 },
  { 110, 1 },
  { 106, 4 },
  { 106, 4 },
  { 107, 1 },
  { 105, 1 },
  { 108, 3 },
  { 108, 2 },
  { 108, 2 },
  { 108, 1 },
  { 80, 5 },
  { 80, 4 },
  { 80, 2 },
  { 80, 1 },
  { 88, 1 },
  { 88, 3 },
  { 88, 3 },
  { 115, 4 },
  { 115, 4 },
  { 117, 1 },
  { 117, 1 },
  { 119, 1 },
  { 119, 1 },
  { 118, 0 },
  { 118, 1 },
  { 121, 1 },
  { 121, 3 },
  { 120, 0 },
  { 120, 1 },
  { 122, 1 },
  { 122, 3 },
  { 74, 6 },
  { 74, 4 },
  { 74, 6 },
  { 74, 4 },
  { 74, 1 },
  { 73, 4 },
  { 73, 4 },
  { 73, 2 },
  { 104, 2 },
  { 104, 3 },
  { 103, 0 },
  { 103, 1 },
  { 116, 4 },
  { 116, 5 },
  { 123, 0 },
  { 123, 1 },
  { 124, 1 },
  { 124, 3 },
  { 75, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  parserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 2: /* program ::= program line DOT */
#line 204 "parser_impl.y"
{
  yy_destructor(yypParser,22,&yymsp[0].minor);
}
#line 1569 "parser_impl.c"
        break;
      case 3: /* line ::= INCLUDE STRING */
#line 206 "parser_impl.y"
{ pParser->include(yymsp[0].minor.yy0.index);   yy_destructor(yypParser,23,&yymsp[-1].minor);
}
#line 1575 "parser_impl.c"
        break;
      case 4: /* line ::= rule */
#line 207 "parser_impl.y"
{ pParser->add(yymsp[0].minor.yy69); }
#line 1580 "parser_impl.c"
        break;
      case 5: /* line ::= HIDE */
#line 208 "parser_impl.y"
{ OUT->show(false);   yy_destructor(yypParser,25,&yymsp[0].minor);
}
#line 1586 "parser_impl.c"
        break;
      case 6: /* line ::= SHOW */
#line 209 "parser_impl.y"
{ OUT->show(true);   yy_destructor(yypParser,26,&yymsp[0].minor);
}
#line 1592 "parser_impl.c"
        break;
      case 7: /* line ::= HIDE signed SLASH NUMBER */
#line 210 "parser_impl.y"
{ OUT->show(yymsp[-2].minor.yy0.index, yymsp[0].minor.yy0.number, false);   yy_destructor(yypParser,25,&yymsp[-3].minor);
  yy_destructor(yypParser,10,&yymsp[-1].minor);
}
#line 1599 "parser_impl.c"
        break;
      case 8: /* line ::= HIDE predicate cond */
#line 211 "parser_impl.y"
{ pParser->add(new Display(yymsp[-2].minor.yy0.loc(), false, yymsp[-1].minor.yy63, *yymsp[0].minor.yy146)); delete yymsp[0].minor.yy146; }
#line 1604 "parser_impl.c"
        break;
      case 9: /* line ::= SHOW signed SLASH NUMBER */
#line 212 "parser_impl.y"
{ OUT->show(yymsp[-2].minor.yy0.index, yymsp[0].minor.yy0.number, true);   yy_destructor(yypParser,26,&yymsp[-3].minor);
  yy_destructor(yypParser,10,&yymsp[-1].minor);
}
#line 1611 "parser_impl.c"
        break;
      case 10: /* line ::= SHOW predicate cond */
#line 213 "parser_impl.y"
{ pParser->add(new Display(yymsp[-2].minor.yy0.loc(), true, yymsp[-1].minor.yy63, *yymsp[0].minor.yy146)); delete yymsp[0].minor.yy146; }
#line 1616 "parser_impl.c"
        break;
      case 11: /* line ::= CONST IDENTIFIER ASSIGN term */
#line 214 "parser_impl.y"
{ pParser->constTerm(yymsp[-2].minor.yy0.index, yymsp[0].minor.yy27);   yy_destructor(yypParser,28,&yymsp[-3].minor);
  yy_destructor(yypParser,30,&yymsp[-1].minor);
}
#line 1623 "parser_impl.c"
        break;
      case 12: /* line ::= EXTERNAL predicate cond */
#line 215 "parser_impl.y"
{ pParser->add(new External(yymsp[-2].minor.yy0.loc(), yymsp[-1].minor.yy63, *yymsp[0].minor.yy146)); delete yymsp[0].minor.yy146; }
#line 1628 "parser_impl.c"
        break;
      case 13: /* line ::= EXTERNAL signed SLASH NUMBER */
#line 216 "parser_impl.y"
{ GRD->externalStm(yymsp[-2].minor.yy0.index, yymsp[0].minor.yy0.number);   yy_destructor(yypParser,31,&yymsp[-3].minor);
  yy_destructor(yypParser,10,&yymsp[-1].minor);
}
#line 1635 "parser_impl.c"
        break;
      case 14: /* line ::= CUMULATIVE IDENTIFIER */
#line 217 "parser_impl.y"
{ pParser->incremental(Parser::IPART_CUMULATIVE, yymsp[0].minor.yy0.index);   yy_destructor(yypParser,32,&yymsp[-1].minor);
}
#line 1641 "parser_impl.c"
        break;
      case 15: /* line ::= VOLATILE IDENTIFIER */
#line 218 "parser_impl.y"
{ pParser->incremental(Parser::IPART_VOLATILE, yymsp[0].minor.yy0.index);   yy_destructor(yypParser,33,&yymsp[-1].minor);
}
#line 1647 "parser_impl.c"
        break;
      case 16: /* line ::= BASE */
#line 219 "parser_impl.y"
{ pParser->incremental(Parser::IPART_BASE);   yy_destructor(yypParser,34,&yymsp[0].minor);
}
#line 1653 "parser_impl.c"
        break;
      case 19: /* line ::= DOMAIN signed LBRAC sem_var_list RBRAC */
#line 222 "parser_impl.y"
{
	foreach (VarSigVec &x, *yymsp[-1].minor.yy71) {
		pParser->domainStm(yymsp[-3].minor.yy0.loc(), yymsp[-3].minor.yy0.index, x);
	}
	del(yymsp[-1].minor.yy71);
  yy_destructor(yypParser,35,&yymsp[-4].minor);
  yy_destructor(yypParser,36,&yymsp[-2].minor);
  yy_destructor(yypParser,37,&yymsp[0].minor);
}
#line 1666 "parser_impl.c"
        break;
      case 20: /* signed ::= IDENTIFIER */
#line 229 "parser_impl.y"
{ yygotominor.yy0 = yymsp[0].minor.yy0; }
#line 1671 "parser_impl.c"
        break;
      case 21: /* signed ::= MINUS IDENTIFIER */
#line 230 "parser_impl.y"
{ yygotominor.yy0 = yymsp[-1].minor.yy0; yygotominor.yy0.index = GRD->index(std::string("-") + GRD->string(yymsp[0].minor.yy0.index)); }
#line 1676 "parser_impl.c"
        break;
      case 22: /* cond ::= */
      case 36: /* body ::= */ yytestcase(yyruleno==36);
      case 100: /* weightcond ::= */ yytestcase(yyruleno==100);
      case 166: /* priolit_cond ::= */ yytestcase(yyruleno==166);
#line 232 "parser_impl.y"
{ yygotominor.yy146 = new LitPtrVec(); }
#line 1684 "parser_impl.c"
        break;
      case 23: /* cond ::= COLON literal cond */
      case 99: /* nweightcond ::= COLON literal nweightcond */ yytestcase(yyruleno==99);
#line 233 "parser_impl.y"
{ yygotominor.yy146 = yymsp[0].minor.yy146; yygotominor.yy146->push_back(yymsp[-1].minor.yy38);   yy_destructor(yypParser,38,&yymsp[-2].minor);
}
#line 1691 "parser_impl.c"
        break;
      case 24: /* var_list ::= VARIABLE */
#line 235 "parser_impl.y"
{ yygotominor.yy129 = new VarSigVec(); yygotominor.yy129->push_back(VarSig(yymsp[0].minor.yy0.loc(), yymsp[0].minor.yy0.index)); }
#line 1696 "parser_impl.c"
        break;
      case 25: /* var_list ::= var_list COMMA VARIABLE */
#line 236 "parser_impl.y"
{ yymsp[-2].minor.yy129->push_back(VarSig(yymsp[0].minor.yy0.loc(), yymsp[0].minor.yy0.index)); yygotominor.yy129 = yymsp[-2].minor.yy129;   yy_destructor(yypParser,20,&yymsp[-1].minor);
}
#line 1702 "parser_impl.c"
        break;
      case 26: /* sem_var_list ::= var_list */
#line 238 "parser_impl.y"
{ yygotominor.yy71 = new VarSigVecVec(); yygotominor.yy71->push_back(*yymsp[0].minor.yy129); del(yymsp[0].minor.yy129); }
#line 1707 "parser_impl.c"
        break;
      case 27: /* sem_var_list ::= sem_var_list SEM var_list */
#line 239 "parser_impl.y"
{ yygotominor.yy71 = yymsp[-2].minor.yy71;               yygotominor.yy71->push_back(*yymsp[0].minor.yy129); del(yymsp[0].minor.yy129);   yy_destructor(yypParser,2,&yymsp[-1].minor);
}
#line 1713 "parser_impl.c"
        break;
      case 28: /* rule ::= head IF body */
#line 241 "parser_impl.y"
{ yygotominor.yy69 = new Rule(yymsp[-2].minor.yy38->loc(), yymsp[-2].minor.yy38, *yymsp[0].minor.yy146); del(yymsp[0].minor.yy146);   yy_destructor(yypParser,40,&yymsp[-1].minor);
}
#line 1719 "parser_impl.c"
        break;
      case 29: /* rule ::= IF body */
#line 242 "parser_impl.y"
{ yygotominor.yy69 = new Rule(yymsp[-1].minor.yy0.loc(), 0, *yymsp[0].minor.yy146); del(yymsp[0].minor.yy146); }
#line 1724 "parser_impl.c"
        break;
      case 30: /* rule ::= head */
#line 243 "parser_impl.y"
{ LitPtrVec v; yygotominor.yy69 = new Rule(yymsp[0].minor.yy38->loc(), yymsp[0].minor.yy38, v); }
#line 1729 "parser_impl.c"
        break;
      case 31: /* head ::= predicate */
      case 40: /* lit ::= predlit */ yytestcase(yyruleno==40);
#line 245 "parser_impl.y"
{ yygotominor.yy38 = yymsp[0].minor.yy63; }
#line 1735 "parser_impl.c"
        break;
      case 32: /* head ::= aggr_atom */
      case 33: /* head ::= disjunction */ yytestcase(yyruleno==33);
      case 46: /* body_literal ::= aggr_atom */ yytestcase(yyruleno==46);
      case 50: /* body_literal ::= conjunction */ yytestcase(yyruleno==50);
#line 246 "parser_impl.y"
{ yygotominor.yy38 = yymsp[0].minor.yy21; }
#line 1743 "parser_impl.c"
        break;
      case 34: /* nbody ::= body_literal */
#line 249 "parser_impl.y"
{ yygotominor.yy146 = vec1(yymsp[0].minor.yy38); }
#line 1748 "parser_impl.c"
        break;
      case 35: /* nbody ::= nbody COMMA body_literal */
#line 250 "parser_impl.y"
{ yygotominor.yy146 = yymsp[-2].minor.yy146; yygotominor.yy146->push_back(yymsp[0].minor.yy38);   yy_destructor(yypParser,20,&yymsp[-1].minor);
}
#line 1754 "parser_impl.c"
        break;
      case 37: /* body ::= nbody */
      case 101: /* weightcond ::= nweightcond */ yytestcase(yyruleno==101);
      case 167: /* priolit_cond ::= npriolit_cond */ yytestcase(yyruleno==167);
#line 253 "parser_impl.y"
{ yygotominor.yy146 = yymsp[0].minor.yy146; }
#line 1761 "parser_impl.c"
        break;
      case 38: /* predlit ::= predicate */
#line 255 "parser_impl.y"
{ yygotominor.yy63 = yymsp[0].minor.yy63; }
#line 1766 "parser_impl.c"
        break;
      case 39: /* predlit ::= NOT predicate */
#line 256 "parser_impl.y"
{ yygotominor.yy63 = yymsp[0].minor.yy63; yymsp[0].minor.yy63->sign(true); yymsp[0].minor.yy63->loc(yymsp[-1].minor.yy0.loc()); }
#line 1771 "parser_impl.c"
        break;
      case 41: /* lit ::= term cmp term */
#line 259 "parser_impl.y"
{ yygotominor.yy38 = new RelLit(yymsp[-2].minor.yy27->loc(), yymsp[-1].minor.yy93, yymsp[-2].minor.yy27, yymsp[0].minor.yy27); }
#line 1776 "parser_impl.c"
        break;
      case 42: /* literal ::= lit */
      case 45: /* body_literal ::= literal */ yytestcase(yyruleno==45);
#line 261 "parser_impl.y"
{ yygotominor.yy38 = yymsp[0].minor.yy38; }
#line 1782 "parser_impl.c"
        break;
      case 43: /* literal ::= VARIABLE ASSIGN term */
#line 262 "parser_impl.y"
{ yygotominor.yy38 = new RelLit(yymsp[-2].minor.yy0.loc(), RelLit::ASSIGN, new VarTerm(yymsp[-2].minor.yy0.loc(), yymsp[-2].minor.yy0.index), yymsp[0].minor.yy27);   yy_destructor(yypParser,30,&yymsp[-1].minor);
}
#line 1788 "parser_impl.c"
        break;
      case 44: /* literal ::= term CASSIGN term */
#line 263 "parser_impl.y"
{ yygotominor.yy38 = new RelLit(yymsp[-2].minor.yy27->loc(), RelLit::ASSIGN, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,42,&yymsp[-1].minor);
}
#line 1794 "parser_impl.c"
        break;
      case 47: /* body_literal ::= NOT aggr_atom */
#line 267 "parser_impl.y"
{ yygotominor.yy38 = yymsp[0].minor.yy21; yymsp[0].minor.yy21->sign(true);   yy_destructor(yypParser,41,&yymsp[-1].minor);
}
#line 1800 "parser_impl.c"
        break;
      case 48: /* body_literal ::= VARIABLE ASSIGN aggr_ass */
#line 268 "parser_impl.y"
{ yygotominor.yy38 = yymsp[0].minor.yy21; yymsp[0].minor.yy21->assign(new VarTerm(yymsp[-2].minor.yy0.loc(), yymsp[-2].minor.yy0.index));   yy_destructor(yypParser,30,&yymsp[-1].minor);
}
#line 1806 "parser_impl.c"
        break;
      case 49: /* body_literal ::= term CASSIGN aggr_ass */
#line 269 "parser_impl.y"
{ yygotominor.yy38 = yymsp[0].minor.yy21; yymsp[0].minor.yy21->assign(yymsp[-2].minor.yy27);   yy_destructor(yypParser,42,&yymsp[-1].minor);
}
#line 1812 "parser_impl.c"
        break;
      case 51: /* cmp ::= GREATER */
#line 272 "parser_impl.y"
{ yygotominor.yy93 = RelLit::GREATER;   yy_destructor(yypParser,43,&yymsp[0].minor);
}
#line 1818 "parser_impl.c"
        break;
      case 52: /* cmp ::= LOWER */
#line 273 "parser_impl.y"
{ yygotominor.yy93 = RelLit::LOWER;   yy_destructor(yypParser,44,&yymsp[0].minor);
}
#line 1824 "parser_impl.c"
        break;
      case 53: /* cmp ::= GTHAN */
#line 274 "parser_impl.y"
{ yygotominor.yy93 = RelLit::GTHAN;   yy_destructor(yypParser,45,&yymsp[0].minor);
}
#line 1830 "parser_impl.c"
        break;
      case 54: /* cmp ::= LTHAN */
#line 275 "parser_impl.y"
{ yygotominor.yy93 = RelLit::LTHAN;   yy_destructor(yypParser,46,&yymsp[0].minor);
}
#line 1836 "parser_impl.c"
        break;
      case 55: /* cmp ::= EQUAL */
#line 276 "parser_impl.y"
{ yygotominor.yy93 = RelLit::EQUAL;   yy_destructor(yypParser,47,&yymsp[0].minor);
}
#line 1842 "parser_impl.c"
        break;
      case 56: /* cmp ::= INEQUAL */
#line 277 "parser_impl.y"
{ yygotominor.yy93 = RelLit::INEQUAL;   yy_destructor(yypParser,48,&yymsp[0].minor);
}
#line 1848 "parser_impl.c"
        break;
      case 57: /* term ::= VARIABLE */
#line 279 "parser_impl.y"
{ yygotominor.yy27 = new VarTerm(yymsp[0].minor.yy0.loc(), yymsp[0].minor.yy0.index); }
#line 1853 "parser_impl.c"
        break;
      case 58: /* term ::= IDENTIFIER */
#line 280 "parser_impl.y"
{ yygotominor.yy27 = pParser->term(Val::ID, yymsp[0].minor.yy0.loc(), yymsp[0].minor.yy0.index); }
#line 1858 "parser_impl.c"
        break;
      case 59: /* term ::= STRING */
#line 281 "parser_impl.y"
{ yygotominor.yy27 = pParser->term(Val::STRING, yymsp[0].minor.yy0.loc(), yymsp[0].minor.yy0.index); }
#line 1863 "parser_impl.c"
        break;
      case 60: /* term ::= NUMBER */
#line 282 "parser_impl.y"
{ yygotominor.yy27 = new ConstTerm(yymsp[0].minor.yy0.loc(), Val::create(Val::NUM, yymsp[0].minor.yy0.number)); }
#line 1868 "parser_impl.c"
        break;
      case 61: /* term ::= ANONYMOUS */
#line 283 "parser_impl.y"
{ yygotominor.yy27 = new VarTerm(yymsp[0].minor.yy0.loc()); }
#line 1873 "parser_impl.c"
        break;
      case 62: /* term ::= INFIMUM */
#line 284 "parser_impl.y"
{ yygotominor.yy27 = new ConstTerm(yymsp[0].minor.yy0.loc(), Val::create(Val::INF, 0)); }
#line 1878 "parser_impl.c"
        break;
      case 63: /* term ::= SUPREMUM */
#line 285 "parser_impl.y"
{ yygotominor.yy27 = new ConstTerm(yymsp[0].minor.yy0.loc(), Val::create(Val::SUP, 0)); }
#line 1883 "parser_impl.c"
        break;
      case 64: /* term ::= term DOTS term */
#line 287 "parser_impl.y"
{ yygotominor.yy27 = new RangeTerm(yymsp[-2].minor.yy27->loc(), yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,3,&yymsp[-1].minor);
}
#line 1889 "parser_impl.c"
        break;
      case 65: /* term ::= term SEM term */
#line 288 "parser_impl.y"
{ yygotominor.yy27 = new PoolTerm(yymsp[-2].minor.yy27->loc(), yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,2,&yymsp[-1].minor);
}
#line 1895 "parser_impl.c"
        break;
      case 66: /* term ::= term PLUS term */
#line 289 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-2].minor.yy27->loc(), MathTerm::PLUS, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,7,&yymsp[-1].minor);
}
#line 1901 "parser_impl.c"
        break;
      case 67: /* term ::= term MINUS term */
#line 290 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-2].minor.yy27->loc(), MathTerm::MINUS, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,8,&yymsp[-1].minor);
}
#line 1907 "parser_impl.c"
        break;
      case 68: /* term ::= term MULT term */
#line 291 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-2].minor.yy27->loc(), MathTerm::MULT, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,9,&yymsp[-1].minor);
}
#line 1913 "parser_impl.c"
        break;
      case 69: /* term ::= term SLASH term */
#line 292 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-2].minor.yy27->loc(), MathTerm::DIV, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,10,&yymsp[-1].minor);
}
#line 1919 "parser_impl.c"
        break;
      case 70: /* term ::= term DIV term */
#line 293 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-2].minor.yy27->loc(), MathTerm::DIV, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 1925 "parser_impl.c"
        break;
      case 71: /* term ::= term PDIV term */
#line 294 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-2].minor.yy27->loc(), MathTerm::DIV, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,14,&yymsp[-1].minor);
}
#line 1931 "parser_impl.c"
        break;
      case 72: /* term ::= term MOD term */
#line 295 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-2].minor.yy27->loc(), MathTerm::MOD, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,11,&yymsp[-1].minor);
}
#line 1937 "parser_impl.c"
        break;
      case 73: /* term ::= term PMOD term */
#line 296 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-2].minor.yy27->loc(), MathTerm::MOD, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,12,&yymsp[-1].minor);
}
#line 1943 "parser_impl.c"
        break;
      case 74: /* term ::= term POW term */
#line 297 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-2].minor.yy27->loc(), MathTerm::POW, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,15,&yymsp[-1].minor);
}
#line 1949 "parser_impl.c"
        break;
      case 75: /* term ::= term PPOW term */
#line 298 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-2].minor.yy27->loc(), MathTerm::POW, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,16,&yymsp[-1].minor);
}
#line 1955 "parser_impl.c"
        break;
      case 76: /* term ::= term AND term */
#line 299 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-2].minor.yy27->loc(), MathTerm::AND, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,6,&yymsp[-1].minor);
}
#line 1961 "parser_impl.c"
        break;
      case 77: /* term ::= term XOR term */
#line 300 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-2].minor.yy27->loc(), MathTerm::XOR, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,4,&yymsp[-1].minor);
}
#line 1967 "parser_impl.c"
        break;
      case 78: /* term ::= term QUESTION term */
#line 301 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-2].minor.yy27->loc(), MathTerm::OR, yymsp[-2].minor.yy27, yymsp[0].minor.yy27);   yy_destructor(yypParser,5,&yymsp[-1].minor);
}
#line 1973 "parser_impl.c"
        break;
      case 79: /* term ::= PABS LBRAC term RBRAC */
#line 302 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-1].minor.yy27->loc(), MathTerm::ABS, yymsp[-1].minor.yy27);   yy_destructor(yypParser,52,&yymsp[-3].minor);
  yy_destructor(yypParser,36,&yymsp[-2].minor);
  yy_destructor(yypParser,37,&yymsp[0].minor);
}
#line 1981 "parser_impl.c"
        break;
      case 80: /* term ::= VBAR term VBAR */
#line 303 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-1].minor.yy27->loc(), MathTerm::ABS, yymsp[-1].minor.yy27);   yy_destructor(yypParser,21,&yymsp[-2].minor);
  yy_destructor(yypParser,21,&yymsp[0].minor);
}
#line 1988 "parser_impl.c"
        break;
      case 81: /* term ::= PPOW LBRAC term COMMA term RBRAC */
#line 304 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-3].minor.yy27->loc(), MathTerm::POW, yymsp[-3].minor.yy27, yymsp[-1].minor.yy27);   yy_destructor(yypParser,16,&yymsp[-5].minor);
  yy_destructor(yypParser,36,&yymsp[-4].minor);
  yy_destructor(yypParser,20,&yymsp[-2].minor);
  yy_destructor(yypParser,37,&yymsp[0].minor);
}
#line 1997 "parser_impl.c"
        break;
      case 82: /* term ::= PMOD LBRAC term COMMA term RBRAC */
#line 305 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-3].minor.yy27->loc(), MathTerm::MOD, yymsp[-3].minor.yy27, yymsp[-1].minor.yy27);   yy_destructor(yypParser,12,&yymsp[-5].minor);
  yy_destructor(yypParser,36,&yymsp[-4].minor);
  yy_destructor(yypParser,20,&yymsp[-2].minor);
  yy_destructor(yypParser,37,&yymsp[0].minor);
}
#line 2006 "parser_impl.c"
        break;
      case 83: /* term ::= PDIV LBRAC term COMMA term RBRAC */
#line 306 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-3].minor.yy27->loc(), MathTerm::DIV, yymsp[-3].minor.yy27, yymsp[-1].minor.yy27);   yy_destructor(yypParser,14,&yymsp[-5].minor);
  yy_destructor(yypParser,36,&yymsp[-4].minor);
  yy_destructor(yypParser,20,&yymsp[-2].minor);
  yy_destructor(yypParser,37,&yymsp[0].minor);
}
#line 2015 "parser_impl.c"
        break;
      case 84: /* term ::= IDENTIFIER LBRAC termlist RBRAC */
#line 307 "parser_impl.y"
{ yygotominor.yy27 = new FuncTerm(yymsp[-3].minor.yy0.loc(), yymsp[-3].minor.yy0.index, *yymsp[-1].minor.yy11); delete yymsp[-1].minor.yy11;   yy_destructor(yypParser,36,&yymsp[-2].minor);
  yy_destructor(yypParser,37,&yymsp[0].minor);
}
#line 2022 "parser_impl.c"
        break;
      case 85: /* term ::= LBRAC termlist RBRAC */
#line 308 "parser_impl.y"
{ yygotominor.yy27 = yymsp[-1].minor.yy11->size() == 1 ? yymsp[-1].minor.yy11->pop_back().release() : new FuncTerm(yymsp[-2].minor.yy0.loc(), GRD->index(""), *yymsp[-1].minor.yy11); delete yymsp[-1].minor.yy11;   yy_destructor(yypParser,37,&yymsp[0].minor);
}
#line 2028 "parser_impl.c"
        break;
      case 86: /* term ::= LBRAC termlist COMMA RBRAC */
#line 309 "parser_impl.y"
{ yygotominor.yy27 = new FuncTerm(yymsp[-3].minor.yy0.loc(), GRD->index(""), *yymsp[-2].minor.yy11); delete yymsp[-2].minor.yy11;   yy_destructor(yypParser,20,&yymsp[-1].minor);
  yy_destructor(yypParser,37,&yymsp[0].minor);
}
#line 2035 "parser_impl.c"
        break;
      case 87: /* term ::= AT IDENTIFIER LBRAC termlist RBRAC */
#line 310 "parser_impl.y"
{ yygotominor.yy27 = new LuaTerm(yymsp[-3].minor.yy0.loc(), yymsp[-3].minor.yy0.index, *yymsp[-1].minor.yy11); delete yymsp[-1].minor.yy11;   yy_destructor(yypParser,53,&yymsp[-4].minor);
  yy_destructor(yypParser,36,&yymsp[-2].minor);
  yy_destructor(yypParser,37,&yymsp[0].minor);
}
#line 2043 "parser_impl.c"
        break;
      case 88: /* term ::= AT IDENTIFIER LBRAC RBRAC */
#line 311 "parser_impl.y"
{ TermPtrVec args; yygotominor.yy27 = new LuaTerm(yymsp[-2].minor.yy0.loc(), yymsp[-2].minor.yy0.index, args);   yy_destructor(yypParser,53,&yymsp[-3].minor);
  yy_destructor(yypParser,36,&yymsp[-1].minor);
  yy_destructor(yypParser,37,&yymsp[0].minor);
}
#line 2051 "parser_impl.c"
        break;
      case 89: /* term ::= MINUS term */
#line 312 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-1].minor.yy0.loc(), MathTerm::MINUS, ZERO(yymsp[-1].minor.yy0.loc()), yymsp[0].minor.yy27); }
#line 2056 "parser_impl.c"
        break;
      case 90: /* term ::= BNOT term */
#line 313 "parser_impl.y"
{ yygotominor.yy27 = new MathTerm(yymsp[-1].minor.yy0.loc(), MathTerm::XOR, MINUSONE(yymsp[-1].minor.yy0.loc()), yymsp[0].minor.yy27); }
#line 2061 "parser_impl.c"
        break;
      case 91: /* nweightlist ::= weightlit */
      case 105: /* ncondlist ::= condlit */ yytestcase(yyruleno==105);
#line 315 "parser_impl.y"
{ yygotominor.yy94 = vec1(yymsp[0].minor.yy100); }
#line 2067 "parser_impl.c"
        break;
      case 92: /* nweightlist ::= nweightlist COMMA weightlit */
      case 106: /* ncondlist ::= ncondlist COMMA condlit */ yytestcase(yyruleno==106);
#line 316 "parser_impl.y"
{ yygotominor.yy94 = yymsp[-2].minor.yy94; yygotominor.yy94->push_back(yymsp[0].minor.yy100);   yy_destructor(yypParser,20,&yymsp[-1].minor);
}
#line 2074 "parser_impl.c"
        break;
      case 93: /* weightlist ::= */
      case 107: /* condlist ::= */ yytestcase(yyruleno==107);
#line 317 "parser_impl.y"
{ yygotominor.yy94 = new CondLitVec(); }
#line 2080 "parser_impl.c"
        break;
      case 94: /* weightlist ::= nweightlist */
      case 108: /* condlist ::= ncondlist */ yytestcase(yyruleno==108);
#line 318 "parser_impl.y"
{ yygotominor.yy94 = yymsp[0].minor.yy94; }
#line 2086 "parser_impl.c"
        break;
      case 95: /* weightlit ::= lit nweightcond ASSIGN term */
#line 320 "parser_impl.y"
{ yygotominor.yy100 = new CondLit(yymsp[-3].minor.yy38->loc(), yymsp[-3].minor.yy38, yymsp[0].minor.yy27, *yymsp[-2].minor.yy146); delete yymsp[-2].minor.yy146;   yy_destructor(yypParser,30,&yymsp[-1].minor);
}
#line 2092 "parser_impl.c"
        break;
      case 96: /* weightlit ::= lit ASSIGN term weightcond */
#line 321 "parser_impl.y"
{ yygotominor.yy100 = new CondLit(yymsp[-3].minor.yy38->loc(), yymsp[-3].minor.yy38, yymsp[-1].minor.yy27, *yymsp[0].minor.yy146); delete yymsp[0].minor.yy146;   yy_destructor(yypParser,30,&yymsp[-2].minor);
}
#line 2098 "parser_impl.c"
        break;
      case 97: /* weightlit ::= lit weightcond */
      case 109: /* condlit ::= lit weightcond */ yytestcase(yyruleno==109);
      case 116: /* ccondlit ::= lit nweightcond */ yytestcase(yyruleno==116);
#line 322 "parser_impl.y"
{ yygotominor.yy100 = new CondLit(yymsp[-1].minor.yy38->loc(), yymsp[-1].minor.yy38, ONE(yymsp[-1].minor.yy38->loc()), *yymsp[0].minor.yy146); delete yymsp[0].minor.yy146; }
#line 2105 "parser_impl.c"
        break;
      case 98: /* nweightcond ::= COLON literal */
      case 164: /* npriolit_cond ::= COLON literal */ yytestcase(yyruleno==164);
#line 324 "parser_impl.y"
{ yygotominor.yy146 = vec1(yymsp[0].minor.yy38);   yy_destructor(yypParser,38,&yymsp[-1].minor);
}
#line 2112 "parser_impl.c"
        break;
      case 102: /* aggr_ass ::= SUM LSBRAC weightlist RSBRAC */
#line 330 "parser_impl.y"
{ yygotominor.yy21 = new SumAggrLit(yymsp[-3].minor.yy0.loc(), *yymsp[-1].minor.yy94, false); delete yymsp[-1].minor.yy94;   yy_destructor(yypParser,56,&yymsp[-2].minor);
  yy_destructor(yypParser,57,&yymsp[0].minor);
}
#line 2119 "parser_impl.c"
        break;
      case 103: /* aggr_ass ::= LSBRAC weightlist RSBRAC */
#line 331 "parser_impl.y"
{ yygotominor.yy21 = new SumAggrLit(yymsp[-2].minor.yy0.loc(), *yymsp[-1].minor.yy94, false); delete yymsp[-1].minor.yy94;   yy_destructor(yypParser,57,&yymsp[0].minor);
}
#line 2125 "parser_impl.c"
        break;
      case 104: /* aggr_num ::= AVG LSBRAC weightlist RSBRAC */
#line 333 "parser_impl.y"
{ yygotominor.yy21 = new AvgAggrLit(yymsp[-3].minor.yy0.loc(), *yymsp[-1].minor.yy94); delete yymsp[-1].minor.yy94;   yy_destructor(yypParser,56,&yymsp[-2].minor);
  yy_destructor(yypParser,57,&yymsp[0].minor);
}
#line 2132 "parser_impl.c"
        break;
      case 110: /* aggr_ass ::= COUNT LCBRAC condlist RCBRAC */
#line 342 "parser_impl.y"
{ yygotominor.yy21 = new SumAggrLit(yymsp[-3].minor.yy0.loc(), *yymsp[-1].minor.yy94, true); delete yymsp[-1].minor.yy94;   yy_destructor(yypParser,60,&yymsp[-2].minor);
  yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 2139 "parser_impl.c"
        break;
      case 111: /* aggr_ass ::= LCBRAC condlist RCBRAC */
#line 343 "parser_impl.y"
{ yygotominor.yy21 = new SumAggrLit(yymsp[-2].minor.yy0.loc(), *yymsp[-1].minor.yy94, true); delete yymsp[-1].minor.yy94;   yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 2145 "parser_impl.c"
        break;
      case 112: /* aggr ::= EVEN LCBRAC condlist RCBRAC */
#line 345 "parser_impl.y"
{ yygotominor.yy21 = new ParityAggrLit(yymsp[-3].minor.yy0.loc(), *yymsp[-1].minor.yy94, true, true); delete yymsp[-1].minor.yy94;   yy_destructor(yypParser,60,&yymsp[-2].minor);
  yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 2152 "parser_impl.c"
        break;
      case 113: /* aggr ::= ODD LCBRAC condlist RCBRAC */
#line 346 "parser_impl.y"
{ yygotominor.yy21 = new ParityAggrLit(yymsp[-3].minor.yy0.loc(), *yymsp[-1].minor.yy94, false, true); delete yymsp[-1].minor.yy94;   yy_destructor(yypParser,60,&yymsp[-2].minor);
  yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 2159 "parser_impl.c"
        break;
      case 114: /* aggr ::= EVEN LSBRAC weightlist RSBRAC */
#line 347 "parser_impl.y"
{ yygotominor.yy21 = new ParityAggrLit(yymsp[-3].minor.yy0.loc(), *yymsp[-1].minor.yy94, true, false); delete yymsp[-1].minor.yy94;   yy_destructor(yypParser,56,&yymsp[-2].minor);
  yy_destructor(yypParser,57,&yymsp[0].minor);
}
#line 2166 "parser_impl.c"
        break;
      case 115: /* aggr ::= ODD LSBRAC weightlist RSBRAC */
#line 348 "parser_impl.y"
{ yygotominor.yy21 = new ParityAggrLit(yymsp[-3].minor.yy0.loc(), *yymsp[-1].minor.yy94, false, false); delete yymsp[-1].minor.yy94;   yy_destructor(yypParser,56,&yymsp[-2].minor);
  yy_destructor(yypParser,57,&yymsp[0].minor);
}
#line 2173 "parser_impl.c"
        break;
      case 117: /* ccondlist ::= ccondlit */
      case 123: /* head_ccondlist ::= head_ccondlit_cond */ yytestcase(yyruleno==123);
#line 351 "parser_impl.y"
{ yygotominor.yy94 = new CondLitVec(); yygotominor.yy94->push_back(yymsp[0].minor.yy100); }
#line 2179 "parser_impl.c"
        break;
      case 118: /* conjunction ::= ccondlist */
      case 126: /* disjunction ::= head_ccondlist */ yytestcase(yyruleno==126);
#line 353 "parser_impl.y"
{ yygotominor.yy21 = new JunctionAggrLit(yymsp[0].minor.yy94->at(0).loc(), *yymsp[0].minor.yy94); delete yymsp[0].minor.yy94; }
#line 2185 "parser_impl.c"
        break;
      case 119: /* head_ccondlit_nocond ::= predicate */
#line 355 "parser_impl.y"
{ LitPtrVec cond; yygotominor.yy100 = new CondLit(yymsp[0].minor.yy63->loc(), yymsp[0].minor.yy63, ONE(yymsp[0].minor.yy63->loc()), cond); }
#line 2190 "parser_impl.c"
        break;
      case 120: /* head_ccondlit_cond ::= predicate nweightcond */
#line 356 "parser_impl.y"
{ yygotominor.yy100 = new CondLit(yymsp[-1].minor.yy63->loc(), yymsp[-1].minor.yy63, ONE(yymsp[-1].minor.yy63->loc()), *yymsp[0].minor.yy146); delete yymsp[0].minor.yy146; }
#line 2195 "parser_impl.c"
        break;
      case 121: /* head_ccondlit ::= head_ccondlit_nocond */
      case 122: /* head_ccondlit ::= head_ccondlit_cond */ yytestcase(yyruleno==122);
#line 357 "parser_impl.y"
{ yygotominor.yy100 = yymsp[0].minor.yy100; }
#line 2201 "parser_impl.c"
        break;
      case 124: /* head_ccondlist ::= head_ccondlit_nocond VBAR head_ccondlit */
#line 361 "parser_impl.y"
{ yygotominor.yy94 = new CondLitVec(); yygotominor.yy94->push_back(yymsp[-2].minor.yy100); yygotominor.yy94->push_back(yymsp[0].minor.yy100);   yy_destructor(yypParser,21,&yymsp[-1].minor);
}
#line 2207 "parser_impl.c"
        break;
      case 125: /* head_ccondlist ::= head_ccondlist VBAR head_ccondlit */
#line 362 "parser_impl.y"
{ yygotominor.yy94 = yymsp[-2].minor.yy94; yygotominor.yy94->push_back(yymsp[0].minor.yy100);   yy_destructor(yypParser,21,&yymsp[-1].minor);
}
#line 2213 "parser_impl.c"
        break;
      case 127: /* aggr_ass ::= MIN LSBRAC weightlist RSBRAC */
#line 366 "parser_impl.y"
{ yygotominor.yy21 = new MinMaxAggrLit(yymsp[-3].minor.yy0.loc(), *yymsp[-1].minor.yy94, false); delete yymsp[-1].minor.yy94;   yy_destructor(yypParser,56,&yymsp[-2].minor);
  yy_destructor(yypParser,57,&yymsp[0].minor);
}
#line 2220 "parser_impl.c"
        break;
      case 128: /* aggr_ass ::= MAX LSBRAC weightlist RSBRAC */
#line 367 "parser_impl.y"
{ yygotominor.yy21 = new MinMaxAggrLit(yymsp[-3].minor.yy0.loc(), *yymsp[-1].minor.yy94, true); delete yymsp[-1].minor.yy94;   yy_destructor(yypParser,56,&yymsp[-2].minor);
  yy_destructor(yypParser,57,&yymsp[0].minor);
}
#line 2227 "parser_impl.c"
        break;
      case 129: /* aggr_num ::= aggr_ass */
      case 130: /* aggr ::= aggr_num */ yytestcase(yyruleno==130);
      case 134: /* aggr_atom ::= aggr */ yytestcase(yyruleno==134);
#line 369 "parser_impl.y"
{ yygotominor.yy21 = yymsp[0].minor.yy21; }
#line 2234 "parser_impl.c"
        break;
      case 131: /* aggr_atom ::= term aggr_num term */
#line 372 "parser_impl.y"
{ yygotominor.yy21 = yymsp[-1].minor.yy21; yygotominor.yy21->lower(yymsp[-2].minor.yy27); yygotominor.yy21->upper(yymsp[0].minor.yy27); }
#line 2239 "parser_impl.c"
        break;
      case 132: /* aggr_atom ::= aggr_num term */
#line 373 "parser_impl.y"
{ yygotominor.yy21 = yymsp[-1].minor.yy21; yygotominor.yy21->upper(yymsp[0].minor.yy27); }
#line 2244 "parser_impl.c"
        break;
      case 133: /* aggr_atom ::= term aggr_num */
#line 374 "parser_impl.y"
{ yygotominor.yy21 = yymsp[0].minor.yy21; yygotominor.yy21->lower(yymsp[-1].minor.yy27); }
#line 2249 "parser_impl.c"
        break;
      case 135: /* predicate ::= MINUS IDENTIFIER LBRAC termlist RBRAC */
#line 377 "parser_impl.y"
{ yygotominor.yy63 = pParser->predLit(yymsp[-4].minor.yy0.loc(), yymsp[-3].minor.yy0.index, *yymsp[-1].minor.yy11, true); delete yymsp[-1].minor.yy11;   yy_destructor(yypParser,36,&yymsp[-2].minor);
  yy_destructor(yypParser,37,&yymsp[0].minor);
}
#line 2256 "parser_impl.c"
        break;
      case 136: /* predicate ::= IDENTIFIER LBRAC termlist RBRAC */
#line 378 "parser_impl.y"
{ yygotominor.yy63 = pParser->predLit(yymsp[-3].minor.yy0.loc(), yymsp[-3].minor.yy0.index, *yymsp[-1].minor.yy11, false); delete yymsp[-1].minor.yy11;   yy_destructor(yypParser,36,&yymsp[-2].minor);
  yy_destructor(yypParser,37,&yymsp[0].minor);
}
#line 2263 "parser_impl.c"
        break;
      case 137: /* predicate ::= MINUS IDENTIFIER */
#line 379 "parser_impl.y"
{ TermPtrVec terms; yygotominor.yy63 = pParser->predLit(yymsp[-1].minor.yy0.loc(), yymsp[0].minor.yy0.index, terms, true); }
#line 2268 "parser_impl.c"
        break;
      case 138: /* predicate ::= IDENTIFIER */
#line 380 "parser_impl.y"
{ TermPtrVec terms; yygotominor.yy63 = pParser->predLit(yymsp[0].minor.yy0.loc(), yymsp[0].minor.yy0.index, terms, false); }
#line 2273 "parser_impl.c"
        break;
      case 139: /* termlist ::= term */
#line 382 "parser_impl.y"
{ yygotominor.yy11 = vec1(yymsp[0].minor.yy27); }
#line 2278 "parser_impl.c"
        break;
      case 140: /* termlist ::= termlist COMMA term */
#line 383 "parser_impl.y"
{ yygotominor.yy11 = yymsp[-2].minor.yy11; yymsp[-2].minor.yy11->push_back(yymsp[0].minor.yy27);   yy_destructor(yypParser,20,&yymsp[-1].minor);
}
#line 2284 "parser_impl.c"
        break;
      case 141: /* termlist ::= termlist DSEM termlist */
#line 384 "parser_impl.y"
{ yygotominor.yy11 = yymsp[-2].minor.yy11; yymsp[-2].minor.yy11->push_back(new ArgTerm(yymsp[-1].minor.yy0.loc(), yygotominor.yy11->pop_back().release(), *yymsp[0].minor.yy11)); delete yymsp[0].minor.yy11; }
#line 2289 "parser_impl.c"
        break;
      case 142: /* optimize ::= soptimize LSBRAC prio_list RSBRAC */
#line 386 "parser_impl.y"
{ pParser->nextLevel();   yy_destructor(yypParser,56,&yymsp[-2].minor);
  yy_destructor(yypParser,57,&yymsp[0].minor);
}
#line 2296 "parser_impl.c"
        break;
      case 143: /* optimize ::= soptimize_set LCBRAC prio_set RCBRAC */
#line 387 "parser_impl.y"
{ pParser->nextLevel();   yy_destructor(yypParser,60,&yymsp[-2].minor);
  yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 2303 "parser_impl.c"
        break;
      case 144: /* soptimize ::= MINIMIZE */
#line 389 "parser_impl.y"
{ pParser->maximize(false); pParser->optimizeSet(false);   yy_destructor(yypParser,66,&yymsp[0].minor);
}
#line 2309 "parser_impl.c"
        break;
      case 145: /* soptimize ::= MAXIMIZE */
#line 390 "parser_impl.y"
{ pParser->maximize(true); pParser->optimizeSet(false);   yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 2315 "parser_impl.c"
        break;
      case 146: /* soptimize_set ::= MINIMIZE */
#line 391 "parser_impl.y"
{ pParser->maximize(false); pParser->optimizeSet(true);   yy_destructor(yypParser,66,&yymsp[0].minor);
}
#line 2321 "parser_impl.c"
        break;
      case 147: /* soptimize_set ::= MAXIMIZE */
#line 392 "parser_impl.y"
{ pParser->maximize(true); pParser->optimizeSet(true);   yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 2327 "parser_impl.c"
        break;
      case 150: /* nprio_list ::= weightedpriolit */
      case 154: /* nprio_set ::= priolit */ yytestcase(yyruleno==154);
#line 397 "parser_impl.y"
{ pParser->add(yymsp[0].minor.yy142); }
#line 2333 "parser_impl.c"
        break;
      case 151: /* nprio_list ::= weightedpriolit COMMA prio_list */
      case 155: /* nprio_set ::= priolit COMMA prio_set */ yytestcase(yyruleno==155);
#line 398 "parser_impl.y"
{ pParser->add(yymsp[-2].minor.yy142);   yy_destructor(yypParser,20,&yymsp[-1].minor);
}
#line 2340 "parser_impl.c"
        break;
      case 156: /* weightedpriolit ::= predlit ASSIGN term AT term priolit_cond */
#line 407 "parser_impl.y"
{ yygotominor.yy142 = new Optimize(yymsp[-5].minor.yy63->loc(), yymsp[-5].minor.yy63, yymsp[-3].minor.yy27, yymsp[-1].minor.yy27, *yymsp[0].minor.yy146, pParser->maximize()); pParser->setUniques(yygotominor.yy142); del(yymsp[0].minor.yy146);   yy_destructor(yypParser,30,&yymsp[-4].minor);
  yy_destructor(yypParser,53,&yymsp[-2].minor);
}
#line 2347 "parser_impl.c"
        break;
      case 157: /* weightedpriolit ::= predlit ASSIGN term priolit_cond */
#line 408 "parser_impl.y"
{ yygotominor.yy142 = new Optimize(yymsp[-3].minor.yy63->loc(), yymsp[-3].minor.yy63, yymsp[-1].minor.yy27, new ConstTerm(yymsp[-3].minor.yy63->loc(), Val::create(Val::NUM, pParser->level())), *yymsp[0].minor.yy146, pParser->maximize()); pParser->setUniques(yygotominor.yy142); del(yymsp[0].minor.yy146);   yy_destructor(yypParser,30,&yymsp[-2].minor);
}
#line 2353 "parser_impl.c"
        break;
      case 158: /* weightedpriolit ::= predlit npriolit_cond ASSIGN term AT term */
#line 409 "parser_impl.y"
{ yygotominor.yy142 = new Optimize(yymsp[-5].minor.yy63->loc(), yymsp[-5].minor.yy63, yymsp[-2].minor.yy27, yymsp[0].minor.yy27, *yymsp[-4].minor.yy146, pParser->maximize()); pParser->setUniques(yygotominor.yy142); del(yymsp[-4].minor.yy146);   yy_destructor(yypParser,30,&yymsp[-3].minor);
  yy_destructor(yypParser,53,&yymsp[-1].minor);
}
#line 2360 "parser_impl.c"
        break;
      case 159: /* weightedpriolit ::= predlit npriolit_cond ASSIGN term */
#line 410 "parser_impl.y"
{ yygotominor.yy142 = new Optimize(yymsp[-3].minor.yy63->loc(), yymsp[-3].minor.yy63, yymsp[0].minor.yy27, new ConstTerm(yymsp[-3].minor.yy63->loc(), Val::create(Val::NUM, pParser->level())), *yymsp[-2].minor.yy146, pParser->maximize()); pParser->setUniques(yygotominor.yy142); del(yymsp[-2].minor.yy146);   yy_destructor(yypParser,30,&yymsp[-1].minor);
}
#line 2366 "parser_impl.c"
        break;
      case 160: /* weightedpriolit ::= priolit */
#line 411 "parser_impl.y"
{ yygotominor.yy142 = yymsp[0].minor.yy142; }
#line 2371 "parser_impl.c"
        break;
      case 161: /* priolit ::= predlit AT term priolit_cond */
#line 413 "parser_impl.y"
{ yygotominor.yy142 = new Optimize(yymsp[-3].minor.yy63->loc(), yymsp[-3].minor.yy63, ONE(yymsp[-3].minor.yy63->loc()), yymsp[-1].minor.yy27, *yymsp[0].minor.yy146, pParser->maximize()); pParser->setUniques(yygotominor.yy142); del(yymsp[0].minor.yy146);   yy_destructor(yypParser,53,&yymsp[-2].minor);
}
#line 2377 "parser_impl.c"
        break;
      case 162: /* priolit ::= predlit npriolit_cond AT term */
#line 414 "parser_impl.y"
{ yygotominor.yy142 = new Optimize(yymsp[-3].minor.yy63->loc(), yymsp[-3].minor.yy63, ONE(yymsp[-3].minor.yy63->loc()), yymsp[0].minor.yy27, *yymsp[-2].minor.yy146, pParser->maximize()); pParser->setUniques(yygotominor.yy142); del(yymsp[-2].minor.yy146);   yy_destructor(yypParser,53,&yymsp[-1].minor);
}
#line 2383 "parser_impl.c"
        break;
      case 163: /* priolit ::= predlit priolit_cond */
#line 415 "parser_impl.y"
{ yygotominor.yy142 = new Optimize(yymsp[-1].minor.yy63->loc(), yymsp[-1].minor.yy63, ONE(yymsp[-1].minor.yy63->loc()), new ConstTerm(yymsp[-1].minor.yy63->loc(), Val::create(Val::NUM, pParser->level())), *yymsp[0].minor.yy146, pParser->maximize()); pParser->setUniques(yygotominor.yy142); del(yymsp[0].minor.yy146); }
#line 2388 "parser_impl.c"
        break;
      case 165: /* npriolit_cond ::= npriolit_cond COLON literal */
#line 418 "parser_impl.y"
{ yygotominor.yy146 = yymsp[-2].minor.yy146; yymsp[-2].minor.yy146->push_back(yymsp[0].minor.yy38);   yy_destructor(yypParser,38,&yymsp[-1].minor);
}
#line 2394 "parser_impl.c"
        break;
      case 168: /* compute ::= COMPUTE LCBRAC compute_list RCBRAC */
#line 423 "parser_impl.y"
{
  yy_destructor(yypParser,68,&yymsp[-3].minor);
  yy_destructor(yypParser,60,&yymsp[-2].minor);
  yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 2403 "parser_impl.c"
        break;
      case 169: /* compute ::= COMPUTE NUMBER LCBRAC compute_list RCBRAC */
#line 424 "parser_impl.y"
{
  yy_destructor(yypParser,68,&yymsp[-4].minor);
  yy_destructor(yypParser,27,&yymsp[-3].minor);
  yy_destructor(yypParser,60,&yymsp[-2].minor);
  yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 2413 "parser_impl.c"
        break;
      case 172: /* ncompute_list ::= computelit */
#line 429 "parser_impl.y"
{ pParser->add(yymsp[0].minor.yy190); }
#line 2418 "parser_impl.c"
        break;
      case 173: /* ncompute_list ::= computelit COMMA ncompute_list */
#line 430 "parser_impl.y"
{ pParser->add(yymsp[-2].minor.yy190);   yy_destructor(yypParser,20,&yymsp[-1].minor);
}
#line 2424 "parser_impl.c"
        break;
      case 174: /* computelit ::= predlit priolit_cond */
#line 432 "parser_impl.y"
{ yygotominor.yy190 = new Compute(yymsp[-1].minor.yy63->loc(), yymsp[-1].minor.yy63, *yymsp[0].minor.yy146); del(yymsp[0].minor.yy146); }
#line 2429 "parser_impl.c"
        break;
      default:
      /* (0) start ::= program */ yytestcase(yyruleno==0);
      /* (1) program ::= */ yytestcase(yyruleno==1);
      /* (17) line ::= optimize */ yytestcase(yyruleno==17);
      /* (18) line ::= compute */ yytestcase(yyruleno==18);
      /* (148) prio_list ::= */ yytestcase(yyruleno==148);
      /* (149) prio_list ::= nprio_list */ yytestcase(yyruleno==149);
      /* (152) prio_set ::= */ yytestcase(yyruleno==152);
      /* (153) prio_set ::= nprio_set */ yytestcase(yyruleno==153);
      /* (170) compute_list ::= */ yytestcase(yyruleno==170);
      /* (171) compute_list ::= ncompute_list */ yytestcase(yyruleno==171);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
#line 77 "parser_impl.y"
 pParser->parseError(); 
#line 2489 "parser_impl.c"
  parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  (void)yymajor;
  (void)yyminor;
  parserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 78 "parser_impl.y"
 pParser->syntaxError(); 
#line 2508 "parser_impl.c"
  parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  parserTOKENTYPE yyminor       /* The value for the token */
  parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
