/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  hamlib-widgets.c:  Container widgets for hamlib controls.

  PLEASE NOTE, THAT MOST OF THE CODE FROM THIS FILE HAS BEEN REPLACED
  BY gnome-hamlib-rig.c AND IS THEREFORE OBSOLETE!


  Copyright (C)  2001, 2002  Alexandru Csete.

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include <string.h>
#include <math.h>
#include "hamlib-widgets.h"
#include "defaults.h"

#ifdef HAVE_CONFIG_H
#  include "../config.h"
#endif

#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_RIG_H)
#  include <hamlib/rig.h>
#endif

#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_ROTATOR_H)
#  include <hamlib/rotator.h>
#endif

/* Do we need riglist.h at all? */
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_RIGLIST_H)
#  include <hamlib/riglist.h>
#endif

#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_ROTLIST_H)
#  include <hamlib/rotlist.h>
#endif


extern GtkWidget *app; /* main.c */

/* Private callback functions */
gint hamlib_riglist_widget_compare_func (GtkCList *, gconstpointer, gconstpointer);




GtkWidget *hamlib_riglist_widget_new (GSList *riglist)
{
	/* This function returns a Clist widget containing
	   a list of available RIGS. The widget can be
	   embedded into fx. a dialog box.
	*/
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_RIG_H)
	guint numrigs,i;
	gchar *buf,**text;
	GtkWidget *clist;
	gchar *titles[4] = {
		N_(" ID "),
		N_(" Brand "),
		N_(" Model "),
		N_(" Ver. ")
	};
	struct rig_caps *rcaps;


	if (!riglist)
		return NULL;

	clist = gtk_clist_new_with_titles (4, titles);
	numrigs = g_slist_length (riglist);
	for (i=0; i<numrigs; i++) {
		rcaps = (struct rig_caps *) g_slist_nth_data (riglist, i);
		buf = g_strdup_printf ("%d;%s;%s;%s", rcaps->rig_model,
				       rcaps->mfg_name, rcaps->model_name,
				       rcaps->version);
		text = g_strsplit (buf, ";", 4);
		gtk_clist_append (GTK_CLIST (clist), text);
		/* attach rig id to row */
		gtk_clist_set_row_data (GTK_CLIST (clist), i, GUINT_TO_POINTER (rcaps->rig_model));
		g_free (buf);
		g_strfreev (text);
	}

	/* sort rows according to hamlib rig id */
	gtk_clist_set_compare_func (GTK_CLIST (clist), hamlib_riglist_widget_compare_func );
        gtk_clist_set_sort_column (GTK_CLIST (clist), 0);
	gtk_clist_set_sort_type (GTK_CLIST (clist), GTK_SORT_ASCENDING);
	gtk_clist_sort (GTK_CLIST (clist));
	/* select Hamlib Dummy as default */
	gtk_clist_select_row (GTK_CLIST (clist), 0, 0);

	/* adjust column width and disable titles */
	for (i=0; i<4; i++) {
		gtk_clist_set_column_width (GTK_CLIST (clist), i,
					    gtk_clist_optimal_column_width (GTK_CLIST (clist), i));
		gtk_clist_column_title_passive (GTK_CLIST (clist), i);
	}

	return clist;
#endif
	return NULL;
}



GtkWidget *hamlib_rotlist_widget_new (GSList *rotlist)
{
	/* This function returns a Clist widget containing
	   a list of available rotators. The widget can be
	   embedded into fx. a dialog box.
	*/
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_ROTATOR_H)
	guint numrigs,i;
	gchar *buf,**text;
	GtkWidget *clist;
	gchar *titles[4] = {
		N_(" ID "),
		N_(" Brand "),
		N_(" Model "),
		N_(" Ver. ")
	};
	struct rot_caps *rcaps;


	if (!rotlist)
		return NULL;

	clist = gtk_clist_new_with_titles (4, titles);
	numrigs = g_slist_length (rotlist);
	for (i=0; i<numrigs; i++) {
		rcaps = (struct rot_caps *) g_slist_nth_data (rotlist, i);
		buf = g_strdup_printf ("%d;%s;%s;%s", rcaps->rot_model,
				       rcaps->mfg_name, rcaps->model_name,
				       rcaps->version);
		text = g_strsplit (buf, ";", 4);
		gtk_clist_append (GTK_CLIST (clist), text);
		/* attach rig id to row */
		gtk_clist_set_row_data (GTK_CLIST (clist), i, GUINT_TO_POINTER (rcaps->rot_model));
		g_free (buf);
		g_strfreev (text);
	}

	/* sort rows according to hamlib rig id */
	gtk_clist_set_compare_func (GTK_CLIST (clist), hamlib_riglist_widget_compare_func );
        gtk_clist_set_sort_column (GTK_CLIST (clist), 0);
	gtk_clist_set_sort_type (GTK_CLIST (clist), GTK_SORT_ASCENDING);
	gtk_clist_sort (GTK_CLIST (clist));
	/* select Hamlib Dummy as default */
	gtk_clist_select_row (GTK_CLIST (clist), 0, 0);

	/* adjust column width and disable titles */
	for (i=0; i<4; i++) {
		gtk_clist_set_column_width (GTK_CLIST (clist), i,
					    gtk_clist_optimal_column_width (GTK_CLIST (clist), i));
		gtk_clist_column_title_passive (GTK_CLIST (clist), i);
	}

	return clist;
#endif
	return NULL;
}



gint hamlib_riglist_widget_compare_func (GtkCList *clist, gconstpointer s1, gconstpointer s2)
{
	/* This function is used as sorting function for the
	   riglist widget.
	   s1 and s2 are pointers to GtkClistRow structures.
	*/
        GtkCListRow *row1 = (GtkCListRow *) s1;
        GtkCListRow *row2 = (GtkCListRow *) s2;
        gdouble d1,d2;

        d1 = g_strtod (GTK_CELL_TEXT (row1->cell[0])->text, NULL);
        d2 = g_strtod (GTK_CELL_TEXT (row2->cell[0])->text, NULL);

	return ( d1==d2 ) ? 0 : ( d1<d2 ? -1 : 1 );
}

