/*___INFO__MARK_BEGIN__*/
/*************************************************************************
 *
 *  The Contents of this file are made available subject to the terms of
 *  the Sun Industry Standards Source License Version 1.2
 *
 *  Sun Microsystems Inc., March, 2001
 *
 *
 *  Sun Industry Standards Source License Version 1.2
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.2 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://gridengine.sunsource.net/Gridengine_SISSL_license.html
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *   Copyright: 2001 by Sun Microsystems, Inc.
 *
 *   All Rights Reserved.
 *
 ************************************************************************/
/*___INFO__MARK_END__*/
/**
 *  Generated from javamodel_impl.jsp
 *  !!! DO NOT EDIT THIS FILE !!!
 */
<%
    final com.sun.grid.cull.CullDefinition cullDef = (com.sun.grid.cull.CullDefinition)params.get("cullDef");
    final com.sun.grid.cull.JavaHelper jh = (com.sun.grid.cull.JavaHelper)params.get("javaHelper");
    final com.sun.grid.cull.CullObject cullObj = (com.sun.grid.cull.CullObject)params.get("cullObj");
    com.sun.grid.cull.CullAttr   attr = null;
    final String interfaceName = jh.getClassName(cullObj);
    final String classname = interfaceName + "Impl";
%>
package <%=jh.getPackageName()%>;

import javax.management.*;
import com.sun.grid.jgdi.configuration.GEObject;
import java.util.List;
import java.util.LinkedList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.Iterator;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.logging.Level;

/**
 *  Java representation of the cull object <%=cullObj.getName()%>
 *  defined in <%=jh.getSource(cullObj).getName()%>
 *
 *  <p><strong>Warning:</strong>  The  <%=classname%> class will 
 *  not be compatible with future Sun&trade; Grid Engine releases.</p>
 */
public class <%=classname%> extends <%

  if(cullObj.getParentObject() != null) {
%>  <%=jh.getClassName(cullObj.getParentObject())%>Impl<%
  } else {
%>   GEObjectImpl<%
  }
%> implements <%=interfaceName%> {

<% // Default constructor ----------------------------------------- %>

   /**
    *  Create a new instance of <%=classname%>. The new instance
    *  will not be initialized with the default values.
    */
   public <%=classname%>() {
      this(false);
   }
   
   /**
    *   Create a new instanceof
    *   @param  initWithDefaultValues if <code>true</code> the new instance will
    *                                 be initialized with the default values as defined
    *                                 in the cull definition.
    */
   public <%=classname%>(boolean initWithDefaultValues) { 
<%
     if(cullObj.getParentObject() != null) {
%>
      super(initWithDefaultValues);
<%
     }
%>
      if (initWithDefaultValues) { <%
     for(int i = 0; i < cullObj.getAttrCount(); i++ ) {

       attr = cullObj.getAttr(i);
       
       if(attr.isHidden()) {
           continue;
       }
       
       if( attr.getDefault() != null ) {
          String defaultValue = null;
          String attrValue = attr.getDefault();
          String attrName = jh.getAttrName(attr);
          String attrType = jh.getFullClassName(attr.getType());

          if((attr instanceof com.sun.grid.cull.CullListAttr ||
              attr instanceof com.sun.grid.cull.CullMapListAttr ) && 
              attrName.endsWith("List")) {
              attrName = attrName.substring(0, attrName.length() - 4);
          }
          if( attr instanceof com.sun.grid.cull.CullMapAttr ) {
             
             com.sun.grid.cull.CullMapAttr mapAttr =(com.sun.grid.cull.CullMapAttr)attr;
             
             
             String gsname =  Character.toUpperCase( attrName.charAt(0) ) +
                             attrName.substring(1);
             
             com.sun.grid.cull.CullAttr valueAttr = mapAttr.getValueAttr();
             
             if (attrValue.equalsIgnoreCase("NONE")) {
                defaultValue = null;
             } else {
               defaultValue = jh.getInitializer(valueAttr, attrValue);
             }
             
             String defaultKey = ((com.sun.grid.cull.CullMapAttr )attr).getDefaultKey();
             if (defaultKey != null) {
              if (attr instanceof com.sun.grid.cull.CullMapListAttr) {
                if (gsname.equals("LoadThresholds") && attrValue.indexOf('=') > 0) {
                  String elems[] = attrValue.split("=");
                  String cls = jh.getInitializer(valueAttr, elems[0]);
%>
                     ComplexEntryImpl c = <%=cls%>;
                     c.setStringval("<%=elems[1]%>");
                     addDefault<%=gsname%>(c);
<%
                } else {
%>
                     addDefault<%=gsname%>(<%=defaultValue%>);
<%
               }
              } else {
%>
       put<%=gsname%>("<%=defaultKey%>", <%=defaultValue%>);
<%
              }              
             }
             
          } else {
       
//          if (attrValue.equalsIgnoreCase("NONE")) {
//             defaultValue = null;
//          } else {
             defaultValue = jh.getInitializer(attr, attrValue);
//          }
          
          String gsname =  Character.toUpperCase( attrName.charAt(0) ) +
                             attrName.substring(1);
      %>
       set<%=gsname%>(<%=defaultValue%>);<%    
       
          } // end of if
       }
    } // end of for %>
    
    }

  } // end of default constructor
  
  // --- newInstance method with primary key field
  
<%
   if(cullObj.getPrimaryKeyCount() > 0) {
%>
   /**
    *  Create a new instance of <%=classname%>
    */
   public <%=classname%>(<%      
     for(int i = 0; i < cullObj.getPrimaryKeyCount(); i++ ) {
        com.sun.grid.cull.CullAttr pkAttr = cullObj.getPrimaryKeyAttr(i);
        String pkAttrName = jh.getAttrName(pkAttr);
        if( i > 0 ) {
       %>, <%
        }
     %><%=jh.getFullClassName(pkAttr.getType())%> <%=pkAttrName%> <%
     }    
%>) {

<%
     for(int i = 0; i < cullObj.getPrimaryKeyCount(); i++ ) {
        com.sun.grid.cull.CullAttr pkAttr = cullObj.getPrimaryKeyAttr(i);
        String pkAttrName = jh.getAttrName(pkAttr);

        String pkGsname =  Character.toUpperCase( pkAttrName.charAt(0) ) +
                              pkAttrName.substring(1);   
%>   
         set<%=pkGsname%>(<%=pkAttrName%>);
<%
     } 
%>
    }
<%
  }
%>

<%
    // Iterate over all attributes and create member variable, 
    // getter and setter
    for (int i = 0; i < cullObj.getAttrCount(); i++) {
        attr = cullObj.getAttr(i);
        String attrType = jh.getFullClassName(attr.getType());
        String attrName = jh.getAttrName(attr);
        String gsname = Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
%>
    // Attribute <%=attrName%> ------------------------------------------------
<%
    if (attr instanceof com.sun.grid.cull.CullMapListAttr) {
    /* ------------------------------------------------------------------------
     * ---------------------- MapList Attribute -----------------------------------
     * ------------------------------------------------------------------------
     */ 
        if (attrName.endsWith("List")) {
            attrName = attrName.substring(0, attrName.length() - 4);
            gsname = Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
        }
        com.sun.grid.cull.CullMapAttr mapAttr = (com.sun.grid.cull.CullMapAttr)attr;
        com.sun.grid.cull.CullObject subobj = cullDef.getCullObject(mapAttr.getType());
        com.sun.grid.cull.CullAttr keyAttr = mapAttr.getKeyAttr();
        com.sun.grid.cull.CullAttr valueAttr = mapAttr.getValueAttr();
        String keyClassName = jh.getClassName(keyAttr.getType());
        String valueClassName = jh.getClassName(valueAttr.getType());
        String fullValueClassName = jh.getClassName(valueAttr.getType());
        String defaultKey = mapAttr.getDefaultKey();
        if (defaultKey == null) {
            defaultKey = "default";
        }
%>
    private Map m_<%=attrName%>;
    
    private void init<%=gsname%>() {
        if (m_<%=attrName%> == null) {
            m_<%=attrName%> = new HashMap();
        }
    }
   
    /**
     *  Get the value of a <%=mapAttr.getKeyName()%> at an index.
     *  @param <%=mapAttr.getKeyName()%> the <%=mapAttr.getKeyName()%>
     *  @param index the index
     */
    public <%=valueClassName%> get<%=gsname%>(<%=keyClassName%> <%=mapAttr.getKeyName()%>, int index) {
        init<%=gsname%>();
        List list = (List)m_<%=attrName%>.get(<%=mapAttr.getKeyName()%>);
        if (list == null || index < 0 || index >= list.size()) {
            throw new IllegalArgumentException("No <%=attrName%> for " + <%=mapAttr.getKeyName()%> + "[" + index + "] set");
        }
        <%=fullValueClassName%> ret = (<%=fullValueClassName%>)list.get(index);
<%
    if (jh.isPrimitiv(valueAttr)) {
%>
        return ret.<%=valueClassName%>Value();
<%
    } else {
%>
        return ret;
<%
    }
%>
    }
   
    /**
     *  Get the number of values for a <%=mapAttr.getKeyName()%>
     *  @param <%=mapAttr.getKeyName()%> the <%=mapAttr.getKeyName()%>
     */
    public int get<%=gsname%>Count(<%=keyClassName%> <%=mapAttr.getKeyName()%>) {
       if (m_<%=attrName%> != null) {
            List list = (List)m_<%=attrName%>.get(<%=mapAttr.getKeyName()%>);
            if (list != null) {
                return list.size();
            }
        }
        return 0;
    }
   
    /**
     *  Add a <%=mapAttr.getValueName()%> attribute to a <%=mapAttr.getKeyName()%>.
     *
     *  @param <%=mapAttr.getKeyName()%>  the <%=mapAttr.getKeyName()%>
     *  @param <%=mapAttr.getValueName()%> the <%=mapAttr.getValueName()%> attribute
     */
    public void add<%=gsname%>(<%=keyClassName%> <%=mapAttr.getKeyName()%>, <%=valueClassName%> <%=mapAttr.getValueName()%>) {
        init<%=gsname%>();
        List list = (List)m_<%=attrName%>.get(<%=mapAttr.getKeyName()%>);
        if (list == null) {
            list = new LinkedList();
            m_<%=attrName%>.put(<%=mapAttr.getKeyName()%>, list);
        }
<%
    if (jh.isPrimitiv(valueAttr)) {
%>
        list.add(new <%=fullValueClassName%>(<%=mapAttr.getValueName()%>));      
<%
    } else {
%>
        list.add(<%=mapAttr.getValueName()%>);      
<%
    }
%>   
    }

    /**
     *  Initialize <code><%=mapAttr.getValueName()%></code> attribute for a <code><%=mapAttr.getKeyName()%></code> 
     *  with an empty list.
     *
     *  @param <%=mapAttr.getKeyName()%>  the <%=mapAttr.getKeyName()%>
     */
    public void addEmpty<%=gsname%>(<%=keyClassName%> <%=mapAttr.getKeyName()%>) {
        init<%=gsname%>();
        List list = (List)m_<%=attrName%>.get(<%=mapAttr.getKeyName()%>);
        if (list == null) {
            list = new LinkedList();
            m_<%=attrName%>.put(<%=mapAttr.getKeyName()%>, list);
        }
    }
   
    /**
     *  Set a <%=mapAttr.getValueName()%> attribute for a <%=mapAttr.getKeyName()%>.
     *
     *  @param <%=mapAttr.getKeyName()%>  the <%=mapAttr.getKeyName()%>
     *  @param index  index of the <%=mapAttr.getValueName()%> attribute
     *  @param <%=mapAttr.getValueName()%>  the <%=mapAttr.getValueName()%> attribute
     */
    public void set<%=gsname%>(<%=keyClassName%> <%=mapAttr.getKeyName()%>, int index, <%=valueClassName%> <%=mapAttr.getValueName()%>) {
        init<%=gsname%>();
        List list = (List)m_<%=attrName%>.get(<%=mapAttr.getKeyName()%>);
        if (list == null) {
            list = new LinkedList();
            m_<%=attrName%>.put(<%=mapAttr.getKeyName()%>, list);
        }
<%
    if (jh.isPrimitiv(valueAttr)) {
%>
        list.set(index, new <%=fullValueClassName%>(<%=mapAttr.getValueName()%>));      
<%
    } else {
%>
        list.set(index, <%=mapAttr.getValueName()%>);      
<%
    }
%>   
    }
   
    /**
     *  Remove a <%=mapAttr.getValueName()%> attribute for a <%=mapAttr.getKeyName()%>.
     *
     *  @param <%=mapAttr.getKeyName()%>  the <%=mapAttr.getKeyName()%>
     *  @param index the index of the <%=mapAttr.getValueName()%> attribute
     *  @return the remove <%=mapAttr.getValueName()%> attribute of <code>null</code>
     *          if the attribute has not been found
     */
    public Object remove<%=gsname%>At(<%=keyClassName%> <%=mapAttr.getKeyName()%>, int index) {
        if (m_<%=attrName%> != null) {
            List list = (List)m_<%=attrName%>.get(<%=mapAttr.getKeyName()%>);
            if (list != null) {
                return list.remove(index);
            }
        }
        return null;
    }
   
    /**
     *  Remove a <%=mapAttr.getValueName()%> attribute for a <%=mapAttr.getKeyName()%>.
     *
     *  @param <%=mapAttr.getKeyName()%>  the <%=mapAttr.getKeyName()%>
     *  @param <%=mapAttr.getValueName()%> the <%=mapAttr.getValueName()%>) attribute
     *  @return <code>true</code> if the attribute has been removed
     */
    public boolean remove<%=gsname%>(<%=keyClassName%> <%=mapAttr.getKeyName()%>, <%=valueClassName%> <%=mapAttr.getValueName()%>) {
        if (m_<%=attrName%> != null) {
            List list = (List)m_<%=attrName%>.get(<%=mapAttr.getKeyName()%>);
            if (list != null) {
<%
    if (jh.isPrimitiv(valueAttr)) {
%>
                return list.remove(new <%=fullValueClassName%>(<%=mapAttr.getValueName()%>));              
<%
    } else {
%>
                return list.remove(<%=mapAttr.getValueName()%>);      
<%
    }
%>      
            }   
        }
        return false;
    }
   
    /**
     *  Remove all <%=mapAttr.getValueName()%>) attributes.
     */
    public void removeAll<%=gsname%>() {
        if (m_<%=attrName%> != null) {
            m_<%=attrName%>.clear();
        }
    }
   
    /**
     *  Remove all <%=mapAttr.getValueName()%>) attributes for a <%=mapAttr.getKeyName()%>.
     *
     *  @param <%=mapAttr.getKeyName()%> the <%=mapAttr.getKeyName()%>
     */   
    public void removeAll<%=gsname%>(<%=keyClassName%> <%=mapAttr.getKeyName()%>) {
        if (m_<%=attrName%> != null) {
            List list = (List)m_<%=attrName%>.get(<%=mapAttr.getKeyName()%>);
            if (list != null) {
                list.clear();
            }
        }
    }
   
    /**
     *   Get a unmodifiable set of stored <%=attrName%> attribute keys.
     *   @return unmodifiable set of stored <%=attrName%> attribute keys
     */
    public Set<String> get<%=gsname%>Keys() {
        if (m_<%=attrName%> != null) {
            return Collections.unmodifiableSet(m_<%=attrName%>.keySet());
        } else {
            return Collections.EMPTY_SET;
        }      
    }
   
    /**
     *  Determine if the <%=attrName%> is set
     */
    public boolean isSet<%=gsname%>() {
        return (m_<%=attrName%> != null) && (!m_<%=attrName%>.isEmpty());
    }
   
    /**
     *  Get a unmodifiable list of <%=attrName%> attributes
     *  @param hostname the key
     *  @return unmodifiable list of <%=attrName%> attributes
     */
    public List get<%=gsname%>List(<%=keyClassName%> <%=mapAttr.getKeyName()%>) {
        if (m_<%=attrName%> != null) {
            List list = (List)m_<%=attrName%>.get(<%=mapAttr.getKeyName()%>);
            if (list != null) {
                return Collections.unmodifiableList(list);
            }
        }
        return Collections.EMPTY_LIST;
    }
   
    // default methods
   
    /**
     *  <p>Get the default value of the attribute <%=attrName%>.
     *  (<%=mapAttr.getDefaultKey()%>)</p>
     *  @return the default value of the attribute <%=attrName%>
     *  @throws  java.lang.IllegalStateException if the default value is not set
     */
    public <%=valueClassName%> getDefault<%=gsname%>(int index) {
        return get<%=gsname%>("<%=mapAttr.getDefaultKey()%>", index);
    }
   
    /**
     *  Get the number of values for  the default <code><%=mapAttr.getKeyName()%></code>
     *  (<%=mapAttr.getDefaultKey()%>).
     */
    public int getDefault<%=gsname%>Count() {
        return get<%=gsname%>Count("<%=mapAttr.getDefaultKey()%>");
    }
   
    /**
     *  Add <code><%=mapAttr.getValueName()%></code> attribute to 
     *  the default <code><%=mapAttr.getKeyName()%></code>  (<%=mapAttr.getDefaultKey()%>).
     *
     *  @param <%=mapAttr.getValueName()%> the <%=mapAttr.getValueName()%> attribute
     */
    public void addDefault<%=gsname%>(<%=valueClassName%> <%=mapAttr.getValueName()%>) {
        add<%=gsname%>("<%=mapAttr.getDefaultKey()%>", <%=mapAttr.getValueName()%>);
    }
   
    /**
     *  Set <code><%=mapAttr.getValueName()%></code> attribute for the default
     *  <code><%=mapAttr.getKeyName()%></code> (<%=mapAttr.getDefaultKey()%>).
     *
     *  @param index  index of the <%=mapAttr.getValueName()%> attribute
     *  @param <%=mapAttr.getValueName()%>  the <%=mapAttr.getValueName()%> attribute
     */
    public void setDefault<%=gsname%>(int index, <%=valueClassName%> <%=mapAttr.getValueName()%>) {
        set<%=gsname%>("<%=mapAttr.getDefaultKey()%>", index, <%=mapAttr.getValueName()%>);
    }
   
    /**
     *  Remove <code><%=mapAttr.getValueName()%></code> attribute for the
     *  default <code><%=mapAttr.getKeyName()%></code> (<%=mapAttr.getDefaultKey()%>).
     *
     *  @param <%=mapAttr.getKeyName()%>  the <%=mapAttr.getKeyName()%>
     *  @param index the index of the <%=mapAttr.getValueName()%> attribute
     *  @return the remove <%=mapAttr.getValueName()%> attribute of <code>null</code>
     *          if the attribute has not been found
     */
    public Object removeDefault<%=gsname%>At(<%=keyClassName%> <%=mapAttr.getKeyName()%>, int index) {
        return remove<%=gsname%>At("<%=mapAttr.getDefaultKey()%>", index);
    }
   
    /**
     *  Remove <code><%=mapAttr.getValueName()%></code> attribute from the
     *  default <code><%=mapAttr.getKeyName()%></code> (<%=mapAttr.getDefaultKey()%>).
     *
     *  @param <%=mapAttr.getValueName()%> the <%=mapAttr.getValueName()%>) attribute
     *  @return <code>true</code> if the attribute has been removed
     */
    public boolean removeDefault<%=gsname%>(<%=keyClassName%> <%=mapAttr.getKeyName()%>, <%=valueClassName%> <%=mapAttr.getValueName()%>) {
        return remove<%=gsname%>("<%=mapAttr.getDefaultKey()%>", <%=mapAttr.getValueName()%>);
    }

    /**
     *  Remove all <%=mapAttr.getValueName()%>) attributes from 
     *  the default <code><%=mapAttr.getKeyName()%></code> (<%=mapAttr.getDefaultKey()%>).
     */
    public void removeAllDefault<%=gsname%>() {
        removeAll<%=gsname%>("<%=mapAttr.getDefaultKey()%>");
    }
   
    
<%
    } else if (attr instanceof com.sun.grid.cull.CullMapAttr) {
    /* ------------------------------------------------------------------------
     * ---------------------- Map Attribute -----------------------------------
     * ------------------------------------------------------------------------
     */ 
        if (attrName.endsWith("List")) {          
            attrName = attrName.substring(0, attrName.length() - 4);
            gsname = Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
        }
        com.sun.grid.cull.CullMapAttr mapAttr = (com.sun.grid.cull.CullMapAttr)attr;
        com.sun.grid.cull.CullObject subobj = cullDef.getCullObject(mapAttr.getType());
        com.sun.grid.cull.CullAttr keyAttr = mapAttr.getKeyAttr();
        com.sun.grid.cull.CullAttr valueAttr = mapAttr.getValueAttr();
        String keyClassName = jh.getClassName(keyAttr.getType());
%>
    // keyClassName for <%=keyAttr.getType()%> = <%=keyClassName%>
<%
        String valueClassName = jh.getClassName(valueAttr.getType());
        String fullValueClassName = jh.getFullClassNameOrWrapper(valueAttr.getType());
        String defaultKey = mapAttr.getDefaultKey();
        if (defaultKey == null) {
           defaultKey = "default";
        }
%>
   
    private Map m_<%=attrName%>;

    private void init<%=gsname%>() {
        if (m_<%=attrName%> == null) {
            m_<%=attrName%> = new HashMap();
        }
    }
   
    /**
     *  <p>Put the attribute <%=attrName%> for a <%=mapAttr.getKeyName()%>.</p>
     *
     *  @param <%=mapAttr.getKeyName()%>    the <%=mapAttr.getKeyName()%>
     *  @param <%=mapAttr.getValueName()%>  the <%=mapAttr.getValueName()%>
     */
    public void put<%=gsname%>(<%=keyClassName%> <%=mapAttr.getKeyName()%>, <%=valueClassName%> <%=mapAttr.getValueName()%>) {   
        init<%=gsname%>();
        m_<%=attrName%>.put(<%=mapAttr.getKeyName()%>,
<%
        if (jh.isPrimitiv(valueAttr)) {
%>
                            new <%=fullValueClassName%>(<%=mapAttr.getValueName()%>)
<%
    } else {
%>
                            <%=mapAttr.getValueName()%>
<%
    }
%>
                            );
    }

    /**
     *  <p>Get the default value of the attribute <%=attrName%>.</p>
     *  @return the default value of the attribute <%=attrName%>
     *  @throws  java.lang.IllegalStateException if the default value is not set
     */
    public <%=valueClassName%> getDefault<%=gsname%>() {
        if (m_<%=attrName%> == null) {
            throw new IllegalStateException("default value for attribute <%=attrName%> not found");
        }
        <%=fullValueClassName%> ret = (<%=fullValueClassName%>)m_<%=attrName%>.get("<%=defaultKey%>");
        if (ret == null) {
            throw new IllegalStateException("default value for attribute <%=attrName%> not found");
        }
<%
        if (jh.isPrimitiv(valueAttr)) {
%>
        return ret.<%=valueClassName%>Value();
<%
        } else {
%>
        return ret;
<%
        }
%>
    }
   
    /**
     *  <p>Get the <%=attrName%> attribute for a <%=mapAttr.getKeyName()%>.</p>
     *  @param   <%=mapAttr.getKeyName()%>   the <%=mapAttr.getKeyName()%>
     *  @return  the <%=attrName%> attribute for the host or the
     *           default value of  <%=attrName%>
     */
    public <%=valueClassName%> get<%=gsname%>(String <%=mapAttr.getKeyName()%>) {
        init<%=gsname%>();
        if (m_<%=attrName%>.containsKey(<%=mapAttr.getKeyName()%>)) {      
            <%=fullValueClassName%> ret = (<%=fullValueClassName%>)m_<%=attrName%>.get(<%=mapAttr.getKeyName()%>);
            if (ret != null) {
<%
        if (jh.isPrimitiv(valueAttr)) {
%>
                return ret.<%=valueClassName%>Value();
<%
        } else {
%>
                return ret;
<%
        }
%>
            } else {
                return <%=jh.getNullValue(valueAttr)%>;
            }
        } else {
            return getDefault<%=gsname%>();
        }
    }
<%   
   if (mapAttr.getDefaultKey() != null) {
%>
    /**
     *  Set <code><%=mapAttr.getValueName()%></code> attribute for the default
     *  <code><%=mapAttr.getKeyName()%></code> (<%=mapAttr.getDefaultKey()%>).
     *
     *  @param <%=mapAttr.getValueName()%>  the <%=mapAttr.getValueName()%> attribute
     */
    public void setDefault<%=gsname%>(<%=valueClassName%> <%=mapAttr.getValueName()%>) {
        put<%=gsname%>("<%=mapAttr.getDefaultKey()%>", <%=mapAttr.getValueName()%>);
    }
<%    
    }
%>

    /**
     *  <p>remove the attribute <%=attrName%> for a <%=mapAttr.getKeyName()%>.</p>
     *
     *  @param <%=mapAttr.getKeyName()%> tje <%=mapAttr.getKeyName()%>
     *  @return the <%=mapAttr.getValueName()%> for the <%=mapAttr.getKeyName()%> or <code>null</code>
     *          if the <%=mapAttr.getValueName()%> attribute was not defined for the <%=mapAttr.getKeyName()%>.
     */
    public <%=fullValueClassName%> remove<%=gsname%>(String <%=mapAttr.getKeyName()%>) {
        init<%=gsname%>();
        return (<%=fullValueClassName%>)m_<%=attrName%>.remove(<%=mapAttr.getKeyName()%>);
    }

    /**
     *  <p>Remove the attribute <%=attrName%> for all <%=mapAttr.getKeyName()%>s.</p>
     */
    public void removeAll<%=gsname%>() {
        if (m_<%=attrName%> != null) {
            m_<%=attrName%>.clear();
        }
    }
   
    /**
     *  Get the set of <%=mapAttr.getKeyName()%>s which have the attribute <%=attrName%> set.
     *  @return set of <%=mapAttr.getKeyName()%>s
     */
    public Set<String> get<%=gsname%>Keys() {
        if (m_<%=attrName%> == null) {
            return Collections.EMPTY_SET;
        } else {
            return Collections.unmodifiableSet(m_<%=attrName%>.keySet());
        }
    }
   
    /**
     *  Get the number of <%=mapAttr.getKeyName()%>s which have the attribute <%=attrName%> set.
     *  @return the number of <%=mapAttr.getKeyName()%>s which have the attribute <%=attrName%> set.
     */
    public int get<%=gsname%>Count() {
        if (m_<%=attrName%> == null) {
            return 0;
        } else {
            return m_<%=attrName%>.size();
        }
    }
   
    /**
     *  Determine if any <%=attrName%> attribute is set
     *  @return <code>true</code> if the <%=attrName%> attribute is set
     */
    public boolean isSet<%=gsname%> () {
        return (m_<%=attrName%> != null) && (!m_<%=attrName%>.isEmpty());
    }
   
    /**
     *  Determine if any <%=attrName%> attribute is for a <%=mapAttr.getKeyName()%> is set
     *  @param  <%=mapAttr.getKeyName()%> the <%=mapAttr.getKeyName()%>
     *  @return <code>true</code> if the <%=attrName%> attribute is set
     */
    public boolean isSet<%=gsname%>(String <%=mapAttr.getKeyName()%>) {
        return (m_<%=attrName%> != null) && (m_<%=attrName%>.get(<%=mapAttr.getKeyName()%>) != null);
    }
   

<%
    // end of Map Attribute  
    } else if (attr instanceof com.sun.grid.cull.CullListAttr) {
    /* ------------------------------------------------------------------------
     * ---------------------- List Attribute ----------------------------------
     * ------------------------------------------------------------------------
     */
        if (attrName.endsWith("List")) {
            attrName = attrName.substring(0, attrName.length() - 4);
            gsname =  Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
        }
%>
    private List< <%=attrType%> > m_<%=attrName%>List;
   
    private void init<%=gsname%>() {
        if (m_<%=attrName%>List == null) {
            m_<%=attrName%>List = new LinkedList< <%=attrType%> >();
        }
    }

    /**
     *   Add a <%=attrType%> attribute.
<% if (classname.equals("UserSetImpl") && gsname.equals("Entries") ) { %>
     *   If the value already exists in the list it is not added <% } %>
     *   @param a<%=attrName%>  the new <%=attrType%> attribute
     */
    public void add<%=gsname%>(<%=attrType%> a<%=attrName%>) {   
        init<%=gsname%>();
        <% if (classname.equals("UserSetImpl") && gsname.equals("Entries") ) { %>
        if (!m_<%=attrName%>List.contains(a<%=attrName%>)) {
            m_<%=attrName%>List.add(a<%=attrName%>);
        } <% } else { %>
        m_<%=attrName%>List.add(a<%=attrName%>);
        <% } %>
    }
   
   
    /**
     *   Set a <%=attrType%> attribute.
     *   @param index   index of the <%=attrType%> attribute
     *   @param a<%=attrName%>  the new <%=attrType%> attribute
     */
    public void set<%=gsname%>(int index, <%=attrType%> a<%=attrName%>) {
        init<%=gsname%>();
        m_<%=attrName%>List.set(index, a<%=attrName%>);
    }

    /**
     *  Remove all <%=attrType%> attributes.
     */
    public void removeAll<%=gsname%>() {
        if (m_<%=attrName%>List != null) {
            m_<%=attrName%>List.clear();
        }
    }

    /**
     *  Remote a <%=attrType%> attribute at an index.
     *  @param index  the index of the <%=attrType%> attribute which should be
     *                removed
     *  @return the removed <%=attrType%> attribute or <code>null</code> if
     *          no attribute at this index is stored
     */
    public <%=attrType%> remove<%=gsname%>(int index) {
        init<%=gsname%>();
        return (<%=attrType%>)m_<%=attrName%>List.remove(index);
    }

    /**
     *  Remote a specific <%=attrType%> attribute.
     *  @param a<%=attrName%>  the <%=attrType%> attribute which should be
     *                         removed
     *  @return <code>true</code> if the <%=attrType%> attribute has been removed
     */
    public boolean remove<%=gsname%>(<%=attrType%> a<%=attrName%>) {
        init<%=gsname%>();
        return m_<%=attrName%>List.remove(a<%=attrName%>);
    }
   
    /**
     *   Get a unmodifiable list of all <%=attrType%> attributes.
     *
     *   @return Unmodifiable list with all <%=attrType%> attributes
     */
    public List< <%=attrType%> > get<%=gsname%>List() {
        init<%=gsname%>();
        return Collections.unmodifiableList(m_<%=attrName%>List);
    }

    /**
     *  Get the number of <%=attrType%> attributes.
     *
     *  @return The number of <%=attrType%> attributes.
     */
    public int get<%=gsname%>Count() {
        if (m_<%=attrName%>List != null) {
            return m_<%=attrName%>List.size();
        } else {
            return 0;
        }
    }
 
    /**
     *  Get a <%=attrType%> attribute at an index.
     *  @param index  the index of the <%=attrType%> attribute which should be
     *                removed
     *  @return the <%=attrType%> attribute
     */
    public <%=attrType%> get<%=gsname%>(int index) {
        init<%=gsname%>();
        return (<%=attrType%>)m_<%=attrName%>List.get(index);
    }
   
    /**
     *  Determine if the <%=attrName%> attribute is set
     *  @return <code>true</code> if the <%=attrName%> attribute is set
     */
    public boolean isSet<%=gsname%> () {
        return (m_<%=attrName%>List != null) && (!m_<%=attrName%>List.isEmpty());
    }
   
<%
    // end of List Attribute
    } else {
    /* ------------------------------------------------------------------------
     * ---------------------- Simple Attribute ----------------------------------
     * ------------------------------------------------------------------------
     */
    if (jh.isPrimitiv(attr)) {
%>
    private boolean is<%=gsname%>Set;
<%
    }
%>   
    /**
     *  Determine if the <%=attrName%> attribute is set
     *  @return <code>true</code> if the <%=attrName%> attribute is set
     */
    public boolean isSet<%=gsname%>() {
<%
    if (jh.isPrimitiv(attr)) {
%>
        return is<%=gsname%>Set;
<%
    } else {
%>   
        return  (m_<%=attrName%> != null);
<%
    }
%>
    }
   
    private <%=attrType%> m_<%=attrName%>;

    /**
     *   Set the <%=attrName%> attribute.
     *
     *   @param a<%=gsname%>  the new value for the  <%=attrName%> attribute
     */
    public void set<%=gsname%>(<%=attrType%> a<%=gsname%>) {   
        m_<%=attrName%> = a<%=gsname%>;
<%
        if (jh.isPrimitiv(attr)) {
%>
        is<%=gsname%>Set = true;
<%
        }
%>
    }

    /**
     *  Get the value of the <%=attrName%> attribute.
     *  @return the value of the <%=attrName%> attribute
     */
    public <%=attrType%> <%=attrType.endsWith("oolean")?"is":"get"%><%=gsname%>() {
        return m_<%=attrName%>;
    }

<%
    } // end of else normal attributes
} // end of for of attribute
// equals method ----------------------------------------- 
%>


    /**
     *  Is the primary key information equal to the primary key information
     *  of <code>obj</code>.
     *
     *  @param obj   the compared object
     *  @return <code>true</code> if the primary key information is equal to the
     *          primary key informations of <code>obj</code>.
     */
    public boolean equals(Object obj) {
<%
    if (cullObj.getParentObject() != null) {
%>
        return obj instanceof <%=classname%> && super.equals(obj);
<%
    } else {
        for (int i = 0; i < cullObj.getPrimaryKeyCount(); i++) {
            attr = cullObj.getPrimaryKeyAttr(i);
            String attrName = jh.getAttrName(attr);
            String gsname = Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
            if (jh.isPrimitiv(attr)) {
%>
        return (obj instanceof <%=classname%> && get<%=gsname%>() == ((<%=jh.getFullClassName(cullObj)%>)obj).get<%=gsname%>());
<%
            } else {
%>
        return (obj instanceof <%=classname%> && get<%=gsname%>().equals(((<%=jh.getFullClassName(cullObj)%>)obj).get<%=gsname%>()));
<%
            } // end of isPrimitiv
        } // end of for
        // for loop has been skipped
        if (cullObj.getPrimaryKeyCount() == 0) {
%>            
            return obj instanceof <%=classname%>;
<%
        }
    } // end of if (cullObj.getParentObject() != null)
%>
    }

<%
    class EqualsCompletelyGenerator {
        public void gen(com.sun.grid.cull.CullAttr attr) {
            if (!attr.isReadOnly()) {
                if (attr instanceof com.sun.grid.cull.CullMapListAttr) {
                    genMapListAttr((com.sun.grid.cull.CullMapListAttr)attr);
                } else if (attr instanceof com.sun.grid.cull.CullMapAttr) {
                    genMapAttr((com.sun.grid.cull.CullMapAttr)attr);
                } else if (attr instanceof com.sun.grid.cull.CullListAttr) {
                    genListAttr((com.sun.grid.cull.CullListAttr)attr);
                } else {
                    genSimpleAttr(attr);
                }
            }
        } // end of gen
        public void genMapListAttr(com.sun.grid.cull.CullMapListAttr attr) {
            com.sun.grid.cull.CullAttr keyAttr = attr.getKeyAttr();
            com.sun.grid.cull.CullAttr valueAttr = attr.getValueAttr();
            String attrName = jh.getAttrName(attr);  
            if (attrName.endsWith("List")) {
                attrName = attrName.substring(0, attrName.length() - 4);
            }
            String gsname = Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
%>        
            {
                Set <%=attrName%>Set1 = get<%=gsname%>Keys();
                Set <%=attrName%>Set2 = obj1.get<%=gsname%>Keys();
          
                if (<%=attrName%>Set1.size() != <%=attrName%>Set2.size()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("map lists <%=attrName%> has different key sizes");
                    }
                    return false;
                }
                Iterator iter = get<%=gsname%>Keys().iterator();
                while (iter.hasNext()) {
                    <%=jh.getFullClassNameOrWrapper(keyAttr.getType())%> key = (<%=jh.getFullClassNameOrWrapper(keyAttr.getType())%>)iter.next();
                    int count = get<%=gsname%>Count(key);
                    if (count != obj1.get<%=gsname%>Count(key)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("map list <%=attrName%> is different list size for key " + key);
                    }
                    return false;
                }
                for (int i = 0; i < count; i++) {
                    <%=jh.getFullClassName(valueAttr.getType())%> value1 = get<%=gsname%>(key, i);
                    <%=jh.getFullClassName(valueAttr.getType())%> value2 = obj1.get<%=gsname%>(key, i);
<%
                    genValueCompare(valueAttr, "value1", "value2");
%>
                }
            }
        }
<%
        } // end of genMapListAttr
        public void genMapAttr(com.sun.grid.cull.CullMapAttr mapAttr) {
            com.sun.grid.cull.CullAttr keyAttr = mapAttr.getKeyAttr();
            com.sun.grid.cull.CullAttr valueAttr = mapAttr.getValueAttr();
            String attrName = jh.getAttrName(mapAttr);   
            if (attrName.endsWith("List")) {
                attrName  = attrName.substring(0, attrName.length() - 4 );
            }
            String gsname = Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
%>           
            {
                Set <%=attrName%>Set1 = get<%=gsname%>Keys();
                Set <%=attrName%>Set2 = obj1.get<%=gsname%>Keys();
                if (<%=attrName%>Set1.size() != <%=attrName%>Set2.size()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("maps <%=attrName%> has different key sizes");
                    }
                    return false;
                }
                Iterator iter = get<%=gsname%>Keys().iterator();
                while (iter.hasNext()) {
                    <%=jh.getFullClassNameOrWrapper(keyAttr.getType())%> key = (<%=jh.getFullClassNameOrWrapper(keyAttr.getType())%>)iter.next();
                    <%=jh.getFullClassName(valueAttr.getType())%> value1 = get<%=gsname%>(key);
                    <%=jh.getFullClassName(valueAttr.getType())%> value2 = obj1.get<%=gsname%>(key);             
<%
                    genValueCompare(valueAttr, "value1", "value2");
%>
                }
            }
<%
        } // end of genMapAttr
        public void genListAttr(com.sun.grid.cull.CullListAttr attr) {
            String attrName = jh.getAttrName(attr);
            if (attrName.endsWith("List")) {
                attrName = attrName.substring(0, attrName.length() - 4);
            }
            String gsname = Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
%>
            {
                int <%=attrName%>Count = get<%=gsname%>Count();
                if (<%=attrName%>Count != obj1.get<%=gsname%>Count()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("lists <%=attrName%> has different sizes");
                    }
                    return false;
                }
                for (int i = 0; i < <%=attrName%>Count; i++) {
                    <%=jh.getFullClassName(attr.getType())%> value1 = get<%=gsname%>(i);
                    <%=jh.getFullClassName(attr.getType())%> value2 = obj1.get<%=gsname%>(i);
<%
                    genValueCompare(attr, "value1", "value2");
%>
                } // end of for
            }
<%
        } // end of genListAttr
        public void genSimpleAttr(com.sun.grid.cull.CullAttr attr) {
            String attrName = jh.getAttrName(attr);
            String gsname = Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
            String getter = null;
            if (jh.getClassName(attr.getType()).endsWith("oolean")) {
                getter = "is" + gsname;
            } else {
                getter = "get" + gsname;
            }
%>
            {
                <%=jh.getFullClassName(attr.getType())%> value1 = <%=getter%>();
                <%=jh.getFullClassName(attr.getType())%> value2 = obj1.<%=getter%>();        
<%
                genValueCompare(attr, "value1", "value2");
%>
            }
<%
        } // end of genSimpleAttr
        public void genValueCompare(com.sun.grid.cull.CullAttr attr, String value1, String value2) {
            if (jh.isPrimitiv(attr)) { 
%>
            if (<%=value1%> != <%=value2%>) {
                if (logger.isLoggable(Level.FINE)) { 
                    logger.fine("primitive attributes <%=attr.getName()%> are not equal");
                }
                return false;
            }
<%
            } else {
%>
            if (<%=value1%> == null) {
                if (<%=value2%> != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("attribute <%=attr.getName()%> of obj1 " + <%=value2%> + " is not null as obj " + <%=value1%>);
                    }
                    return false;
                }
            } else {
<%
                if (jh.getClassName(attr.getType()).equals("String") || 
                    cullDef.getCullObject(attr.getType()).getType() == com.sun.grid.cull.CullObject.TYPE_MAPPED) {
%>
                if (!<%=value1%>.equals(<%=value2%>)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("attributes <%=attr.getName()%> are not equal: " + <%=value1%> + " != " + <%=value2%>);
                    }
                    return false;
                }
<%
                } else {
%>
                if (!<%=value1%>.equalsCompletely(<%=value2%>)) {
                    return false;
                }           
<%
                }
%>
            }
<%
            }
        } // end of genValueCompare
    } // end of EqualsCompletelyGenerator
%>    
    
    public boolean equalsCompletely(Object obj) {
        Logger logger = Logger.getLogger(getClass().getName());
        if (obj instanceof  <%=classname%>) {
            <%=jh.getFullClassName(cullObj)%> obj1 = (<%=jh.getFullClassName(cullObj)%>)obj;
<%
    EqualsCompletelyGenerator equalsCompletelyGenerator = new EqualsCompletelyGenerator();
    for (int i = 0; i < cullObj.getAttrCount(); i++ ) {
        attr = cullObj.getAttr(i);
        equalsCompletelyGenerator.gen(attr);
    }
%>
            return true;
        } else {
            return true;
        }
    }
  
    public java.lang.String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("<%=classname%>(");
<%
    {
        boolean first = true;
        com.sun.grid.cull.CullObject c = cullObj;
        if (cullObj.getParentObject() != null) {
            c = cullObj.getParentObject();
        }
        for (int i = 0; i < c.getAttrCount(); i++) {
            attr = c.getAttr(i);
            String attrName = jh.getAttrName(attr);
            String gsname = Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
            if (attr.isPrimaryKey()) {
                if (first) {
                    first = false;
                } else {
%>
        ret.append(", ");
<%
                }
%>
        ret.append(get<%=gsname%>());
<%
        }
    }
}
%>
        ret.append(")");
        return ret.toString();
    }

<%
    class DumpCompletelyGenerator {
        public void dump(com.sun.grid.cull.CullAttr attr) {
            if (!attr.isReadOnly()) {
                if (attr instanceof com.sun.grid.cull.CullMapListAttr) {
                    dumpMapListAttr((com.sun.grid.cull.CullMapListAttr)attr);
                } else if (attr instanceof com.sun.grid.cull.CullMapAttr) {
                    dumpMapAttr((com.sun.grid.cull.CullMapAttr)attr);
                } else if (attr instanceof com.sun.grid.cull.CullListAttr) {
                    dumpListAttr((com.sun.grid.cull.CullListAttr)attr);
                } else {
                    dumpSimpleAttr(attr);
                }
            }
        } // end of dump
        public void dumpMapListAttr(com.sun.grid.cull.CullMapListAttr attr) {
            com.sun.grid.cull.CullAttr keyAttr = attr.getKeyAttr();
            com.sun.grid.cull.CullAttr valueAttr = attr.getValueAttr();
            String attrName = jh.getAttrName(attr);
            if (attrName.endsWith("List")) {
                attrName = attrName.substring(0, attrName.length() - 4);
            }
            String gsname = Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
%>        
            for (<%=jh.getFullClassNameOrWrapper(keyAttr.getType())%> key : get<%=gsname%>Keys()) {
                int count = get<%=gsname%>Count(key);
                for (int i = 0; i < count; i++) {
                    <%=jh.getFullClassName(valueAttr.getType())%> value = get<%=gsname%>(key, i);
                    <%
                    if (jh.isPrimitiv(valueAttr) || jh.isString(valueAttr)) {
                    %>
                    sb.append("<%=gsname%>[" + key + "," + i + "] = " + value + "\n");
                    <%
                    } else {
                    %>
                    sb.append("<%=gsname%>[" + key + "," + i + "] = " + value.dump() + "\n");
                    <%
                    }
                    %>
                }
            }
<%
        } // end of dumpMapListAttr
        public void dumpMapAttr(com.sun.grid.cull.CullMapAttr mapAttr) {
            com.sun.grid.cull.CullAttr keyAttr = mapAttr.getKeyAttr();
            com.sun.grid.cull.CullAttr valueAttr = mapAttr.getValueAttr();
            String attrName = jh.getAttrName(mapAttr);   
            if (attrName.endsWith("List")) {
                attrName = attrName.substring(0, attrName.length() - 4);
            }
            String gsname =  Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
%>
            for (<%=jh.getFullClassNameOrWrapper(keyAttr.getType())%> key : get<%=gsname%>Keys()) {
                <%=jh.getFullClassName(valueAttr.getType())%> value = get<%=gsname%>(key);
                <%
                if (jh.isPrimitiv(valueAttr) || jh.isString(valueAttr)) {
                %>
                sb.append("<%=gsname%>[" + key + "] = " + value + "\n");
                <%
                } else {
                %>
                sb.append("<%=gsname%>[" + key + "] = " + value.dump() + "\n");
                <%
                }
                %>
            }
<%
        } // end of dumpMapAttr
        public void dumpListAttr(com.sun.grid.cull.CullListAttr attr) {
            String attrName = jh.getAttrName(attr);
            if (attrName.endsWith("List")) {
                attrName  = attrName.substring(0, attrName.length() - 4);
            }
            String gsname = Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
%>
            int <%=attrName%>Count = get<%=gsname%>Count();
            for (int i = 0; i < <%=attrName%>Count; i++) {
                <%=jh.getFullClassName(attr.getType())%> value = get<%=gsname%>(i);
                <%
                if (jh.isPrimitiv(attr) || jh.isString(attr)) {
                %>
                sb.append("<%=gsname%>[" + i + "] = " + value + "\n");
                <%
                } else {
                %>
                sb.append("<%=gsname%>[" + i + "] = " + value.dump() + "\n");
                <%
                }
                %>
            } // end of for
<%
        } // end of dumpListAttr
        public void dumpSimpleAttr(com.sun.grid.cull.CullAttr attr) {
            String attrName = jh.getAttrName(attr);
            String gsname = Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
            String getter = null;
            if (jh.getClassName(attr.getType()).endsWith("oolean")) {
                getter = "is" + gsname;
            } else {
                getter = "get" + gsname;
            }
%>
            {
                <%=jh.getFullClassName(attr.getType())%> value = <%=getter%>();
                sb.append("<%=gsname%> = " + value + "\n");
            }
<%
        } // end of dumpSimpleAttr
    } // end of DumpCompletelyGenerator
%>

    public java.lang.String dump() {
        StringBuilder sb = new StringBuilder();
<%
        DumpCompletelyGenerator dumpCompletelyGenerator = new DumpCompletelyGenerator();
        for (int i = 0; i < cullObj.getAttrCount(); i++) {
            attr = cullObj.getAttr(i);
            dumpCompletelyGenerator.dump(attr);
        }
%>
        return sb.toString();
    }    
<%
    if (classname.equals("ComplexEntryImpl")) {
%>
        <%@include file="javamodel_impl_CE.static"%>
<%
    } else if (classname.equals("AdvanceReservationImpl")) {
%>
        <%@include file="javamodel_impl_AR.static"%>
<%
    }
%>
 
}
