C Copyright 2005-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C
C
C  Fortran 77 Implementation: set_missing_fortran
C
C  Description: how to set a key as missing.
C
C
C  Author: Enrico Fucile <enrico.fucile@ecmwf.int>
C
C
C
      program set
      implicit none
      include 'grib_api_f77.h'
      integer err
      character*6 string_value
      integer infile,outfile
      integer igrib,iret
      character*256 error
      integer len

      infile=5
      outfile=6
      string_value='sfc'
      len=3

      call grib_check(grib_open_file(infile
     X,'../../data/reduced_gaussian_pressure_level.grib2','r'))

      call grib_check(grib_open_file(outfile
     X,'out_surface_level.grib2','w'))

C     a new grib message is loaded from file
C     igrib is the grib id to be used in subsequent calls
      call grib_check(grib_new_from_file(infile,igrib))

      call grib_check(grib_set_string(igrib,
     X'typeOfFirstFixedSurface', string_value))

      call grib_check(grib_set_missing(igrib,
     X'scaleFactorOfFirstFixedSurface'))

      call grib_check(grib_set_missing(igrib,
     X'scaledValueOfFirstFixedSurface'))

C     write modified message to a file
      call grib_check(grib_write(igrib,outfile))

      call grib_check(grib_release(igrib))

      call grib_check(grib_close_file(infile))

      call grib_check(grib_close_file(outfile))

      end
