/* 
 *  gretl -- Gnu Regression, Econometrics and Time-series Library
 *  Copyright (C) 2001 Allin Cottrell and Riccardo "Jack" Lucchetti
 * 
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GRETL_PRN_H
#define GRETL_PRN_H

typedef enum {
    GRETL_PRINT_STDOUT,
    GRETL_PRINT_STDERR,
    GRETL_PRINT_FILE,
    GRETL_PRINT_BUFFER,
    GRETL_PRINT_TEMPFILE,
    GRETL_PRINT_STREAM
} PrnType;

typedef enum {
    GRETL_FORMAT_TXT       = 1 << 0,
    GRETL_FORMAT_TEX       = 1 << 1,
    GRETL_FORMAT_DOC       = 1 << 2,
    GRETL_FORMAT_RTF       = 1 << 3,
    GRETL_FORMAT_RTF_TXT   = 1 << 4,
    GRETL_FORMAT_EQN       = 1 << 5,
    GRETL_FORMAT_SELECTION = 1 << 6,
    GRETL_FORMAT_CSV       = 1 << 7,
    GRETL_FORMAT_TAB       = 1 << 8,
    GRETL_FORMAT_MODELTAB  = 1 << 9,
    GRETL_FORMAT_LANDSCAPE = 1 << 10,
    GRETL_FORMAT_UTF       = 1 << 11
} PrnFormat;

/* functions follow */

void gretl_print_destroy (PRN *prn);

PRN *gretl_print_new (PrnType ptype, int *err);

PRN *gretl_print_new_with_filename (const char *fname, int *err);

PRN *gretl_print_new_with_tempfile (int *err);

int gretl_print_has_tempfile (PRN *prn);

const char *gretl_print_get_tempfile_name (PRN *prn);

PRN *gretl_print_new_with_buffer (char *buf);

PRN *gretl_print_new_with_stream (FILE *fp);

void gretl_print_detach_stream (PRN *prn);

int gretl_print_reset_buffer (PRN *prn);

int gretl_print_rename_file (PRN *prn, const char *oldpath, 
			     const char *newpath);

const char *gretl_print_get_buffer (PRN *prn);

const char *gretl_print_get_trimmed_buffer (PRN *prn);

char *gretl_print_steal_buffer (PRN *prn);

void gretl_print_get_size (PRN *prn, int *width, int *height);

FILE *gretl_print_read_tempfile (PRN *prn);

int gretl_print_stop_tempfile_read (PRN *prn, FILE *fp);

int gretl_print_set_save_position (PRN *prn);

void gretl_print_unset_save_position (PRN *prn);

char *gretl_print_get_chunk (PRN *prn);

void gretl_print_set_format (PRN *prn, PrnFormat format);

void gretl_print_toggle_doc_flag (PRN *prn);

void gretl_print_set_utf_flag (PRN *prn);

int gretl_print_supports_utf (PRN *prn);

void gretl_print_set_delim (PRN *prn, char delim);

int pprintf (PRN *prn, const char *format, ...);

int pputs (PRN *prn, const char *s);

int pputc (PRN *prn, int c);

void gretl_prn_newline (PRN *prn);

void gretl_print_flush_stream (PRN *prn);

int printing_to_standard_stream (PRN *prn);

int printing_is_redirected (PRN *prn);

int print_start_redirection (PRN *prn, FILE *fp);

int print_end_redirection (PRN *prn);

int plain_format (PRN *prn);

int rtf_format (PRN *prn);

int rtf_doc_format (PRN *prn);

int tex_format (PRN *prn);

int tex_doc_format (PRN *prn);

int tex_eqn_format (PRN *prn);

int csv_format (PRN *prn);

int prn_format (PRN *prn);

char prn_delim (PRN *prn);

int gretl_print_has_buffer (PRN *prn);

int gretl_print_alloc (PRN *prn, size_t s);

PRN *set_up_verbose_printer (gretlopt opt, PRN *prn);

void close_down_verbose_printer (PRN *vprn);

#endif /* GRETL_PRN_H */
