headings 10
Tests 21
add
addto
adf
arch
chow
coeffsum
coint
coint2
cusum
hausman
leverage
lmtest
meantest
omit
omitfrom
reset
restrict
runs
testuhat
vartest
vif
Estimation 21
ar
arima
corc
equation
garch
hccm
hilu
hsk
lad
logistic
logit
mpols
nls
ols
probit
pwe
system
tobit
tsls
var
wls
Graphs 6
boxplot
gnuplot
graph
plot
rmplot
scatters
Dataset 16
data
delete
genr
import
info
setinfo
labels
nulldata
open
panel
rename
setobs
setmiss
smpl
store
varlist
Statistics 7
corr
corrgm
freq
pca
pergm
spearman
summary
Utilities 7
criteria
critical
help
modeltab
pvalue
quit
shell
Transformations 7
diff
lags
ldiff
logs
multiply
rhodiff
square
Programming 9
else
end
endif
endloop
function
if
loop
run
set
Printing 5
eqnprint
outfile
print
printf
tabprint
Prediction 3
fcast
fcasterr
fit

# add Tests

Argumento:  listavar 
Opciones:   --vcv (mostrar matriz de covarianzas)
            --quiet (no muetra las estimaciones del modelo aumentado)
Ejemplos:   add 5 7 9
            add xx yy zz

Debe utilizarse despus de una instruccin de estimacin. Las variables de
listavar se aaden al modelo anterior y se estima el nuevo modelo. Si se
aade ms de una variable, se presenta el estadstico F para las variables
aadidas (slo para el mtodo MCO) junto con su valor-p. Un valor-p inferior
a 0.05 indica que los coeficientes son conjuntamente significativos al nivel
del 5 por ciento.

Si se usa la opcin --quiet el resultado que se muestra es slo el
estadstico para el contraste de significacin conjunta de las variables
aadidas, en los dems casos se presentan tambin las estimaciones del
modelo aumentado. En este ltimo caso, la opcin --vcv hace que tambin se
presente la matriz de covarianzas de los coeficientes.

Men grfico: Ventana de Modelo, /Contrastes/Aadir variables

# addto Tests

Argumentos: ID_modelo listavar 
Opcin:     --quiet (no mostrar las estimaciones del modelo aumentado)
Ejemplo:    addto 2 5 7 9

Funciona como la instruccin "add", salvo que Vd. especifica un modelo
previo (usando su identificador --ID-- de modelo, que se presenta al
principio de los resultados del modelo) que se toma como base para aadir
las variables. En el ejemplo de arriba se aaden las variables nmeros 5, 7
y 9 al Modelo 2.

Men grfico: Ventana de Modelo, /Contrastes/aadir variables

# adf Tests

Argumentos: orden nombre_var 
Ejemplo:    adf 2 x1

Calcula los estadsticos para dos contrastes de Dickey-Fuller. En cada caso
la hiptesis nula es que la variable seleccionada presenta una raz
unitaria. El primero es un estadstico t basado en el modelo

  (1 - L)x(t) = m + gx(t-1) + e(t)

La hiptesis nula es que g = 0. En el segundo contraste (aumentado) se
realiza la estimacin de una regresin no retringida (cuyos regresores son
una constante, una tendencia temporal, el primer retardo de la variable y
"orden" retardos de la primera diferencia) y una versin restringida
(quitando la tendencia temporal y el primer retardo). El estadstico de
contraste es

  F(2, T-k) = [(ESSr - ESSu)/2] / [ESSu/(T - k)]

donde T es el tamao de la muestra, k el nmero de parmetros del modelo no
restringido, y los subndices u y r denotan el modelo no restringido y el
restringido respectivamente. Hay que sealar que los valores crticos para
estos estadsticos no son los habituales; se muestra el valor p cuando es
posible determinarlo.

Men grfico: /Variable/Contraste aumentado de Dickey-Fuller

# ar Estimation

Argumentos: retardos ; vardep varindeps 
Opcin:     --vcv (mostrar la matriz de covarianzas)
Ejemplo:    ar 1 3 4 ; y 0 x1 x2 x3

Computa las estimaciones de los parmetros usando el procedimiento iterativo
generalizado de Cochrane-Orcutt (ver Seccin 9.5 del libro de Ramanathan).
Las iteraciones terminan cuando dos sumas de cuadrados residuales sucesivas
no difieren en ms del 0.005 por ciento o despus de 20 iteraciones.

"retardos" es una lista de retardos de los residuos, que termina con un
punto y coma. En el ejemplo anterior el trmino de error se especifica como

  u(t) = rho(1)*u(t-1) + rho(3)*u(t-3) + rho(4)*u(t-4)

Men grfico: /Modelo/Serie temporal/Estimacin autorregresiva

# arch Tests

Argumentos: orden vardep varindeps 
Ejemplo:    arch 4 y 0 x1 x2 x3

Contrasta la existencia de ARCH (Autoregressive Conditional
Heteroskedasticity -- Heterocedasticidad condicional autorregresiva) del
orden especificado, en el modelo. Si el estadstico de contraste LM tiene un
valor p inferior a 0.10, entonces tambin se realiza la estimacin del
modelo ARCH. Si la prediccin de la varianza de cualquier observacin, en la
regresin auxiliar, no es positiva entonces se usa en su lugar el
correspondiente residuo al cuadrado. Despus se realiza una estimacin por
mnimos cuadrados ponderados sobre el modelo original.

Ver tambin "garch".

Men grfico: Ventana de Modelo, /Contrastes/ARCH

# arima Estimation

Argumentos: p q ; vardep [ varindeps ] 
Opciones:   --native (Usar rutina nativa plugin (por defecto))
            --x-12-arima (usar el programa X-12-ARIMA para realizar la estimacin)
            --verbose (mostrar detalles de las iteraciones)
            --vcv (mostrar la matriz de covarianzas)
Ejemplos:   arma 1 2 ; y
            arma 2 2 ; y 0 x1 x2 --verbose

Si no se da una lista varindeps, estima un modelo ARMA (Autoregressive,
Moving Average) univariante. Los valores enteros p y q representan los
rdenes AR y MA respectivamente. Si se aade una lista varindeps, el modelo
pasa a ser un ARMAX.

Por defecto se usa la funcin "nativa" ARMA de gretl; en el caso de un
modelo ARMA univariante se puede usar X-12-ARIMA en su lugar (si est
instalado el paquete X-12-ARIMA para gretl).

La sopciones dadas arriba pueden combinarse, pero la matriz de covarianzas
no est disponible cuando se realiza la estimacin mediante X-12-ARIMA.

El algoritmo ARMA nativo de gretl ha sido, en su mayor parte, creado por
Riccardo "Jack" Lucchetti. Utiliza un procedimiento de mxima verosimilitud
condicional, implementado por medio de la estimacin por mnimos cuadrados
iterativos de la regresin del producto externo del gradiente (OPG, outer
product of the gradient regression). Ver el manual de gretl para entender la
lgica de este procedimiento. Los coeficientes AR (y los de cualquier
regresor adicional) se inicializan por medio de la estimacin por MCO de un
AR, y los coeficientes MA se inicializan asignndoles valor cero.

El valor del coeficiente AIC para los modelos ARMA se calcula de acuerdo con
la definicin usada en el programa X-12-ARIMA, es decir

  AIC = -2L + 2k

donde L es la log-verosimilitud y k es el nmero total de parmetros
estimados. La "frecuencia" que se presenta asociada a las races AR y MA es
el valor lambda que soluciona

  z = r * exp(i*2*pi*lambda)

donde z es la raz en cuestin y r es su mdulo.

Men grfico: /Variable/Modelo ARMA, /Modelo/Serie temporal/ARMAX
Otro acceso:  Men emergente de la ventana principal (seleccin simple)

# boxplot Graphs

Argumento:  listavar 
Opcin:     --notches (presenta el intervalo de confianza 90 por ciento para la mediana)

Estos grficos (debidos a Tukey y Chambers) muestran la distribucin de una
variable. La caja central recoge el 50 por ciento intermedio de los datos,
es decir, est acotada por el primero y tercer cuartiles. Las "patillas" se
extienden hasta los valores mnimo y mximo. Se dibuja una lnea a lo largo
de la caja en el lugar de la mediana.

En el caso de grficos de caja recortados, el recorte muestra los lmites de
un intervalo de aproximadamente el 90 por ciento de confianza para la
mediana. Este intervalo se obtienen por el mtodo bootstrap.

Despus de cada variable especificada en la instruccin boxplot, se puede
aadir una expresin booleana entre parntesis para limitar la muestra para
la variable en cuestin. Debe de insertarse un espacio entre el nombre o
nmero de la variable y la expresin. Supongamos que usted tiene valores de
los salarios de hombres y mujeres, y tiene una variable ficticia SEXO con
valor 1 para los hombres y 0 para las mujeres. En este caso usted puede
dibujar grficos de caja comparativos usando la siguiente "listavar":

	salary (GENDER=1) salary (GENDER=0)

Algunos detalles de los grficos de caja de gretl pueden controlarse por
medio de un fichero (de texto plano) llamado .boxplotrc. Para ms detalles
sobre esto ver el manual de gretl.

Men grfico: /Datos/Grficos/Grficos de caja

# chow Tests

Argumento:  obs 
Ejemplos:   chow 25
            chow 1988:1

Primero debe ejecutarse una regresin por MCO. Crea una variable ficticia
que es igual a 1 desde el punto de corte especificado en obs hasta el final
de la muestra y 0 en el resto. Tambin crea los trminos de interaccin
entre esta variable ficticia y las variables independientes originales. Se
ejecuta una regresin aumentada incluyendo estos trminos y se calcula un
estadstico F, tomando la regresin aumentada como 'no restringida' y la
original como 'restringida'. Este estadstico es adecuado para contrastar la
hiptesis nula de que no hay cambio estructural en el punto de ruptura
indicado.

Men grfico: Ventana de Modelo, /Contrastes/Contraste de Chow

# coeffsum Tests

Argumento:  listavar 
Ejemplo:    coeffsum xt xt_1 xr_2

Debe ejecutarse despus de una regresin. Calcula la suma de los
coeficientes de las variables de la lista listavar. Presenta la suma junto
con su desviacin tpica y el valor p para la hiptesis nula de que la suma
es cero.

Hay que sealar la diferencia entre esta instruccin y "omit", que contrasta
la hiptesis nula de que los coeficientes de un subconjunto de variables
independientes son todos iguales a cero zero.

Men grfico: Ventana de Modelo, /Contrastes/Suma de coeficientes

# coint Tests

Argumentos: orden vardep varindeps 
Ejemplo:    coint 4 y x1 x2

Contraste de cointegracin de Engle-Granger. Esta instruccin realiza los
contrastes de Dickey-Fuller aumentados de la hiptesis nula de que cada una
de las variables de la lista tiene una raz unitaria, usando el orden de
retardos dado. Se estima la ecuacin cointegrante y se realiza un contraste
ADF sobre los residuos de esta regresin. Tambin se presenta el estadstico
de Durbin-Watson para la regresin cointegrante. Hay que sealar que ninguno
de estos estadsticos de contraste puede compararse con las tablas
estadsticas usuales.

Men grfico: /Modelo/Serie temporal/Contrates de cointegracin/Engle-Granger

# coint2 Tests

Argumentos: orden vardep varindeps 
Opcin:     --verbose (mostrar los detalles de las regresiones auxiliares)
Ejemplos:   coint2 2 y x
            coint2 4 y x1 x2 --verbose

Realiza el contraste de la traza de Johansen para contrastar cointegracin
entre las variables de la lista para el orden dado. Los valores crticos se
computan por medio de la aproximacin gamma de J. Doornik (Doornik, 1998).
Para detalles sobre este contraste ver el libro de Hamilton, Time Series
Analysis (1994), Captulo 20.

Se presenta aqu la siguiente tabla como gua para la interpretacin de los
resultados ofrecidos por el contraste, para el caso de 3 variables. H0
denota la hiptesis nula, H1 la hiptesis alternativa y c el nmero de
relaciones cointegrantes.

            Rango   Contraste de la traza     Contraste Lmax 
                          H0     H1              H0     H1
             ---------------------------------------------------
              0          c = 0  c = 3          c = 0  c = 1
              1          c = 1  c = 3          c = 1  c = 2
              2          c = 2  c = 3          c = 2  c = 3
             ---------------------------------------------------

Men grfico: /Modelo/Serie temporal/Contraste de cointegracin/Johansen

# corc Estimation

Argumentos: vardep varindeps 
Opcin:     --vcv (mostrar la matriz de covarianzas)
Ejemplo:    corc 1 0 2 4 6 7

Computa estimaciones de los parmetros usando el procedimiento iterativo de
Cochrane-Orcutt (ver Seccin 9.4 del libro de Ramanathan). Las iteraciones
finalizan cuando dos estimaciones sucesivas del coeficiente de
autocorrelacin no difieren en ms de 0,001 o despus de 20 iteraciones.

Men grfico: /Modelo/Serie temporal/Cochrane-Orcutt

# corr Statistics

Argumento:  [ listavar ] 
Ejemplo:    corr y x1 x2 x3

Presenta los coeficientes de correlacin por pares para las variables de
listavar, o para todas las variables del conjunto de datos, si no se
proporciona listavar.

Men grfico: /Datos/Matriz de correlacin
Otro acceso:  Men emergente de la ventana principal (cuando se hace 
      seleccin mltiple)

# corrgm Statistics

Argumentos: variable [ retardo_max ] 
Ejemplo:    corrgm x 12

Presenta los valores de la funcin de autocorrelacin para la variable
especificada (por nombre o por nmero). Ver Ramanathan, Seccin 11.7. Es por
tanto rho(u(t), u(t-s)) donde ut es la t-sima observacin de la variable u
y s es el nmero de retardos.

Tambin se presentan las autocorrelaciones parciales, siendo stas los
coeficientes una vez descontado el efecto de los dems retardos
intervinientes. Esta instruccin tambin representa el correlograma y
muestra el estadstico Q de Box-Pierce para el contraste de la hiptesis
nula de que la serie es "ruido blanco". Este se distribuye asintticamente
como una chi-cuadrado con grados de libertad igual al nmero de retardos
utilizados.

Si se especifica un valor para retardo_max entonces el tamao del
correlograma se limita como mximo a ese nmero de retardos, en los dems
casos se determina automticamente.

Men grfico: /Variable/Correlograma
Otro acceso:  Men emergente de la ventana principal (cuando se hace 
      una seleccin simple)

# criteria Utilities

Argumentos: scr T k 
Ejemplo:    criteria 23.45 45 8

Calcula los estadsticos de seleccin de modelos (ver Ramanathan, Seccin
4.3), dados scr (suma de cuadrados de los residuos), el nmero de
observaciones (T), y el nmero de coeficientes (k). T, k, y scr pueden ser
valores numricos o nombres de variables definidas previamente.

# critical Utilities

Argumentos: distrib param1 [ param2 ] 
Ejemplos:   critical t 20
            critical X 5
            critical F 3 37

Si distrib es t, X or F, presenta los valores crticos para la distribucin
t de Student, chi-cuadrado o F respectivamente, para los niveles de
significacin ms comunes y usando los grados de libertad especificados, que
se dan en param1 para la t y chi-cuadrado, o param1 y param2 para la F. Si
distrib es d, presenta los valores superior e inferior del estadstico de
Durbin-Watson al 5 por ciento de significacin, para el nmero de
observaciones dado en param1, y para una rango de 1 a 5 variables
explicativas.

Men grfico: /Utilidades/Tablas estadsticas

# cusum Tests

Debe realizarse despus de la estimacin de un modelo por MCO. Realiza el
contraste CUSUM de estabilidad de los parmetros. Se obtiene una serie de
errores de predicin (escalados) un perodo hacia adelante al ejecutar una
serie de regresiones: la primera regresin utiliza las primeras k
observaciones y se usa para generar una prediccin de la variable
dependiente en la observacin k + 1; la segunda utiliza las primeras k + 1
observaciones y genera una prediccin para la observacin k + 2, y as
sucesivamente (donde k es el nmero de parmetros en el modelo original). Se
muestra y se representa graicamente la suma acumulada de los errores de
prediccin escalados. La hiptesis nula de estabilidad en los parmetros se
rechaza al nivel de significacin del 5 por ciento si la suma acumulada se
sale de la banda de 95 por ciento de confianza.

Tambin se presenta el estadstico t de Harvey-Collier para contrastar la
hiptesis nula de estabilidad de los parmetros. Para ms detalles ver
Captulo 7 del libro de Greene Econometric Analysis.

Men grfico: Ventana de Modelo, /Contrastes/CUSUM

# data Dataset

Argumento:  listavar 

Lee las variables de listavar desde una base de datos (de gretl o RATS 4.0),
que debe de haber sido abierta previamente usando la instruccin "open".
Adems, se debe de establecer una frecuencia y un rango muestral para los
datos usando las instrucciones "setobs" y "smpl" antes de usar esta orden.
He aqu un ejemplo completo:

	open macrodat.rat
	setobs 4 1959:1
	smpl ; 1999:4
	data GDP_JP GDP_UK

Estas instrucciones abren una base de datos denominada macrodat.rat,
establecen un conjunto de datos trimestral que empieza en el primer
trimestre de 1959 y acaba en el cuarto trimestre de 1999, y despus importan
las series denominadas GDP_JP y GDP_UK.

Si las series que van a ser ledas son de una frecuencia mayor que el
conjunto de datos actual, se debe especificar un mtodo de compactado como
en las siguientes lneas:

	data (compact=average) 
	LHUR PUNEW

Los cuatro mtodos de compactado disponibles son "average" (promediar: toma
la media de las observaciones de frecuencia mayor), "last" (ltima: usa la
ltima observacin), "first" y "sum".

Men grfico: /Archivo/Revisar bases de datos

# delete Dataset

Argumento:  [ listavar ] 

Borra las variables de la lista (dadas mediante nombre o nmero) del
conjunto de datos. Debe usarse con precaucin: no se pide confirmacin, y
cualquier variable con nmero de ID mayor ser renumerada.

Si con esta instruccin no se proporciona una lista listavar, se borra la
ltima variable (la de nmero ID mayor) del conjunto de datos.

Men grfico: Men emergente de la ventana principal (seleccin simple)

# diff Transformations

Argumento:  listavar 

Se obtiene la primera diferencia de cada variable de la lista listavar y el
resultado se guarda en una nueva variable cuyo nombre tiene el prefijo d_.
As "diff x y" crea las nuevas variables d_x = x(t) - x(t-1) y d_y = y(t) -
y(t-1).

Men grfico: /Datos/Aadir variables/Primeras diferencias

# else Programming

Ver "if".

# end Programming

Cierra un bloque de instrucciones de algunos tipos. Por ejemplo, end system
termina un sistema de ecuaciones (Ver "system").

# endif Programming

Ver "if".

# endloop Programming

Marca el final de un bucle de instrucciones. Ver "loop".

# eqnprint Printing

Argumento:  [ -f nombre_de_fichero ] 
Opcin:     --complete (Crea un documento completo)

Debe ejecutarse despus de la estimacin de un modelo. Presenta el modelo
estimado en formato de ecuacin LaTeX. Si se especifica un nombre de fichero
usando la opcin -f la salida va a ese fichero, en caso contrario va a una
fichero cuyo nombre tiene la forma equation_N.tex, donde N es el nmero de
modelos estimados hasta el momento en la sesin actual. Ver tambin
"tabprint".

Si se aplica la opcin --complete, el fichero LaTeX es un documento
completo, listo para ser procesado; en caso contrario deber incluirse
dentro de un documento previamente preparado.

Men grfico: Ventana de Modelo, /LaTeX

# equation Estimation

Argumentos: vardep varindeps 
Ejemplo:    equation y x1 x2 x3 const

Sirve pare especificar una ecuacin dentro de un sistema de ecuaciones (ver
"system"). La sintaxis para especificar una ecuacin dentro de un sistema
SUR (Ecuaciones de regresin aparentemente no relacinadas) es la misma que,
por ejemplo, la de MCO (ver "ols"). Para una ecuacin dentro de un sistema
de Mnimos Cuadrados en Tres Etapas se puede (a) dar la especificacin de
una ecuacin de tipo MCO y proporcionar una lista comn de instrumentos
usando la opcin "instr" (ver de nuevo "system"), o (b) usar la misma
sintaxis de definicin de ecuaciones que para "tsls".

# fcast Prediction

Argumentos: [ obs_inic obs_fin ] var_ajustada 
Ejemplos:   fcast 1997:1 2001:4 f1
            fcast fit2

Debe ejecutarse despus de una instruccin de estimacin. Se generan
predicciones para el dominio muestral especificado (o el dominio muestral
mayor posible si no se han proporcionado obs_inic y obs_fin) y los valores
se guardan como var_ajustada, que luego puede mostrarse o representarse
grficamente. Las variables del lado derecho son las del modelo original. No
se pueden sustituir por otras variables. Si se especifica un proceso de
error autorregresivo (para "hilu", "corc", y "ar") la prediccin se hace
condicionada un paso adelante y tiene en cuenta el proceso del error.

Men grfico: Ventana de Modelo, /Datos del Modelo/Predicciones con desviaciones tpicas

# fcasterr Prediction

Argumentos: obs_inic obs_fin 
Opcin:     --plot (mostrar el grfico)

Despus de estimar un modelo por medio de MCO usted puede usar esta
instruccin para mostrar los valores ajustados para el rango de
observaciones determinado, las desviaciones tpicas de estos valores
ajustados y los intervalos de confianza del 95 por ciento.

Las desviaciones tpicas se calculan de la forma descrita en el Captulo 6
del libro de Wooldridge Introductory Econometrics. Estas tienen en cuenta
dos fuentes de variabilidad: la asociada al valor esperado de la variable
dependiente condicionado a los valores dados de las variables
independientes, y la varianza de los residuos de la regresin.

Men grfico: Ventana de Modelo, /Datos del modelo/Predicciones con desviaciones tpicas

# fit Prediction

Es un atajo a "fcast". Debe de ejecutarse despus de una instruccin de
estimacin. Genera los valores ajustados basados en la ltima regresin,
para la mustra actual, y los guarda en una serie denominada autofit. En el
caso de modelos de series temporales tambin hace emerger un grfico con los
valores originales y ajustados de la variable dependiente con respecto al
tiempo.

# freq Statistics

Argumento:  var 

Presenta la distribucin de frecuencias de la variable var (que se da por
nombre o nmero); tambin muestra los resultados del contraste de normalidad
de Doornik-Hansen. En modo interactivo, se presenta un grfico de la
distribucin.

Men grfico: /Variable/Distribucin de frecuencias

# function Programming

Define una funcin.

# garch Estimation

Argumentos: p q ; vardep [ varindeps ] 
Opciones:   --robust (Desviaciones tpicas robustas)
            --verbose (muestra los detalles de las iteraciones)
            --vcv (presenta la matriz de covarianzas)
Ejemplos:   garch 1 1 ; y
            garch 1 1 ; y 0 x1 x2 --robust

Estima un modelo GARCH (GARCH = Generalized Autoregressive Conditional
Heteroskedasticity), o un modelo univariante o, si se especifican varindeps,
un modelo que incluye las variables exgenas dadas. Los valoires enteros p y
q representan los rdenes de retardos en la ecuacin de la varianza
condicional.

  h(t) = sum(i=1 to q) a(i)*u(t-i) + sum(j=1 to p) b(j)*h(t-j)

El algoritmo GARCH de gretl es bsicamente el de Fiorentini, Calzolari y
Panattoni (1996), y se usa con el amable permiso del profesor Fiorentini.

Con esta instruccin estn disponibles varias variantes de las estimaciones
de la matriz de covarianzas de los coeficientes. Por defecto se usa el
Hessiano a no ser que se indique la opcin --robust, en cuyo caso se utiliza
la matriz de covarianzas QML (White). Se pueden especificar otras
posibilidades (p.ej. la matriz de informacin, o el estimador
Bollerslev-Wooldridge) usando la instruccin "set".

Men grfico: /Modelo/Serie temporal/GARCH

# genr Dataset

Argumentos: nueva_var = frmula 

Crea variables nuevas, normalmente como transformaciones de variables ya
existentes. Ver tambin "diff", "logs", "lags", "ldiff", "multiply" y
"square" como atajos.

Los operadores aritmticos soportados son, en orden de precedencia: ^
(exponenciacin); *, / y % (mdulo o resto); + y -.

Los operadores Booleanos disponibles son (de nuevo, en orden de
precedencia): ! (negacin), & (Y lgico), | (O lgico), >, <, =, >= (mayor o
igual que), <= (menor o igual que) y != (distinto que). Se pueden usar
operadores Booleanos para construir variables ficticias: por ejemplo (x >
10) devuelve 1 si x > 10, y 0 en otro caso.

Las funciones se clasifican en:

  Funcione matemticas estndar: abs, cos, exp, int (parte entera), ln
  (logaritmo natural: log es un sinnimo), sin, sqrt.

  Funciones estadsticas: max (valor mximo de una serie), min (mnimo),
  mean (media aritmtica), median, var (varianza) sd (desviacin tpica),
  sst (suma de desviaciones desde la media, al cuadrado), sum, cov
  (covarianza), corr (coeficiente de correlacin), pvalue, sort, cum
  (acumulacin, o suma secuencial), resample (remuestrear una serie con
  reemplazamiento, con el propsito de hacer bootstrap), hpfilt (Filtro de
  Hodrick-Prescott: esta funcin devuelve el "componente cclico" de la
  serie).

  Funciones de series temporales: diff (primera diferencia), ldiff
  (diferencia logartmica, o primera diferencia del logaritmo natural). Para
  generar retardos de una variable x, se usa la sintaxis "x(-N)", donde N
  representa la longitud deseada del retardo; para generar adelantos, se usa
  "x(+N)".

  Funciones de conjunto de datos: misszero (reemplaza los cdigos de
  observacin ausente de una serie dada con ceros); zeromiss (la operacin
  inversa a misszero); nobs (devuelve el nmero de observaciones vlidas de
  una serie de datos determinada), missing (para cada observacin, devuelve
  1 si el argumento tiene una observacin ausente, y 0 en caso contrario);
  ok (el opuesto de missing).

  Nmeros pseudo-aleatorios: uniform, normal.

Todas las funciones de arriba excepto cov, corr, pvalue, uniform y normal
toman como nico argumento o el nombre de una variable (ntese que, en una
frmula "genr", no es posible referirse a las variables por su nmero de ID)
o una expresin que se evala en una variable (p.ej. ln((x1+x2)/2)). cov y
corr requieren dos argumentos, y devuelven respectivamente la covarianza y
el coeficiente de correlacin entre sus argumentos. La funcin pvalue toma
los mismos argumentos que la instruccin "pvalue", pero en este contexto
deben introducirse comas entre los argumentos. Esta funcin devuelve un
valor p a una cola y, en el caso de las distribuciones normal y t, es para
la "cola corta". Con la normal, por ejemplo, tanto 1,96 como -1,96 darn un
resultado de aproximadamente 0,025.

uniform() y normal(), que no toman arguamentos, devuelven series de nmeros
pseudo-aleatorios extrados de la distribucin uniforme (0-1) y normal
estndar respectivamente (ver tambin la instruccin "set", opcin seed). La
series de datos uniformes se generan utilizando el Mersenne Twister; para
series normales se usa el mtodo de Box y Muller (1958), tomando la entrada
del Mersenne Twister.

Adems de los operadores y funciones ya mencionados, hay algunos usos
especiales de "genr":

  "genr time" crea una variable de tendencia temporal (1,2,3,...) llamada
  "time". "genr index" hace lo mismo, excepto que ahora la variable se
  denomina index.

  "genr dummy" crea variables ficticias hasta la periodicidad de los datos.
  P.ej. en el caso de datos trimestrales (periodicidad 4), el programa crea
  dummy_1 = 1 para el primer trimestre y 0 en los dems trimestres, dummy_2
  = 1 para el segundo trimestre y 0 en los dems, y as sucesivamente.

  "genr paneldum" crea un conjunto de variables ficticias especiales para
  ser usadas con un conjunto de datos de panel -- ver "panel".

Usando "genr" se pueden recuperar los valores de algunas variables internas
que se definen al ejecutar una regresin, de la siguiente foprma:

  $ess: suma de cuadrados de los residuos

  $rsq: R-cuadrado no corregido

  $T: nmero de observaciones usadas

  $df: grados de libertad

  $trsq: TR-cuadrado (el tamao muestral por el R-cuadrado)

  $sigma: desviacin tpica de los residuos

  $aic: Criterio de informacin de Akaike

  $bic: Criterio de informacin de Schwarz

  $lnl: logaritmo de la verosimilitud (donde es aplicable)

  coeff(var): coeficiente estimado para la variable var

  stderr(var): desviacin tpica estimada para la variable var

  rho(i): coeficiente autorregresivo de i-simo orden de los residuos

  vcv(x1,x2): covarianza entre los coeficientes para las variables nombradas
  x1 y x2

Nota: En el programa en lnea de instrucciones, las instrucciones "genr" que
recuperan datos relativos a un modelo siempre hacen referencia al ltimo
modelo estimado. Esto tambin es cierto para el programa en modo GUI, si uno
usa "genr" en la "consola de gretl" o introduce una frmula usando la opcin
"Definir nueva variable" del men de Variable en la ventana principal. Sin
embargo, con el GUI, usted tiene la posibilidad de recuperar datos de
cualquier modelo que actualmente se est mostrando en una ventana (sea o no
el modelo ms reciente). Usted puede hacer esto bajo el men "Datos del
Modelo" de la ventana del modelo.

Las series internas uhat e yhat contienen, respectivamente, los residuos y
los valores ajustados de la ltima regresin.

Tambin estn disponibles dos variables "internas" relacionadas con el
conjunto de datos actual: $nobs contiene el nmero de observaciones del
rango muestral actual (que puede ser o no igual a $T, el nmero de
observaciones usadas al estimar el ltimo modelo), y $pd contiene la
frecuencia o periodicidad de los datos (p.ej 4 para datos trimestrales).

La variable t sirve como ndice de las observaciones. Por ejemplo genr dum =
(t=15) generar una variable ficticia que toma valor 1 para la observacin
15, y 0 en las dems. La variable obs es similar pero ms flexible: usted
puede usarla para extraer observaciones particulares por fecha o nombre. Por
ejemplo, genr d = (obs>1986:4) o genr d = (obs="CA"). La ltima forma
presupone que las observaciones tienen etiquetas; la etiqueta debe ponerse
entre comillas.

Pueden utilizarse valores escalares de una serie en el contexto de una
frmula genr, usando la sintaxis nombre_var[obs]. El valor obs puede darse
por nmero o fecha. Ejemplos: x[5], CPI[1996:01]. Para datos diarios data,
se debe de usar la forma YYYY:MM:DD, p.ej. ibm[1970:01:23].

Se puede modificar una observacin individual de una serie por medio de
genr. Para hacerlo, hay que adjuntar al nombre de la variable en el lado
izquierdo de la frmula, entre corchetes, un nmero de observacin vlido o
una fecha. Por ejemplo, genr x[3] = 30 o genr x[1950:04] = 303.7.

Aqu hay un par de sugerencias sobre variable ficticias:

  Supongamos que x est codificada con los valores 1, 2, o 3 y usted quiere
  tres variables ficticias, d1 = 1 si x = 1, 0 en otro caso, d2 = 1 si x =
  2, y as sucesivamente. Para crearlas, use las instrucciones:

	    genr d1 = (x=1)
	    genr d2 = (x=2)
	    genr d3 = (x=3)

  Para crear z = max(x,y) do

	    genr d = x>y
	    genr z = (x*d)+(y*(1-d))

  Frmula               Comentario
  -------               -------
  y = x1^3              x1 al cubo
  y = ln((x1+x2)/x3)    
  z = x>y               z(t) = 1 si x(t) > y(t), en otro caso 0
  y = x(-2)             x retardada 2 periodos
  y = x(2)              x adelantada 2 periodos
  y = diff(x)           y(t) = x(t) - x(t-1)
  y = ldiff(x)          y(t) = log x(t) - log x(t-1), la tasa de crecimiento 
                        instantnea de x
  y = sort(x)           ordena x en orden creciente y lo guarda en y
  y = -sort(-x)         ordena x en orden decreciente
  y = int(x)            trunca x y guarda su valor entero como y
  y = abs(x)            guarda los valores absolutos de x
  y = sum(x)            suma los valores de x excluyendo los valores ausentes, 
                        con entradas -999
  y = cum(x)            acumulacin: y(t) = la suma desde s=1 hasta s=t de 
                        x(s) 
  aa = $ess             hace aa igual a la suma de cuadrados de los residuos 
                        de la ltima regresin
  x = coeff(sqft)       guarda el coeficiente estimado de la variable sqft de 
                        la ltima regresin
  rho4 = rho(4)         guarda el coeficiente autorregresivo de 4 orden del 
                        ltimo modelo (supone un modelo ar)
  cvx1x2 = vcv(x1, x2)  guarda la covarianza de los coeficientes estimados de 
                        las variables x1 y x2 del ltimo modelo
  foo = uniform()       variable pseudo-aleatoria uniforme en el rango 0-1
  bar = 3 * normal()    variable pseudo-aleatoria normal, mu = 0, sigma = 3
  samp = !missing(x)    = 1 para las observaciones en las que no hay valores 
                        ausentes de x.

Men grfico: /Variable/Definir nueva variable
Otro acceso:  Men emergente de la ventana principal

# gnuplot Graphs

Argumentos: yvars xvar [ dumvar ] 
Opciones:   --with-lines (usar lneas, no puntos)
            --with-impulses (usar lneas verticales)
            --suppress-fitted (no mostrar el ajuste mnimo-cuadrtico)
            --dummy (ver abajo)
Ejemplos:   gnuplot y1 y2 x
            gnuplot x time --with-lines
            gnuplot wages educ gender --dummy

Sin la opcin --dummy, las variables yvars se representan contra xvar. Con
--dummy, yvar se representa contra xvar con los puntos pintados de
diferentes colores dependiendo de si el valor de dumvar es 1 o 0.

La variable time se comporta de manera especial: si no existe, entonces se
generar automticamente.

En modo interactivo los resultados se muestran inmediatamente. En modo batch
se escribe un fichero de instrucciones gnuplot con un nombre que sigue el
modelo gpttmpN.plt, empezando con N = 01. Los grficos actuales se pueden
generar ms tarde usando gnuplot (bajo MS Windows, wgnuplot).

Hay una nueva opcin disponible en esta instruccin: despus de la
especificacin de las variables a representar y las opciones (si se elige
alguna), usted puede aadir instrucciones literales de gnuplot para
controlar la apariencia del grfico (por ejemplo, poner el ttulo del
grfico y/o el rango de los ejes). Estas instrucciones deberan inclurse
entre parntesis y cada instruccin gnuplot debe terminar con un punto y
coma. Se puede usar una barra invertida (/) para continuar un conjunto de
instrucciones gnuplot sobre ms de una lnea. He aqu un ejemplo de la
sintaxis:

{ set title 'Mi ttulo'; set yrange [0:1000]; }

Men grfico: /Datos/Grficos
Otro acceso:  Mene emergente de la ventana principal, botn de grfico de
      la barra de herramientas

# graph Graphs

Argumentos: yvars xvar 
Opcin:     --tall (usar 40 filas)

Grficos ASCII. Las variables yvars (que pueden determinarse por nombre o
nmero) se representan con respecto a xvar usando smbolos ASCII. La opcin
--tall producir un grfico con 40 filas y 60 columnas. Sin ella, el grfico
ser de 20 por 60 (para salida por pantalla). Ver tambin "gnuplot".

# hausman Tests

Este contraste slo est disponible despus de haber estimado un modelo
mediante la instruccin "ols" (ver tambin "panel" y "setobs"). Contrasta el
modelo simple combinado contra sus alternativas principales, el modelo de
efectos fijos y el modelo de efectos aleatorios.

El modelo de efectos fijos aade una variable ficticia para todas menos una
de las unidades de seccin cruzada, permitiendo al intercepto de la
regresin variar a travs de estas unidades. Se presenta un estadstico F
para el contraste de significacin conjunta de estas variables ficticias. El
modelo de efectos aleatorios descompone la varianza residual en dos partes,
una parte especfica de las unidades de seccin cruzada y la otra especfica
de cada observacin particular. (Este estimador slo puede computarse si el
nmero de unidades de seccin cruzada es mayor que el nmero de parmetros a
estimar.) El estadstico LM de Breusch-Pagan sirve para contrastar la
hiptesis nula (de que el estimador MCO combinado es el adecuado) contra la
alternativa de efectos aleatorios.

El modelo de MCO combinados puede ser rechazado contra ambas alternativas,
el modelo de efectos fijos y el de efectos aleatorios. Si el error
especfico de unidad o grupo est incorrelacionado con las variables
independientes, el estimador de efectos aleatorios es ms eficiente que el
estimador de efectos fijos; en caso contrario el estimador de efectos
aleatorios sera inconsistente y sera preferible el estimador de efectos
fijos. La hiptesis nula para el contraste de Hausman es que el error
especfico de grupo no est tan correlacionado (as que es preferible el
modelo de efectos aleatorios). Un valor p bajo para este contraste es un
sntoma en contra del modelo de efectos aleatorios y a favor del modelo de
efectos fijos.

Men grfico: Ventana de Modelo, /Contrastes/Diagnsticos de panel

# hccm Estimation

Argumentos: vardep varindeps 
Opcin:     --vcv (presenta la matriz de covarianzas)

Matriz de covarianzas consistente ante heterocedasticidad: esta instruccin
ejecuta una regresin en la que los coeficientes se estiman mediante un
procedimiento MCO estndar, pero las desviaciones tpicas de los
coeficientes estimados se calculan de una manera que es robusta ante
heterocedasticidad, en concreto usando el procedimiento "jackknife" de
MacKinnon-White.

Men grfico: /Modelo/HCCM

# help Utilities

Proporciona una lista de las instrucciones disponibles. "help" instruccin
describe la instruccin (p.ej. "help smpl"). Vd. puede escribir "man" en
lugar de "help" si lo desea.

Men grfico: /Ayuda

# hilu Estimation

Argumentos: vardep varindeps 
Opcin:     --vcv (presenta la matriz de covarianzas)

Calcula estimaciones de los parmetros del modelo especificado usando el
procedimiento de bsqueda de Hildreth-Lu search procedure (refinado mediante
el procedimiento CORC). Este procedimiento est diseado para corregir las
estimaciones teniendo en cuenta la correlacin serial del trmino de error.
La suma de cuadrados de los residuos del modelo transformado se representa
con respecto al valor de rho desde -0.99 hasta 0.99.

Men grfico: /Modelo/Serie temporal/Hildreth-Lu

# hsk Estimation

Argumentos: vardep varindeps 
Opcin:     --vcv (presenta la matriz de covarianzas)

Se calcula una regresin por MCO y se guardan los residuos. El logaritmo del
cuadrado de los residuos entonces pasa a ser la variable dependiente en una
regresin auxiliar, en cuyo lado derecho estn las variables independientes
originales ms sus cuadrados. Los valores ajustados en la regresin auxiliar
se usan entonces para construir una serie de ponderaciones y el modelo
original se reestima utilizando mnimos cuadrados ponderados. El resultado
final se presenta en un informe.

La serie de ponderaciones se forma como 1/sqrt(exp(y*)), donde y* denota los
valores ajustados mediante la regresin auxiliar.

Men grfico: /Modelo/Corregido de Heterocedasticidad

# if Programming

Control de flujo para la ejecucin de instrucciones. La sintaxis es:

	if condicin
	   instrucciones1
	else
	   instrucciones2
	endif
            
condicin debe ser una expresin Booleana, para su sintaxis ver "genr". El
bloque "else" es opcional; los bloques if ... endif pueden estar anidados.

# import Dataset

Argumento:  nombre_fichero 
Opcin:     --box1 (datos BOX1)

Transfiere datos desde un fichero de formato CSV (Comma-separated values),
tal y como los que pueden escribirse fcilmente desde cualquier programa de
hoja de clculo. El fichero debera de tener los nombres de las variables en
la primera lnea y una matriz rectangular de datos en las restantes. Las
variables deberan estar ordenadas "por observacin" (una columna para cada
variable; cada fila representa una observacin). Ver el manual de gretl para
ms detalles.

Con la opcin --box1, lee u fichero de formato BOX1, como los que se
obtienen utilizando el Servicio de Extraccin de Datos del US Bureau of the
Census.

Men grfico: /Archivo/Abrir datos/importar

# info Dataset

Presenta cualquier informacin suplemnentaria que se haya guardado con el
fichero de datos actual.

Men grfico: /Datos/Leer informacin
Otro acceso:  Ventanas de navegacin de datos

# setinfo Dataset

Argumentos: nombre_var -d descripcin -n nombre a mostrar 
Ejemplo:    label x1 -d "Descripcin de x1" -n "Nombre en los grficos"

Establece la etiqueta descriptiva de la variable determinada (si se da la
opcin -d, seguida de una cadena de caracteres entre comillas) y/o el
"nombre a mostrar" para la variable (si se da la opcin -n, seguida de una
cadena de caracteres entre comillas). Si una variable tiene un "nombre a
mostrar", se usar ste al generar los grficos.

Men grfico: /Variable/Editar atributos
Otro acceso:  Men emergente de la ventana principal

# labels Dataset

Presenta las etiquetas informativas de cualquier variable que haya sido
generada usando la instruccin "genr", y cualquier variable aadida al
conjunto de datos por medio del GUI.

# lad Estimation

Argumentos: vardep varindeps 

Calcula una regresin que minimiza la suma de las desviaciones absolutas de
los valores observados de la variable dependiente con respecto a los
ajustados. La estimaciones de los coeficientes se derivan usando el
algoritmo simplex de Barrodale-Roberts; se muestra un aviso si la solucin
no es nica. Las desviaciones tpicas se derivan utilizando el procedimiento
bootstrap con 500 extracciones.

Men grfico: /Modelo/Mnima devsiacin absoluta

# lags Transformations

Argumento:  listavar 

Crea variables nuevas que son valores retardados de cada una de las
variables de listavar. El nmero de variables retardadas es igual a la
periodicidad. Por ejemplo, si la periodicidad es 4 (trimestral), la
instruccin "lags x y" crea x_1 = x(t-1), x_2 = x(t-2), x_3 = x(t-3) y x_4 =
x(t-4). Lo mismo para y. Estas variables deben ser referenciadas de manera
exacta, es decir, con el carcter de subrayado.

Men grfico: /Datos/Aadir variables/retardos de las variables seleccionadas

# ldiff Transformations

Argumento:  listavar 

Calcula la primera diferencia del logaritmo natural de cada variable de
listavar y guarda el resultado en una nueva variable con el prefijo ld_. As
"ldiff x y" crea las nuevas variables ld_x = ln[x(t)] - ln[x(t-1)] y ld_y =
ln[y(t)] - ln[y(t-1)].

Men grfico: /Datos/Aadir variables/diferencias de logaritmos de las variables seleccionadas

# leverage Tests

Opcin:     --save (guardar las variables)

Debe ejecutarse inmediatamente despus de una instruccin "MCO". Calcula el
apalancamiento (h, que debe estar entre 0 y 1) para cada punto de datos de
la muestra sobre la que se estim el ltimo modelo. Presenta el residuo (u)
de cada observacin junto a su apalancamiento y una medida de su influencia
sobre las estimaciones, u*h/(1-h). Los "puntos palanca" para los cuales el
valor de h es mayor que 2k/n (donde k es el nmero de parmetros estimados y
n es el tamao muestral) se marcan con un asterisco. Para ms detalles sobre
los conceptos de apalancamiento e influencia ver Davidson and MacKinnon
(1993, Captulo 2).

Tambin se presentan los valores DFFITS: estos son los "residuos
studentizados" (residuos predichos divididos por sus desviaciones tpicas)
multiplicados por sqrt[h/(1 - h)]. Para ms detalles sobre residuos
studentizados y DFFITS ver el libro de G. S. Maddala, Introduction to
Econometrics, captulo 12; y tambin Belsley, Kuh y Welsch (1980). En
resumen, un "residuo predicho" es la diferencia entre el valor observado de
la variable dependiente en la observacin t y el valor ajustado para la
observacin t obtenido de una regresin en la que se omite esa observacin
(o se aade una variable ficticia con valor 1 slo para la observacin t);
el residuo studentizado se obtiene dividiendo el residuo predicho por su
desviacin tpica.

Si con esta instruccin se da la opcin --save, entonces los valores del
apalancamiento, influencia y DFFITS se aaden al conjunto de datos actual.

Men grfico: Ventana de Modelo, /Contrastes/observaciones influyentes

# lmtest Tests

Opciones:   --logs (no linealidad, logaritmos)
            --autocorr (correlacin serial)
            --squares (no linealidad, cuadrados)
            --white (heterocedasticidad (Contraste de White))

Debe ejecutarse justo despus de una instruccin "mco". Realiza alguna
combinacin de lo siguiente: contrastes de Multiplicador de Lagrange de no
linealidad (logaritmos y cuadrados), contraste de heterocedasticidad de
White, y el contraste LMF de correlacin serial hasta el orden de la
periodicidad (ver Kiviet, 1986). Tambin se presentan los correspondientes
coeficientes de la regresin auxiliar. Ver Ramanathan, Captulos 7, 8, y 9
para ms detalles. En el,caso del contrastes de White, slo se usan los
cuadrados de las variables independientes y no sus productos cruzados. En el
caso del contraste de autocorrelacin, si el valor p del estadstico LMF es
menor que 0,05 (y el modelo no se haba estimado originariamente con
desviaciones tpicas robustas) entonces se calculan y se presentan las
desviaciones tpicas robustas ante correlacin serial. Para detalles sobre
el clculo de estas desviaciones tpicas ver Wooldridge (2002, Captulo 12).

Men grfico: Ventan de Modelo, /Contrastes

# logistic Estimation

Argumentos: vardep varindeps [ ymax=valor ] 
Opcin:     --vcv (mostrar la matriz de covarianzas)
Ejemplos:   logistic y const x
            logistic y const x ymax=50

Regresin logstica: desarrolla una regresin MCO utilizando la
transformacin logstica de la variable dependiente,

  log(y/(ymax - y))

La variable dependiente debe ser estrictamente positiva. Si es una fraccin
decimal, entre 0 y 1, por defecto se usa un valor y* (el mximo asinttico
de la variable dependiente) of 1. Si la variable dependiente es un
porcentaje, entre 0 y 100, por defecto y* es 100. Si Vd. desea establecer
otro valor mximo utilice el parmetro opcional ymax=valor despus de la
lista de regresores. El valor proporcionado debe ser mayor que todos los
valores observados de la variable dependiente.

Los valores ajustados y los residuos de la regresin se transforman
automticamente usando

  y = ymax / (1 + exp(-x))

donde x representa o un valor ajustado o un residuo de la regresin MCO
usando la variable dependiente transformada. Los valores que se presentan
son as comparables con los valores originales de la variable dependiente.

Ntese que si la variable dependiente es binaria, en lugar de esto se
debera usar la instruccin "logit".

Men grfico: /Modelo/Logstico

# logit Estimation

Argumentos: vardep varindeps 
Opcin:     --vcv (mostrar la matriz de covarianzas)

Regresin binomial logit. La variable dependiente debera ser una variable
binaria. Se obtienen las estimaciones mximo-verosmiles de los coeficientes
de las variables varindeps por medio del mtodo EM (Expectation-Maximization
method, ver Ruud, 2000, Captulo 27). Como el modelo no es lineal las
pendientes dependen de los valores de las variables independientes: las
poendientes que se presentan se han evaluado en la media de dichas
variables. La hiptesis de que todos los coeficientes, aparte de la
constante, son cero se contrasta mediante el estadstico chi-cuadrado.

Si Vd. desea utilizar logit para el anlisis de proporciones (donde la
variable dependiente, para cada observacin, es la proporcin de casos que
tienen una determinada caracterstica, en lugar de un 1 o un 0 indicando si
la caracterstica est presente o no) no debera usar la instruccin
"logit", sino mejor debera construir la variable logit (p.ej. genr lgt_p =
log(p/(1 - p))) y usarla como variable dependiente en una regresin MCO. Ver
Ramanathan, Captulo 12.

Men grfico: /Modelo/Logit

# logs Transformations

Argumento:  listavar 

Se obtiene el logaritmo natural de cada una de las variables de listavar y
el resultado se guarda en una nueva variable con el prefijo l_ que es "ele"
y carcter de subrayadoe. "logs x y" crea las nuevas variables l_x = ln(x) y
l_y = ln(y).

Men grfico: /Datos/Aadir variables/logaritmos de las variables seleccionadas

# loop Programming

Argumento:  control 
Opcin:     --progressive (permite formas especiales de ciertas instrucciones)
Ejemplos:   loop 1000
            loop 1000 --progressive
            loop while essdiff > .00001
            loop for i=1991..2000
            loop for (r=-.99; r<=.99; r+=.01)

El parmetro "control" debe tomar una de las cuatro formas posibles, tal y
como se muestra en los ejemplos: un nmero de veces entero a repetir las
instrucciones del bucle; "while" ms una condicin numrica; o "for" ms un
rango de valores para la variable ndice interna i; o "for" ms tres
expresiones entre parntesis, separadas por puntos y comas. En la ltima
forma, la expresin del lado izquierdo inicializa una variable, la del medio
establece una condicin para que continen las iteraciones, y la de la
derecha determina un incremento o decremento a aplicar al comienzo de la
segunda y siguientes iteraciones. (Esta es una forma restringida de la
instruccin for del lenguaje de programacin C.)

Esta instruccin abre un modo de ejecucin especial en el cual el programa
acepta instrucciones a ejecutar repetidamente. Dentro de un bucle slo se
pueden utilizar ciertas instrucciones: "genr", "ols", "print", "printf",
"pvalue", "sim", "smpl", "store", "summary", "if", "else" y "endif". Se sale
del modo de introduccin de instrucciones de bucle con "endloop": en este
punto se ejecutan todas las instrucciones que estn en la cola del bucle.

Ver el manual de gretl para ms detalles y ejemplos. El efecto de la opcin
--progressive (que est diseada para su uso en simulaciones de Monte Carlo)
se explica all.

# meantest Tests

Argumentos: var1 var2 
Opcin:     --unequal-vars (suponer que las varianzas son diferentes)

Calcula el estadstico t para la hiptesis nula de que las medias
poblacionales de las variables var1 y var2 son iguales, y presenta su valor
p. Por defecto se calcula el estadstico bajo el supuesto de que las
varianzas de las dos variables son iguales; con la opcin --unequal-vars se
suponen varianzas distintas. Esto implicar una diferencia en el estadstico
de contraste slo si hay un nmero diferente de valores no ausentes para las
dos variables.

Men grfico: /Datos/Diferencia de medias

# modeltab Utilities

Argumentos: add  o show  o free 

Sirve para manipular la "tabla de modelos" de gretl. Ver el manual de gretl
para ms detalles. Las sub-instrucciones tienen los isguientes efectos:
"add" aade el ltimo modelo estimado a la tabla de modelos, si es posible;
"show" presenta la tabla de modelos en una ventana; y "free" vaca la tabla.

Men grfico: Ventana de sesin, icono de Tabla de modelos

# mpols Estimation

Argumentos: vardep varindeps 

Computa las estimaciones MCO para el modelo especificado, usando aritmtica
de punto flotante con precisin mltiple. Esta instruccin slo est
disponible si gretl se compila con soporte para la biblioteca Gnu de
Precisin Mltiple (GMP).

Para estimar un ajuste polinomial usando aritmtica de precisin mltiple
para generar las potencias necesarias de la variable independiente use por
ejmplo la forma "mpols y 0 x ; 2 3 4". Esto realiza una regresin de y sobre
x, x cuadrado, x al cubo y x a la cuarta potencia. Es decir, los nmeros a
la derecha del punto y coma (que deben ser enteros positivos) determinan las
potencias de x a utilizar. Si se especifica ms de una variable
independiente, ha de considerarse que la ltima antes del punto y coma es la
variable que va a ser elevada a varias potencias.

Men grfico: /Modelo/MCO de alta precisin

# multiply Transformations

Argumentos: x sufijo listavar 
Ejemplos:   multiply invpop pc 3 4 5 6
            multiply 1000 big x1 x2 x3

Las variables de listavar (referenciadas por nombre o nmero) se multiplican
por x, que puede ser un valor numrico o el nombre de una variable
previamente definida. Los productos se nombran con el sufijo especificado
(mximo 3 caracteres). Si es necesario, se truncan primero los nombres
originales de las variables. Por ejemplo, supongamos que Vd. desea crear las
versiones per cpita de ciertas variables, y tiene la variable pob
(poblacin). Un conjunto de instrucciones adecuado sera:

	genr invpob = 1/pob
	multiply invpob pc income

que crear incomepc como el producto de income e invpob, y expendpc como
expend por invpob.

# nls Estimation

Argumentos: funcin derivadas 
Opcin:     --vcv (mostrar la matriz de covarianzas)

Desarrolla la estimacin por Mnimos Cuadrados No Lineales (NLS) utilizando
una versin modificada del algoritmo de Levenberg-Marquandt. El usuario debe
suministrar la especificacin de una funcin. Los parmetros de esta funcin
deben ser declarados antes y hay que asignarles unos valores iniciales
(usando la instruccin "genr") antes de la estimacin. Opcionalmente, el
usuario puede especoficar las derivadas de la funcin de regresin con
respectyo a cada uno de los parmetros; si nbo se proporcionan las derivadas
analticas se computa una aproximacin numrica al Jacobiano.

Es ms sencillo mostrar lo que se necesita con un ejemplo. Lo siguiente es
un lote de instrucciones completo para estimar la funcin de consumo no
lineal definida en el libro de William Greene Econometric Analysis (Captulo
11 de la 4 edicin inglesa, o Captulo 9 de la 5). Los nmeros a la
izquierda de las lneas son para referencia y no son parte de las
instrucciones. Hay que sealar que la opcin --vcv, para presentar la matriz
de covarianzas de las estimaciones de los parmetros se escribe junto a la
instruccin final, end nls.

	1   open greene11_3.gdt
	2   ols C 0 Y
	3   genr alfa = coeff(0)
	4   genr beta = coeff(Y)
	5   genr gamma = 1.0
	6   nls C = alfa + beta * Y^gamma
	7   deriv alfa = 1
	8   deriv beta = Y^gamma
	9   deriv gamma = beta * Y^gamma * log(Y)
	10  end nls --vcv

Muchas veces es conveniente inicializar los parmetros haciendo referencia a
un modelo lineal relacionado con el actual; esto se realiza aqu en las
lneas 2 a 5. A los parmetros alfa, beta y gamma se les podra asignar
cualesquiera valores iniciales (no necesariamente basados en un modelo
estimado por MCO), aunque la convergencia del procedimiento de MC no
lineales no est garantizada para un punto de inicio arbitrario.

Las instrucciones de MC no lineales actuales ocupan las lneas 6 a 10. En la
lnea 6 se invoica la instruccin "nls": se especifica una variable
dependiente seguida de un signo igual y despus la especificacin de una
funcin. La sintaxis para la expresin de la derecha es la misma que para la
instruccin "genr". Las tres siguientes lneas determinan las derivadas de
la funcin de regresin con respecto a cada uno de los parmetros. Cada
lnea comienza con la palabra "deriv", da el nombre de un parmetro, un
signo igual y una expresin por la que se calcula la derivada (de nuevo, la
sintaxis aqu es la misma que para "genr"). Estas lneas "deriv" son
opcionales, pero es conveniente proporcionarlas, si es posible. La lnea 10,
"end nls", completa la instruccin e invoca la estimacin.

Para ms detalles sobre la estimacin por MC. no lineales ver el manual de
gretl.

Men grfico: /Modelo/Mnimos cuadrados no lineales

# nulldata Dataset

Argumento:  largura de la serie 
Ejemplo:    nulldata 500

Forma un conjunto de datos "vaco", que contiene slo una constante y una
variable ndice, con periodicidad 1 y el nmero de observaciones
especificado. Esto puede usarse para hacer simulaciones: algunas de las
instrucciones "genr" (p.ej. "genr uniform()", "genr normal()") generan,
desde cero, datos ficticios para rellenar el conjunto de datos. Esta
instruccin puede ser til tambin junto a la instruccin "loop". Ver
tambin la opcin "seed" de la instruccin "set".

Men grfico: /Archivo/Crear conjunto de datos

# ols Estimation

Argumentos: vardep varindeps 
Opciones:   --vcv (mostrar la matriz de covarianzas)
            --robust (desviaciones tpicas robustas)
            --quiet (suprime la presentacin de los resusltados)
            --no-df-corr (suprime la correccin de grados de libertad)
            --print-final (ver ms abajo)
Ejemplos:   ols 1 0 2 4 6 7
            ols y 0 x1 x2 x3 --vcv
            ols y 0 x1 x2 x3 --quiet

Calcula las estimaciones de mnimos cuadrados ordinarios (MCO) con vardep
como variable dependiente y siendo varindeps la lista de variables
independientes. Las variables se pueden determinar por nombre o por su
nmero; hay que usar el nmero cero para el trmino constante.

Adems de las estimaciones de los coeficientes y de las desviaciones
tpicas, el programa tambin presenta los valores p de los estadsticos t (a
dos colas) y F. Un valor p inferior a 0,01 indica significatividad al nivel
del 1 por ciento y se denota mediante ***. ** indica un nivel de
significatividad entre el 1 y 5 por ciento y * indica significatividad entre
el 5 y 10 por ciento. Tambin se presentan algunos estadsticos de seleccin
de modelos (se describen en Ramanathan, Seccin 4.3).

Si se da la opcin --no-df-corr, no se aplica la correccin habitual de
grados de libertad al calcular la estimacin de la varianza de las
perturbaciones (y as tampoco en la estimacin de las desviaciones tpicas
de los estimadores de los parmetros).

La opcin --print-final es aplicable slo en el contexto de un bucle (ver
"loop"). Se encarga de que las regresiones se ejecuten "silenciosamente" en
todas las iteraciones excepto la iteracin final del bucle. Ver el manual de
gretl para ms detalles.

Algunas variables que se definen internamente al ejecutar la instruccin
"ols", pueden recuperarse mediante la instruccin "genr", teniendo en cuenta
que "genr" debe invocarse immediatamente despus de la instruccin "ols".

Mediante la instruccin "set" puede ajustarse la frmula especfica que se
usa para generar las desviaciones tpicas robustas (cuando se da la opcin
--robust).

Men grfico: /Modelo/Mnimos cuadrados ordinarios
Otro acceso:  Botn beta con sombrero en la barra de herramientas

# omit Tests

Argumento:  listavar 
Opciones:   --vcv (mostrar la matriz de covarianzas)
            --quiet (no mostrar las estimaciones del modelo reducido)
Ejemplo:    omit 5 7 9

Esta instruccin debe invocarse justo despus de una instruccin de
estimacin. Las variables seleccionadas se omiten del modelo anterior y se
estima el nuevo modelo. Si se omite ms de una variable, se presentar el
estadstico F de Wald para las variables omitidas y su valor p (slo para el
mtodo MCO). Un valor p inferior a 0,05 indica que los coeficientes son
conjuntamente significativos al nivel de significacin del 5 por ciento.

Si se da la opcin --quiet el resultado que se muestra es slo el contraste
de significacin conjunta de las variables omitidas, en caso contrario,
tambin se presentan las estimaciones del modelo reducido. En este ltimo
caso, la opcin --vcv hace que tambin se muestre la matriz de covarianzas
de los coeficientes estimados.

Men grfico: ventana de Modelo, /Contrastes/omitir variables

# omitfrom Tests

Argumentos: ID_modelo listavar 
Opcin:     --quiet (no mostrar las estimaciones del modelo reducido)
Ejemplo:    omitfrom 2 5 7 9

Funciona igual que "omit", excepto que aqu Vd. tiene que especificar un
modelo anterior (usando su nmero ID identificador de modelo, que se
presenta al principio de los resultados del modelo) que se toma como base
para omitir las variables. En el ejemplo de arriba se omiten del Modelo 2
las variables con nmeros 5, 7 y 9.

Men grfico: Ventana de Modelo, /Contrastes/omitir variables

# open Dataset

Argumento:  fichero_de_datos 

Abre un fichero de datos. Si ya hay un fichero de datos abierto, se
reemplaza por el que ahora se abre. El programa tratar de detectar el
formato del fichero de datos (formato nativo de gretl, texto plano, CSV o
BOX1).

Esta instruccin tambin se puede usar para abrir una base de datos (de
fromato gretl o RATS 4.0). En este caso, despus debera ejecutarse la
instruccin "data" para extraer de ella series determinadas.

Men grfico: /Archivo/Abrir datos
Otro acceso:  Arrastrar un fichero de datos sobre gretl (en MS Windows o Gnome)

# outfile Printing

Argumentos: nombre_de_fichero opcin 
Opciones:   --append (aadir a un fichero)
            --close (cerrar el fichero)
            --write (sobreescribir el fichero)
Ejemplos:   outfile --write regres.txt
            outfile --close

Enva los resultados a nombre_de_fichero, hasta nuevo aviso. Use la opcin
--append para aadir los resultados a un fichero ya existente o --write para
empezar un nuevo fichero (o sobreescribir uno existente). De esta forma slo
se puede abrir un fichero en cada momento.

La opcin --close se usa para cerrar un fichero de resultados que estuviera
abierto previamente. Los resultados se enviarn entonces a la salida por
defecto.

En el primer ejemplo de arriba, se abre el fichero regres.txt para
escritura, y en el segundo se cierra. Esta secuencia tendra sentido slo si
se ejecutaran algunas instrucciones antes de --close. Por ejemplo si se
invocara una instruccin "ols", sus resultados iran a regres.txt en lugar
de a la pantalla.

# panel Dataset

Opciones:   --cross-section (secciones cruzadas apiladas)
            --time-series (series temporale apiladas)

Indica que el conjunto de datos actual debe ser interpretado como un panel
(combinando secciones cruzadas y series temporales). Por defecto, o usando
la opcin --time-series, se considera que el conjunto de datos est en la
forma de series temporales apiladas (los sucesivos bloques de datos
contienen series temporales para cada unidad de seccin cruzada). Con la
opcin --cross-section, elconjunto de datos se lee como secciones cruzadas
apiladas (los sucesivos bloques de datos contienen secciones cruzadas para
cada periodo temporale). Ver tambin "setobs".

Men grfico: /Muestra/Interpretar como panel

# pca Statistics

Argumento:  listavar 
Opciones:   --save-all (guardar todos los componentes)
            --save (guardar los componentes ms importantes)

Anlisis de componentes principales. Presenta los valores propios de la
matriz de correlacin de las variables de la lista listavar y la proporcin
de la varianza conjunta explicada por cada uno de los componentes. Tambin
presenta los vectores propios correspondientes (o "ponderaciones de los
componentes").

Si se da la opcin --save, los componentes con valorres propios mayores que
1,0 se guardan como variables en el conjunto de datos, con nombres PC1, PC2
y as sucesivamente. Estas variables artificiales se forman como la suma de
(ponderaciones de los componentes) por (Xi estandarizadas), donde Xi denota
la i-sima variable de la lista listavar.

Si se da la opcin --save-all, se guardan todos los componentes de la manera
que se ha descrito arriba.

Men grfico: Men emergente de la ventana principal (seleccin mltiple)

# pergm Statistics

Argumento:  nombre_var 
Opcin:     --bartlett (usar la venatana de retardos de Bartlett)

Calcula y presenta (y si no se ejecuta en modo batch, representa
grficamente) el espectro de la variable especificada. Sin la opcin
--bartlett se ofrece el periodograma muestral; con dicha opcin, se utiliza
una ventana de retardos de Bartlett de longitud 2*sqrt(T) (donde T es el
tamao muestral) para estimar el espectro (ver Captulo 18 del libro de
Greene Econometric Analysis). Cuando se presenta el periodograma muestral,
tambin se proporciona un contraste t sobre integracin fraccional de la
serie ("memoria larga"): la hiptesis nula es que el orden de integracin es
cero.

Men grfico: /Variable/Espectro
Otro acceso:  Men emergente de la ventana principal (seleccin simple)

# plot Graphs

Argumento:  listavar 
Opcin:     --one-scale (forzar una sla escala)

Representa grficamente los valores de las variables especificadas, para el
rango muestral que est actualmente activo, utilizando smbolos ASCII. Cada
lnea indica una observacin y los valores se representan horizontalmente.
Por defecto, las variables se cambian a la escala ms adecuada. Ver tambin
"gnuplot".

# print Printing

Argumentos: listavar  o cadena_literal 
Opciones:   --byobs (por observaciones)
            --ten (usar 10 dgitos significativos)
Ejemplos:   print x1 x2 --byobs
            print "Esto es una cadena de caracteres"

Si se da una lista listavar, presenta los valores de las variables
especificadas; si no se da ninguna lista, muestra los valores de todas las
variables del conjunto de datos actual. Si se da la opcin --byobs, los
datos se presentan 'por observacin', en caso contrario, se presentan 'por
variable'. Si se da la opcin --ten, los datos se presentan por variable
mostrando 10 dgitos significativos.

Si el argumento de la instruccin "print" es una cadena literal (que debe
comenzar con comillas dobles, "), la cadena se presenta tal y como est. Ver
tambin "printf".

Men grfico: /Datos/Mostrar valores

# printf Printing

Argumentos: format args 

Presenta valores escalares bajo el control de una cadena de caracteres
(proporcionando as un subconjunto de las utilidades de la instruccin
printf() del lenguaje de programacin C). Los formatos que se reconocen son
%g y %f, en cada caso con los diferentes modificadores disponibles en C.
Ejemplos: el formato %.10g presenta un valor con 10 dgitos significativos;
%12.6f presenta una valor con 6 decimales y con una anchura de 12
caracteres.

La propia cadena de caracteres que indica el formato debe de estar incluida
entre comillas. Los valores a mostrar deben seguir el formato de la cadena,
separados por comas. Estos valores deberan de tener la forma de (a) nombres
de variables del conjunto de datos, o (b) expresiones que sean vlidas para
la instruccin "genr". En el siguiente ejemplo se muestran los valores de
dos variables ms el de una expresin calculada:

	ols 1 0 2 3
	genr b = coeff(2)
	genr dt_b = stderr(2)
	printf "b = %.8g, desviacin tpica %.8g, t = %.4f\n", b, dt_b, b/dt_b

La largura mxima de una cadena de formato es de 127 caracteres. Se
reconocen las secuencias de escape \n (nueva lnea), \t (tabulador), \v
(tabulador vertical) y \\ (backslash literal). Para presentar un signo de
porcentaje literal use %%.

# probit Estimation

Argumentos: vardep varindeps 
Opcin:     --vcv (mostrar la matriz de covarianzas)

La variable dependiente debera ser una variable binaria. Se obtienen las
estimaciones mximo-verosmiles de los coeficientes de las variables
varindeps por medio de mnimos cuadrados iterativos (el mtodo EM o
Expectation-Maximization). Como el modelo no es lineal las pendientes
dependen de los valores de las variables independientes: las pendientes que
se presentan estn evaluadas en las medias de dichas variables. El
estadstico chi-cuadrado sirve para contrastar la hiptesis nula de que
todos los coeficientes, excepto la constante, son cero.

El anlisis Probit de proporciones no est an implementado en gretl.

Men grfico: /Modelo/Probit

# pvalue Utilities

Argumentos: dist [ params ] xval 
Ejemplos:   pvalue z zscore
            pvalue t 25 3.0
            pvalue X 3 5.6
            pvalue F 4 58 fval
            pvalue G xbar varx x

Calcula el rea a la derecha de xval en la distribucin especificada (z para
Gaussiana, t para la t de Student, X para la chi-cuadrado, F para la F y G
para la distribucin gamma). Para las ditribuciones t y chi-cuadrado deben
proporcionarse los grados de libertad; para la F hay que proporcionar los
grados de libertad del numerador y del denominador; y para la distribucin
gamma se necesitan la media y la varianza.

Men grfico: /Utilidades/buscador de valores-p

# pwe Estimation

Argumentos: vardep varindeps 
Opcin:     --vcv (mostrar la matriz de covarianzas)
Ejemplo:    pwe 1 0 2 4 6 7

Calcula estimaciones de los parmetros utilizando el procedimiento de
Prais-Winsten, un mtodo de Mnimos cuadrados generalizados factibles que
est diseado para tener en cuenta la autocorrelacin de primer orden del
trmino de error. El procedimiento es iterativo, igual que "corc"; la
diferencia es que mientras el mtodo de Cochrane-Orcutt desperdicia la
primera observacin, el de Prais-Winsten la utiliza. Para ms detalles, ver
por ejemplo el Captulo 13 del libro de Greene Econometric Analysis (2000).

Men grfico: /Modelo/Serie temporal/Prais-Winsten

# quit Utilities

Sale del programa, dndole a Vd. la opcin de guardar las rdenes y
resultados de su sesin al salir.

Men grfico: /Archivo/Salir

# rename Dataset

Argumentos: var_nmero nuevo_nombre 

Cambia el nombre de la variable con nmero de identificacin var_nmero a
nuevo_nombre. El nmero var_nmero debe estar entre el 1 y el nmero de
variables en el conjunto de datos. El nuevo nombre debe tener como mximo 8
caracteres, debe empezar con una letra y debe estar formado slo por letras
dgitos y el carcter de subrayado (_). character.

Men grfico: /Variable/Editar atributos
Otro acceso:  Men emergente de la ventana principal (seleccin simple)

# reset Tests

Debe ejecutarse despus de la estimacin de un modelo va MCO. Realiza el
contraste de especificacin de modelos (no linealidad) RESET de Ramsey. Para
ello aade a la regresin el cuadrado y el cubo de los valores ajustados y
calcula el estadstico F para la hiptesis nula de que los parmetros de las
dos variables aadidas son cero.

Men grfico: Ventana de Modelo, /Contrastes/Contraste RESET de Ramsey

# restrict Tests

Evala un conjunto de restricciones sobre los parmetros del ltimo modelo
estimado. En modo "guin de instrucciones", el conjunto de restricciones
debe incluirse entre "restrict" y "end restrict", pero en la caja de dilogo
sobre restricciones (en el entorno grfico) pueden omitirse esas lneas.

Cada restriccin del conjunto debe expresarse como una ecuacin, con una
combinacin lineal de los parmetros a la izquierda y un valor numrico a la
derecha del signo igual. Los parmetros se referencian en la forma bN, donde
N representa la posicin en la lista de regresores, comenzando en cero. Por
ejemplo, b1 denota al segundo parmetro de la regresin.

El segundo y siguientes trminos bN de una ecuacin pueden ir
premultiplicados por un nmero, utilizando * para representar la
multiplicacin, por ejemplo 3.5*b4.

He aqu un ejemplo de un conjunto de restricciones:

	restrict
	 b1 = 0
	 b2 - b3 = 0
	 b4 + 2*b5 = 1
	end restrict

Las restricciones se evalan mediante un contraste F de Wald, usando la
matriz de covarianzas de los coeficientes del modelo en cuestin.

Men grfico: Ventana de Modelo, /Contrastes/Restricciones lineales

# rhodiff Transformations

Argumentos: listarho ; listavar 
Ejemplos:   rhodiff .65 ; 2 3 4
            rhodiff r1 r2 ; x1 x2 x3

Crea las versiones rho-diferenciadas de las variables (dadas por nombre o
nmero) de la lista listavar y las aade al conjunto de datos, usando el
sufijo # para las nuevas variables. Dada la variable v1 una variable de
listavar, y las entradas r1 y r2 de listarho, se crea

v1# = v1 - r1*v1(-1) - r2*v1(-2)

Las entradas de listarho pueden darse como valores numricos o como nombres
de variables definidas previamente.

# rmplot Graphs

Argumento:  nombre_var 

Grfico Rango-media plot: esta instruccin crea un sencillo grfico para
ayudar a decidir si una serie temporal, y(t), tiene varianza constante o no.
Se toma la muestra completa t=1,...,T y se divide en pequeas submuestras de
tamao arbitrario k. La primera submuestra se forma con y(1),...,y(k), la
segunda con y(k+1), ..., y(2k), y as sucesivamente. Para cada submuetra se
calcula la media muestral y el rango (= el mximo menos el mnimo), y se
forma un grfico con las medias en el eje horizontal y los rangos en el
vertical. As, cada submuestra est representada por un punto en este plano.
Si la varianza de la serie es constante, se espera que los rangos de las
submuestras sean independientes de las medias; si vemos que los puntos se
distribuyen a lo largo de una lnea de creciente, esto sugiere que la
varianza de la serie aumenta con la media; si los puntos siguen una lnea
decreciente esto indica que la varianza disminuye a medida que la media
aumenta.

Adems del grfico, gretl presenta las medias y los rangos de cada
submuestra, el coeficiente para la pendiente en una regresin MCO de los
rangos sobre las medias y el valor p para el contraste de la hiptesis nula
de que dicha pendiente es cero. Si el coeficiente de la pendiente es
significativo, al nivel de significacin del 10 por ciento, se muestra
tambin en el grfico la recta de regresin estimada de los rangos sobre las
medias.

Men grfico: /Variable/Grfico rango-media

# run Programming

Argumento:  inputfile 

Ejecuta las instrucciones de inputfile y devuelve el control a la lnea de
instrucciones.

Men grfico: Icono de 'ejecutar' en la ventana de guin de instrucciones

# runs Tests

Argumento:  nombre_var 

Realiza el contraste "rachas" (no paramtrico) de aleatoriedad de la
variable especificada. Si Vd. desea contrastar la aleatoriedad de las
desviaciones respecto a la mediana, para una variable denominada x1 con
mediana distinta de cero, puede hacer lo siguiente:

	genr signx1 = x1 - median(x1)
	runs signx1

Men grfico: /Variable/Contraste de rachas

# scatters Graphs

Argumentos: yvar ; xlistavar  o ylistavar ; xvar 
Ejemplos:   scatters 1 ; 2 3 4 5
            scatters 1 2 3 4 5 6 ; 7

Dibuja grficos bivarianes, de la variable yvar con respecto a todas las
variables de la lista xlistavar, o de todas las variables de la lista
ylistavar con respecto a xvar. El primer ejemplo de arriba sita la variable
1 en el eje y y realiza cuatro grficos, el primero con la variable 2 en el
eje x, el segundo con la variable 3 en el eje x, y as sucesivamente. En el
segundo ejemplo se representa cada una de las variables 1,..., 6 con
respecto a la variable 7 en el eje x. Revisar un conjunto de grficos como
estos puede ser til al realizar anlisis exploratorio de datos. El nmero
mximo de grficos es seis; cualquier otra variable extra en la lista ser
ignorada.

Men grfico: /Datos/Grficos bivariantes mltiples

# set Programming

Argumentos: variable valor 

Establece los valores de varios parmetros del programa. Los valores dados
permanecen vigentes durante todo el desarrollo de la sesin de gretl, a no
ser que se cambien con una nueva llamada a la instruccin "set". Los
parmetros que pueden determinarse de esta forma se enumeran abajo. Hay que
sealar que los parmetros de hac_lag y hc_version se usan cuando se elige
la opcin --robust en la instruccin "ols".

  echo: off u on (por defecto). Suprime o activa el eco de las instrucciones
  en la salida de gretl.

  qr: on u off (por defecto). Utiliza QR en lugar de la descomposicin de
  Cholesky al calcular las estimaciones por MCO.

  hac_lag: nw1 (por defecto) o nw2, o un entero. Establece el retardo
  mximo, p, usado al calcular desviaciones tpicas HAC (Heteroskedasticity
  and Autocorrelation Consistent) usando el mtodo de Newey-West para datos
  de series temporales. nw1 y nw2 representan dos variantes para el clculo
  automtico basadas en el tamao muestral, T: para nw1, p = 0.75 * T^(1/3),
  y para nw2, p = 4 * (T/100)^(2/9).

  hc_version: 0 (por defecto), 1, 2 o 3. Determina la variante usada al
  calcular desviaciones tpicas consistentes ante heterocedasticidad con
  datos de seccin cruzada. Las opciones corresponden a los valores HC0,
  HC1, HC2 y HC3 estudiadas por Davidson y MacKinnon en Econometric Theory
  and Methods, captulo 5. HC0 produce lo que normalmente se llaman
  "desviaciones tpicas de White".

  force_hc: off (por defecto) u on. Por defecto, con datos de series
  temporales y cuando se da la opcin --robust en "ols", se usa el estimador
  HAC. Si se establece force_hc en "on", esto fuerza al clculo de la Matriz
  de Covarianzas Consistente ante Heterocedasticidad regular (que no tiene
  en cuenta la autocorrelacin).

  garch_vcv: unset, hessian, im (matriz de informacin) , op (matriz de
  productos externos), qml (estimador QML), bw (Bollerslev-Wooldridge).
  Especifica la variante que se usar para estimar la matriz de covarianzas
  de los coeficientes para modelos GARCH. Si se da unset (por defecto)
  entonces se usa el Hessiano a no ser que se d tambin la opcin "robust"
  para la instruccin garch, en cuyo caso se usa QML.

  hp_lambda: auto (por defecto), o un valor numrico. Determina el parmetro
  de suavizado para el filtro de Hodrick-Prescott (ver la funcin hpfilt
  bajo la instruccin "genr"). El valor por defecto es usar 100 veces el
  cuadrado de la periodicidad, lo cual da 100 para datos anuales, 1600 para
  trimestrales, y as sucesivamente.

# setobs Dataset

Argumentos: periodicidad obs_inicial 
Ejemplos:   setobs 4 1990:1
            setobs 12 1978:03
            setobs 20 1:01

Fuerza al programa a interpretar el conjunto de datos actual como serie
temporal o como panel, cuando los datos se han ledo como series simples sin
fechas. La periodicidad debe ser un entero; obs_inicial es una cadena de
caracteres que representa la fecha o identificacin de panel de la primera
observacin. Ver tambin "panel".

Men grfico: /Muestra/Establecer frecuencia, observacin inicial

# setmiss Dataset

Argumentos: valor [ listavar ] 
Ejemplos:   setmiss -1
            setmiss 100 x2

Hace que el programa interprete algn valor numrico concreto (el primer
parmetro de la instruccin) como cdigo para valor "ausente", en el caso de
datos importados. Si este valor es el nico parmetro, como en el primer
ejemplo de arriba, la interpretacin se aplicar a todas las series del
conjunto de datos. Si despus de "valor" sigue una lista de variables, por
nombre o nmero, la interpretacin se restringe a las variables
especificadas. As, en el segundo ejemplo el valor 100 se interpreta como
cdigo para "valor ausente", pero slo para la variable x2.

Men grfico: /Muestra/Establecer cdigo de 'valor perdido'

# shell Utilities

Argumento:  instruccin_de_shell 
Ejemplos:   ! ls -al
            ! notepad

Un "!" al comienzo de una lnea de instrucciones se interpreta como un
escape al shell del usuario. As se pueden ejecutar instrucciones de shell
arbitrarias desde dentro de gretl.

# smpl Dataset

Variantes:  smpl startobs endobs
                  smpl +i -j
                  smpl dumvar --dummy
                  smpl condition --restrict
                  smpl --no-missing [ varlist ]
                  smpl n --random
                  smpl full
Ejemplos:   smpl 3 10
            smpl 1960:2 1982:4
            smpl +1 -1
            smpl x > 3000 --restrict
            smpl y > 3000 --restrict --replace
            smpl 100 --random

Cambia el rango muestral. El nuevo rango puede definirse de varias formas.
En la primera forma alternativa (y los dos primeros ejemplos) de arriba
startobs y endobs deben ser coherentes con la periodicidad de los datos.
Cualquiera de ellos se puede sustituir por un punto y coma para dejar el
valor sin cambios. En la segunda forma los enteros i y j (que pueden ser
postivos o negativos y deberan tener signo) se toman como offsets respecto
al rango muestral existente. En la tercera forma, dummyvar debe ser una
variable indicador con valores 0 o 1 en cada observacin; la muestra se
restringir a las observaciones en las que el valor es 1. La cuarta forma,
usando --restrict restringe la muestra a las observaciones que satisfacen la
condicin Booleana (que se especifica de acuerdo a la sintaxis de la
instruccin "genr").

Con la opcin --no-missing, si se especifica listavar, las observaciones se
seleccionan con la condicin de que todas las variables de listavar tengan
valores vlidos en esa observacin; cuando no se especifica listavar, las
observaciones se seleccionan con la condicin de que todas las variables
tengan valores validos (no ausentes).

Con la opcin --random, se extrae del conjunto de datos el nmero de
observaciones especificado, de manera aleatoria. Si se desea poder replicar
esta seleccin ms adelante, se debe establecer primero una semilla para el
generador de nmeros aleatorios (Vase la instruccin "set").

La forma final, smpl full, restablece el rango muestral completo.

Ntese que las restricciones sobre la muestra son, por defecto,
acumulativas: la base para cualquier orden smpl es la muestra actual. Si Vd.
desea que la instruccin acte reemplazando cualquier restriccin previa,
puede aadir la opcin --replace al final de la instruccin.

Puede usarse la variable interna obs junto con la opcin --restrict de smpl
para excluir observaciones particulares de la muestra. Por ejemplo,

	smpl obs!=4 --restrict

quitar slo la cuarta observacin. Si los datos se identifican mediante
etiquetas,

	smpl obs!="USA" --restrict

quitar la observacin con etiqueta "USA".

Con respecto a las formas --dummy, --restrict y --no-missing de smpl, hay
que sealar que cualquier informacin "estructural" en el fichero de datos
(referente a la estructura de series temporales o de panel de los datos) se
pierde al ejecutar esta orden. Es posible reimponer la estructura inicial
con la instruccin "setobs".

Vase el manual de gretl para ms detalles.

Men grfico: /Muestra

# spearman Statistics

Argumentos: x y 
Opcin:     --verbose (mostrar los datos ordenados)

Presenta el coeficiente de rango de correlacin para las dos variables x e
y. No es necesario antes ordenar y hacer el ranking de las variables, la
funcin se encarga de ello.

El ranking automtico es de mayor a menor (es decir, el mayor valor de los
datos obtiene rango 1). Si Vd. necesita invertir este ranking cree una nueva
variable que sea el negativo de la primera original. Por ejemplo:

	genr altx = -x
	spearman altx y

Men grfico: /Modelo/Correlacin por Rangos

# square Transformations

Argumento:  listavar 
Opcin:     --cross (adems de los cuadrados genera los productos cruzados)

Genera variables nuevas que son los cuadrados de las variables de la lista
listavar (ms los productos cruzados, si se da la opcin --cross). Por
ejemplo, "square x y" generar sq_x = x cuadrado, sq_y = y cuadrado and
(optionalmente) x_y = x por y. Si una determinada variable es una variable
ficticia, no ser elevada al cuadrado, ya que se obtendra lo mismo.

Men grfico: /Datos/Aadir variables/cuadrados delas variables

# store Dataset

Argumentos: fichero_de_datos [ listavar ] 
Opciones:   --csv (usar formato CSV)
            --gnu-octave (usar formato GNU Octave)
            --gnu-R (usar formato GNU R)
            --traditional (usar el formato tradicional de ESL)
            --gzipped (aplicar la compresin mediante gzip)
            --dat (usar el formato ASCII de PcGive)

Guarda el conjunto de datos completo o, si se suministra una lista listavar,
el subconjunto especificado de variables del conjunto de datos actual, al
fichero dado en fichero_de_datos.

Por defecto los datos se guardan en formato gretl "nativo", pero las
distintas opciones permiten guardarlos en varios formatos alternativos. Los
datos CSV (Comma-Separated Values) pueden ser ledos por programas de hoja
de clculos y tambin pueden manipularse mediante un editor de textos. Los
formatos de Octave, R y PcGive estn diseados para el uso con estos
respectivos programas. La compresin mediante Gzip puede ser til para
grandes conjuntos de datos. Ver el manual de gretl para detalles sobre los
distintos formatos.

Hay que sealar que las variables escalares no sern guardadas
automticamente: si Vd. desea guardar escalares debe escribirlas
explcitamente en la lista listavar.

Men grfico: /Archivo/Guardar datos; /Archivo/Exportar datos

# summary Statistics

Argumento:  [ listavar ] 

Presenta los estadsticos principales de las variables de la lista listavar,
o si se omite listavar, de todas las variables del conjunto de datos. Se
muestran la media, desviacin tpica, coeficiente de variacin (= dt/media),
mediana, mnimo, mximo, coeficiente de asimetra y exceso de curtosis.

Men grfico: /Datos/Estadsticos principales
Otro acceso:  Men emergente de la ventana principal

# system Estimation

Argumentos: type savevars 
Ejemplos:   system type=sur
            system type=sur save=resids
            system type=3sls save=resids,fitted

Da comienzo a un sistema de ecuaciones. Actualmente se soportan dos tipos de
sistemas: "sur" (Seemingly Unrelated Regressions, ecuaciones de regresin
aparentemente no relacionadas) y "3sls" (Three-Stage Least Squares, mnimos
cuadrados en tres etapas). En el campor opcional "save=" se puede
especificar si guardar los residuos ("resids") y/o los valores ajustados
("fitted"). El sistemna debe contener al menos dos ecuaciones, que se
especifican por medio de la instruccin "equation", y debe terminarse con la
lnea "end system".

En el contexto de un sistema de Mnimos Cuadrados en Tres Etapas, Vd. puede
proporcionar una lista de instrumentos (mediante nombre o nmero). Esta
debera ir en una linea por separado dentro del bloque "system", precedido
de la palabra "instr".

# tabprint Printing

Argumento:  [ -f fichero ] 
Opcin:     --complete (Crea un documento completo)

Debe ejecutarse despus de la estimacin de un modelo. Presenta el modelo
estimado en forma de una tabla de LaTeX. Si se especifica un nombre de
fichero por medio de la opcin -f el resultado va a ese fichero, en caso
contrario va a un fichero con un nombre de la forma model_N.tex, donde N es
el nmero de modelos estimados hasta ese momento en la sesin actual de
gretl. Ver tambin "eqnprint".

Si se da la opcin --complete el fichero LaTeX ser un documento completo,
listo para ser procesado; en caso contrario debera ser incluido en un
documento ya formado.

Men grfico: Ventana de Modelo, /LaTeX

# testuhat Tests

Debe ejecutarse despus de una instruccin de estimacin. Da la distribucin
de frecuencias de los residuos del modelo y un contraste chi-cuadrado de
normalidad, basado en el procedimiento propuesto por Doornik y Hansen
(1984).

Men grfico: Ventana de Modelo, /Contrastes/normalidad de los residuos

# tobit Estimation

Argumentos: vardep varindeps 
Opciones:   --vcv (mostrar la matriz de covarianzas)
            --verbose (mostrar los detalles de las iteraciones)

Estima un modelo Tobit. Este modelo puede ser adecuado cuando la variable
dependiente es una variable "truncada". Por ejemplo, se observan valores
positivos y cero de las compras de bienes duraderos por parte de las
familias, pero no valores negativos. Sin embargo las decisiones sobre tales
compras pueden considerarse como resultados de una disposicin subyacente a
la compra que puede ser negativa en algunos casos. Para detalles ver el
libro de Greene Econometric Analysis, Captulo 20.

Men grfico: /Modelo/Tobit

# tsls Estimation

Argumentos: vardep varindeps ; instrumentos 
Opciones:   --vcv (mostrar la matriz de covarianzas)
            --robust (desviaciones tpicas robustas)
Ejemplo:    tsls y1 0 y2 y3 x1 x2 ; 0 x1 x2 x3 x4 x5 x6

Calcula las estimaciones por mnimos cuadrados en dos etapas (MC2E o VI):
vardep es la variable dependiente, varindeps es la lista de variables
independientes (incluyendo las variables endgenas del lado derecho) en la
ecuacin estructural para la cual se necesitan las estimaciones MC2E; y
instrumentos es la lista combinada de variables exgenas y predeterminadas
en todas las ecuaciones. Si la lista de instrumentos no es al menos tan
larga como varindeps, el modelo no est identificado.

En el ejemplo de arriba, las ys son las variables endgenas y las xs son las
exgenas y predeterminadas.

Men grfico: /Modelo/Mnimos cuadrados en dos etapas

# var Estimation

Argumentos: orden listavar ; detlist 
Opcin:     --quiet (no mostrar respuestas al impulso etc.)
Ejemplo:    var 4 x1 x2 x3 ; const time

Construye y estima (usando MCO) un modelo autorregresivo vectorial (VAR). El
primer argumento especifica el orden de retardos, despues va la estructura
de la primera ecuacin. No hay que incluir retardos entre los elementos de
listavar -- se aadirn automticamente. El punto y coma separa las
variables estocsticas, para las que se incluirn un nmero orden de
retardos, de los terminos determinsticos de detlist, tales como la
constante, la tendencia temporal y las variables ficticias estacionales.

De hecho, gretl es capaz de reconocer las variables determinsticas ms
comunes (constante, tendencia temporal, variables ficticias que no tengan
ms valores que el 0 y el 1), as que estas no es necesario situarlas
despus del punto y coma. Variables determinsticas ms complejas (p.ej. una
tendencia temporal interactuando con una variable ficticia) deben incluirse
despus del punto y coma.

Se ejecuta una regresin por separado para cada variable de listavar. La
salida de cada ecuacin presenta los contrastes F de restricciones cero de
todos los retardos de cada variable; un contraste F de significatividad del
retardo mximo; descomposiciones de la varianza de prediccin y las
funciones impulso-respuesta.

Las descomposiciones de la varianza y las funciones impulso-respuesta se
basan en la descomposicin de Cholesky de la matriz de covarianzas
contempornea, y en este contexto el orden en el que se dan las variables
(estocsticas) es importante. La primera variable de la lista se supone que
es "ms exgena" dentro del periodo.

Men grfico: /Modelo/Serie temporal/Autorregresin vectorial (VAR)

# varlist Dataset

Presenta un listado de las variables actualmente disponibles. "list" y "ls"
son sinnimos.

# vartest Tests

Argumentos: var1 var2 

Calcula el estadstico F para contrastar la hiptesis nula de que las
varianzas poblacionales de las variables var1 y var2 son iguales, y muestra
su valor p.

Men grfico: /Datos/Diferencia de varianzas

# vif Tests

Debe ejecutarse inmediatamente despus de la estimacin de un modelo que
incluya al menos dos variables independientes. Calcula y muestra los
factores de inflacin de varianza (VIFs) de los regresores. El factor de
inflacin de varianza (VIF) del regresor j se define como

  1/(1 - Rj^2

donde Rj es el coeficiente de correlacin mltiple entre el regresor j y los
dems regresores. El factor tiene un valor mnimo de 1,0 cuando la variable
en cuestin es ortogonal a las dems variables independientes. Neter,
Wasserman, y Kutner (1990) sugieren inspeccionar el mayor VIF como una
medida de diagnstico para la multicolinealidad; un valor mayor que 10 se
suele considerar que indica un grado de multicolinealidad problemtico.

Men grfico: Model window, /Tests/collinearity

# wls Estimation

Argumentos: wtvar vardep varindeps 
Opcin:     --vcv (mostrar la matriz de covarianzas)

Calcula las estimaciones de Mnimos cuadrados ponderados usando wtvar como
variable de ponderaciones, vardep como variable dependiente y varindeps como
lista de variables independientes. En concreto, se ejecuta una regresin MCO
de wtvar * vardep contra wtvar * varindeps. Si wtvar es una variable
ficticia, esto es equivalente a eliminar todas las observaciones en las que
wtvar tiene valor cero.

Men grfico: /Modelo/Mnimos cuadrados ponderados

