# $Id: Preferences.pm,v 1.2 2003/02/01 17:26:10 jodrell Exp $
package Greenwich::Preferences;

use strict;

sub new {
	my $self		= {};
	$self->{PACKAGE}	= shift;
	bless($self, $self->{PACKAGE});
	my %args		= @_;
	$self->{lexicon}	= $args{lexicon};
	$self->{options}	= $args{options};

	$self->{window} = Gtk::Dialog->new();
	$self->{window}->set_position('center');
	$self->{window}->set_title($self->string('prefstitle'));
	$self->{window}->signal_connect('destroy', sub { $self->destroy() });

	$self->{buttons}{ok_button}	= Gnome::Stock->button('Button_Ok');
	$self->{buttons}{cancel_button}	= Gnome::Stock->button('Button_Cancel');
	$self->{buttons}{cancel_button}->signal_connect('clicked', sub { $self->destroy() });

	$self->{frames}{whois}	= Gtk::Frame->new($self->string('whoislabel'));
	$self->{frames}{display}= Gtk::Frame->new($self->string('displaylabel'));
	$self->{frames}{net}	= Gtk::Frame->new($self->string('netlabel'));
	$self->{frames}{recurs}	= Gtk::Frame->new($self->string('recursivelabel'));

	$self->{whoisbox} = Gtk::VBox->new(0, 0);
	$self->{whoisbox}->border_width(8);
	$self->{whoisbox}->set_spacing(8);
	$self->{controls}{use_external} = Gtk::CheckButton->new($self->string('useexternal'));
	$self->{controls}{external} = Gtk::Entry->new();
	$self->{whoisbox}->pack_start($self->{controls}{use_external},	0, 1, 0);
	$self->{whoisbox}->pack_start($self->label('extstring'),	0, 1, 0);
	$self->{whoisbox}->pack_start($self->{controls}{external},	0, 1, 0);
	$self->{frames}{whois}->add($self->{whoisbox});

	$self->{displaybox} = Gtk::VBox->new(0, 0);
	$self->{displaybox}->border_width(8);
	$self->{displaybox}->set_spacing(8);
	$self->{controls}{font} = Gtk::Button->new('');
	$self->{controls}{font}->signal_connect('clicked', sub { $self->select_font() });
	$self->{displaybox}->pack_start($self->label('selectfont'),	0, 1, 0);
	$self->{displaybox}->pack_start($self->{controls}{font},	0, 1, 0);
	$self->{frames}{display}->add($self->{displaybox});

	$self->{netbox} = Gtk::HBox->new(0, 0);
	$self->{netbox}->border_width(8);
	$self->{netbox}->set_spacing(8);
	$self->{controls}{timeout} = Gtk::SpinButton->new(Gtk::Adjustment->new(10, 0, 1000, 1, 10, undef), 1, 0);
	$self->{controls}{timeout}->set_numeric(1);
	$self->{netbox}->pack_start($self->label('timeout'),	1, 1, 0);
	$self->{netbox}->pack_start($self->{controls}{timeout},	0, 0, 0);
	$self->{frames}{net}->add($self->{netbox});

	$self->{controls}{recursive} = Gtk::CheckButton->new($self->string('dorecursive'));
	$self->{controls}{recursive}->border_width(8);
	$self->{frames}{recurs}->add($self->{controls}{recursive});

	$self->{window}->vbox()->set_border_width(8);
	$self->{window}->vbox()->set_spacing(8);
	$self->{window}->action_area()->set_border_width(0);
	$self->{window}->action_area()->set_spacing(8);

	foreach my $name (qw(whois display net recurs)) {
		$self->{window}->vbox()->pack_start($self->{frames}{$name}, 1, 1, 0);
	}

	$self->{window}->action_area()->pack_start($self->{buttons}{ok_button},		0, 1, 0);
	$self->{window}->action_area()->pack_start($self->{buttons}{cancel_button},	0, 1, 0);

	$self->configure();

	return $self;
}

sub string {
	my ($self, $str) = @_;
	return $self->{lexicon}->maketext($str);
}

sub label {
	my ($self, $str) = @_;
	return Gtk::Label->new($self->string($str));
}

sub ok_button {
	my $self = shift;
	return $self->{buttons}{ok_button};
}

sub show {
	my $self = shift;
	$self->{window}->show_all();
}

sub destroy {
	my $self = shift;
	$self->{window}->destroy();
	return;
}

sub configure {
	my $self = shift;
	$self->{controls}{use_external}->set_active(1) if ($self->{options}{use_external} eq 'true');
	$self->{controls}{external}->set_text($self->{options}{external});
	$self->set_font_label();
	$self->{controls}{timeout}->set_value($self->{options}{timeout});
	$self->{controls}{recursive}->set_active(1) if ($self->{options}{follow} eq 'true');
	return;
}

sub font_string {
	my ($self, $font) = @_;
	my @parts = split(/-/, $font);
	return sprintf('%s %dpt', ucfirst($parts[2]), ($parts[7] ne '*' ? $parts[7] : ($parts[8] / 10)));
}

sub select_font {
	my $self = shift;
	my $font_selector = Gtk::FontSelectionDialog->new($self->string('selectfont'));
	$font_selector->set_font_name($self->{options}{font});
	$font_selector->signal_connect('delete_event', sub { $font_selector->destroy() });
	$font_selector->cancel_button()->signal_connect('clicked', sub { $font_selector->destroy() });
	$font_selector->ok_button()->signal_connect(
		'clicked',
		sub {
			$self->{options}{font} = $font_selector->get_font_name();
			$self->set_font_label();
			$font_selector->destroy();
		}
	);
	$font_selector->show();
	return;
}

sub set_font_label {
	my $self = shift;
	# this causes intermittent crashes that i can't explain:
	#my $style = Gtk::Widget->get_default_style();
	#my $font = Gtk::Gdk::Font->load($self->{options}{font});
	#$style->font($font);
	#$self->{controls}{font}->child()->set_style($style);
	$self->{controls}{font}->child()->set_text($self->font_string($self->{options}{font}));
	return;
}

sub get_options {
	my $self = shift;
	$self->{options}{use_external}	= ($self->{controls}{use_external}->active() ? 'true' : 'false');
	$self->{options}{external}	= $self->{controls}{external}->get_text();
	$self->{options}{timeout}	= $self->{controls}{timeout}->get_value_as_int();
	$self->{options}{follow}	= ($self->{controls}{recursive}->active() ? 'true' : 'false');
	return %{$self->{options}};
}

1;