/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCSFTPWINDOW_H__
#define __GRDCSFTPWINDOW_H__

#include "config.h"

#ifdef HAVE_LIBSSH

#include "grdcfile.h"
#include "grdcftpwindow.h"
#include "grdcssh.h"

G_BEGIN_DECLS

#define GRDC_TYPE_SFTP_WINDOW               (grdc_sftp_window_get_type ())
#define GRDC_SFTP_WINDOW(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRDC_TYPE_SFTP_WINDOW, GrdcSFTPWindow))
#define GRDC_SFTP_WINDOW_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GRDC_TYPE_SFTP_WINDOW, GrdcSFTPWindowClass))
#define GRDC_IS_SFTP_WINDOW(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRDC_TYPE_SFTP_WINDOW))
#define GRDC_IS_SFTP_WINDOW_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), GRDC_TYPE_SFTP_WINDOW))
#define GRDC_SFTP_WINDOW_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GRDC_TYPE_SFTP_WINDOW, GrdcSFTPWindowClass))

typedef struct _GrdcSFTPWindow
{
    GrdcFTPWindow window;

    GrdcSFTP *sftp;

    pthread_t thread;
    gint taskid;
    gboolean thread_abort;
    gboolean quit_when_close;
} GrdcSFTPWindow;

typedef struct _GrdcSFTPWindowClass
{
    GrdcFTPWindowClass parent_class;

} GrdcSFTPWindowClass;

GType grdc_sftp_window_get_type (void) G_GNUC_CONST;

/* Create a new SFTP window using an existing sftp session */
GtkWidget* grdc_sftp_window_new (GtkWindow *parent, GrdcSFTP *sftp, gboolean quit_when_close);

/* Create a new SFTP window using an not-yet-initialized sftp session */
GtkWidget* grdc_sftp_window_new_init (GtkWindow *parent, GrdcSFTP *sftp, gboolean quit_when_close);

/* Create a stand-alone SFTP window using a connection profile */
void grdc_sftp_window_open (GtkWindow *parent, GrdcFile *grdcfile, gboolean quit_when_close);

G_END_DECLS

#endif  /* HAVE_LIBSSH */

#endif  /* __GRDCSFTPWINDOW_H__  */

