/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCFTPWINDOW_H__
#define __GRDCFTPWINDOW_H__

G_BEGIN_DECLS

#define GRDC_TYPE_FTP_WINDOW               (grdc_ftp_window_get_type ())
#define GRDC_FTP_WINDOW(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRDC_TYPE_FTP_WINDOW, GrdcFTPWindow))
#define GRDC_FTP_WINDOW_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GRDC_TYPE_FTP_WINDOW, GrdcFTPWindowClass))
#define GRDC_IS_FTP_WINDOW(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRDC_TYPE_FTP_WINDOW))
#define GRDC_IS_FTP_WINDOW_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), GRDC_TYPE_FTP_WINDOW))
#define GRDC_FTP_WINDOW_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GRDC_TYPE_FTP_WINDOW, GrdcFTPWindowClass))

typedef struct _GrdcFTPWindowPriv GrdcFTPWindowPriv;

typedef struct _GrdcFTPWindow
{
    GtkWindow window;

    GrdcFTPWindowPriv *priv;
} GrdcFTPWindow;

typedef struct _GrdcFTPWindowClass
{
    GtkWindowClass parent_class;

    void (* quit) (GrdcFTPWindow *window);
    void (* open_dir) (GrdcFTPWindow *window);
    void (* new_task) (GrdcFTPWindow *window);
    void (* cancel_task) (GrdcFTPWindow *window);
    void (* delete_file) (GrdcFTPWindow *window);
} GrdcFTPWindowClass;

GType grdc_ftp_window_get_type (void) G_GNUC_CONST;

enum
{
    GRDC_FTP_FILE_TYPE_DIR,
    GRDC_FTP_FILE_TYPE_FILE,
    GRDC_FTP_FILE_N_TYPES,
};

enum
{
    GRDC_FTP_FILE_COLUMN_TYPE,
    GRDC_FTP_FILE_COLUMN_NAME,
    GRDC_FTP_FILE_COLUMN_SIZE,
    GRDC_FTP_FILE_COLUMN_USER,
    GRDC_FTP_FILE_COLUMN_GROUP,
    GRDC_FTP_FILE_COLUMN_PERMISSION,
    GRDC_FTP_FILE_COLUMN_NAME_SORT, /* Auto populate */
    GRDC_FTP_FILE_N_COLUMNS
};

enum
{
    GRDC_FTP_TASK_TYPE_DOWNLOAD,
    GRDC_FTP_TASK_TYPE_UPLOAD,
    GRDC_FTP_TASK_N_TYPES
};

enum
{
    GRDC_FTP_TASK_STATUS_WAIT,
    GRDC_FTP_TASK_STATUS_RUN,
    GRDC_FTP_TASK_STATUS_FINISH,
    GRDC_FTP_TASK_STATUS_ERROR,
    GRDC_FTP_TASK_N_STATUSES
};

enum
{
    GRDC_FTP_TASK_COLUMN_TYPE,
    GRDC_FTP_TASK_COLUMN_NAME,
    GRDC_FTP_TASK_COLUMN_SIZE,
    GRDC_FTP_TASK_COLUMN_TASKID,
    GRDC_FTP_TASK_COLUMN_TASKTYPE,
    GRDC_FTP_TASK_COLUMN_REMOTEDIR,
    GRDC_FTP_TASK_COLUMN_LOCALDIR,
    GRDC_FTP_TASK_COLUMN_STATUS,
    GRDC_FTP_TASK_COLUMN_DONESIZE,
    GRDC_FTP_TASK_COLUMN_TOOLTIP,
    GRDC_FTP_TASK_N_COLUMNS
};

typedef struct _GrdcFTPTask
{
    /* Read-only */
    gint type;
    gchar *name;
    gint taskid;
    gint tasktype;
    gchar *remotedir;
    gchar *localdir;
    GtkTreeRowReference *rowref;
    /* Updatable */
    gfloat size;
    gint status;
    gfloat donesize;
    gchar *tooltip;
} GrdcFTPTask;

GtkWidget* grdc_ftp_window_new (GtkWindow *parent, const gchar *server_name);

void grdc_ftp_window_clear_file_list (GrdcFTPWindow *window);
/* column, value, ..., -1 */
void grdc_ftp_window_add_file (GrdcFTPWindow *window, ...);
/* Set the current directory. Should be called by opendir signal handler */
void grdc_ftp_window_set_dir (GrdcFTPWindow *window, const gchar *dir);
/* Get the current directory as newly allocated string */
gchar* grdc_ftp_window_get_dir (GrdcFTPWindow *window);
/* Get the next waiting task */
GrdcFTPTask* grdc_ftp_window_get_waiting_task (GrdcFTPWindow *window);
/* Update the task */
void grdc_ftp_window_update_task (GrdcFTPWindow *window, GrdcFTPTask* task);
/* Free the GrdcFTPTask object */
void grdc_ftp_task_free (GrdcFTPTask *task);

G_END_DECLS

#endif  /* __GRDCFTPWINDOW_H__  */

