/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCFILEEDIOR_H__
#define __GRDCFILEEDIOR_H__

G_BEGIN_DECLS

/* Open a dialog to create a new .grdc file. Return response id: OK:Connect, APPLY:Save, CANCEL */
gint grdc_file_editor_create (GtkWindow *parent, gboolean quit_when_close);
gint grdc_file_editor_create_full (GtkWindow *parent, gboolean quit_when_close,
    const gchar *server, const gchar *protocol);
/* Open a dialog to edit an existing .grdc file. */
gint grdc_file_editor_open (GtkWindow *parent, gchar *filename, gboolean quit_when_close);
/* Open a dialog for a quick connection without .grdc file. */
gint grdc_file_editor_open_temp (GtkWindow *parent, gboolean quit_when_close);
gint grdc_file_editor_open_temp_full (GtkWindow *parent, gboolean quit_when_close,
    const gchar *server, const gchar *protocol);

G_END_DECLS

#endif  /* __GRDCFILEEDIOR_H__  */

