/* param.c
 * Copyright (C) 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#include "graveman.h"

GHashTable *Gparamhash = NULL;

void param_store_value(gchar *Aentry, gchar *Avalue)
{
  gpointer Loldkey, Loldval;
  /* on commence par supprimer l'eventuelle ancienne cle */
  if (g_hash_table_lookup_extended(Gparamhash, Aentry, &Loldkey, &Loldval) == TRUE) {
    g_hash_table_remove(Gparamhash, Aentry);
    g_free(Loldkey);
    g_free(Loldval);
  }

  g_hash_table_insert(Gparamhash, g_strdup(Aentry), g_strdup(Avalue ? Avalue : ""));
}

/* renvoi une valeur de la ligne de commande */
gchar *param_get_string(gchar *Anom)
{
  return (gchar *)g_hash_table_lookup(Gparamhash, Anom);
}

/* renvoi un boolean de la ligne de commande */
gboolean param_get_boolean(gchar *Anom)
{
  gchar *Lvalue = (gchar *) g_hash_table_lookup(Gparamhash, Anom);
  return (Lvalue && *Lvalue == '1' ? TRUE : FALSE);
}

/* parsing ligne de commande */
gboolean graveman_init(gint Aargc, gchar *Aargv[]) {
  gint i;
  gchar *ptr;

  Gparamhash = _hash();

  for (i = 1; i <= Aargc; i++) {
    ptr = Aargv[i-1];
    while (*ptr=='-') ptr++;
    if (*ptr == 'v') {
      g_printf("%s\n", VERSION);
      return FALSE;
    } else if (*ptr == 'V') {
      g_printf("%s: %s\n", _("Version"), VERSION);
      g_printf("%s: %s\n", _("Compiled with ogg vorbis support"), 
#ifdef ENABLE_OGG
          _("yes")
#else
          _("no")
#endif
          );
      g_printf("%s: %s\n", _("Compiled with mp3 support"), 
#ifdef ENABLE_MP3
          _("yes")
#else
          _("no")
#endif
          );
      g_printf("%s: %s\n", _("Compiled with flac support"), 
#ifdef ENABLE_FLAC
          _("yes")
#else
          _("no")
#endif
          );
      g_printf("%s: %s\n", _("Compiled with linux-ide devices support"),
#ifdef LINUX_IDE
          _("yes")
#else
          _("no")
#endif
          );

      g_printf("%s: %s\n", _("Compiled with linux-scsi devices support"),
#ifdef LINUX_SCSI
          _("yes")
#else
          _("no")
#endif
          );

      g_printf("%s %s\n", _("Compiled"), 
#ifdef DEBUG
          _("with debug support")
#else
          _("without debug support")
#endif
          );
      return FALSE;
    } else if (*ptr == 'h') {
      g_printf("%s %s\n", PACKAGE, VERSION); 
      g_printf(_("By Sylvain Cresto <scresto@gmail.com>\n\n"));
      g_printf("  %s %s %s\n"
               "\t-v\t%s\n"
               "\t-V\t%s\n"
               "\t-s\t%s\n\n",
               _("Usage:"), Aargv[0], _("[options]"), _("show version number."),
               _("show compilation informations."), _("always scan devices on startup"));
      return FALSE;
    } else if (*ptr == 's') {
      param_store_value("scan_drives", "1");
    }
  }

  return TRUE;
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
