/* images.c
 * Copyright (C) 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */


#include "graveman.h"

GdkPixbuf *GDirIcone, *GFileIcone, *GCDIcone, *GAudioIcone, *GCDRWIcone, *GCDpetiteIcone,
  *GCDRWpetiteIcone, *GpetiteGraver, *GGraver, *GISOpetiteIcone, *GEraseCdrw, *GFileImage,
  *GDVDpetiteIcone, *GDVDRWpetiteIcone, *GcharsetpetiteIcone, *GiconeOK, *GiconePASOK, *GiconeMITIGE,
  *GMenuAudio = NULL, *GMenuData = NULL, *GMenuCopy = NULL, *GMenuOther = NULL, *GMenuDvd = NULL;


void load_all_images()
{
  GDirIcone = create_pixbuf("folder5-petit.png");
  GFileIcone = create_pixbuf("stock_new.png");
  GFileImage = create_pixbuf("file_image.png");
  GCDIcone = create_pixbuf("gnome-dev-cdrom.png");
  GAudioIcone = create_pixbuf("gnome-dev-cdrom-audio-24.png");
  GCDRWIcone = create_pixbuf("i-cdrom.png");
  GCDRWpetiteIcone = create_pixbuf("petitcdrw.png");
  GDVDRWpetiteIcone = create_pixbuf("petitdvdrw.png");
  GCDpetiteIcone = create_pixbuf("petitcd.png");
  GDVDpetiteIcone = create_pixbuf("petitdvd.png");
  GISOpetiteIcone = create_pixbuf("petitiso.png");
  GpetiteGraver = create_pixbuf("graver-petite.png");
  GGraver = create_pixbuf("graver.png");
  GEraseCdrw = create_pixbuf("erase-cdrw.png");
  GcharsetpetiteIcone = create_pixbuf("petitcharset.png");
  GiconeOK = create_pixbuf("petitok.png");
  GiconePASOK = create_pixbuf("petitpasok.png");
  GiconeMITIGE = create_pixbuf("petitmitige.png");
}

void load_menu_images(gchar *Lquel) {
  gchar Limgname[100];
  if (G_IS_OBJECT(GMenuAudio)) g_object_unref(GMenuAudio);
  if (G_IS_OBJECT(GMenuData)) g_object_unref(GMenuData);
  if (G_IS_OBJECT(GMenuDvd)) g_object_unref(GMenuDvd);
  if (G_IS_OBJECT(GMenuCopy)) g_object_unref(GMenuCopy);
  if (G_IS_OBJECT(GMenuOther)) g_object_unref(GMenuOther);

  g_snprintf(Limgname, sizeof(Limgname)-1, "menu-audio-%s.png", Lquel);
  GMenuAudio = create_pixbuf(Limgname);
  g_snprintf(Limgname, sizeof(Limgname)-1, "menu-data-%s.png", Lquel);
  GMenuData = create_pixbuf(Limgname);
  g_snprintf(Limgname, sizeof(Limgname)-1, "menu-dvd-%s.png", Lquel);
  GMenuDvd = create_pixbuf(Limgname);
  g_snprintf(Limgname, sizeof(Limgname)-1, "menu-copy-%s.png", Lquel);
  GMenuCopy = create_pixbuf(Limgname);
  g_snprintf(Limgname, sizeof(Limgname)-1, "menu-other-%s.png", Lquel);
  GMenuOther = create_pixbuf(Limgname);
}

void prepare_menu_images(Tgrave *Ag)
{
  gchar *Limg = conf_get_string("iconsize");
  gchar *Lcurrent = sc_grave_get_data(Ag, "_current_size");

  if (!Lcurrent || strcmp(Lcurrent, Limg)) {
    load_menu_images(Limg);

    g_free(Lcurrent);
    sc_grave_replace_data(Ag, g_strdup(Limg), "_current_size");
  }
}


void free_all_images()
{
  g_object_unref(GiconeOK);
  g_object_unref(GiconePASOK);
  g_object_unref(GiconeMITIGE);
  g_object_unref(GcharsetpetiteIcone);
  g_object_unref(GEraseCdrw);
  g_object_unref(GGraver);
  g_object_unref(GISOpetiteIcone);
  g_object_unref(GpetiteGraver);
  g_object_unref(GDVDRWpetiteIcone);
  g_object_unref(GCDRWpetiteIcone);
  g_object_unref(GDVDpetiteIcone);
  g_object_unref(GCDpetiteIcone);
  if (G_IS_OBJECT(GMenuOther)) g_object_unref(GMenuOther);
  if (G_IS_OBJECT(GMenuCopy)) g_object_unref(GMenuCopy);
  if (G_IS_OBJECT(GMenuData)) g_object_unref(GMenuData);
  if (G_IS_OBJECT(GMenuDvd)) g_object_unref(GMenuDvd);
  if (G_IS_OBJECT(GMenuAudio)) g_object_unref(GMenuAudio);
  g_object_unref(GCDRWIcone);
  g_object_unref(GAudioIcone);
  g_object_unref(GCDIcone);
  g_object_unref(GFileImage);
  g_object_unref(GFileIcone);
  g_object_unref(GDirIcone);

}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
