/* tools.h
 * Copyright (C) 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */
#ifndef _G_TOOLS_H
#define _G_TOOLS_H

extern char *ltrim(char *Abuf);
extern gchar *belleHeure(gchar *Abuf, gchar *Adst);
extern gint sc_strcountv(gchar **Aarray);
extern void sc_strstripv(gchar **Aarray);
extern gpointer get_combo_value(GtkWidget *Acombo);
extern gchar *get_combo_value_pos(GtkWidget *Acombo, gint Apos);
extern gint get_combo_intvalue(GtkWidget *Acombo);
extern gint make_int(gchar *Abuf);
extern gshort make_short(gchar *Abuf);
extern gchar *sc_realloc_cat(gchar *Asep, gchar *Asrc, gchar *Aplus);
extern gchar *format_length(guint64 Alennbr);
extern gchar *format_size(guint64 Asize);
extern gboolean sc_str_has_casesuffix(gchar *Astr, gchar *Asuffix);
extern gchar * sc_strescape (const gchar *source);
extern void sc_line_data_copy(GtkTreeModel *Amodel, GtkTreeIter *Aiterde, GtkTreeIter *Aitervers);
extern gboolean sc_str_match(gchar *Lpattern, gchar *Lstr);
extern void exit_prog(gint Apid, gboolean Aabort, GError **Aerror, gchar *Adefmsg);
extern gint sc_mkdir(const gchar *Aname, mode_t Amode);
extern gboolean get_only_numerics(gchar *Abuffer, gint Abufsize, gchar *Asource, gchar Aend);
extern gdouble get_pourcent(gchar *Atotal, gchar *Aactu);
extern gchar *next_no_numeric(gchar *Ade);
extern gchar *next_putzero(gchar *Asource, gchar Asrc);
extern glong get_2time(gchar *Asource);
extern gchar *sc_chomp(gchar *Astr);
extern gboolean read_all_output_callback(GIOChannel *Astd, GIOCondition Acond, gpointer Adata);

#endif

/*
 * vim:et:ts=8:sts=2:sw=2
 */
