/* cdrecord.h
 * Copyright (C) 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */
#ifndef _G_CDRECORD_H
#define _G_CDRECORD_H

extern gchar *cdrecord_get_mediainfo(Tgrave *Ag, Tdriveinfo *Adevice, GError **Aerror);
extern gchar *burn_data_getextrapara(Tgrave *Ag);
extern int scan_for_drives(Tgrave *Ag, GError **Aerror);
extern gboolean burn_from_image(gchar *Aop, Tgrave *Ag, GError **Aerror);
extern gboolean gravepiste(Tgrave *Ag, GError **Aerror);
extern gboolean maj_drive_info(Tdriveinfo *Adrive, gchar *Adev, GError **Aerror);
extern gboolean perform_fix_cd(Tgrave *Ag, GError **Aerror);
extern void eject_cd(gchar *Adev, GError **Aerror);
extern gboolean perform_erase_cdrw(Tgrave *Ag, GError **Aerror);
extern gboolean common_blankorfix_callback(GIOChannel *Astd, GIOCondition Acond, gpointer Adata);

#endif

/*
 * vim:et:ts=8:sts=2:sw=2
 */
