/*
 * $Id: sph.c,v 1.3 2000/11/28 09:19:48 andreas Exp $
 *
 ****************************************************************************
 *
 * MODULE:       m.datum.shift
 * AUTHOR(S):	 Michael Shapiro, CERL
 *               Andreas Lange - andreas.lange@rhein-main.de
 * PURPOSE: 	 create a list of all available ellipsoids/spheroids
 * COPYRIGHT:    (C) 2000 by the GRASS Development Team
 *
 *               This program is free software under the GNU General Public
 *   	    	 License (>=v2). Read the file COPYING that comes with GRASS
 *   	    	 for details.
 *
 *****************************************************************************/

#include "gis.h"

char *
spheroid_list(void)
{
  int len, n;
  char *list;
  char *name;
  
  len=0;
  for (n=0; (name = G_ellipsoid_name(n)) != NULL; n++)
    len += strlen(name)+1;
  list = G_malloc(len);
  for (n=0; (name = G_ellipsoid_name(n)) != NULL; n++)
    {
      if (n) 
	G_strcat (list, ",");
      else 
	*list = '\0';
      strcat (list, name);
    }
  return list;
}
