/*
* $Id: setup.c,v 1.3 2002/01/22 04:50:55 glynn Exp $
*
****************************************************************************
*
* MODULE:       d.display
*
* AUTHOR(S):    
*
* PURPOSE:      d.display setup
*
* COPYRIGHT:    (C) 2001 by the GRASS Development Team
*
*               This program is free software under the GNU General Public
*   	    	License (>=v2). Read the file COPYING that comes with GRASS
*   	    	for details.
*
*****************************************************************************/

#include "windows.h"
#include "lproto.h"
#include "gis.h"
#include "raster.h"
#include "display.h"
#include "D.h"
#include <stdio.h>
#include <string.h>

int setup()
{
	FILE *popen() ;
	FILE *fptr ;
	int T, B, L, R;
	char name[128];

	if (R_open_driver() != 0)
		G_fatal_error ("No graphics device selected");

/* Try to make it possible to interactively change colors */
	R_color_table_float() ;

/* Make sure screen is clear */
	Dclearscreen() ;
	D_clear_window();
	
	T=R_screen_top();
	B=R_screen_bot();
	L=R_screen_left();
	R=R_screen_rite();
	strcpy(name,"full_screen");
	D_new_window(name, T, B, L, R);
	if (D_set_cur_wind(name)) 
		G_fatal_error("Current graphics frame not available");
		
	Derase("black");

/* Establish windows on screen */
	Dnew(LOC.name, LOC.bot, LOC.top, LOC.left, LOC.right) ;
	Dnew(NAM.name, NAM.bot, NAM.top, NAM.left, NAM.right) ;
	Dnew(COO.name, COO.bot, COO.top, COO.left, COO.right) ;
	Dnew(REF.name, REF.bot, REF.top, REF.left, REF.right) ;
	Dnew(LEG.name, LEG.bot, LEG.top, LEG.left, LEG.right) ;
	Dnew(MAP.name, MAP.bot, MAP.top, MAP.left, MAP.right) ;
	Dnew(LO1.name, LO1.bot, LO1.top, LO1.left, LO1.right) ;
	Dnew(LO2.name, LO2.bot, LO2.top, LO2.left, LO2.right) ;
	Dnew(LO3.name, LO3.bot, LO3.top, LO3.left, LO3.right) ;

/* Show GRASS logo */
	Dchoose(LO1.name) ;
	R_close_driver();

	gorun("grass.logo.sh", "") ;

/* Provide known information */
	if (R_open_driver() != 0)
	    G_fatal_error ("No graphics device selected");
	Dchoose(LOC.name) ;
	R_close_driver();

	if (NULL != (fptr = popen("d.text", "w")))
	{
		fprintf(fptr, ".S 60\n.C white\n.B\n") ;
		fprintf(fptr, "%s\n", G_myname()) ;
		pclose(fptr) ;
	}

	show_region() ;

	return 0;
}
