// -*- c++ -*-
//------------------------------------------------------------------------------
//                              Card.h
//------------------------------------------------------------------------------
// $Id: Card.h,v 1.10 2006/09/06 02:07:59 vlg Exp $
//
// Date: Jan 8, 2004
//------------------------------------------------------------------------------
#ifndef CARD_H
#define CARD_H

#include "VCard.h"
#include "Granule-main.h"

class Card : public VCard 
{
public:
	Card ();

	virtual void set_question     (const ustring& q_);
	virtual void set_answer       (const ustring& a_);
	virtual void set_example      (const ustring& e_);
	virtual void set_alt_spelling (const ustring& a_);

	void set_id (long id_);

	virtual ustring get_question     () const { return m_question;     }
	virtual ustring get_answer       () const { return m_answer;       }
	virtual ustring get_example      () const { return m_example;      }
	virtual ustring get_alt_spelling () const { return m_alt_spelling; }
	virtual long    get_id           () const { return m_id;           }

	virtual void dump () const;

protected:
	virtual bool less_then_expiration (const VCard& rhs_) { return true; }
	virtual bool equal_expiration     (const VCard& rhs_) { return true; }

private:
	long    m_id;
	ustring m_question;
	ustring m_answer;
	ustring m_example;
	ustring m_alt_spelling;
};

inline void 
Card::set_question (const ustring& q_) 
{ 
	m_question = q_;
	mark_dirty (); 
}

inline void 
Card::set_answer (const ustring& a_) 
{ 
	m_answer = a_;
	mark_dirty (); 
}

inline void
Card::set_example (const ustring& e_) 
{ 
	m_example = e_;
	mark_dirty (); 
}

inline void
Card::set_alt_spelling (const ustring& a_) 
{ 
	m_alt_spelling = a_;
	mark_dirty (); 
}

inline void
Card::set_id (long id_)
{ 
	m_id = id_;
	mark_dirty (); 
}

#endif /* CARD_H */
