// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: Granule-main.h,v 1.17 2005/10/13 03:04:13 vlg Exp $
//------------------------------------------------------------------------------
//                            Granule-main.h
//------------------------------------------------------------------------------
//  Copyright (c) 2004 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed Dec 31 23:18:34 2003
//
//------------------------------------------------------------------------------

#ifndef MAIN_H
#define MAIN_H

#include <assa/Assure.h>

using ASSA::APP;
using ASSA::TRACE;
using ASSA::ALL;

enum { GRAPP    = ASSA::APP,	// 0x02
	   GUITRACE = ASSA::USR1,	// 0x04
	   DECK     = ASSA::USR2,	// 0x08
	   GEOM     = ASSA::USR3	// 0x10
};

typedef enum {
    Start = 0,
    Dirty,						/// Lesson deck has been modified
    Clean,						/// No modifications has been done
    Finish						
} WMState;

typedef enum { 
	FRONT, 
	BACK 
} SideSelection;

typedef enum { 
	LOAD_OK, 
	LOAD_FAILED 
} DeckLoadStatus;

typedef enum {
	INSTALL_DECK,				// Load a deck from a file
	ADD_TO_DECK					// Add cards to a deck from another deck file
} DeckAction;

typedef enum {
	NEW_DECK,					// Brand new deck (different from MODIFIED)
	INVALID_DECK,				// Tried and failed to load the deck
	MODIFIED_DECK,				// Deck has been modified with edit/add/delete
	CLEAN_DECK					// Deck doesn't need to be saved
} DeckEditStatus;

enum {
	CARD_BOX_SIZE = 5,
	MAX_CARDS     = 100000,		// Maximum cards in Deck/CardFile
};

typedef enum {
	SPACE_SEP,
	TAB_SEP,
	COLON_SEP,
	SEMICOLON_SEP,
	COMMA_SEP,
} CSVSeparator;

#define CARD_FILE_EXT  ".cdf"
#define DECK_FILE_EXT  ".dkf"
#define UNKNOWN_FNAME  "Unknown"       /* Name of 'New' CardFile */

#endif /* MAIN_H */

