// -*- c++ -*-
// generated by glade--
//------------------------------------------------------------------------------
// $Id: GeneralPref.h,v 1.8 2006/02/10 03:26:05 vlg Exp $
//------------------------------------------------------------------------------
//                            GeneralPref.h
//------------------------------------------------------------------------------
//  Copyright (c) 2004 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Sun May 30 21:09:23 EDT 2004
//
//------------------------------------------------------------------------------

#ifndef _GENERALPREF_H
#define _GENERALPREF_H

#include <gtkmm/entry.h>
#include <gtkmm/button.h>
#include <gtkmm/box.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/label.h>
#include <gtkmm/table.h>
#include <gtkmm/fontselection.h>

class PrefWindow;

/**-----------------------------------------------------------------------------
	Compound Font Entry

	+-------+-------+---------------------------+
	| Label | Entry | Select Font Dialog Button |
	+-------+-------+---------------------------+
--------------------------------------------------------------------------------
*/
class FontEntry 
{
public:
    Gtk::Label*   m_label;
    Gtk::Entry*   m_entry;		// Font entry
    Gtk::Button*  m_button;		// Font Dialog selection button
};

/**-----------------------------------------------------------------------------
	Compound history size option
--------------------------------------------------------------------------------
*/
class HistSizeBox : public Gtk::HBox
{
public:
	HistSizeBox ();

	Gtk::Entry* get_entry () { return m_entry; }
	void set_value (int v_);
	int  get_value ();

private:
	Gtk::Label*  m_label;
	Gtk::Entry*  m_entry;
};

/**-----------------------------------------------------------------------------
	General Preferences tab
--------------------------------------------------------------------------------
*/
class GeneralPref : public Gtk::VBox
{  
public:
    GeneralPref (PrefWindow& parent_);

    void on_select_clicked (int idx_);
    void changed_cb        ();
    void load_from_config  ();
    void save_to_config    ();

protected:
	static const int  FONT_ENTRY_SZ = 5;

    PrefWindow&       m_pref_window;
    FontEntry         m_fentry [FONT_ENTRY_SZ];	// Font entry
    Gtk::CheckButton* m_dup_checkbutton;
	Gtk::CheckButton* m_relpath_checkbutton;
	Gtk::CheckButton* m_keys_shortcuts_checkbutton;
	HistSizeBox*      m_hist_size;
	Gtk::Table*       m_font_table;
};

#endif
