// -*- c++ -*-
// generated by glade--
//------------------------------------------------------------------------------
// $Id: GeneralPref.cpp,v 1.11 2006/02/13 03:50:25 vlg Exp $
//------------------------------------------------------------------------------
//                            GeneralPref.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2004,2005 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Sun May 30 21:09:23 EDT 2004
//
//------------------------------------------------------------------------------

#include <gtkmm/label.h>
#include <gtkmm/frame.h>
#include <gtkmm/box.h>
#include <gtkmm/scrolledwindow.h>

#include "Granule-main.h"
#include "Config.h"
#include "PrefWindow.h"
#include "GeneralPref.h"

#include "Intern.h"             // i18n macros

using sigc::mem_fun;
using sigc::bind;

static const char* flabels[] = {
    _("Question font: "),
    _("Answer font: "),
    _("Example font: "),
	_("Input font: "),
	_("Application font: ")
};

enum { QFONT, AFONT, EFONT, IFONT, PFONT };

/**-----------------------------------------------------------------------------
   Class HistSizeBox methods
--------------------------------------------------------------------------------
**/
HistSizeBox::
HistSizeBox () : Gtk::HBox (false, 10)
{
	m_label = Gtk::manage(new Gtk::Label (
							  _("CardFile Recent History entries size")));
	m_label->set_alignment(0, 0.5);
	m_label->set_padding(0,0);
	m_label->set_justify(Gtk::JUSTIFY_FILL);
	m_label->set_line_wrap(false);
	m_label->set_use_markup(false);
	m_label->set_selectable(false);
	
	m_entry = Gtk::manage (new Gtk::Entry);
	m_entry->set_flags       (Gtk::CAN_FOCUS);
	m_entry->set_visibility  (true);
	m_entry->set_editable    (true);
	m_entry->set_max_length  (0);
	m_entry->set_text        ("5");
	m_entry->set_has_frame   (true);
	m_entry->set_width_chars (3);
	m_entry->set_activates_default (false);

	pack_start (*m_entry, Gtk::PACK_SHRINK, 0);
	pack_start (*m_label, Gtk::PACK_SHRINK, 0);
}

void
HistSizeBox::
set_value (int v_)
{
	char buf[24];
	sprintf (buf, "%d", v_);
	m_entry->set_text (buf);
}

int
HistSizeBox::
get_value ()
{
	return (::atoi (m_entry->get_text ().c_str ()));
}

/**-----------------------------------------------------------------------------
   Class GeneralPref methods
--------------------------------------------------------------------------------
**/
GeneralPref::
GeneralPref (PrefWindow& pwin_) 
	: 
	Gtk::VBox (false, 0),
	m_pref_window (pwin_)
{  
	trace_with_mask("GeneralPref::GeneralPref",GUITRACE);

	int i;
	set_border_width(14);

	m_font_table = Gtk::manage (new Gtk::Table (FONT_ENTRY_SZ, 3, false));

	Gtk::Frame* frame1 = Gtk::manage(new Gtk::Frame());
	Gtk::Frame* frame2 = Gtk::manage(new Gtk::Frame());
	Gtk::Frame* frame3 = Gtk::manage(new Gtk::Frame());
	Gtk::Frame* frame4 = Gtk::manage(new Gtk::Frame());
	Gtk::Label* empty_label;

	m_dup_checkbutton  = 
	    Gtk::manage(new Gtk::CheckButton(
						_("Remove duplicates when inserting new\n"
						  "cards from a Deck to the CardBox")));
	m_dup_checkbutton->set_alignment (0.1, 0);

	m_relpath_checkbutton = 
	    Gtk::manage(new Gtk::CheckButton(
						_("Record all dynamic links in CardFile"
						  " as relative paths")));
	m_relpath_checkbutton->set_alignment (0.1, 0);

	m_keys_shortcuts_checkbutton = 
	    Gtk::manage(new Gtk::CheckButton(
				_("Some keyboard input methods may conflict with keyboard\n"
				  "shortcuts. If checked, disable all shortcuts in DeckPlayer\n"
				  "dialog (requires restart).")));

	m_keys_shortcuts_checkbutton->set_alignment (0.1, 0);

	m_hist_size = Gtk::manage (new HistSizeBox);

	for (i = 0; i < FONT_ENTRY_SZ; i++) {
	    m_fentry [i].m_label  = Gtk::manage(new Gtk::Label (flabels[i]));
	    m_fentry [i].m_entry  = Gtk::manage(new Gtk::Entry);
	    m_fentry [i].m_button = Gtk::manage(new Gtk::Button ("Select"));

	    m_fentry [i].m_label->set_alignment(Gtk::ALIGN_RIGHT,Gtk::ALIGN_CENTER);
	    m_fentry [i].m_label->set_padding(0,0);
	    m_fentry [i].m_label->set_justify(Gtk::JUSTIFY_LEFT);
	    m_fentry [i].m_label->set_line_wrap(false);
	    m_fentry [i].m_label->set_use_markup(false);
	    m_fentry [i].m_label->set_selectable(false);

	    m_fentry [i].m_entry->set_flags(Gtk::CAN_FOCUS);
	    m_fentry [i].m_entry->set_visibility(true);
	    m_fentry [i].m_entry->set_editable(true);
	    m_fentry [i].m_entry->set_max_length(0);
	    m_fentry [i].m_entry->set_text("");
	    m_fentry [i].m_entry->set_has_frame(true);
	    m_fentry [i].m_entry->set_activates_default(false);
#ifdef IS_HILDON
		m_fentry [i].m_entry->set_width_chars (26);
#endif

	    m_fentry [i].m_button->set_flags(Gtk::CAN_FOCUS);

		m_font_table->attach (*m_fentry [i].m_label, 
							  0, 1, i, i+1,
							  Gtk::FILL, 
							  Gtk::AttachOptions (), 2, 2);

		m_font_table->attach (*m_fentry [i].m_entry, 
							  1, 2, i, i+1,
#ifdef IS_HILDON
							  Gtk::FILL,
#else
							  Gtk::EXPAND|Gtk::FILL,
#endif
							  Gtk::AttachOptions(), 2, 2);

		m_font_table->attach (*m_fentry [i].m_button, 
							  2, 3, i, i+1,
							  Gtk::FILL, 
							  Gtk::AttachOptions (), 2, 2);
	}

	m_dup_checkbutton->set_flags  (Gtk::CAN_FOCUS);
	m_dup_checkbutton->set_relief (Gtk::RELIEF_NORMAL);
	m_dup_checkbutton->set_mode   (true);
	m_dup_checkbutton->set_active (false);
	m_dup_checkbutton->set_border_width (4);

	m_relpath_checkbutton->set_flags  (Gtk::CAN_FOCUS);
	m_relpath_checkbutton->set_relief (Gtk::RELIEF_NORMAL);
	m_relpath_checkbutton->set_mode   (true);
	m_relpath_checkbutton->set_active (false);
	m_relpath_checkbutton->set_border_width (4);

	m_keys_shortcuts_checkbutton->set_flags  (Gtk::CAN_FOCUS);
	m_keys_shortcuts_checkbutton->set_relief (Gtk::RELIEF_NORMAL);
	m_keys_shortcuts_checkbutton->set_mode   (true);
	m_keys_shortcuts_checkbutton->set_active (false);
	m_keys_shortcuts_checkbutton->set_border_width (4);

	/** Duplicate check button
	 */
	empty_label = Gtk::manage(new Gtk::Label(""));

	empty_label->set_alignment  (0.5,0.5);
	empty_label->set_padding    (0,0);
	empty_label->set_justify    (Gtk::JUSTIFY_LEFT);
	empty_label->set_line_wrap  (false);
	empty_label->set_use_markup (false);
	empty_label->set_selectable (false);

	frame1->set_shadow_type  (Gtk::SHADOW_ETCHED_IN);
	frame1->set_border_width(2);
	frame1->set_label_align  (1, 1);
	frame1->set_label_widget (*empty_label);
	frame1->add (*m_dup_checkbutton);

	/** Relative path check button
	 */
	empty_label = Gtk::manage(new Gtk::Label(""));
	empty_label->set_alignment  (0.5,0.5);
	empty_label->set_padding    (0,0);
	empty_label->set_justify    (Gtk::JUSTIFY_LEFT);
	empty_label->set_line_wrap  (false);
	empty_label->set_use_markup (false);
	empty_label->set_selectable (false);

	frame2->set_shadow_type  (Gtk::SHADOW_ETCHED_IN);
	frame2->set_border_width (2);
	frame2->set_label_align  (1, 1);
	frame2->set_label_widget (*empty_label);
	frame2->add (*m_relpath_checkbutton);

	/** History Size check button
	 */
	empty_label = Gtk::manage(new Gtk::Label(""));
	empty_label->set_alignment  (0.5,0.5);
	empty_label->set_padding    (0,0);
	empty_label->set_justify    (Gtk::JUSTIFY_LEFT);
	empty_label->set_line_wrap  (false);
	empty_label->set_use_markup (false);
	empty_label->set_selectable (false);

	frame3->set_shadow_type  (Gtk::SHADOW_ETCHED_IN);
	frame3->set_border_width (2);
	frame3->set_label_align  (1, 1);
	frame3->set_label_widget (*empty_label);
	frame3->add (*m_hist_size);

	/** Key shortcuts
	 */
	empty_label = Gtk::manage(new Gtk::Label(""));

	empty_label->set_alignment  (0.5,0.5);
	empty_label->set_padding    (0,0);
	empty_label->set_justify    (Gtk::JUSTIFY_LEFT);
	empty_label->set_line_wrap  (false);
	empty_label->set_use_markup (false);
	empty_label->set_selectable (false);

	frame4->set_shadow_type  (Gtk::SHADOW_ETCHED_IN);
	frame4->set_border_width (2);
	frame4->set_label_align  (1, 1);
	frame4->set_label_widget (*empty_label);
	frame4->add (*m_keys_shortcuts_checkbutton);

	/** Maemo has a narrow screen and thus requires
	 * 	smart packing.
	 */
#ifdef IS_HILDON

	Gtk::ScrolledWindow* scrollw = Gtk::manage (new Gtk::ScrolledWindow);
	scrollw->set_flags (Gtk::CAN_FOCUS);
	scrollw->set_shadow_type (Gtk::SHADOW_NONE);
	scrollw->set_policy (Gtk::POLICY_AUTOMATIC , Gtk::POLICY_ALWAYS);
	scrollw->property_window_placement ().set_value (Gtk::CORNER_TOP_LEFT);

	Gtk::VBox* scrollw_vbox = Gtk::manage (new Gtk::VBox (false, 0));

	scrollw_vbox->pack_start (*m_font_table, Gtk::PACK_SHRINK, 4);
	scrollw_vbox->pack_start (*frame1, Gtk::PACK_SHRINK, 0);
	scrollw_vbox->pack_start (*frame2, Gtk::PACK_SHRINK, 0);
	scrollw_vbox->pack_start (*frame3, Gtk::PACK_SHRINK, 0);
	scrollw_vbox->pack_start (*frame4, Gtk::PACK_SHRINK, 0);

	scrollw->add (*scrollw_vbox);
	pack_start (*scrollw);

#else  // Desktop

	pack_start (*m_font_table, Gtk::PACK_EXPAND_WIDGET, 4);
	pack_start (*frame1, Gtk::PACK_SHRINK, 0);
	pack_start (*frame2, Gtk::PACK_SHRINK, 0);
	pack_start (*frame3, Gtk::PACK_SHRINK, 0);
	pack_start (*frame4, Gtk::PACK_SHRINK, 0);

#endif

	/** Set callbacks
	 */
	m_dup_checkbutton->signal_toggled().connect (
		mem_fun (m_pref_window, &PrefWindow::changed_cb));

	m_relpath_checkbutton->signal_toggled().connect (
		mem_fun (m_pref_window, &PrefWindow::changed_cb));

	m_keys_shortcuts_checkbutton->signal_toggled().connect (
		mem_fun (m_pref_window, &PrefWindow::changed_cb));

	m_hist_size->get_entry ()->signal_changed ().connect (
		mem_fun (m_pref_window, &PrefWindow::changed_cb));

	for (i = 0; i < FONT_ENTRY_SZ; i++) {
	    m_fentry [i].m_entry->signal_changed().connect (
			mem_fun (m_pref_window, &PrefWindow::changed_cb));

	    m_fentry [i].m_button->signal_clicked().connect (
			bind<int>(mem_fun (*this, &GeneralPref::on_select_clicked), i));
	}
	
	show_all ();
}
void
GeneralPref::
changed_cb () 
{ 
	m_pref_window.changed (); 
}

void
GeneralPref::
load_from_config ()
{
	trace_with_mask("GeneralPref::load_from_config",GUITRACE);

	m_fentry [QFONT].m_entry->set_text(CONFIG->get_question_font().to_string());
	m_fentry [AFONT].m_entry->set_text(CONFIG->get_answer_font  ().to_string());
	m_fentry [EFONT].m_entry->set_text(CONFIG->get_example_font ().to_string());
	m_fentry [IFONT].m_entry->set_text(CONFIG->get_input_font   ().to_string());
	m_fentry [PFONT].m_entry->set_text(CONFIG->get_app_font     ().to_string());

	m_dup_checkbutton    ->set_active (CONFIG->get_remove_duplicates ());
	m_relpath_checkbutton->set_active (CONFIG->with_relpaths         ());
	m_hist_size          ->set_value  (CONFIG->get_history_size      ());

	m_keys_shortcuts_checkbutton->set_active (CONFIG->disable_key_shortcuts ());
}

void
GeneralPref::
save_to_config ()
{
	trace_with_mask("GeneralPref::save_to_config",GUITRACE);

	CONFIG->set_question_font (m_fentry [QFONT].m_entry->get_text ());
	CONFIG->set_answer_font   (m_fentry [AFONT].m_entry->get_text ());
	CONFIG->set_example_font  (m_fentry [EFONT].m_entry->get_text ());
	CONFIG->set_input_font    (m_fentry [IFONT].m_entry->get_text ());
	CONFIG->set_app_font      (m_fentry [PFONT].m_entry->get_text ());

	CONFIG->set_remove_duplicates (m_dup_checkbutton->get_active ());
	CONFIG->with_relpaths (m_relpath_checkbutton->get_active ());

	if (m_hist_size->get_value () <= 0) {
		m_hist_size->set_value (5); // enforce sane default
	}
	CONFIG->set_history_size (m_hist_size->get_value ());

	CONFIG->disable_key_shortcuts (m_keys_shortcuts_checkbutton->get_active ());
}

void
GeneralPref::
on_select_clicked (int idx_)
{
	trace_with_mask("GeneralPref::on_select_clicked",GUITRACE);

	Gtk::FontSelectionDialog sfd ("Select Text Font");
	sfd.set_font_name (m_fentry [idx_].m_entry->get_text ());

	if (sfd.run () != Gtk::RESPONSE_OK) {
		return;
	}
	m_fentry [idx_].m_entry->set_text (sfd.get_font_name ());
	DL((GRAPP,"Text font changed : \"%s\"\n", 
		m_fentry [idx_].m_entry->get_text ().c_str ()));
}
