# -*- rpm-spec -*-
#===============================================================================
#
# GRANULE spec.in file.
#
# RPM format: name-version-release.rpm
#
# $Id: granule.spec.in,v 1.16 2005/11/13 02:50:47 vlg Exp $
#===============================================================================
%define debug_package   %{nil}

%define name            granule
%define ver             1.2.1

%define rel             1
%define disttag         fc2
%define release         %{rel}.%{disttag}

%define prefix          /usr
%define datadir         %{prefix}/share
%define localedir       %{datadir}/locale

Summary:    granule
Name:       %name
Version:    %ver
Release:    %{release}
Source:     %{name}-%{version}.tar.gz
License:    GPL
Group:      Applications
Packager:	Vladislav Grinchenko (vlg@users.sourceforge.net)
Source: 	%{name}-%{version}.tar.gz
URL:        http://granule.sourceforge.net/
Prefix: 	/usr
BuildRoot:  /var/tmp/%{name}-%{version}-root

%description 
granule is a flashcard program that implements Leither cardfile
methodology for learing new words. It features both short-term and
long-term memory training capabilities with scheduling.

#===============================================================================
# preparation section
#===============================================================================

%prep
%setup

#===============================================================================
# build section
#===============================================================================

%build

glib-gettextize --copy --force
intltoolize --automake --copy --force

%configure
if [ "$SMP" != "" ]; then
	make -j$SMP "MAKE=make -j$SMP"
else
	make
fi

#===============================================================================
# install section
#===============================================================================

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -rf $RPM_BUILD_ROOT; fi
make DESTDIR=$RPM_BUILD_ROOT install

%find_lang %{name} --with-gnome

#===============================================================================
# clenup section
#===============================================================================

%clean
rm -rf $RPM_BUILD_ROOT

#===============================================================================
# files that go into libassa package
#===============================================================================

%files
%defattr(-,root,root)

%doc COPYING AUTHORS README ChangeLog NEWS INSTALL 

%{prefix}/bin/granule
%{datadir}/granule/granule
%{datadir}/granule/pixmaps/*
%{datadir}/granule/xml/*
%{localedir}/*/*/*
%{datadir}/applications/granule.desktop
%{datadir}/pixmaps/granule.png

#===============================================================================

%changelog
* Sun Nov  6 2005 Vladislav Grinchenko <vlg@users.sourceforge.net> 
- Fixed License tag

* Mon Jul  4 2005 Vladislav Grinchenko <vlg@users.sourceforge.net> 
- Changed XML dir.
 
* Thu Jun  3 2004 Vladislav Grinchenko <vlg@users.sourceforge.net> - 1.0.0
- Initial release.

