/*		
 *		GRAMophone II, a grammar based algorithmic musical composition tool
 *		--------------------------------------------------------------------
 *		
 *		debug.c
 *
 *		Copyright (c) 2007, Giovanni Ferranti <giovanni@giovanniferranti.it>
 *
 * 		GRAMophone II is free software; you can redistribute it and/or modify
 * 		it under the terms of the GNU General Public License as published by
 * 		the Free Software Foundation; either version 2 of the License, or
 * 		(at your option) any later version.
 *
 * 		This program is distributed in the hope that it will be useful,
 * 		but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * 		GNU Library General Public License for more details.
 *
 *		You should have received a copy of the GNU General Public License along
 *		with this program; if not, write to the Free Software Foundation, Inc.,
 *		51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *		-------------------------------------------------------------------
 */

#include "global.h"

void print_composition_info() {
	printf("Composition Info:\n\n");
	printf("Title: %s\nAuthor and Copyright: %s\n", title, copyright);
	printf("\n");
}

void print_global_params() {
	register unsigned char i;
	
	printf("Global Parameters:\n\n");
	printf("Default grammar: %d\n", grammarOption);
	printf("Default iterations: %d\n", global_iterations);
	printf("Default resolution: %d\n", global_resolution);
	printf("Default time signature: %d/%d\n", glob_num, glob_den);
	printf("Default tempo: %d\n", tempo);
	for(i=0; i<NUM_GLOBAL_PARAMS; i++)
		printf("Parameter %d: %d\n", i, global_params[i]);
	printf("\n");	
}

void print_local_params(unsigned char i) {
	register unsigned char j;
	
	if(i)
		printf("\n");
	printf("Player: %s\n\n", players[i]->identifier);
	printf("Local Parameters:\n\n");
	if(players[i]) {
		printf("Grammar: %d\n", players[i]->grammar);
		//printf("Time signature: %d/%d\n", players[i]->num, players[i]->den);
		printf("Iterations: %d\n", players[i]->iterations);
		for(j=0; j<NUM_LOCAL_PARAMS; j++)
			printf("Parameter %d: %d\n", j, players[i]->local_params[j]);
		printf("\n");	
	}
	printf("\n");	
}

