/*		
 *		GRAMophone II, a grammar based algorithmic musical composition tool
 *		--------------------------------------------------------------------
 *		
 *		GRAMophone.c
 *
 *		Copyright (c) 2007, Giovanni Ferranti <giovanni@giovanniferranti.it>
 *
 * 		GRAMophone II is free software; you can redistribute it and/or modify
 * 		it under the terms of the GNU General Public License as published by
 * 		the Free Software Foundation; either version 2 of the License, or
 * 		(at your option) any later version.
 *
 * 		This program is distributed in the hope that it will be useful,
 * 		but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * 		GNU Library General Public License for more details.
 *
 *		You should have received a copy of the GNU General Public License along
 *		with this program; if not, write to the Free Software Foundation, Inc.,
 *		51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *		--------------------------------------------------------------------
 */

#include "global.h"

void version() {
  printf("\n---------------------------------------------------------\n");	
  printf("GRAMophone II %s\n", VERSION);
  printf("(c) 2007 Giovanni Ferranti <giovanni@giovanniferranti.it>\n");
  printf("This program is released under GNU General Public License\n\n");
  printf("powered by Tim Thompson Midifile Library\n");
  printf("---------------------------------------------------------\n\n");  
}

void dedicated() {
	printf("                      _qp,            ----        \n");
	printf("\\             ---   x0MM00&_            -         \n");
	printf("              --   QQM00 ~00                 --   \n");
	printf("                 _##MO&b/\\$B&   _ _          _,age\n");
	printf("\\;y;p\\ymwm*xm01&NM#M&$d~Bm00&\"L$:&&&&TK&w )MQSVQ&7\n");
	printf("0MMMg&&rrrrrMr.@000## \\shNM#P {aW$700009DL]#D2EQM*\n");
	printf("OM&140M/gt&/  R*#000#w_!4p00 ^z,-w&#N&}MQL\"QFFfQW4\n");
	printf("M1#kZp$6MMr~    ]N00MEM0N00#T  G400M&& 0#\" N1 E##g\n");
	printf("00M&QMM~~        M#0At#M0NMNN  N6KRMMr&DD  B0~:0Q&\n");
	printf("d#&O\"            JQMM1B0N0BM!  \\$~32$:M0T  J&&,W8W\n");
	printf("TwF      ,gpK     BM#QDMM&^  m,hh$4Z$MMp    0p^$N0\n");
	printf("O#N       ~^Qq     B   \"     6NZ:4mMm&A8    BA&lMX\n");
	printf("NNEb         `\\    =-*a\\     Q2#p$B$d#N#*6  j##R00\n");
	printf("#&,                    3     bF&B0UQW0KMMg0p0ND&NN\n");
	printf("B~       (             m      #8SB&#0&&A@&#RQAKH]m\n");
	printf("0Tt           \\a,      )@     {Kb#EB00x  - Q*&00$#\n");
	printf("#\\        /  :##x -qp#pQmpgpq,_4@4r0BQ~_z3Q0M@MM0&\n");
	printf("B:      /\\ ~_\\MMB  d#&h0#00#k0pEK&Mg& 1\\4NMM0M00Lp\n");
	printf("#^       ,  ##_!W^jN   ]k7@D#NZ_   `~ -m,jRMMM00M5\n");
	printf("NWq      ,Dp0000M0^    j#QMN0R6EBBg#B*M0M#QMg#BM0W\n");
	printf("N#r \\   O6jM00MF`      0BMMNN0V9B@@&$ ~0MN10NMMMN&\n");
	printf("R0xm   -     _pphgg__,#MM00NBMV9$~    xMM0#KM0BM#0\n");
	printf("&&00mj  - ,*N&0M0#&M0#K&1NM#0&&       QM0NNMMM0&NM\n");
	printf("~/~\\L?i`w ET&0QNBM0KX0#&N&B@       ,jp&B0$FM#0#0#\n");
	printf("I want to dedicate GRAMophone II to Maria Fra'\n");
	exit(0);
}

int main(int argc, char **argv) {
  extern FILE *yyin;	

  checkOption=debugOption=0;
  strcpy(namefile, "");
  ++argv;
  if(argc>1) {
	if(!strcmp(argv[0], "-c"))
	  checkOption++;
	if(!strcmp(argv[0], "-d"))
	  debugOption++;
	if(!strcmp(argv[0], "-dedicated"))
	  dedicated();
	if(checkOption||debugOption) {
	  yyin=fopen(argv[1], "r");
	  if(argv[2])
		strcpy(namefile, argv[2]);
	}
	else {
	  yyin=fopen(argv[0], "r");
	  if(argv[1])
		strcpy(namefile, argv[1]);		  
	}
	if(!yyin) {
	  fprintf(stderr, "Error loading composition source!\n");
	  exit(1);
	}
  }
  else
	usageError();
  version();
  if(checkOption)
	printf("checking your composition source...\n");
  initGRAMophone();
  yyparse();
  fclose(yyin);
  checkOption?(printf("the composition source is ok\n")):(grammyvm());
  if(!checkOption)
  	fclose(midi);
  return 0;
}
